# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** composite documents, assemble/build documents from other documents
  or parts of marked up text

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/ao_composite.rb;hb=HEAD]

=end
module SiSU_Assemble
  require_relative 'se'                                 # se.rb
  require_relative 'utils_composite'                    # utils_composite.rb
  class RemoteImage
    def initialize
      @env=SiSU_Env::InfoEnv.new
    end
    def image(dir)
      images=[]
      images[0]=dir
      images
    end
    def download_images(images_info)
      path="#{@env.processing_path.processing}/external_document/image"
      FileUtils::mkdir_p(path) \
        unless FileTest.directory?(path)
      download_from=images_info.shift
      images_info.each do |i|
        image="#{path}/#{i}"
        imagefile=File.new(image,'w+')
        open("#{download_from}/#{i}") do |g|
          imagefile << g.read
        end
        imagefile.close
      end
      output_path="#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}/_sisu/image_external"
      FileUtils::mkdir_p(output_path) \
        unless FileTest.directory?(output_path)
      SiSU_Env::SystemCall.new("#{path}/*",output_path,'q').rsync
    end
  end
  class Composite
    include SiSU_Composite_Doc_Utils # composite doc, .ssm, extract all related insert files, array of filenames test
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::InfoEnv.new
    end
    def read
      begin
        pwd=Dir.pwd
        Dir.chdir(@opt.f_pth[:pth])
        if @opt.fno =~/\S+?\.ssm$/
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Composite Document',
            "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}",
          ).grey_title_hi unless @opt.act[:quiet][:set]==:on
          composite_and_imported_filenames_array(@opt.fno) # composite doc, .ssm, extract all related insert files, array of filenames test
          assembled=loadfile(@opt.fno)
          write(assembled)
        end
        Dir.chdir(pwd)
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).
          location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def insert?(para)
      if para =~ /^<<\s+((?:https?|file):\/\/\S+?\.ss[it])$/ # and NetTest
        url($1.strip)
      elsif para =~/^<<\s+(\S+?\.ss[it])$/
        loadfilename=$1.strip
        insert_array=loadfile(loadfilename)
        file=insertion(loadfilename,insert_array)
        file[:prepared]
      else para
      end
    end
    def loadfile(loadfilename)
      begin
        if FileTest.file?(loadfilename)
          insert_array=IO.readlines(loadfilename,'')
          if loadfilename =~/\S+?\.ss[itm]$/
            if (@opt.act[:verbose][:set]==:on \
            || @opt.act[:verbose_plus][:set]==:on \
            || @opt.act[:maintenance][:set]==:on)
              SiSU_Screen::Ansi.new(
                @opt.act[:color_state][:set],
                'loading:',
                loadfilename,
              ).txt_grey
            end
            tuned_file=if loadfilename =~/\S+?\.ss[im]$/
              insert_array.each.map do |para|
                insert?(para)
              end
            elsif loadfilename =~/\S+?\.sst$/
              insert_array.each.map do |para|
                para
              end
            end.flatten.compact
          end
        end
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def url(loadfilename)
      if loadfilename =~ /((?:https?|file):\/\/\S+?\.ss[it])$/ # and NetTest
        loadfilename=$1
        begin
          require 'uri'
          require 'open-uri'
          require 'pp'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('uri, open-uri or pp NOT FOUND (LoadError)')
        end
        insert=open(loadfilename)
        insert_array=insert.dup
        insert.close
        file=insertion(loadfilename,insert_array)
        file[:prepared]
      end
    end
    def write(assembled)
      assembled_file=File.new("#{@env.processing_path.composite_file}/#{@opt.fnb}.ssm.sst",'w+')
      assembled.each {|a| assembled_file << a }
      assembled_file.close
    end
    def download_images(download_from,images_array)
      path="#{@env.processing_path.processing}/external_document/image"
      FileUtils::mkdir_p(path) unless FileTest.directory?(path)
      images_array.each do |i|
        image="#{path}/#{i}"
        unless FileTest.exists?(image)
          imagefile=File.new(image,'w+')
          open("#{download_from}/#{i}") do |g|
            imagefile << g.read
          end
          imagefile.close
        end
      end
    end
    def insertion(fni,insert_array)
      file={ prepared: [], images: [] }
      rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      file[:prepared] << "\n% |#{fni}|@|^|>>ok\n\n"
      @code_flag=false
      insert_array.each do |i|
        @code_flag=if i =~/^code\{/ then true
        elsif i =~/^\}code/         then false
        else @code_flag
        end
        if not @code_flag \
        and i !~/^%+\s/
          i=i.
            gsub(/^([123]|:?[ABCD])~\? /,
              '% [conditional heading:] \1~ ')    #off conditional heading (consider syntax)
          if i =~/^@\S+?:/
            i=i.gsub(/\n/m,"\n%  ").
              gsub(/\n%\s+$/m,'').
              gsub(/^@\S+?:/m,"\n% [imported header:] ")                       #off imported headers
          end
        end
        file[:prepared] << i
        if i !~/^%+\s/ \
        and i =~rgx_image
          file[:images] << i.scan(rgx_image).uniq
        end
      end
      file[:prepared] << "\n% end import" << "\n\n"
      if file[:images].length > 0
        file[:images]=file[:images].flatten.uniq
        file[:images].delete_if {|x| x =~/https?:\/\// }
      end
      file
    end
  end
  class CompositeFileList
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::InfoEnv.new
    end
    def read
      begin
        @opt.fns=@opt.fns.gsub(/\.ssm\.sst$/,'.ssm') #FIX earlier, hub
        fns_array=IO.readlines(@opt.fns,'')
        insertions?(fns_array)
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def insertions?(fns_array)
      tuned_file=[]
      SiSU_Screen::Ansi.new(
        @opt.act[:color_state][:set],
        'Composite Document',
        @opt.fno
      ).grey_title_hi unless @opt.act[:quiet][:set]==:on
      @ssm=[@opt.fns]
      fns_array.each do |para|
        if para =~/^<<\s+(\S+?\.ss[it])$/
          loadfilename=$1.strip
          if (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'loading:',
              loadfilename,
            ).txt_grey
          end
          tuned_file << if loadfilename =~ /(?:https?|file):\/\/\S+?\.ss[it]$/
            @ssm << loadfilename
          elsif loadfilename =~ /\.ss[it]$/ \
          and FileTest.file?(loadfilename)
            @ssm << loadfilename
          else
            STDERR.puts %{SKIPPED processing file: [#{@opt.lng}] "#{@opt.fns}" it requires an invalid or non-existent file: "#{loadfilename}"}
            $process_document = :skip; break #remove this line to continue processing documents that have missing include files
            para
          end
        end
      end
      @ssm
    end
  end
end
__END__
