% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-fitdistr-tidiers.R
\name{glance.fitdistr}
\alias{glance.fitdistr}
\title{Glance at a(n) fitdistr object}
\usage{
\method{glance}{fitdistr}(x, ...)
}
\arguments{
\item{x}{A \code{fitdistr} object returned by \code{\link[MASS:fitdistr]{MASS::fitdistr()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:
\item{n}{Number of observations used in estimation}
\item{logLik}{log-likelihood of estimated data}
\item{AIC}{Akaike Information Criterion}
\item{BIC}{Bayesian Information Criterion}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[MASS:fitdistr]{MASS::fitdistr()}}

Other fitdistr tidiers: \code{\link{tidy.fitdistr}}
}
\concept{fitdistr tidiers}
