if (typeof global === 'undefined') {
var global = this;
}
function __createIterableObject(arr, methods) {
methods = methods || {};
if (typeof Symbol !== 'function' || !Symbol.iterator) {
  return {};
}
arr.length++;
var iterator = {
  next: function() {
    return { value: arr.shift(), done: arr.length <= 0 };
  },
  'return': methods['return'],
  'throw': methods['throw']
};
var iterable = {};
iterable[Symbol.iterator] = function(){ return iterator; }
return iterable;
}

function test() {

var iterator = (function * generator() {
  yield * global.__createIterableObject([5, 6, 7]);
}());
var item = iterator.next();
var passed = item.value === 5 && item.done === false;
item = iterator.next();
passed    &= item.value === 6 && item.done === false;
item = iterator.next();
passed    &= item.value === 7 && item.done === false;
item = iterator.next();
passed    &= item.value === undefined && item.done === true;
return passed;
      
}

if (!test())
    throw new Error("Test failed");

