# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationCreateParameters(Model):
    """Request parameters for creating a new application.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param app_roles: The collection of application roles that an application
     may declare. These roles can be assigned to users, groups or service
     principals.
    :type app_roles: list[~azure.graphrbac.models.AppRole]
    :param available_to_other_tenants: Required. Whether the application is
     available to other tenants.
    :type available_to_other_tenants: bool
    :param display_name: Required. The display name of the application.
    :type display_name: str
    :param homepage: The home page of the application.
    :type homepage: str
    :param identifier_uris: Required. A collection of URIs for the
     application.
    :type identifier_uris: list[str]
    :param reply_urls: A collection of reply URLs for the application.
    :type reply_urls: list[str]
    :param key_credentials: The list of KeyCredential objects.
    :type key_credentials: list[~azure.graphrbac.models.KeyCredential]
    :param password_credentials: The list of PasswordCredential objects.
    :type password_credentials:
     list[~azure.graphrbac.models.PasswordCredential]
    :param oauth2_allow_implicit_flow: Whether to allow implicit grant flow
     for OAuth2
    :type oauth2_allow_implicit_flow: bool
    :param required_resource_access: Specifies resources that this application
     requires access to and the set of OAuth permission scopes and application
     roles that it needs under each of those resources. This pre-configuration
     of required resource access drives the consent experience.
    :type required_resource_access:
     list[~azure.graphrbac.models.RequiredResourceAccess]
    """

    _validation = {
        'available_to_other_tenants': {'required': True},
        'display_name': {'required': True},
        'identifier_uris': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'app_roles': {'key': 'appRoles', 'type': '[AppRole]'},
        'available_to_other_tenants': {'key': 'availableToOtherTenants', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'homepage': {'key': 'homepage', 'type': 'str'},
        'identifier_uris': {'key': 'identifierUris', 'type': '[str]'},
        'reply_urls': {'key': 'replyUrls', 'type': '[str]'},
        'key_credentials': {'key': 'keyCredentials', 'type': '[KeyCredential]'},
        'password_credentials': {'key': 'passwordCredentials', 'type': '[PasswordCredential]'},
        'oauth2_allow_implicit_flow': {'key': 'oauth2AllowImplicitFlow', 'type': 'bool'},
        'required_resource_access': {'key': 'requiredResourceAccess', 'type': '[RequiredResourceAccess]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationCreateParameters, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.app_roles = kwargs.get('app_roles', None)
        self.available_to_other_tenants = kwargs.get('available_to_other_tenants', None)
        self.display_name = kwargs.get('display_name', None)
        self.homepage = kwargs.get('homepage', None)
        self.identifier_uris = kwargs.get('identifier_uris', None)
        self.reply_urls = kwargs.get('reply_urls', None)
        self.key_credentials = kwargs.get('key_credentials', None)
        self.password_credentials = kwargs.get('password_credentials', None)
        self.oauth2_allow_implicit_flow = kwargs.get('oauth2_allow_implicit_flow', None)
        self.required_resource_access = kwargs.get('required_resource_access', None)
