/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foo.FooDateFormat;
import com.foobar.Utils;
import java.text.DateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Locale;

public class DateFormatProviderImpl
extends DateFormatProvider {
    static Locale[] avail = new Locale[]{Locale.JAPAN, new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), new Locale("yy")};
    static String[] datePattern = new String[]{"yyyy'\u5e74'M'\u6708'd'\u65e5'", "yyyy/MMM/dd", "yyyy/MM/dd", "yy/MM/dd"};
    static String[] timePattern = new String[]{"H'\u6642'mm'\u5206'ss'\u79d2' z", "H:mm:ss z", "H:mm:ss", "H:mm"};
    static String[] dialect = new String[]{"\u3067\u3059\u3002", "\u3084\u3002", "\u3069\u3059\u3002", "\u308f\u3044\u308f\u3044"};

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public DateFormat getDateInstance(int n, Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooDateFormat(datePattern[n] + dialect[i], locale);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public DateFormat getTimeInstance(int n, Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooDateFormat(timePattern[n] + dialect[i], locale);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooDateFormat(datePattern[n] + " " + timePattern[n2] + dialect[i], locale);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }
}

