// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-date.prototype.setmonth
es6id: 20.3.4.25
description: Abrupt completion during type coercion of provided "month"
info: |
  1. Let t be LocalTime(? thisTimeValue(this value)).
  2. If t is NaN, let t be +0; otherwise, let t be LocalTime(t).
  3. Let y be ? ToNumber(year).
  4. If month is not specified, let m be MonthFromTime(t); otherwise, let m be
     ? ToNumber(month).
---*/

var date = new Date();
var callCount = 0;
var originalValue = date.getTime();
var obj = {
  valueOf: function() {
    throw new Test262Error();
  }
};
var counter = {
  valueOf: function() {
    callCount += 1;
  }
};

assert.throws(Test262Error, function() {
  date.setMonth(obj, counter);
});

assert.sameValue(date.getTime(), originalValue);
assert.sameValue(callCount, 0);

reportCompare(0, 0);
