"use strict";

var helpers = require("../../helpers/helpers");

exports["Chile/Continental"] = {

	"guess:by:offset" : helpers.makeTestGuess("Chile/Continental", { offset: true, expect: "America/Santiago" }),

	"guess:by:abbr" : helpers.makeTestGuess("Chile/Continental", { abbr: true, expect: "America/Santiago" }),

	"1910" : helpers.makeTestYear("Chile/Continental", [
		["1910-01-10T04:42:45+00:00", "23:59:59", "SMT", 16966 / 60],
		["1910-01-10T04:42:46+00:00", "23:42:46", "-05", 300]
	]),

	"1916" : helpers.makeTestYear("Chile/Continental", [
		["1916-07-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1916-07-01T05:00:00+00:00", "00:17:14", "SMT", 16966 / 60]
	]),

	"1918" : helpers.makeTestYear("Chile/Continental", [
		["1918-09-10T04:42:45+00:00", "23:59:59", "SMT", 16966 / 60],
		["1918-09-10T04:42:46+00:00", "00:42:46", "-04", 240]
	]),

	"1919" : helpers.makeTestYear("Chile/Continental", [
		["1919-07-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1919-07-01T04:00:00+00:00", "23:17:14", "SMT", 16966 / 60]
	]),

	"1927" : helpers.makeTestYear("Chile/Continental", [
		["1927-09-01T04:42:45+00:00", "23:59:59", "SMT", 16966 / 60],
		["1927-09-01T04:42:46+00:00", "00:42:46", "-04", 240]
	]),

	"1928" : helpers.makeTestYear("Chile/Continental", [
		["1928-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1928-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1928-09-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1928-09-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1929" : helpers.makeTestYear("Chile/Continental", [
		["1929-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1929-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1929-09-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1929-09-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1930" : helpers.makeTestYear("Chile/Continental", [
		["1930-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1930-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1930-09-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1930-09-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1931" : helpers.makeTestYear("Chile/Continental", [
		["1931-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1931-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1931-09-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1931-09-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1932" : helpers.makeTestYear("Chile/Continental", [
		["1932-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1932-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1932-09-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1932-09-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1942" : helpers.makeTestYear("Chile/Continental", [
		["1942-06-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1942-06-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1942-08-01T04:59:59+00:00", "23:59:59", "-05", 300],
		["1942-08-01T05:00:00+00:00", "01:00:00", "-04", 240]
	]),

	"1946" : helpers.makeTestYear("Chile/Continental", [
		["1946-07-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1946-07-15T04:00:00+00:00", "01:00:00", "-03", 180],
		["1946-09-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1946-09-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1947" : helpers.makeTestYear("Chile/Continental", [
		["1947-04-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1947-04-01T04:00:00+00:00", "23:00:00", "-05", 300],
		["1947-05-22T03:59:59+00:00", "22:59:59", "-05", 300],
		["1947-05-22T04:00:00+00:00", "00:00:00", "-04", 240]
	]),

	"1968" : helpers.makeTestYear("Chile/Continental", [
		["1968-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1968-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1969" : helpers.makeTestYear("Chile/Continental", [
		["1969-03-30T02:59:59+00:00", "23:59:59", "-03", 180],
		["1969-03-30T03:00:00+00:00", "23:00:00", "-04", 240],
		["1969-11-23T03:59:59+00:00", "23:59:59", "-04", 240],
		["1969-11-23T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1970" : helpers.makeTestYear("Chile/Continental", [
		["1970-03-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1970-03-29T03:00:00+00:00", "23:00:00", "-04", 240],
		["1970-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1970-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1971" : helpers.makeTestYear("Chile/Continental", [
		["1971-03-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1971-03-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1971-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["1971-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1972" : helpers.makeTestYear("Chile/Continental", [
		["1972-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["1972-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["1972-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1972-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1973" : helpers.makeTestYear("Chile/Continental", [
		["1973-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1973-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1973-09-30T03:59:59+00:00", "23:59:59", "-04", 240],
		["1973-09-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1974" : helpers.makeTestYear("Chile/Continental", [
		["1974-03-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["1974-03-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["1974-10-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["1974-10-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1975" : helpers.makeTestYear("Chile/Continental", [
		["1975-03-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["1975-03-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["1975-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["1975-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1976" : helpers.makeTestYear("Chile/Continental", [
		["1976-03-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1976-03-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1976-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["1976-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1977" : helpers.makeTestYear("Chile/Continental", [
		["1977-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["1977-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["1977-10-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1977-10-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1978" : helpers.makeTestYear("Chile/Continental", [
		["1978-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["1978-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["1978-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1978-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1979" : helpers.makeTestYear("Chile/Continental", [
		["1979-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1979-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1979-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["1979-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1980" : helpers.makeTestYear("Chile/Continental", [
		["1980-03-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["1980-03-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["1980-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["1980-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1981" : helpers.makeTestYear("Chile/Continental", [
		["1981-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1981-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["1981-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1981-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1982" : helpers.makeTestYear("Chile/Continental", [
		["1982-03-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1982-03-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1982-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["1982-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1983" : helpers.makeTestYear("Chile/Continental", [
		["1983-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["1983-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["1983-10-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1983-10-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1984" : helpers.makeTestYear("Chile/Continental", [
		["1984-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1984-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1984-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["1984-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1985" : helpers.makeTestYear("Chile/Continental", [
		["1985-03-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["1985-03-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["1985-10-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["1985-10-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("Chile/Continental", [
		["1986-03-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["1986-03-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["1986-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["1986-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("Chile/Continental", [
		["1987-04-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-04-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["1987-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1987-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("Chile/Continental", [
		["1988-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["1988-10-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1988-10-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("Chile/Continental", [
		["1989-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["1989-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1989-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("Chile/Continental", [
		["1990-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1990-09-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["1990-09-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("Chile/Continental", [
		["1991-03-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-03-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["1991-10-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["1991-10-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("Chile/Continental", [
		["1992-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["1992-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1992-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("Chile/Continental", [
		["1993-03-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1993-03-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1993-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["1993-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("Chile/Continental", [
		["1994-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["1994-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["1994-10-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1994-10-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("Chile/Continental", [
		["1995-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["1995-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["1995-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1995-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("Chile/Continental", [
		["1996-03-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-03-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["1996-10-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["1996-10-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("Chile/Continental", [
		["1997-03-30T02:59:59+00:00", "23:59:59", "-03", 180],
		["1997-03-30T03:00:00+00:00", "23:00:00", "-04", 240],
		["1997-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["1997-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("Chile/Continental", [
		["1998-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1998-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["1998-09-27T03:59:59+00:00", "23:59:59", "-04", 240],
		["1998-09-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("Chile/Continental", [
		["1999-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["1999-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["1999-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["1999-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("Chile/Continental", [
		["2000-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["2000-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["2000-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["2000-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("Chile/Continental", [
		["2001-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["2001-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["2001-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2001-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("Chile/Continental", [
		["2002-03-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["2002-03-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["2002-10-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["2002-10-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("Chile/Continental", [
		["2003-03-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["2003-03-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["2003-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["2003-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("Chile/Continental", [
		["2004-03-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["2004-03-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["2004-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["2004-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("Chile/Continental", [
		["2005-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["2005-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["2005-10-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["2005-10-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("Chile/Continental", [
		["2006-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["2006-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["2006-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["2006-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("Chile/Continental", [
		["2007-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["2007-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["2007-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2007-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("Chile/Continental", [
		["2008-03-30T02:59:59+00:00", "23:59:59", "-03", 180],
		["2008-03-30T03:00:00+00:00", "23:00:00", "-04", 240],
		["2008-10-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["2008-10-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("Chile/Continental", [
		["2009-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2009-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2009-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["2009-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("Chile/Continental", [
		["2010-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2010-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2010-10-10T03:59:59+00:00", "23:59:59", "-04", 240],
		["2010-10-10T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("Chile/Continental", [
		["2011-05-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2011-05-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2011-08-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["2011-08-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("Chile/Continental", [
		["2012-04-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["2012-04-29T03:00:00+00:00", "23:00:00", "-04", 240],
		["2012-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2012-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("Chile/Continental", [
		["2013-04-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2013-04-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2013-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2013-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("Chile/Continental", [
		["2014-04-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2014-04-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2014-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2014-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("Chile/Continental", [
		["2016-05-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2016-05-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2016-08-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2016-08-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("Chile/Continental", [
		["2017-05-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["2017-05-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["2017-08-13T03:59:59+00:00", "23:59:59", "-04", 240],
		["2017-08-13T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("Chile/Continental", [
		["2018-05-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["2018-05-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["2018-08-12T03:59:59+00:00", "23:59:59", "-04", 240],
		["2018-08-12T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("Chile/Continental", [
		["2019-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2019-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2019-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2019-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("Chile/Continental", [
		["2020-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2020-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2020-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2020-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("Chile/Continental", [
		["2021-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2021-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2021-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2021-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("Chile/Continental", [
		["2022-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2022-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2022-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2022-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("Chile/Continental", [
		["2023-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2023-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2023-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2023-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("Chile/Continental", [
		["2024-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2024-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2024-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2024-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("Chile/Continental", [
		["2025-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2025-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2025-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2025-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("Chile/Continental", [
		["2026-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2026-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2026-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2026-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("Chile/Continental", [
		["2027-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2027-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2027-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2027-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("Chile/Continental", [
		["2028-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2028-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2028-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2028-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("Chile/Continental", [
		["2029-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2029-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2029-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2029-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("Chile/Continental", [
		["2030-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2030-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2030-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2030-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("Chile/Continental", [
		["2031-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2031-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2031-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2031-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("Chile/Continental", [
		["2032-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2032-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2032-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2032-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("Chile/Continental", [
		["2033-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2033-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2033-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2033-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("Chile/Continental", [
		["2034-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2034-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2034-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2034-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("Chile/Continental", [
		["2035-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2035-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2035-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2035-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("Chile/Continental", [
		["2036-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2036-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2036-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2036-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("Chile/Continental", [
		["2037-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2037-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2037-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2037-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2038" : helpers.makeTestYear("Chile/Continental", [
		["2038-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2038-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2038-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2038-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2039" : helpers.makeTestYear("Chile/Continental", [
		["2039-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2039-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2039-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2039-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2040" : helpers.makeTestYear("Chile/Continental", [
		["2040-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2040-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2040-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2040-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2041" : helpers.makeTestYear("Chile/Continental", [
		["2041-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2041-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2041-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2041-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2042" : helpers.makeTestYear("Chile/Continental", [
		["2042-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2042-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2042-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2042-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2043" : helpers.makeTestYear("Chile/Continental", [
		["2043-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2043-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2043-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2043-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2044" : helpers.makeTestYear("Chile/Continental", [
		["2044-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2044-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2044-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2044-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2045" : helpers.makeTestYear("Chile/Continental", [
		["2045-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2045-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2045-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2045-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2046" : helpers.makeTestYear("Chile/Continental", [
		["2046-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2046-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2046-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2046-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2047" : helpers.makeTestYear("Chile/Continental", [
		["2047-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2047-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2047-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2047-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2048" : helpers.makeTestYear("Chile/Continental", [
		["2048-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2048-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2048-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2048-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2049" : helpers.makeTestYear("Chile/Continental", [
		["2049-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2049-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2049-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2049-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2050" : helpers.makeTestYear("Chile/Continental", [
		["2050-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2050-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2050-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2050-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2051" : helpers.makeTestYear("Chile/Continental", [
		["2051-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2051-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2051-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2051-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2052" : helpers.makeTestYear("Chile/Continental", [
		["2052-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2052-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2052-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2052-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2053" : helpers.makeTestYear("Chile/Continental", [
		["2053-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2053-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2053-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2053-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2054" : helpers.makeTestYear("Chile/Continental", [
		["2054-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2054-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2054-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2054-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2055" : helpers.makeTestYear("Chile/Continental", [
		["2055-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2055-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2055-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2055-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2056" : helpers.makeTestYear("Chile/Continental", [
		["2056-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2056-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2056-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2056-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2057" : helpers.makeTestYear("Chile/Continental", [
		["2057-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2057-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2057-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2057-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2058" : helpers.makeTestYear("Chile/Continental", [
		["2058-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2058-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2058-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2058-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2059" : helpers.makeTestYear("Chile/Continental", [
		["2059-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2059-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2059-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2059-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2060" : helpers.makeTestYear("Chile/Continental", [
		["2060-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2060-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2060-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2060-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2061" : helpers.makeTestYear("Chile/Continental", [
		["2061-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2061-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2061-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2061-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2062" : helpers.makeTestYear("Chile/Continental", [
		["2062-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2062-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2062-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2062-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2063" : helpers.makeTestYear("Chile/Continental", [
		["2063-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2063-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2063-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2063-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2064" : helpers.makeTestYear("Chile/Continental", [
		["2064-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2064-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2064-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2064-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2065" : helpers.makeTestYear("Chile/Continental", [
		["2065-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2065-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2065-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2065-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2066" : helpers.makeTestYear("Chile/Continental", [
		["2066-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2066-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2066-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2066-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2067" : helpers.makeTestYear("Chile/Continental", [
		["2067-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2067-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2067-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2067-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2068" : helpers.makeTestYear("Chile/Continental", [
		["2068-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2068-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2068-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2068-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2069" : helpers.makeTestYear("Chile/Continental", [
		["2069-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2069-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2069-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2069-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2070" : helpers.makeTestYear("Chile/Continental", [
		["2070-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2070-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2070-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2070-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2071" : helpers.makeTestYear("Chile/Continental", [
		["2071-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2071-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2071-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2071-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2072" : helpers.makeTestYear("Chile/Continental", [
		["2072-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2072-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2072-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2072-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2073" : helpers.makeTestYear("Chile/Continental", [
		["2073-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2073-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2073-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2073-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2074" : helpers.makeTestYear("Chile/Continental", [
		["2074-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2074-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2074-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2074-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2075" : helpers.makeTestYear("Chile/Continental", [
		["2075-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2075-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2075-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2075-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2076" : helpers.makeTestYear("Chile/Continental", [
		["2076-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2076-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2076-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2076-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2077" : helpers.makeTestYear("Chile/Continental", [
		["2077-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2077-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2077-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2077-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2078" : helpers.makeTestYear("Chile/Continental", [
		["2078-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2078-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2078-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2078-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2079" : helpers.makeTestYear("Chile/Continental", [
		["2079-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2079-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2079-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2079-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2080" : helpers.makeTestYear("Chile/Continental", [
		["2080-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2080-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2080-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2080-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2081" : helpers.makeTestYear("Chile/Continental", [
		["2081-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2081-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2081-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2081-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2082" : helpers.makeTestYear("Chile/Continental", [
		["2082-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2082-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2082-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2082-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2083" : helpers.makeTestYear("Chile/Continental", [
		["2083-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2083-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2083-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2083-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2084" : helpers.makeTestYear("Chile/Continental", [
		["2084-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2084-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2084-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2084-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2085" : helpers.makeTestYear("Chile/Continental", [
		["2085-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2085-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2085-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2085-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2086" : helpers.makeTestYear("Chile/Continental", [
		["2086-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2086-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2086-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2086-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2087" : helpers.makeTestYear("Chile/Continental", [
		["2087-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2087-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2087-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2087-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2088" : helpers.makeTestYear("Chile/Continental", [
		["2088-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2088-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2088-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2088-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2089" : helpers.makeTestYear("Chile/Continental", [
		["2089-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2089-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2089-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2089-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2090" : helpers.makeTestYear("Chile/Continental", [
		["2090-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2090-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2090-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2090-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2091" : helpers.makeTestYear("Chile/Continental", [
		["2091-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2091-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2091-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2091-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2092" : helpers.makeTestYear("Chile/Continental", [
		["2092-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2092-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2092-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2092-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2093" : helpers.makeTestYear("Chile/Continental", [
		["2093-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2093-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2093-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2093-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2094" : helpers.makeTestYear("Chile/Continental", [
		["2094-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2094-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2094-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2094-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2095" : helpers.makeTestYear("Chile/Continental", [
		["2095-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2095-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2095-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2095-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2096" : helpers.makeTestYear("Chile/Continental", [
		["2096-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2096-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2096-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2096-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2097" : helpers.makeTestYear("Chile/Continental", [
		["2097-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2097-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2097-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2097-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2098" : helpers.makeTestYear("Chile/Continental", [
		["2098-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2098-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2098-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2098-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2099" : helpers.makeTestYear("Chile/Continental", [
		["2099-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2099-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2099-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2099-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2100" : helpers.makeTestYear("Chile/Continental", [
		["2100-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2100-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2100-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2100-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2101" : helpers.makeTestYear("Chile/Continental", [
		["2101-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2101-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2101-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2101-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2102" : helpers.makeTestYear("Chile/Continental", [
		["2102-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2102-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2102-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2102-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2103" : helpers.makeTestYear("Chile/Continental", [
		["2103-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2103-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2103-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2103-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2104" : helpers.makeTestYear("Chile/Continental", [
		["2104-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2104-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2104-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2104-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2105" : helpers.makeTestYear("Chile/Continental", [
		["2105-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2105-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2105-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2105-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2106" : helpers.makeTestYear("Chile/Continental", [
		["2106-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2106-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2106-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2106-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2107" : helpers.makeTestYear("Chile/Continental", [
		["2107-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2107-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2107-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2107-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2108" : helpers.makeTestYear("Chile/Continental", [
		["2108-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2108-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2108-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2108-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2109" : helpers.makeTestYear("Chile/Continental", [
		["2109-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2109-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2109-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2109-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2110" : helpers.makeTestYear("Chile/Continental", [
		["2110-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2110-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2110-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2110-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2111" : helpers.makeTestYear("Chile/Continental", [
		["2111-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2111-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2111-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2111-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2112" : helpers.makeTestYear("Chile/Continental", [
		["2112-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2112-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2112-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2112-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2113" : helpers.makeTestYear("Chile/Continental", [
		["2113-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2113-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2113-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2113-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2114" : helpers.makeTestYear("Chile/Continental", [
		["2114-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2114-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2114-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2114-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2115" : helpers.makeTestYear("Chile/Continental", [
		["2115-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2115-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2115-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2115-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2116" : helpers.makeTestYear("Chile/Continental", [
		["2116-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2116-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2116-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2116-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2117" : helpers.makeTestYear("Chile/Continental", [
		["2117-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2117-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2117-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2117-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2118" : helpers.makeTestYear("Chile/Continental", [
		["2118-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2118-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2118-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2118-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2119" : helpers.makeTestYear("Chile/Continental", [
		["2119-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2119-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2119-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2119-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2120" : helpers.makeTestYear("Chile/Continental", [
		["2120-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2120-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2120-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2120-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2121" : helpers.makeTestYear("Chile/Continental", [
		["2121-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2121-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2121-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2121-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2122" : helpers.makeTestYear("Chile/Continental", [
		["2122-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2122-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2122-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2122-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2123" : helpers.makeTestYear("Chile/Continental", [
		["2123-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2123-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2123-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2123-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2124" : helpers.makeTestYear("Chile/Continental", [
		["2124-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2124-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2124-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2124-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2125" : helpers.makeTestYear("Chile/Continental", [
		["2125-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2125-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2125-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2125-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2126" : helpers.makeTestYear("Chile/Continental", [
		["2126-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2126-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2126-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2126-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2127" : helpers.makeTestYear("Chile/Continental", [
		["2127-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2127-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2127-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2127-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2128" : helpers.makeTestYear("Chile/Continental", [
		["2128-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2128-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2128-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2128-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2129" : helpers.makeTestYear("Chile/Continental", [
		["2129-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2129-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2129-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2129-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2130" : helpers.makeTestYear("Chile/Continental", [
		["2130-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2130-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2130-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2130-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2131" : helpers.makeTestYear("Chile/Continental", [
		["2131-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2131-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2131-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2131-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2132" : helpers.makeTestYear("Chile/Continental", [
		["2132-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2132-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2132-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2132-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2133" : helpers.makeTestYear("Chile/Continental", [
		["2133-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2133-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2133-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2133-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2134" : helpers.makeTestYear("Chile/Continental", [
		["2134-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2134-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2134-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2134-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2135" : helpers.makeTestYear("Chile/Continental", [
		["2135-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2135-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2135-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2135-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2136" : helpers.makeTestYear("Chile/Continental", [
		["2136-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2136-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2136-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2136-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2137" : helpers.makeTestYear("Chile/Continental", [
		["2137-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2137-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2137-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2137-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2138" : helpers.makeTestYear("Chile/Continental", [
		["2138-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2138-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2138-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2138-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2139" : helpers.makeTestYear("Chile/Continental", [
		["2139-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2139-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2139-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2139-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2140" : helpers.makeTestYear("Chile/Continental", [
		["2140-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2140-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2140-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2140-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2141" : helpers.makeTestYear("Chile/Continental", [
		["2141-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2141-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2141-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2141-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2142" : helpers.makeTestYear("Chile/Continental", [
		["2142-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2142-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2142-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2142-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2143" : helpers.makeTestYear("Chile/Continental", [
		["2143-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2143-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2143-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2143-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2144" : helpers.makeTestYear("Chile/Continental", [
		["2144-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2144-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2144-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2144-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2145" : helpers.makeTestYear("Chile/Continental", [
		["2145-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2145-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2145-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2145-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2146" : helpers.makeTestYear("Chile/Continental", [
		["2146-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2146-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2146-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2146-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2147" : helpers.makeTestYear("Chile/Continental", [
		["2147-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2147-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2147-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2147-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2148" : helpers.makeTestYear("Chile/Continental", [
		["2148-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2148-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2148-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2148-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2149" : helpers.makeTestYear("Chile/Continental", [
		["2149-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2149-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2149-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2149-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2150" : helpers.makeTestYear("Chile/Continental", [
		["2150-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2150-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2150-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2150-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2151" : helpers.makeTestYear("Chile/Continental", [
		["2151-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2151-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2151-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2151-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2152" : helpers.makeTestYear("Chile/Continental", [
		["2152-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2152-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2152-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2152-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2153" : helpers.makeTestYear("Chile/Continental", [
		["2153-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2153-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2153-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2153-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2154" : helpers.makeTestYear("Chile/Continental", [
		["2154-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2154-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2154-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2154-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2155" : helpers.makeTestYear("Chile/Continental", [
		["2155-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2155-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2155-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2155-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2156" : helpers.makeTestYear("Chile/Continental", [
		["2156-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2156-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2156-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2156-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2157" : helpers.makeTestYear("Chile/Continental", [
		["2157-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2157-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2157-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2157-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2158" : helpers.makeTestYear("Chile/Continental", [
		["2158-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2158-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2158-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2158-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2159" : helpers.makeTestYear("Chile/Continental", [
		["2159-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2159-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2159-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2159-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2160" : helpers.makeTestYear("Chile/Continental", [
		["2160-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2160-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2160-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2160-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2161" : helpers.makeTestYear("Chile/Continental", [
		["2161-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2161-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2161-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2161-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2162" : helpers.makeTestYear("Chile/Continental", [
		["2162-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2162-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2162-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2162-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2163" : helpers.makeTestYear("Chile/Continental", [
		["2163-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2163-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2163-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2163-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2164" : helpers.makeTestYear("Chile/Continental", [
		["2164-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2164-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2164-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2164-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2165" : helpers.makeTestYear("Chile/Continental", [
		["2165-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2165-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2165-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2165-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2166" : helpers.makeTestYear("Chile/Continental", [
		["2166-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2166-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2166-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2166-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2167" : helpers.makeTestYear("Chile/Continental", [
		["2167-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2167-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2167-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2167-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2168" : helpers.makeTestYear("Chile/Continental", [
		["2168-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2168-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2168-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2168-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2169" : helpers.makeTestYear("Chile/Continental", [
		["2169-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2169-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2169-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2169-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2170" : helpers.makeTestYear("Chile/Continental", [
		["2170-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2170-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2170-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2170-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2171" : helpers.makeTestYear("Chile/Continental", [
		["2171-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2171-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2171-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2171-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2172" : helpers.makeTestYear("Chile/Continental", [
		["2172-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2172-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2172-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2172-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2173" : helpers.makeTestYear("Chile/Continental", [
		["2173-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2173-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2173-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2173-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2174" : helpers.makeTestYear("Chile/Continental", [
		["2174-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2174-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2174-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2174-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2175" : helpers.makeTestYear("Chile/Continental", [
		["2175-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2175-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2175-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2175-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2176" : helpers.makeTestYear("Chile/Continental", [
		["2176-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2176-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2176-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2176-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2177" : helpers.makeTestYear("Chile/Continental", [
		["2177-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2177-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2177-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2177-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2178" : helpers.makeTestYear("Chile/Continental", [
		["2178-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2178-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2178-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2178-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2179" : helpers.makeTestYear("Chile/Continental", [
		["2179-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2179-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2179-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2179-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2180" : helpers.makeTestYear("Chile/Continental", [
		["2180-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2180-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2180-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2180-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2181" : helpers.makeTestYear("Chile/Continental", [
		["2181-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2181-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2181-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2181-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2182" : helpers.makeTestYear("Chile/Continental", [
		["2182-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2182-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2182-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2182-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2183" : helpers.makeTestYear("Chile/Continental", [
		["2183-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2183-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2183-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2183-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2184" : helpers.makeTestYear("Chile/Continental", [
		["2184-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2184-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2184-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2184-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2185" : helpers.makeTestYear("Chile/Continental", [
		["2185-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2185-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2185-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2185-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2186" : helpers.makeTestYear("Chile/Continental", [
		["2186-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2186-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2186-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2186-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2187" : helpers.makeTestYear("Chile/Continental", [
		["2187-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2187-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2187-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2187-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2188" : helpers.makeTestYear("Chile/Continental", [
		["2188-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2188-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2188-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2188-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2189" : helpers.makeTestYear("Chile/Continental", [
		["2189-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2189-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2189-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2189-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2190" : helpers.makeTestYear("Chile/Continental", [
		["2190-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2190-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2190-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2190-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2191" : helpers.makeTestYear("Chile/Continental", [
		["2191-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2191-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2191-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2191-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2192" : helpers.makeTestYear("Chile/Continental", [
		["2192-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2192-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2192-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2192-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2193" : helpers.makeTestYear("Chile/Continental", [
		["2193-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2193-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2193-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2193-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2194" : helpers.makeTestYear("Chile/Continental", [
		["2194-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2194-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2194-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2194-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2195" : helpers.makeTestYear("Chile/Continental", [
		["2195-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2195-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2195-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2195-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2196" : helpers.makeTestYear("Chile/Continental", [
		["2196-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2196-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2196-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2196-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2197" : helpers.makeTestYear("Chile/Continental", [
		["2197-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2197-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2197-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2197-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2198" : helpers.makeTestYear("Chile/Continental", [
		["2198-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2198-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2198-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2198-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2199" : helpers.makeTestYear("Chile/Continental", [
		["2199-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2199-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2199-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2199-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2200" : helpers.makeTestYear("Chile/Continental", [
		["2200-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2200-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2200-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2200-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2201" : helpers.makeTestYear("Chile/Continental", [
		["2201-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2201-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2201-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2201-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2202" : helpers.makeTestYear("Chile/Continental", [
		["2202-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2202-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2202-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2202-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2203" : helpers.makeTestYear("Chile/Continental", [
		["2203-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2203-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2203-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2203-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2204" : helpers.makeTestYear("Chile/Continental", [
		["2204-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2204-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2204-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2204-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2205" : helpers.makeTestYear("Chile/Continental", [
		["2205-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2205-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2205-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2205-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2206" : helpers.makeTestYear("Chile/Continental", [
		["2206-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2206-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2206-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2206-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2207" : helpers.makeTestYear("Chile/Continental", [
		["2207-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2207-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2207-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2207-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2208" : helpers.makeTestYear("Chile/Continental", [
		["2208-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2208-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2208-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2208-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2209" : helpers.makeTestYear("Chile/Continental", [
		["2209-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2209-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2209-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2209-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2210" : helpers.makeTestYear("Chile/Continental", [
		["2210-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2210-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2210-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2210-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2211" : helpers.makeTestYear("Chile/Continental", [
		["2211-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2211-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2211-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2211-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2212" : helpers.makeTestYear("Chile/Continental", [
		["2212-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2212-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2212-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2212-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2213" : helpers.makeTestYear("Chile/Continental", [
		["2213-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2213-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2213-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2213-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2214" : helpers.makeTestYear("Chile/Continental", [
		["2214-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2214-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2214-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2214-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2215" : helpers.makeTestYear("Chile/Continental", [
		["2215-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2215-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2215-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2215-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2216" : helpers.makeTestYear("Chile/Continental", [
		["2216-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2216-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2216-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2216-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2217" : helpers.makeTestYear("Chile/Continental", [
		["2217-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2217-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2217-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2217-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2218" : helpers.makeTestYear("Chile/Continental", [
		["2218-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2218-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2218-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2218-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2219" : helpers.makeTestYear("Chile/Continental", [
		["2219-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2219-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2219-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2219-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2220" : helpers.makeTestYear("Chile/Continental", [
		["2220-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2220-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2220-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2220-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2221" : helpers.makeTestYear("Chile/Continental", [
		["2221-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2221-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2221-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2221-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2222" : helpers.makeTestYear("Chile/Continental", [
		["2222-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2222-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2222-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2222-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2223" : helpers.makeTestYear("Chile/Continental", [
		["2223-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2223-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2223-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2223-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2224" : helpers.makeTestYear("Chile/Continental", [
		["2224-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2224-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2224-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2224-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2225" : helpers.makeTestYear("Chile/Continental", [
		["2225-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2225-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2225-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2225-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2226" : helpers.makeTestYear("Chile/Continental", [
		["2226-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2226-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2226-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2226-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2227" : helpers.makeTestYear("Chile/Continental", [
		["2227-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2227-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2227-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2227-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2228" : helpers.makeTestYear("Chile/Continental", [
		["2228-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2228-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2228-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2228-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2229" : helpers.makeTestYear("Chile/Continental", [
		["2229-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2229-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2229-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2229-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2230" : helpers.makeTestYear("Chile/Continental", [
		["2230-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2230-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2230-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2230-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2231" : helpers.makeTestYear("Chile/Continental", [
		["2231-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2231-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2231-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2231-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2232" : helpers.makeTestYear("Chile/Continental", [
		["2232-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2232-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2232-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2232-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2233" : helpers.makeTestYear("Chile/Continental", [
		["2233-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2233-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2233-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2233-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2234" : helpers.makeTestYear("Chile/Continental", [
		["2234-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2234-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2234-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2234-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2235" : helpers.makeTestYear("Chile/Continental", [
		["2235-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2235-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2235-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2235-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2236" : helpers.makeTestYear("Chile/Continental", [
		["2236-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2236-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2236-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2236-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2237" : helpers.makeTestYear("Chile/Continental", [
		["2237-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2237-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2237-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2237-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2238" : helpers.makeTestYear("Chile/Continental", [
		["2238-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2238-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2238-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2238-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2239" : helpers.makeTestYear("Chile/Continental", [
		["2239-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2239-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2239-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2239-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2240" : helpers.makeTestYear("Chile/Continental", [
		["2240-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2240-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2240-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2240-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2241" : helpers.makeTestYear("Chile/Continental", [
		["2241-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2241-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2241-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2241-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2242" : helpers.makeTestYear("Chile/Continental", [
		["2242-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2242-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2242-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2242-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2243" : helpers.makeTestYear("Chile/Continental", [
		["2243-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2243-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2243-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2243-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2244" : helpers.makeTestYear("Chile/Continental", [
		["2244-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2244-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2244-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2244-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2245" : helpers.makeTestYear("Chile/Continental", [
		["2245-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2245-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2245-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2245-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2246" : helpers.makeTestYear("Chile/Continental", [
		["2246-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2246-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2246-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2246-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2247" : helpers.makeTestYear("Chile/Continental", [
		["2247-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2247-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2247-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2247-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2248" : helpers.makeTestYear("Chile/Continental", [
		["2248-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2248-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2248-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2248-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2249" : helpers.makeTestYear("Chile/Continental", [
		["2249-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2249-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2249-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2249-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2250" : helpers.makeTestYear("Chile/Continental", [
		["2250-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2250-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2250-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2250-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2251" : helpers.makeTestYear("Chile/Continental", [
		["2251-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2251-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2251-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2251-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2252" : helpers.makeTestYear("Chile/Continental", [
		["2252-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2252-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2252-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2252-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2253" : helpers.makeTestYear("Chile/Continental", [
		["2253-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2253-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2253-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2253-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2254" : helpers.makeTestYear("Chile/Continental", [
		["2254-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2254-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2254-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2254-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2255" : helpers.makeTestYear("Chile/Continental", [
		["2255-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2255-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2255-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2255-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2256" : helpers.makeTestYear("Chile/Continental", [
		["2256-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2256-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2256-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2256-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2257" : helpers.makeTestYear("Chile/Continental", [
		["2257-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2257-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2257-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2257-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2258" : helpers.makeTestYear("Chile/Continental", [
		["2258-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2258-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2258-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2258-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2259" : helpers.makeTestYear("Chile/Continental", [
		["2259-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2259-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2259-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2259-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2260" : helpers.makeTestYear("Chile/Continental", [
		["2260-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2260-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2260-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2260-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2261" : helpers.makeTestYear("Chile/Continental", [
		["2261-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2261-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2261-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2261-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2262" : helpers.makeTestYear("Chile/Continental", [
		["2262-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2262-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2262-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2262-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2263" : helpers.makeTestYear("Chile/Continental", [
		["2263-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2263-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2263-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2263-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2264" : helpers.makeTestYear("Chile/Continental", [
		["2264-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2264-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2264-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2264-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2265" : helpers.makeTestYear("Chile/Continental", [
		["2265-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2265-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2265-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2265-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2266" : helpers.makeTestYear("Chile/Continental", [
		["2266-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2266-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2266-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2266-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2267" : helpers.makeTestYear("Chile/Continental", [
		["2267-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2267-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2267-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2267-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2268" : helpers.makeTestYear("Chile/Continental", [
		["2268-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2268-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2268-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2268-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2269" : helpers.makeTestYear("Chile/Continental", [
		["2269-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2269-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2269-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2269-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2270" : helpers.makeTestYear("Chile/Continental", [
		["2270-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2270-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2270-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2270-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2271" : helpers.makeTestYear("Chile/Continental", [
		["2271-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2271-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2271-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2271-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2272" : helpers.makeTestYear("Chile/Continental", [
		["2272-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2272-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2272-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2272-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2273" : helpers.makeTestYear("Chile/Continental", [
		["2273-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2273-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2273-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2273-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2274" : helpers.makeTestYear("Chile/Continental", [
		["2274-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2274-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2274-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2274-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2275" : helpers.makeTestYear("Chile/Continental", [
		["2275-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2275-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2275-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2275-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2276" : helpers.makeTestYear("Chile/Continental", [
		["2276-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2276-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2276-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2276-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2277" : helpers.makeTestYear("Chile/Continental", [
		["2277-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2277-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2277-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2277-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2278" : helpers.makeTestYear("Chile/Continental", [
		["2278-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2278-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2278-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2278-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2279" : helpers.makeTestYear("Chile/Continental", [
		["2279-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2279-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2279-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2279-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2280" : helpers.makeTestYear("Chile/Continental", [
		["2280-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2280-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2280-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2280-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2281" : helpers.makeTestYear("Chile/Continental", [
		["2281-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2281-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2281-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2281-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2282" : helpers.makeTestYear("Chile/Continental", [
		["2282-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2282-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2282-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2282-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2283" : helpers.makeTestYear("Chile/Continental", [
		["2283-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2283-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2283-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2283-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2284" : helpers.makeTestYear("Chile/Continental", [
		["2284-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2284-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2284-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2284-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2285" : helpers.makeTestYear("Chile/Continental", [
		["2285-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2285-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2285-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2285-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2286" : helpers.makeTestYear("Chile/Continental", [
		["2286-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2286-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2286-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2286-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2287" : helpers.makeTestYear("Chile/Continental", [
		["2287-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2287-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2287-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2287-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2288" : helpers.makeTestYear("Chile/Continental", [
		["2288-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2288-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2288-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2288-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2289" : helpers.makeTestYear("Chile/Continental", [
		["2289-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2289-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2289-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2289-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2290" : helpers.makeTestYear("Chile/Continental", [
		["2290-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2290-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2290-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2290-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2291" : helpers.makeTestYear("Chile/Continental", [
		["2291-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2291-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2291-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2291-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2292" : helpers.makeTestYear("Chile/Continental", [
		["2292-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2292-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2292-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2292-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2293" : helpers.makeTestYear("Chile/Continental", [
		["2293-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2293-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2293-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2293-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2294" : helpers.makeTestYear("Chile/Continental", [
		["2294-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2294-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2294-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2294-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2295" : helpers.makeTestYear("Chile/Continental", [
		["2295-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2295-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2295-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2295-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2296" : helpers.makeTestYear("Chile/Continental", [
		["2296-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2296-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2296-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2296-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2297" : helpers.makeTestYear("Chile/Continental", [
		["2297-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2297-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2297-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2297-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2298" : helpers.makeTestYear("Chile/Continental", [
		["2298-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2298-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2298-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2298-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2299" : helpers.makeTestYear("Chile/Continental", [
		["2299-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2299-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2299-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2299-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2300" : helpers.makeTestYear("Chile/Continental", [
		["2300-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2300-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2300-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2300-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2301" : helpers.makeTestYear("Chile/Continental", [
		["2301-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2301-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2301-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2301-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2302" : helpers.makeTestYear("Chile/Continental", [
		["2302-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2302-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2302-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2302-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2303" : helpers.makeTestYear("Chile/Continental", [
		["2303-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2303-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2303-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2303-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2304" : helpers.makeTestYear("Chile/Continental", [
		["2304-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2304-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2304-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2304-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2305" : helpers.makeTestYear("Chile/Continental", [
		["2305-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2305-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2305-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2305-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2306" : helpers.makeTestYear("Chile/Continental", [
		["2306-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2306-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2306-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2306-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2307" : helpers.makeTestYear("Chile/Continental", [
		["2307-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2307-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2307-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2307-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2308" : helpers.makeTestYear("Chile/Continental", [
		["2308-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2308-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2308-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2308-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2309" : helpers.makeTestYear("Chile/Continental", [
		["2309-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2309-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2309-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2309-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2310" : helpers.makeTestYear("Chile/Continental", [
		["2310-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2310-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2310-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2310-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2311" : helpers.makeTestYear("Chile/Continental", [
		["2311-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2311-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2311-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2311-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2312" : helpers.makeTestYear("Chile/Continental", [
		["2312-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2312-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2312-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2312-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2313" : helpers.makeTestYear("Chile/Continental", [
		["2313-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2313-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2313-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2313-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2314" : helpers.makeTestYear("Chile/Continental", [
		["2314-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2314-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2314-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2314-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2315" : helpers.makeTestYear("Chile/Continental", [
		["2315-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2315-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2315-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2315-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2316" : helpers.makeTestYear("Chile/Continental", [
		["2316-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2316-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2316-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2316-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2317" : helpers.makeTestYear("Chile/Continental", [
		["2317-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2317-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2317-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2317-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2318" : helpers.makeTestYear("Chile/Continental", [
		["2318-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2318-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2318-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2318-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2319" : helpers.makeTestYear("Chile/Continental", [
		["2319-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2319-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2319-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2319-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2320" : helpers.makeTestYear("Chile/Continental", [
		["2320-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2320-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2320-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2320-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2321" : helpers.makeTestYear("Chile/Continental", [
		["2321-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2321-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2321-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2321-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2322" : helpers.makeTestYear("Chile/Continental", [
		["2322-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2322-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2322-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2322-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2323" : helpers.makeTestYear("Chile/Continental", [
		["2323-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2323-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2323-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2323-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2324" : helpers.makeTestYear("Chile/Continental", [
		["2324-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2324-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2324-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2324-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2325" : helpers.makeTestYear("Chile/Continental", [
		["2325-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2325-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2325-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2325-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2326" : helpers.makeTestYear("Chile/Continental", [
		["2326-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2326-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2326-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2326-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2327" : helpers.makeTestYear("Chile/Continental", [
		["2327-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2327-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2327-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2327-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2328" : helpers.makeTestYear("Chile/Continental", [
		["2328-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2328-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2328-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2328-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2329" : helpers.makeTestYear("Chile/Continental", [
		["2329-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2329-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2329-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2329-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2330" : helpers.makeTestYear("Chile/Continental", [
		["2330-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2330-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2330-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2330-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2331" : helpers.makeTestYear("Chile/Continental", [
		["2331-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2331-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2331-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2331-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2332" : helpers.makeTestYear("Chile/Continental", [
		["2332-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2332-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2332-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2332-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2333" : helpers.makeTestYear("Chile/Continental", [
		["2333-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2333-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2333-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2333-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2334" : helpers.makeTestYear("Chile/Continental", [
		["2334-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2334-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2334-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2334-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2335" : helpers.makeTestYear("Chile/Continental", [
		["2335-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2335-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2335-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2335-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2336" : helpers.makeTestYear("Chile/Continental", [
		["2336-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2336-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2336-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2336-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2337" : helpers.makeTestYear("Chile/Continental", [
		["2337-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2337-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2337-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2337-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2338" : helpers.makeTestYear("Chile/Continental", [
		["2338-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2338-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2338-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2338-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2339" : helpers.makeTestYear("Chile/Continental", [
		["2339-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2339-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2339-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2339-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2340" : helpers.makeTestYear("Chile/Continental", [
		["2340-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2340-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2340-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2340-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2341" : helpers.makeTestYear("Chile/Continental", [
		["2341-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2341-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2341-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2341-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2342" : helpers.makeTestYear("Chile/Continental", [
		["2342-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2342-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2342-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2342-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2343" : helpers.makeTestYear("Chile/Continental", [
		["2343-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2343-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2343-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2343-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2344" : helpers.makeTestYear("Chile/Continental", [
		["2344-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2344-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2344-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2344-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2345" : helpers.makeTestYear("Chile/Continental", [
		["2345-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2345-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2345-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2345-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2346" : helpers.makeTestYear("Chile/Continental", [
		["2346-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2346-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2346-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2346-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2347" : helpers.makeTestYear("Chile/Continental", [
		["2347-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2347-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2347-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2347-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2348" : helpers.makeTestYear("Chile/Continental", [
		["2348-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2348-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2348-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2348-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2349" : helpers.makeTestYear("Chile/Continental", [
		["2349-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2349-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2349-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2349-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2350" : helpers.makeTestYear("Chile/Continental", [
		["2350-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2350-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2350-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2350-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2351" : helpers.makeTestYear("Chile/Continental", [
		["2351-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2351-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2351-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2351-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2352" : helpers.makeTestYear("Chile/Continental", [
		["2352-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2352-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2352-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2352-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2353" : helpers.makeTestYear("Chile/Continental", [
		["2353-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2353-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2353-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2353-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2354" : helpers.makeTestYear("Chile/Continental", [
		["2354-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2354-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2354-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2354-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2355" : helpers.makeTestYear("Chile/Continental", [
		["2355-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2355-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2355-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2355-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2356" : helpers.makeTestYear("Chile/Continental", [
		["2356-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2356-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2356-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2356-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2357" : helpers.makeTestYear("Chile/Continental", [
		["2357-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2357-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2357-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2357-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2358" : helpers.makeTestYear("Chile/Continental", [
		["2358-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2358-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2358-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2358-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2359" : helpers.makeTestYear("Chile/Continental", [
		["2359-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2359-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2359-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2359-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2360" : helpers.makeTestYear("Chile/Continental", [
		["2360-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2360-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2360-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2360-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2361" : helpers.makeTestYear("Chile/Continental", [
		["2361-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2361-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2361-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2361-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2362" : helpers.makeTestYear("Chile/Continental", [
		["2362-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2362-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2362-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2362-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2363" : helpers.makeTestYear("Chile/Continental", [
		["2363-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2363-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2363-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2363-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2364" : helpers.makeTestYear("Chile/Continental", [
		["2364-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2364-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2364-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2364-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2365" : helpers.makeTestYear("Chile/Continental", [
		["2365-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2365-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2365-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2365-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2366" : helpers.makeTestYear("Chile/Continental", [
		["2366-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2366-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2366-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2366-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2367" : helpers.makeTestYear("Chile/Continental", [
		["2367-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2367-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2367-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2367-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2368" : helpers.makeTestYear("Chile/Continental", [
		["2368-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2368-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2368-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2368-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2369" : helpers.makeTestYear("Chile/Continental", [
		["2369-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2369-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2369-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2369-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2370" : helpers.makeTestYear("Chile/Continental", [
		["2370-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2370-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2370-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2370-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2371" : helpers.makeTestYear("Chile/Continental", [
		["2371-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2371-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2371-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2371-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2372" : helpers.makeTestYear("Chile/Continental", [
		["2372-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2372-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2372-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2372-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2373" : helpers.makeTestYear("Chile/Continental", [
		["2373-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2373-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2373-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2373-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2374" : helpers.makeTestYear("Chile/Continental", [
		["2374-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2374-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2374-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2374-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2375" : helpers.makeTestYear("Chile/Continental", [
		["2375-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2375-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2375-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2375-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2376" : helpers.makeTestYear("Chile/Continental", [
		["2376-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2376-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2376-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2376-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2377" : helpers.makeTestYear("Chile/Continental", [
		["2377-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2377-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2377-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2377-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2378" : helpers.makeTestYear("Chile/Continental", [
		["2378-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2378-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2378-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2378-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2379" : helpers.makeTestYear("Chile/Continental", [
		["2379-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2379-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2379-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2379-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2380" : helpers.makeTestYear("Chile/Continental", [
		["2380-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2380-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2380-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2380-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2381" : helpers.makeTestYear("Chile/Continental", [
		["2381-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2381-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2381-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2381-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2382" : helpers.makeTestYear("Chile/Continental", [
		["2382-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2382-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2382-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2382-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2383" : helpers.makeTestYear("Chile/Continental", [
		["2383-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2383-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2383-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2383-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2384" : helpers.makeTestYear("Chile/Continental", [
		["2384-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2384-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2384-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2384-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2385" : helpers.makeTestYear("Chile/Continental", [
		["2385-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2385-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2385-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2385-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2386" : helpers.makeTestYear("Chile/Continental", [
		["2386-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2386-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2386-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2386-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2387" : helpers.makeTestYear("Chile/Continental", [
		["2387-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2387-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2387-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2387-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2388" : helpers.makeTestYear("Chile/Continental", [
		["2388-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2388-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2388-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2388-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2389" : helpers.makeTestYear("Chile/Continental", [
		["2389-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2389-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2389-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2389-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2390" : helpers.makeTestYear("Chile/Continental", [
		["2390-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2390-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2390-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2390-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2391" : helpers.makeTestYear("Chile/Continental", [
		["2391-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2391-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2391-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2391-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2392" : helpers.makeTestYear("Chile/Continental", [
		["2392-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2392-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2392-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2392-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2393" : helpers.makeTestYear("Chile/Continental", [
		["2393-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2393-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2393-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2393-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2394" : helpers.makeTestYear("Chile/Continental", [
		["2394-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2394-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2394-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2394-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2395" : helpers.makeTestYear("Chile/Continental", [
		["2395-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2395-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2395-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2395-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2396" : helpers.makeTestYear("Chile/Continental", [
		["2396-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2396-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2396-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2396-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2397" : helpers.makeTestYear("Chile/Continental", [
		["2397-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2397-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2397-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2397-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2398" : helpers.makeTestYear("Chile/Continental", [
		["2398-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2398-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2398-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2398-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2399" : helpers.makeTestYear("Chile/Continental", [
		["2399-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2399-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2399-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2399-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2400" : helpers.makeTestYear("Chile/Continental", [
		["2400-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2400-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2400-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2400-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2401" : helpers.makeTestYear("Chile/Continental", [
		["2401-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2401-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2401-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2401-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2402" : helpers.makeTestYear("Chile/Continental", [
		["2402-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2402-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2402-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2402-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2403" : helpers.makeTestYear("Chile/Continental", [
		["2403-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2403-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2403-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2403-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2404" : helpers.makeTestYear("Chile/Continental", [
		["2404-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2404-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2404-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2404-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2405" : helpers.makeTestYear("Chile/Continental", [
		["2405-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2405-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2405-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2405-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2406" : helpers.makeTestYear("Chile/Continental", [
		["2406-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2406-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2406-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2406-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2407" : helpers.makeTestYear("Chile/Continental", [
		["2407-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2407-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2407-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2407-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2408" : helpers.makeTestYear("Chile/Continental", [
		["2408-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2408-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2408-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2408-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2409" : helpers.makeTestYear("Chile/Continental", [
		["2409-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2409-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2409-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2409-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2410" : helpers.makeTestYear("Chile/Continental", [
		["2410-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2410-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2410-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2410-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2411" : helpers.makeTestYear("Chile/Continental", [
		["2411-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2411-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2411-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2411-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2412" : helpers.makeTestYear("Chile/Continental", [
		["2412-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2412-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2412-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2412-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2413" : helpers.makeTestYear("Chile/Continental", [
		["2413-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2413-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2413-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2413-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2414" : helpers.makeTestYear("Chile/Continental", [
		["2414-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2414-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2414-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2414-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2415" : helpers.makeTestYear("Chile/Continental", [
		["2415-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2415-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2415-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2415-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2416" : helpers.makeTestYear("Chile/Continental", [
		["2416-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2416-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2416-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2416-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2417" : helpers.makeTestYear("Chile/Continental", [
		["2417-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2417-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2417-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2417-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2418" : helpers.makeTestYear("Chile/Continental", [
		["2418-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2418-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2418-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2418-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2419" : helpers.makeTestYear("Chile/Continental", [
		["2419-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2419-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2419-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2419-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2420" : helpers.makeTestYear("Chile/Continental", [
		["2420-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2420-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2420-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2420-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2421" : helpers.makeTestYear("Chile/Continental", [
		["2421-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2421-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2421-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2421-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2422" : helpers.makeTestYear("Chile/Continental", [
		["2422-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2422-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2422-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2422-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2423" : helpers.makeTestYear("Chile/Continental", [
		["2423-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2423-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2423-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2423-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2424" : helpers.makeTestYear("Chile/Continental", [
		["2424-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2424-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2424-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2424-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2425" : helpers.makeTestYear("Chile/Continental", [
		["2425-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2425-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2425-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2425-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2426" : helpers.makeTestYear("Chile/Continental", [
		["2426-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2426-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2426-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2426-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2427" : helpers.makeTestYear("Chile/Continental", [
		["2427-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2427-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2427-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2427-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2428" : helpers.makeTestYear("Chile/Continental", [
		["2428-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2428-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2428-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2428-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2429" : helpers.makeTestYear("Chile/Continental", [
		["2429-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2429-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2429-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2429-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2430" : helpers.makeTestYear("Chile/Continental", [
		["2430-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2430-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2430-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2430-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2431" : helpers.makeTestYear("Chile/Continental", [
		["2431-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2431-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2431-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2431-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2432" : helpers.makeTestYear("Chile/Continental", [
		["2432-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2432-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2432-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2432-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2433" : helpers.makeTestYear("Chile/Continental", [
		["2433-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2433-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2433-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2433-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2434" : helpers.makeTestYear("Chile/Continental", [
		["2434-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2434-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2434-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2434-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2435" : helpers.makeTestYear("Chile/Continental", [
		["2435-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2435-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2435-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2435-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2436" : helpers.makeTestYear("Chile/Continental", [
		["2436-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2436-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2436-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2436-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2437" : helpers.makeTestYear("Chile/Continental", [
		["2437-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2437-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2437-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2437-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2438" : helpers.makeTestYear("Chile/Continental", [
		["2438-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2438-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2438-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2438-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2439" : helpers.makeTestYear("Chile/Continental", [
		["2439-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2439-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2439-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2439-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2440" : helpers.makeTestYear("Chile/Continental", [
		["2440-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2440-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2440-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2440-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2441" : helpers.makeTestYear("Chile/Continental", [
		["2441-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2441-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2441-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2441-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2442" : helpers.makeTestYear("Chile/Continental", [
		["2442-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2442-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2442-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2442-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2443" : helpers.makeTestYear("Chile/Continental", [
		["2443-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2443-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2443-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2443-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2444" : helpers.makeTestYear("Chile/Continental", [
		["2444-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2444-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2444-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2444-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2445" : helpers.makeTestYear("Chile/Continental", [
		["2445-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2445-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2445-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2445-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2446" : helpers.makeTestYear("Chile/Continental", [
		["2446-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2446-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2446-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2446-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2447" : helpers.makeTestYear("Chile/Continental", [
		["2447-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2447-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2447-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2447-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2448" : helpers.makeTestYear("Chile/Continental", [
		["2448-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2448-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2448-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2448-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2449" : helpers.makeTestYear("Chile/Continental", [
		["2449-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2449-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2449-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2449-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2450" : helpers.makeTestYear("Chile/Continental", [
		["2450-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2450-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2450-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2450-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2451" : helpers.makeTestYear("Chile/Continental", [
		["2451-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2451-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2451-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2451-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2452" : helpers.makeTestYear("Chile/Continental", [
		["2452-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2452-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2452-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2452-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2453" : helpers.makeTestYear("Chile/Continental", [
		["2453-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2453-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2453-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2453-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2454" : helpers.makeTestYear("Chile/Continental", [
		["2454-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2454-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2454-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2454-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2455" : helpers.makeTestYear("Chile/Continental", [
		["2455-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2455-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2455-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2455-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2456" : helpers.makeTestYear("Chile/Continental", [
		["2456-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2456-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2456-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2456-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2457" : helpers.makeTestYear("Chile/Continental", [
		["2457-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2457-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2457-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2457-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2458" : helpers.makeTestYear("Chile/Continental", [
		["2458-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2458-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2458-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2458-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2459" : helpers.makeTestYear("Chile/Continental", [
		["2459-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2459-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2459-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2459-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2460" : helpers.makeTestYear("Chile/Continental", [
		["2460-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2460-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2460-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2460-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2461" : helpers.makeTestYear("Chile/Continental", [
		["2461-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2461-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2461-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2461-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2462" : helpers.makeTestYear("Chile/Continental", [
		["2462-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2462-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2462-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2462-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2463" : helpers.makeTestYear("Chile/Continental", [
		["2463-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2463-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2463-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2463-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2464" : helpers.makeTestYear("Chile/Continental", [
		["2464-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2464-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2464-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2464-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2465" : helpers.makeTestYear("Chile/Continental", [
		["2465-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2465-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2465-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2465-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2466" : helpers.makeTestYear("Chile/Continental", [
		["2466-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2466-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2466-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2466-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2467" : helpers.makeTestYear("Chile/Continental", [
		["2467-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2467-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2467-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2467-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2468" : helpers.makeTestYear("Chile/Continental", [
		["2468-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2468-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2468-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2468-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2469" : helpers.makeTestYear("Chile/Continental", [
		["2469-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2469-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2469-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2469-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2470" : helpers.makeTestYear("Chile/Continental", [
		["2470-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2470-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2470-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2470-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2471" : helpers.makeTestYear("Chile/Continental", [
		["2471-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2471-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2471-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2471-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2472" : helpers.makeTestYear("Chile/Continental", [
		["2472-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2472-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2472-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2472-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2473" : helpers.makeTestYear("Chile/Continental", [
		["2473-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2473-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2473-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2473-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2474" : helpers.makeTestYear("Chile/Continental", [
		["2474-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2474-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2474-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2474-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2475" : helpers.makeTestYear("Chile/Continental", [
		["2475-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2475-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2475-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2475-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2476" : helpers.makeTestYear("Chile/Continental", [
		["2476-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2476-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2476-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2476-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2477" : helpers.makeTestYear("Chile/Continental", [
		["2477-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2477-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2477-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2477-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2478" : helpers.makeTestYear("Chile/Continental", [
		["2478-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2478-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2478-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2478-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2479" : helpers.makeTestYear("Chile/Continental", [
		["2479-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2479-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2479-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2479-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2480" : helpers.makeTestYear("Chile/Continental", [
		["2480-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2480-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2480-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2480-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2481" : helpers.makeTestYear("Chile/Continental", [
		["2481-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2481-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2481-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2481-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2482" : helpers.makeTestYear("Chile/Continental", [
		["2482-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2482-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2482-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2482-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2483" : helpers.makeTestYear("Chile/Continental", [
		["2483-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2483-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2483-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2483-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2484" : helpers.makeTestYear("Chile/Continental", [
		["2484-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2484-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2484-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2484-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2485" : helpers.makeTestYear("Chile/Continental", [
		["2485-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2485-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2485-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2485-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2486" : helpers.makeTestYear("Chile/Continental", [
		["2486-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2486-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2486-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2486-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2487" : helpers.makeTestYear("Chile/Continental", [
		["2487-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2487-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2487-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2487-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2488" : helpers.makeTestYear("Chile/Continental", [
		["2488-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2488-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2488-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2488-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2489" : helpers.makeTestYear("Chile/Continental", [
		["2489-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2489-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2489-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2489-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2490" : helpers.makeTestYear("Chile/Continental", [
		["2490-04-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2490-04-02T03:00:00+00:00", "23:00:00", "-04", 240],
		["2490-09-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2490-09-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2491" : helpers.makeTestYear("Chile/Continental", [
		["2491-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2491-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2491-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2491-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2492" : helpers.makeTestYear("Chile/Continental", [
		["2492-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2492-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2492-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2492-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2493" : helpers.makeTestYear("Chile/Continental", [
		["2493-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2493-04-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2493-09-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2493-09-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2494" : helpers.makeTestYear("Chile/Continental", [
		["2494-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2494-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2494-09-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2494-09-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2495" : helpers.makeTestYear("Chile/Continental", [
		["2495-04-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2495-04-03T03:00:00+00:00", "23:00:00", "-04", 240],
		["2495-09-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2495-09-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2496" : helpers.makeTestYear("Chile/Continental", [
		["2496-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2496-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2496-09-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2496-09-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2497" : helpers.makeTestYear("Chile/Continental", [
		["2497-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2497-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2497-09-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2497-09-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2498" : helpers.makeTestYear("Chile/Continental", [
		["2498-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2498-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2498-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2498-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2499" : helpers.makeTestYear("Chile/Continental", [
		["2499-04-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2499-04-05T03:00:00+00:00", "23:00:00", "-04", 240]
	])
};