/* This file generated from tools/Generate-Collation-Data.p6 */
struct collation_key {
    MVMuint32 primary :16;
    MVMuint32 tertiary :5;
    MVMuint32 special :1;
    MVMuint32 secondary :9;
};
struct sub_node {
    MVMuint32 codepoint :18;
    MVMuint32 collation_key_link :14;
    MVMuint32 sub_node_link :13;
    MVMuint32 sub_node_elems :13;
    MVMuint32 collation_key_elems :5;
};
typedef struct sub_node sub_node;
#define main_nodes_elems 4710
#define starter_main_nodes_elems 3816
#define codepoint_sequence_no_max 3
#define special_collation_keys_elems 10463
/* Data from PropList.txt */
MVM_STATIC_INLINE MVMuint32 is_unified_ideograph (MVMCodepoint cp) {
    return
       (0x3400  <= cp && cp <= 0x4DB5 ) /* 3400..4DB5 Unified_Ideograph # Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5 */
    || (0x4E00  <= cp && cp <= 0x9FEF ) /* 4E00..9FEF Unified_Ideograph # Lo [20976] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FEF */
    || (0xFA0E  <= cp && cp <= 0xFA0F ) /* FA0E..FA0F Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA0E..CJK COMPATIBILITY IDEOGRAPH-FA0F */
    || (0xFA11                   == cp) /* FA11..FA11 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA11 */
    || (0xFA13  <= cp && cp <= 0xFA14 ) /* FA13..FA14 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA13..CJK COMPATIBILITY IDEOGRAPH-FA14 */
    || (0xFA1F                   == cp) /* FA1F..FA1F Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA1F */
    || (0xFA21                   == cp) /* FA21..FA21 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA21 */
    || (0xFA23  <= cp && cp <= 0xFA24 ) /* FA23..FA24 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA23..CJK COMPATIBILITY IDEOGRAPH-FA24 */
    || (0xFA27  <= cp && cp <= 0xFA29 ) /* FA27..FA29 Unified_Ideograph # Lo   [3] CJK COMPATIBILITY IDEOGRAPH-FA27..CJK COMPATIBILITY IDEOGRAPH-FA29 */
    || (0x20000 <= cp && cp <= 0x2A6D6) /* 20000..2A6D6 Unified_Ideograph # Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6 */
    || (0x2A700 <= cp && cp <= 0x2B734) /* 2A700..2B734 Unified_Ideograph # Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734 */
    || (0x2B740 <= cp && cp <= 0x2B81D) /* 2B740..2B81D Unified_Ideograph # Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D */
    || (0x2B820 <= cp && cp <= 0x2CEA1) /* 2B820..2CEA1 Unified_Ideograph # Lo [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1 */
    || (0x2CEB0 <= cp && cp <= 0x2EBE0) /* 2CEB0..2EBE0 Unified_Ideograph # Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0 */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Assigned_Block_Nushu (MVMCodepoint cp) {
    return
       (0x1B170 <= cp && cp <= 0x1B2FF) /* 1B170..1B2FF Nushu                              */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_Tangut (MVMCodepoint cp) {
    return
       (0x17000 <= cp && cp <= 0x187FF) /* 17000..187FF Tangut                             */
    || (0x18800 <= cp && cp <= 0x18AFF) /* 18800..18AFF Tangut Components                  */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_CJK_Unified_Ideographs_OR_CJK_Compatibility_Ideographs (MVMCodepoint cp) {
    return
       (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF CJK Unified Ideographs             */
    || (0xF900  <= cp && cp <= 0xFAFF ) /* F900..FAFF CJK Compatibility Ideographs       */
    ;
}

sub_node main_nodes[4710] = {
{76,0,3816,1,0},{108,0,3817,1,0},{188,4,0,0,3},{189,7,0,0,3},{190,10,0,0,3},
{192,13,0,0,2},{193,15,0,0,2},{194,17,0,0,2},{195,19,0,0,2},{196,21,0,0,2},{197,
23,0,0,2},{198,25,0,0,3},{199,28,0,0,2},{200,30,0,0,2},{201,32,0,0,2},{202,34,0,
0,2},{203,36,0,0,2},{204,38,0,0,2},{205,40,0,0,2},{206,42,0,0,2},{207,44,0,0,2},
{208,46,0,0,2},{209,48,0,0,2},{210,50,0,0,2},{211,52,0,0,2},{212,54,0,0,2},{213,
56,0,0,2},{214,58,0,0,2},{216,60,0,0,2},{217,62,0,0,2},{218,64,0,0,2},{219,66,0,
0,2},{220,68,0,0,2},{221,70,0,0,2},{223,72,0,0,3},{224,75,0,0,2},{225,77,0,0,2},
{226,79,0,0,2},{227,81,0,0,2},{228,83,0,0,2},{229,85,0,0,2},{230,87,0,0,3},{231,
90,0,0,2},{232,92,0,0,2},{233,94,0,0,2},{234,96,0,0,2},{235,98,0,0,2},{236,100,
0,0,2},{237,102,0,0,2},{238,104,0,0,2},{239,106,0,0,2},{240,108,0,0,2},{241,110,
0,0,2},{242,112,0,0,2},{243,114,0,0,2},{244,116,0,0,2},{245,118,0,0,2},{246,120,
0,0,2},{248,122,0,0,2},{249,124,0,0,2},{250,126,0,0,2},{251,128,0,0,2},{252,130,
0,0,2},{253,132,0,0,2},{255,134,0,0,2},{256,136,0,0,2},{257,138,0,0,2},{258,140,
0,0,2},{259,142,0,0,2},{260,144,0,0,2},{261,146,0,0,2},{262,148,0,0,2},{263,150,
0,0,2},{264,152,0,0,2},{265,154,0,0,2},{266,156,0,0,2},{267,158,0,0,2},{268,160,
0,0,2},{269,162,0,0,2},{270,164,0,0,2},{271,166,0,0,2},{272,168,0,0,2},{273,170,
0,0,2},{274,172,0,0,2},{275,174,0,0,2},{276,176,0,0,2},{277,178,0,0,2},{278,180,
0,0,2},{279,182,0,0,2},{280,184,0,0,2},{281,186,0,0,2},{282,188,0,0,2},{283,190,
0,0,2},{284,192,0,0,2},{285,194,0,0,2},{286,196,0,0,2},{287,198,0,0,2},{288,200,
0,0,2},{289,202,0,0,2},{290,204,0,0,2},{291,206,0,0,2},{292,208,0,0,2},{293,210,
0,0,2},{294,212,0,0,2},{295,214,0,0,2},{296,216,0,0,2},{297,218,0,0,2},{298,220,
0,0,2},{299,222,0,0,2},{300,224,0,0,2},{301,226,0,0,2},{302,228,0,0,2},{303,230,
0,0,2},{304,232,0,0,2},{306,234,0,0,2},{307,236,0,0,2},{308,238,0,0,2},{309,240,
0,0,2},{310,242,0,0,2},{311,244,0,0,2},{313,246,0,0,2},{314,248,0,0,2},{315,250,
0,0,2},{316,252,0,0,2},{317,254,0,0,2},{318,256,0,0,2},{319,258,0,0,2},{320,260,
0,0,2},{321,262,0,0,2},{322,264,0,0,2},{323,266,0,0,2},{324,268,0,0,2},{325,270,
0,0,2},{326,272,0,0,2},{327,274,0,0,2},{328,276,0,0,2},{329,278,0,0,2},{332,280,
0,0,2},{333,282,0,0,2},{334,284,0,0,2},{335,286,0,0,2},{336,288,0,0,2},{337,290,
0,0,2},{338,292,0,0,3},{339,295,0,0,3},{340,298,0,0,2},{341,300,0,0,2},{342,302,
0,0,2},{343,304,0,0,2},{344,306,0,0,2},{345,308,0,0,2},{346,310,0,0,2},{347,312,
0,0,2},{348,314,0,0,2},{349,316,0,0,2},{350,318,0,0,2},{351,320,0,0,2},{352,322,
0,0,2},{353,324,0,0,2},{354,326,0,0,2},{355,328,0,0,2},{356,330,0,0,2},{357,332,
0,0,2},{360,334,0,0,2},{361,336,0,0,2},{362,338,0,0,2},{363,340,0,0,2},{364,342,
0,0,2},{365,344,0,0,2},{366,346,0,0,2},{367,348,0,0,2},{368,350,0,0,2},{369,352,
0,0,2},{370,354,0,0,2},{371,356,0,0,2},{372,358,0,0,2},{373,360,0,0,2},{374,362,
0,0,2},{375,364,0,0,2},{376,366,0,0,2},{377,368,0,0,2},{378,370,0,0,2},{379,372,
0,0,2},{380,374,0,0,2},{381,376,0,0,2},{382,378,0,0,2},{383,380,0,0,2},{397,382,
0,0,2},{416,384,0,0,2},{417,386,0,0,2},{431,388,0,0,2},{432,390,0,0,2},{446,392,
0,0,2},{452,394,0,0,3},{453,397,0,0,3},{454,400,0,0,3},{455,403,0,0,2},{456,405,
0,0,2},{457,407,0,0,2},{458,409,0,0,2},{459,411,0,0,2},{460,413,0,0,2},{461,415,
0,0,2},{462,417,0,0,2},{463,419,0,0,2},{464,421,0,0,2},{465,423,0,0,2},{466,425,
0,0,2},{467,427,0,0,2},{468,429,0,0,2},{469,431,0,0,3},{470,434,0,0,3},{471,437,
0,0,3},{472,440,0,0,3},{473,443,0,0,3},{474,446,0,0,3},{475,449,0,0,3},{476,452,
0,0,3},{478,455,0,0,3},{479,458,0,0,3},{480,461,0,0,3},{481,464,0,0,3},{482,467,
0,0,4},{483,471,0,0,4},{486,475,0,0,2},{487,477,0,0,2},{488,479,0,0,2},{489,481,
0,0,2},{490,483,0,0,2},{491,485,0,0,2},{492,487,0,0,3},{493,490,0,0,3},{494,493,
0,0,2},{495,495,0,0,2},{496,497,0,0,2},{497,499,0,0,2},{498,501,0,0,2},{499,503,
0,0,2},{500,505,0,0,2},{501,507,0,0,2},{504,509,0,0,2},{505,511,0,0,2},{506,513,
0,0,3},{507,516,0,0,3},{508,519,0,0,4},{509,523,0,0,4},{510,527,0,0,3},{511,530,
0,0,3},{512,533,0,0,2},{513,535,0,0,2},{514,537,0,0,2},{515,539,0,0,2},{516,541,
0,0,2},{517,543,0,0,2},{518,545,0,0,2},{519,547,0,0,2},{520,549,0,0,2},{521,551,
0,0,2},{522,553,0,0,2},{523,555,0,0,2},{524,557,0,0,2},{525,559,0,0,2},{526,561,
0,0,2},{527,563,0,0,2},{528,565,0,0,2},{529,567,0,0,2},{530,569,0,0,2},{531,571,
0,0,2},{532,573,0,0,2},{533,575,0,0,2},{534,577,0,0,2},{535,579,0,0,2},{536,581,
0,0,2},{537,583,0,0,2},{538,585,0,0,2},{539,587,0,0,2},{542,589,0,0,2},{543,591,
0,0,2},{550,593,0,0,2},{551,595,0,0,2},{552,597,0,0,2},{553,599,0,0,2},{554,601,
0,0,3},{555,604,0,0,3},{556,607,0,0,3},{557,610,0,0,3},{558,613,0,0,2},{559,615,
0,0,2},{560,617,0,0,3},{561,620,0,0,3},{562,623,0,0,2},{563,625,0,0,2},{568,627,
0,0,2},{569,629,0,0,2},{675,631,0,0,2},{676,633,0,0,2},{677,635,0,0,2},{678,637,
0,0,2},{679,639,0,0,2},{680,641,0,0,2},{681,643,0,0,2},{682,645,0,0,2},{683,647,
0,0,2},{776,0,3818,1,0},{901,651,0,0,2},{902,653,0,0,2},{904,655,0,0,2},{905,
657,0,0,2},{906,659,0,0,2},{908,661,0,0,2},{910,663,0,0,2},{911,665,0,0,2},{912,
667,0,0,3},{938,670,0,0,2},{939,672,0,0,2},{940,674,0,0,2},{941,676,0,0,2},{942,
678,0,0,2},{943,680,0,0,2},{944,682,0,0,3},{970,685,0,0,2},{971,687,0,0,2},{972,
689,0,0,2},{973,691,0,0,2},{974,693,0,0,2},{975,695,0,0,3},{979,698,0,0,2},{980,
700,0,0,2},{983,702,0,0,3},{1024,705,0,0,2},{1025,707,0,0,2},{1027,709,0,0,2},
{1031,711,0,0,2},{1036,713,0,0,2},{1037,715,0,0,2},{1038,717,0,0,2},{1104,719,0,
0,2},{1105,721,0,0,2},{1107,723,0,0,2},{1111,725,0,0,2},{1116,727,0,0,2},{1117,
729,0,0,2},{1118,731,0,0,2},{1142,733,0,0,2},{1143,735,0,0,2},{1168,737,0,0,2},
{1169,739,0,0,2},{1217,741,0,0,2},{1218,743,0,0,2},{1232,745,0,0,2},{1233,747,0,
0,2},{1234,749,0,0,2},{1235,751,0,0,2},{1238,753,0,0,2},{1239,755,0,0,2},{1242,
757,0,0,2},{1243,759,0,0,2},{1244,761,0,0,2},{1245,763,0,0,2},{1246,765,0,0,2},
{1247,767,0,0,2},{1250,769,0,0,2},{1251,771,0,0,2},{1252,773,0,0,2},{1253,775,0,
0,2},{1254,777,0,0,2},{1255,779,0,0,2},{1258,781,0,0,2},{1259,783,0,0,2},{1260,
785,0,0,2},{1261,787,0,0,2},{1262,789,0,0,2},{1263,791,0,0,2},{1264,793,0,0,2},
{1265,795,0,0,2},{1266,797,0,0,2},{1267,799,0,0,2},{1268,801,0,0,2},{1269,803,0,
0,2},{1272,805,0,0,2},{1273,807,0,0,2},{1415,809,0,0,2},{1488,0,3819,3,0},{1489,
0,3822,2,0},{1490,0,3824,1,0},{1491,0,3825,1,0},{1492,0,3826,1,0},{1493,0,3827,
2,0},{1494,0,3829,1,0},{1496,0,3830,1,0},{1497,0,3831,2,0},{1498,0,3833,1,0},
{1499,0,3834,2,0},{1500,0,3836,1,0},{1502,0,3837,1,0},{1504,0,3838,1,0},{1505,0,
3839,1,0},{1507,0,3840,1,0},{1508,0,3841,2,0},{1510,0,3843,1,0},{1511,0,3844,1,
0},{1512,0,3845,1,0},{1513,0,3846,3,0},{1514,0,3851,1,0},{1519,879,0,0,4},{1520,
883,0,0,2},{1521,885,0,0,2},{1522,887,3852,1,2},{1653,892,0,0,2},{1654,894,0,0,
2},{1655,896,0,0,2},{1656,898,0,0,2},{1728,900,0,0,2},{1730,902,0,0,2},{1747,
904,0,0,2},{1789,906,0,0,2},{1790,908,0,0,2},{1812,910,0,0,2},{1820,912,0,0,2},
{1831,914,0,0,2},{1837,916,0,0,2},{1838,918,0,0,2},{1839,920,0,0,2},{2024,922,0,
0,2},{2025,924,0,0,2},{2026,926,0,0,2},{2325,0,3853,1,0},{2326,0,3854,1,0},
{2327,0,3855,1,0},{2332,0,3856,1,0},{2337,0,3857,1,0},{2338,0,3858,1,0},{2345,
940,0,0,2},{2347,0,3859,1,0},{2351,0,3860,1,0},{2353,946,0,0,2},{2356,948,0,0,
2},{2465,0,3861,1,0},{2466,0,3862,1,0},{2479,0,3863,1,0},{2510,956,0,0,2},{2582,
0,3864,1,0},{2583,0,3865,1,0},{2588,0,3866,1,0},{2603,0,3867,1,0},{2610,0,3868,
1,0},{2616,0,3869,1,0},{2849,0,3870,1,0},{2850,0,3871,1,0},{3406,974,0,0,2},
{3412,976,0,0,2},{3413,978,0,0,2},{3414,980,0,0,2},{3450,982,0,0,2},{3451,984,0,
0,2},{3452,986,0,0,2},{3453,988,0,0,2},{3454,990,0,0,2},{3455,992,0,0,2},{3648,
0,3872,46,0},{3649,0,3918,46,0},{3650,0,3964,46,0},{3651,0,4010,46,0},{3652,0,
4056,46,0},{3661,0,4102,1,0},{3776,0,4103,31,0},{3777,0,4134,31,0},{3778,0,4165,
31,0},{3779,0,4196,31,0},{3780,0,4227,31,0},{3789,0,4258,1,0},{3804,1776,0,0,2},
{3805,1778,0,0,2},{3840,1780,0,0,3},{3904,0,4259,1,0},{3906,0,4260,1,0},{3916,0,
4261,1,0},{3921,0,4262,1,0},{3926,0,4263,1,0},{3931,0,4264,1,0},{3946,1795,0,0,
2},{3953,0,4265,3,0},{3984,0,4268,1,0},{3986,0,4269,1,0},{3996,0,4270,1,0},
{4001,0,4271,1,0},{4006,0,4272,1,0},{4011,0,4273,1,0},{4018,0,4274,2,0},{4019,0,
4277,2,0},{4026,1816,0,0,2},{4027,1818,0,0,2},{4028,1820,0,0,2},{4159,1822,0,0,
3},{5793,1825,0,0,2},{5796,1827,0,0,2},{5797,1829,0,0,2},{5799,1831,0,0,2},
{5801,1833,0,0,2},{5804,1835,0,0,2},{5805,1837,0,0,2},{5806,1839,0,0,2},{5811,
1841,0,0,2},{5812,1843,0,0,2},{5813,1845,0,0,2},{5814,1847,0,0,2},{5819,1849,0,
0,2},{5820,1851,0,0,2},{5821,1853,0,0,2},{5823,1855,0,0,2},{5824,1857,0,0,2},
{5826,1859,0,0,2},{5828,1861,0,0,2},{5830,1863,0,0,2},{5835,1865,0,0,2},{5836,
1867,0,0,2},{5837,1869,0,0,2},{5838,1871,0,0,2},{5840,1873,0,0,2},{5841,1875,0,
0,2},{5843,1877,0,0,2},{5844,1879,0,0,2},{5845,1881,0,0,2},{5848,1883,0,0,2},
{5849,1885,0,0,2},{5851,1887,0,0,2},{5853,1889,0,0,2},{5863,1891,0,0,2},{5864,
1893,0,0,2},{5865,1895,0,0,2},{5866,1897,0,0,2},{5870,1899,0,0,2},{5871,1901,0,
0,4},{5872,1905,0,0,2},{6429,1907,0,0,2},{6430,1909,0,0,2},{6581,0,4280,44,0},
{6582,0,4324,44,0},{6583,0,4368,44,0},{6586,0,4412,44,0},{6622,2263,0,0,2},
{6623,2265,0,0,3},{6740,2268,0,0,3},{7469,2271,0,0,3},{7545,2274,0,0,2},{7546,
2276,0,0,3},{7582,2279,0,0,2},{7635,2281,0,0,2},{7636,2283,0,0,3},{7637,2286,0,
0,2},{7638,2288,0,0,2},{7639,2290,0,0,2},{7640,2292,0,0,2},{7641,2294,0,0,2},
{7653,2296,0,0,2},{7661,2298,0,0,2},{7664,2300,0,0,2},{7666,2302,0,0,2},{7667,
2304,0,0,2},{7668,2306,0,0,2},{7680,2308,0,0,2},{7681,2310,0,0,2},{7682,2312,0,
0,2},{7683,2314,0,0,2},{7684,2316,0,0,2},{7685,2318,0,0,2},{7686,2320,0,0,2},
{7687,2322,0,0,2},{7688,2324,0,0,3},{7689,2327,0,0,3},{7690,2330,0,0,2},{7691,
2332,0,0,2},{7692,2334,0,0,2},{7693,2336,0,0,2},{7694,2338,0,0,2},{7695,2340,0,
0,2},{7696,2342,0,0,2},{7697,2344,0,0,2},{7698,2346,0,0,2},{7699,2348,0,0,2},
{7700,2350,0,0,3},{7701,2353,0,0,3},{7702,2356,0,0,3},{7703,2359,0,0,3},{7704,
2362,0,0,2},{7705,2364,0,0,2},{7706,2366,0,0,2},{7707,2368,0,0,2},{7708,2370,0,
0,3},{7709,2373,0,0,3},{7710,2376,0,0,2},{7711,2378,0,0,2},{7712,2380,0,0,2},
{7713,2382,0,0,2},{7714,2384,0,0,2},{7715,2386,0,0,2},{7716,2388,0,0,2},{7717,
2390,0,0,2},{7718,2392,0,0,2},{7719,2394,0,0,2},{7720,2396,0,0,2},{7721,2398,0,
0,2},{7722,2400,0,0,2},{7723,2402,0,0,2},{7724,2404,0,0,2},{7725,2406,0,0,2},
{7726,2408,0,0,3},{7727,2411,0,0,3},{7728,2414,0,0,2},{7729,2416,0,0,2},{7730,
2418,0,0,2},{7731,2420,0,0,2},{7732,2422,0,0,2},{7733,2424,0,0,2},{7734,2426,0,
0,2},{7735,2428,0,0,2},{7736,2430,0,0,3},{7737,2433,0,0,3},{7738,2436,0,0,2},
{7739,2438,0,0,2},{7740,2440,0,0,2},{7741,2442,0,0,2},{7742,2444,0,0,2},{7743,
2446,0,0,2},{7744,2448,0,0,2},{7745,2450,0,0,2},{7746,2452,0,0,2},{7747,2454,0,
0,2},{7748,2456,0,0,2},{7749,2458,0,0,2},{7750,2460,0,0,2},{7751,2462,0,0,2},
{7752,2464,0,0,2},{7753,2466,0,0,2},{7754,2468,0,0,2},{7755,2470,0,0,2},{7756,
2472,0,0,3},{7757,2475,0,0,3},{7758,2478,0,0,3},{7759,2481,0,0,3},{7760,2484,0,
0,3},{7761,2487,0,0,3},{7762,2490,0,0,3},{7763,2493,0,0,3},{7764,2496,0,0,2},
{7765,2498,0,0,2},{7766,2500,0,0,2},{7767,2502,0,0,2},{7768,2504,0,0,2},{7769,
2506,0,0,2},{7770,2508,0,0,2},{7771,2510,0,0,2},{7772,2512,0,0,3},{7773,2515,0,
0,3},{7774,2518,0,0,2},{7775,2520,0,0,2},{7776,2522,0,0,2},{7777,2524,0,0,2},
{7778,2526,0,0,2},{7779,2528,0,0,2},{7780,2530,0,0,3},{7781,2533,0,0,3},{7782,
2536,0,0,3},{7783,2539,0,0,3},{7784,2542,0,0,3},{7785,2545,0,0,3},{7786,2548,0,
0,2},{7787,2550,0,0,2},{7788,2552,0,0,2},{7789,2554,0,0,2},{7790,2556,0,0,2},
{7791,2558,0,0,2},{7792,2560,0,0,2},{7793,2562,0,0,2},{7794,2564,0,0,2},{7795,
2566,0,0,2},{7796,2568,0,0,2},{7797,2570,0,0,2},{7798,2572,0,0,2},{7799,2574,0,
0,2},{7800,2576,0,0,3},{7801,2579,0,0,3},{7802,2582,0,0,3},{7803,2585,0,0,3},
{7804,2588,0,0,2},{7805,2590,0,0,2},{7806,2592,0,0,2},{7807,2594,0,0,2},{7808,
2596,0,0,2},{7809,2598,0,0,2},{7810,2600,0,0,2},{7811,2602,0,0,2},{7812,2604,0,
0,2},{7813,2606,0,0,2},{7814,2608,0,0,2},{7815,2610,0,0,2},{7816,2612,0,0,2},
{7817,2614,0,0,2},{7818,2616,0,0,2},{7819,2618,0,0,2},{7820,2620,0,0,2},{7821,
2622,0,0,2},{7822,2624,0,0,2},{7823,2626,0,0,2},{7824,2628,0,0,2},{7825,2630,0,
0,2},{7826,2632,0,0,2},{7827,2634,0,0,2},{7828,2636,0,0,2},{7829,2638,0,0,2},
{7830,2640,0,0,2},{7831,2642,0,0,2},{7832,2644,0,0,2},{7833,2646,0,0,2},{7834,
2648,0,0,2},{7835,2650,0,0,3},{7838,2653,0,0,3},{7840,2656,0,0,2},{7841,2658,0,
0,2},{7842,2660,0,0,2},{7843,2662,0,0,2},{7844,2664,0,0,3},{7845,2667,0,0,3},
{7846,2670,0,0,3},{7847,2673,0,0,3},{7848,2676,0,0,3},{7849,2679,0,0,3},{7850,
2682,0,0,3},{7851,2685,0,0,3},{7852,2688,0,0,3},{7853,2691,0,0,3},{7854,2694,0,
0,3},{7855,2697,0,0,3},{7856,2700,0,0,3},{7857,2703,0,0,3},{7858,2706,0,0,3},
{7859,2709,0,0,3},{7860,2712,0,0,3},{7861,2715,0,0,3},{7862,2718,0,0,3},{7863,
2721,0,0,3},{7864,2724,0,0,2},{7865,2726,0,0,2},{7866,2728,0,0,2},{7867,2730,0,
0,2},{7868,2732,0,0,2},{7869,2734,0,0,2},{7870,2736,0,0,3},{7871,2739,0,0,3},
{7872,2742,0,0,3},{7873,2745,0,0,3},{7874,2748,0,0,3},{7875,2751,0,0,3},{7876,
2754,0,0,3},{7877,2757,0,0,3},{7878,2760,0,0,3},{7879,2763,0,0,3},{7880,2766,0,
0,2},{7881,2768,0,0,2},{7882,2770,0,0,2},{7883,2772,0,0,2},{7884,2774,0,0,2},
{7885,2776,0,0,2},{7886,2778,0,0,2},{7887,2780,0,0,2},{7888,2782,0,0,3},{7889,
2785,0,0,3},{7890,2788,0,0,3},{7891,2791,0,0,3},{7892,2794,0,0,3},{7893,2797,0,
0,3},{7894,2800,0,0,3},{7895,2803,0,0,3},{7896,2806,0,0,3},{7897,2809,0,0,3},
{7898,2812,0,0,3},{7899,2815,0,0,3},{7900,2818,0,0,3},{7901,2821,0,0,3},{7902,
2824,0,0,3},{7903,2827,0,0,3},{7904,2830,0,0,3},{7905,2833,0,0,3},{7906,2836,0,
0,3},{7907,2839,0,0,3},{7908,2842,0,0,2},{7909,2844,0,0,2},{7910,2846,0,0,2},
{7911,2848,0,0,2},{7912,2850,0,0,3},{7913,2853,0,0,3},{7914,2856,0,0,3},{7915,
2859,0,0,3},{7916,2862,0,0,3},{7917,2865,0,0,3},{7918,2868,0,0,3},{7919,2871,0,
0,3},{7920,2874,0,0,3},{7921,2877,0,0,3},{7922,2880,0,0,2},{7923,2882,0,0,2},
{7924,2884,0,0,2},{7925,2886,0,0,2},{7926,2888,0,0,2},{7927,2890,0,0,2},{7928,
2892,0,0,2},{7929,2894,0,0,2},{7930,2896,0,0,2},{7931,2898,0,0,2},{7936,2900,0,
0,2},{7937,2902,0,0,2},{7938,2904,0,0,3},{7939,2907,0,0,3},{7940,2910,0,0,3},
{7941,2913,0,0,3},{7942,2916,0,0,3},{7943,2919,0,0,3},{7944,2922,0,0,2},{7945,
2924,0,0,2},{7946,2926,0,0,3},{7947,2929,0,0,3},{7948,2932,0,0,3},{7949,2935,0,
0,3},{7950,2938,0,0,3},{7951,2941,0,0,3},{7952,2944,0,0,2},{7953,2946,0,0,2},
{7954,2948,0,0,3},{7955,2951,0,0,3},{7956,2954,0,0,3},{7957,2957,0,0,3},{7960,
2960,0,0,2},{7961,2962,0,0,2},{7962,2964,0,0,3},{7963,2967,0,0,3},{7964,2970,0,
0,3},{7965,2973,0,0,3},{7968,2976,0,0,2},{7969,2978,0,0,2},{7970,2980,0,0,3},
{7971,2983,0,0,3},{7972,2986,0,0,3},{7973,2989,0,0,3},{7974,2992,0,0,3},{7975,
2995,0,0,3},{7976,2998,0,0,2},{7977,3000,0,0,2},{7978,3002,0,0,3},{7979,3005,0,
0,3},{7980,3008,0,0,3},{7981,3011,0,0,3},{7982,3014,0,0,3},{7983,3017,0,0,3},
{7984,3020,0,0,2},{7985,3022,0,0,2},{7986,3024,0,0,3},{7987,3027,0,0,3},{7988,
3030,0,0,3},{7989,3033,0,0,3},{7990,3036,0,0,3},{7991,3039,0,0,3},{7992,3042,0,
0,2},{7993,3044,0,0,2},{7994,3046,0,0,3},{7995,3049,0,0,3},{7996,3052,0,0,3},
{7997,3055,0,0,3},{7998,3058,0,0,3},{7999,3061,0,0,3},{8000,3064,0,0,2},{8001,
3066,0,0,2},{8002,3068,0,0,3},{8003,3071,0,0,3},{8004,3074,0,0,3},{8005,3077,0,
0,3},{8008,3080,0,0,2},{8009,3082,0,0,2},{8010,3084,0,0,3},{8011,3087,0,0,3},
{8012,3090,0,0,3},{8013,3093,0,0,3},{8016,3096,0,0,2},{8017,3098,0,0,2},{8018,
3100,0,0,3},{8019,3103,0,0,3},{8020,3106,0,0,3},{8021,3109,0,0,3},{8022,3112,0,
0,3},{8023,3115,0,0,3},{8025,3118,0,0,2},{8027,3120,0,0,3},{8029,3123,0,0,3},
{8031,3126,0,0,3},{8032,3129,0,0,2},{8033,3131,0,0,2},{8034,3133,0,0,3},{8035,
3136,0,0,3},{8036,3139,0,0,3},{8037,3142,0,0,3},{8038,3145,0,0,3},{8039,3148,0,
0,3},{8040,3151,0,0,2},{8041,3153,0,0,2},{8042,3155,0,0,3},{8043,3158,0,0,3},
{8044,3161,0,0,3},{8045,3164,0,0,3},{8046,3167,0,0,3},{8047,3170,0,0,3},{8048,
3173,0,0,2},{8050,3175,0,0,2},{8052,3177,0,0,2},{8054,3179,0,0,2},{8056,3181,0,
0,2},{8058,3183,0,0,2},{8060,3185,0,0,2},{8064,3187,0,0,3},{8065,3190,0,0,3},
{8066,3193,0,0,4},{8067,3197,0,0,4},{8068,3201,0,0,4},{8069,3205,0,0,4},{8070,
3209,0,0,4},{8071,3213,0,0,4},{8072,3217,0,0,3},{8073,3220,0,0,3},{8074,3223,0,
0,4},{8075,3227,0,0,4},{8076,3231,0,0,4},{8077,3235,0,0,4},{8078,3239,0,0,4},
{8079,3243,0,0,4},{8080,3247,0,0,3},{8081,3250,0,0,3},{8082,3253,0,0,4},{8083,
3257,0,0,4},{8084,3261,0,0,4},{8085,3265,0,0,4},{8086,3269,0,0,4},{8087,3273,0,
0,4},{8088,3277,0,0,3},{8089,3280,0,0,3},{8090,3283,0,0,4},{8091,3287,0,0,4},
{8092,3291,0,0,4},{8093,3295,0,0,4},{8094,3299,0,0,4},{8095,3303,0,0,4},{8096,
3307,0,0,3},{8097,3310,0,0,3},{8098,3313,0,0,4},{8099,3317,0,0,4},{8100,3321,0,
0,4},{8101,3325,0,0,4},{8102,3329,0,0,4},{8103,3333,0,0,4},{8104,3337,0,0,3},
{8105,3340,0,0,3},{8106,3343,0,0,4},{8107,3347,0,0,4},{8108,3351,0,0,4},{8109,
3355,0,0,4},{8110,3359,0,0,4},{8111,3363,0,0,4},{8112,3367,0,0,2},{8113,3369,0,
0,2},{8114,3371,0,0,3},{8115,3374,0,0,2},{8116,3376,0,0,3},{8118,3379,0,0,2},
{8119,3381,0,0,3},{8120,3384,0,0,2},{8121,3386,0,0,2},{8122,3388,0,0,2},{8124,
3390,0,0,2},{8129,3392,0,0,2},{8130,3394,0,0,3},{8131,3397,0,0,2},{8132,3399,0,
0,3},{8134,3402,0,0,2},{8135,3404,0,0,3},{8136,3407,0,0,2},{8138,3409,0,0,2},
{8140,3411,0,0,2},{8141,3413,0,0,2},{8142,3415,0,0,2},{8143,3417,0,0,2},{8144,
3419,0,0,2},{8145,3421,0,0,2},{8146,3423,0,0,3},{8150,3426,0,0,2},{8151,3428,0,
0,3},{8152,3431,0,0,2},{8153,3433,0,0,2},{8154,3435,0,0,2},{8157,3437,0,0,2},
{8158,3439,0,0,2},{8159,3441,0,0,2},{8160,3443,0,0,2},{8161,3445,0,0,2},{8162,
3447,0,0,3},{8164,3450,0,0,2},{8165,3452,0,0,2},{8166,3454,0,0,2},{8167,3456,0,
0,3},{8168,3459,0,0,2},{8169,3461,0,0,2},{8170,3463,0,0,2},{8172,3465,0,0,2},
{8173,3467,0,0,2},{8178,3469,0,0,3},{8179,3472,0,0,2},{8180,3474,0,0,3},{8182,
3477,0,0,2},{8183,3479,0,0,3},{8184,3482,0,0,2},{8186,3484,0,0,2},{8188,3486,0,
0,2},{8229,3488,0,0,2},{8230,3490,0,0,3},{8243,3493,0,0,2},{8244,3495,0,0,3},
{8246,3498,0,0,2},{8247,3500,0,0,3},{8252,3503,0,0,2},{8263,3505,0,0,2},{8264,
3507,0,0,2},{8265,3509,0,0,2},{8279,3511,0,0,4},{8360,3515,0,0,2},{8448,3517,0,
0,3},{8449,3520,0,0,3},{8451,3523,0,0,2},{8453,3525,0,0,3},{8454,3528,0,0,3},
{8457,3531,0,0,2},{8463,3533,0,0,2},{8470,3535,0,0,2},{8480,3537,0,0,2},{8481,
3539,0,0,3},{8482,3542,0,0,2},{8507,3544,0,0,3},{8525,3547,0,0,3},{8528,3550,0,
0,3},{8529,3553,0,0,3},{8530,3556,0,0,4},{8531,3560,0,0,3},{8532,3563,0,0,3},
{8533,3566,0,0,3},{8534,3569,0,0,3},{8535,3572,0,0,3},{8536,3575,0,0,3},{8537,
3578,0,0,3},{8538,3581,0,0,3},{8539,3584,0,0,3},{8540,3587,0,0,3},{8541,3590,0,
0,3},{8542,3593,0,0,3},{8543,3596,0,0,2},{8545,3598,0,0,2},{8546,3600,0,0,3},
{8547,3603,0,0,2},{8549,3605,0,0,2},{8550,3607,0,0,3},{8551,3610,0,0,4},{8552,
3614,0,0,2},{8554,3616,0,0,2},{8555,3618,0,0,3},{8561,3621,0,0,2},{8562,3623,0,
0,3},{8563,3626,0,0,2},{8565,3628,0,0,2},{8566,3630,0,0,3},{8567,3633,0,0,4},
{8568,3637,0,0,2},{8570,3639,0,0,2},{8571,3641,0,0,3},{8585,3644,0,0,3},{8602,
3647,0,0,2},{8603,3649,0,0,2},{8622,3651,0,0,2},{8653,3653,0,0,2},{8654,3655,0,
0,2},{8655,3657,0,0,2},{8708,3659,0,0,2},{8713,3661,0,0,2},{8716,3663,0,0,2},
{8740,3665,0,0,2},{8742,3667,0,0,2},{8748,3669,0,0,2},{8749,3671,0,0,3},{8751,
3674,0,0,2},{8752,3676,0,0,3},{8769,3679,0,0,2},{8772,3681,0,0,2},{8775,3683,0,
0,2},{8777,3685,0,0,2},{8800,3687,0,0,2},{8802,3689,0,0,2},{8813,3691,0,0,2},
{8814,3693,0,0,2},{8815,3695,0,0,2},{8816,3697,0,0,2},{8817,3699,0,0,2},{8820,
3701,0,0,2},{8821,3703,0,0,2},{8824,3705,0,0,2},{8825,3707,0,0,2},{8832,3709,0,
0,2},{8833,3711,0,0,2},{8836,3713,0,0,2},{8837,3715,0,0,2},{8840,3717,0,0,2},
{8841,3719,0,0,2},{8876,3721,0,0,2},{8877,3723,0,0,2},{8878,3725,0,0,2},{8879,
3727,0,0,2},{8928,3729,0,0,2},{8929,3731,0,0,2},{8930,3733,0,0,2},{8931,3735,0,
0,2},{8938,3737,0,0,2},{8939,3739,0,0,2},{8940,3741,0,0,2},{8941,3743,0,0,2},
{9321,3745,0,0,2},{9322,3747,0,0,2},{9323,3749,0,0,2},{9324,3751,0,0,2},{9325,
3753,0,0,2},{9326,3755,0,0,2},{9327,3757,0,0,2},{9328,3759,0,0,2},{9329,3761,0,
0,2},{9330,3763,0,0,2},{9331,3765,0,0,2},{9332,3767,0,0,3},{9333,3770,0,0,3},
{9334,3773,0,0,3},{9335,3776,0,0,3},{9336,3779,0,0,3},{9337,3782,0,0,3},{9338,
3785,0,0,3},{9339,3788,0,0,3},{9340,3791,0,0,3},{9341,3794,0,0,4},{9342,3798,0,
0,4},{9343,3802,0,0,4},{9344,3806,0,0,4},{9345,3810,0,0,4},{9346,3814,0,0,4},
{9347,3818,0,0,4},{9348,3822,0,0,4},{9349,3826,0,0,4},{9350,3830,0,0,4},{9351,
3834,0,0,4},{9352,3838,0,0,2},{9353,3840,0,0,2},{9354,3842,0,0,2},{9355,3844,0,
0,2},{9356,3846,0,0,2},{9357,3848,0,0,2},{9358,3850,0,0,2},{9359,3852,0,0,2},
{9360,3854,0,0,2},{9361,3856,0,0,3},{9362,3859,0,0,3},{9363,3862,0,0,3},{9364,
3865,0,0,3},{9365,3868,0,0,3},{9366,3871,0,0,3},{9367,3874,0,0,3},{9368,3877,0,
0,3},{9369,3880,0,0,3},{9370,3883,0,0,3},{9371,3886,0,0,3},{9372,3889,0,0,3},
{9373,3892,0,0,3},{9374,3895,0,0,3},{9375,3898,0,0,3},{9376,3901,0,0,3},{9377,
3904,0,0,3},{9378,3907,0,0,3},{9379,3910,0,0,3},{9380,3913,0,0,3},{9381,3916,0,
0,3},{9382,3919,0,0,3},{9383,3922,0,0,3},{9384,3925,0,0,3},{9385,3928,0,0,3},
{9386,3931,0,0,3},{9387,3934,0,0,3},{9388,3937,0,0,3},{9389,3940,0,0,3},{9390,
3943,0,0,3},{9391,3946,0,0,3},{9392,3949,0,0,3},{9393,3952,0,0,3},{9394,3955,0,
0,3},{9395,3958,0,0,3},{9396,3961,0,0,3},{9397,3964,0,0,3},{9451,3967,0,0,2},
{9452,3969,0,0,2},{9453,3971,0,0,2},{9454,3973,0,0,2},{9455,3975,0,0,2},{9456,
3977,0,0,2},{9457,3979,0,0,2},{9458,3981,0,0,2},{9459,3983,0,0,2},{9460,3985,0,
0,2},{9470,3987,0,0,2},{10111,3989,0,0,2},{10121,3991,0,0,2},{10131,3993,0,0,2},
{10764,3995,0,0,4},{10868,3999,0,0,3},{10869,4002,0,0,2},{10870,4004,0,0,3},
{10973,0,4456,1,0},{11492,4009,0,0,3},{11765,4012,0,0,2},{11904,4014,0,0,3},
{11905,4017,0,0,3},{11906,4020,0,0,2},{11907,4022,0,0,2},{11908,4024,0,0,3},
{11909,4027,0,0,2},{11910,4029,0,0,3},{11911,4032,0,0,3},{11912,4035,0,0,3},
{11913,4038,0,0,2},{11914,4040,0,0,3},{11915,4043,0,0,3},{11916,4046,0,0,3},
{11917,4049,0,0,3},{11918,4052,0,0,3},{11919,4055,0,0,2},{11920,4057,0,0,2},
{11921,4059,0,0,3},{11922,4062,0,0,2},{11923,4064,0,0,2},{11924,4066,0,0,2},
{11925,4068,0,0,3},{11926,4071,0,0,2},{11927,4073,0,0,3},{11928,4076,0,0,2},
{11929,4078,0,0,2},{11931,4080,0,0,2},{11932,4082,0,0,3},{11933,4085,0,0,3},
{11934,4088,0,0,3},{11935,4091,0,0,2},{11936,4093,0,0,2},{11937,4095,0,0,2},
{11938,4097,0,0,2},{11939,4099,0,0,2},{11940,4101,0,0,2},{11941,4103,0,0,3},
{11942,4106,0,0,2},{11943,4108,0,0,3},{11944,4111,0,0,2},{11945,4113,0,0,3},
{11946,4116,0,0,3},{11947,4119,0,0,3},{11948,4122,0,0,3},{11949,4125,0,0,2},
{11950,4127,0,0,3},{11951,4130,0,0,2},{11952,4132,0,0,2},{11953,4134,0,0,2},
{11954,4136,0,0,2},{11955,4138,0,0,3},{11956,4141,0,0,3},{11957,4144,0,0,3},
{11958,4147,0,0,3},{11959,4150,0,0,3},{11960,4153,0,0,2},{11961,4155,0,0,2},
{11962,4157,0,0,2},{11963,4159,0,0,3},{11964,4162,0,0,3},{11965,4165,0,0,3},
{11966,4168,0,0,2},{11967,4170,0,0,3},{11968,4173,0,0,3},{11969,4176,0,0,2},
{11970,4178,0,0,2},{11971,4180,0,0,2},{11972,4182,0,0,2},{11973,4184,0,0,2},
{11974,4186,0,0,2},{11975,4188,0,0,3},{11976,4191,0,0,2},{11977,4193,0,0,2},
{11978,4195,0,0,3},{11979,4198,0,0,2},{11980,4200,0,0,2},{11981,4202,0,0,3},
{11982,4205,0,0,3},{11983,4208,0,0,3},{11984,4211,0,0,2},{11985,4213,0,0,2},
{11986,4215,0,0,2},{11987,4217,0,0,2},{11988,4219,0,0,2},{11989,4221,0,0,3},
{11990,4224,0,0,2},{11991,4226,0,0,3},{11992,4229,0,0,2},{11993,4231,0,0,2},
{11994,4233,0,0,2},{11995,4235,0,0,2},{11996,4237,0,0,2},{11997,4239,0,0,2},
{11998,4241,0,0,3},{11999,4244,0,0,2},{12000,4246,0,0,2},{12001,4248,0,0,3},
{12002,4251,0,0,2},{12003,4253,0,0,3},{12004,4256,0,0,3},{12005,4259,0,0,2},
{12006,4261,0,0,2},{12007,4263,0,0,3},{12008,4266,0,0,2},{12009,4268,0,0,2},
{12010,4270,0,0,2},{12011,4272,0,0,3},{12012,4275,0,0,2},{12013,4277,0,0,3},
{12014,4280,0,0,2},{12015,4282,0,0,3},{12016,4285,0,0,2},{12017,4287,0,0,3},
{12018,4290,0,0,3},{12019,4293,0,0,2},{12032,4295,0,0,2},{12033,4297,0,0,2},
{12034,4299,0,0,2},{12035,4301,0,0,2},{12036,4303,0,0,2},{12037,4305,0,0,2},
{12038,4307,0,0,2},{12039,4309,0,0,2},{12040,4311,0,0,2},{12041,4313,0,0,2},
{12042,4315,0,0,2},{12043,4317,0,0,2},{12044,4319,0,0,2},{12045,4321,0,0,2},
{12046,4323,0,0,2},{12047,4325,0,0,2},{12048,4327,0,0,2},{12049,4329,0,0,2},
{12050,4331,0,0,2},{12051,4333,0,0,2},{12052,4335,0,0,2},{12053,4337,0,0,2},
{12054,4339,0,0,2},{12055,4341,0,0,2},{12056,4343,0,0,2},{12057,4345,0,0,2},
{12058,4347,0,0,2},{12059,4349,0,0,2},{12060,4351,0,0,2},{12061,4353,0,0,2},
{12062,4355,0,0,2},{12063,4357,0,0,2},{12064,4359,0,0,2},{12065,4361,0,0,2},
{12066,4363,0,0,2},{12067,4365,0,0,2},{12068,4367,0,0,2},{12069,4369,0,0,2},
{12070,4371,0,0,2},{12071,4373,0,0,2},{12072,4375,0,0,2},{12073,4377,0,0,2},
{12074,4379,0,0,2},{12075,4381,0,0,2},{12076,4383,0,0,2},{12077,4385,0,0,2},
{12078,4387,0,0,2},{12079,4389,0,0,2},{12080,4391,0,0,2},{12081,4393,0,0,2},
{12082,4395,0,0,2},{12083,4397,0,0,2},{12084,4399,0,0,2},{12085,4401,0,0,2},
{12086,4403,0,0,2},{12087,4405,0,0,2},{12088,4407,0,0,2},{12089,4409,0,0,2},
{12090,4411,0,0,2},{12091,4413,0,0,2},{12092,4415,0,0,2},{12093,4417,0,0,2},
{12094,4419,0,0,2},{12095,4421,0,0,2},{12096,4423,0,0,2},{12097,4425,0,0,2},
{12098,4427,0,0,2},{12099,4429,0,0,2},{12100,4431,0,0,2},{12101,4433,0,0,2},
{12102,4435,0,0,2},{12103,4437,0,0,2},{12104,4439,0,0,2},{12105,4441,0,0,2},
{12106,4443,0,0,2},{12107,4445,0,0,2},{12108,4447,0,0,2},{12109,4449,0,0,2},
{12110,4451,0,0,2},{12111,4453,0,0,2},{12112,4455,0,0,2},{12113,4457,0,0,2},
{12114,4459,0,0,2},{12115,4461,0,0,2},{12116,4463,0,0,2},{12117,4465,0,0,2},
{12118,4467,0,0,2},{12119,4469,0,0,2},{12120,4471,0,0,2},{12121,4473,0,0,2},
{12122,4475,0,0,2},{12123,4477,0,0,2},{12124,4479,0,0,2},{12125,4481,0,0,2},
{12126,4483,0,0,2},{12127,4485,0,0,2},{12128,4487,0,0,2},{12129,4489,0,0,2},
{12130,4491,0,0,2},{12131,4493,0,0,2},{12132,4495,0,0,2},{12133,4497,0,0,2},
{12134,4499,0,0,2},{12135,4501,0,0,2},{12136,4503,0,0,2},{12137,4505,0,0,2},
{12138,4507,0,0,2},{12139,4509,0,0,2},{12140,4511,0,0,2},{12141,4513,0,0,2},
{12142,4515,0,0,2},{12143,4517,0,0,2},{12144,4519,0,0,2},{12145,4521,0,0,2},
{12146,4523,0,0,2},{12147,4525,0,0,2},{12148,4527,0,0,2},{12149,4529,0,0,2},
{12150,4531,0,0,2},{12151,4533,0,0,2},{12152,4535,0,0,2},{12153,4537,0,0,2},
{12154,4539,0,0,2},{12155,4541,0,0,2},{12156,4543,0,0,2},{12157,4545,0,0,2},
{12158,4547,0,0,2},{12159,4549,0,0,2},{12160,4551,0,0,2},{12161,4553,0,0,2},
{12162,4555,0,0,2},{12163,4557,0,0,2},{12164,4559,0,0,2},{12165,4561,0,0,2},
{12166,4563,0,0,2},{12167,4565,0,0,2},{12168,4567,0,0,2},{12169,4569,0,0,2},
{12170,4571,0,0,2},{12171,4573,0,0,2},{12172,4575,0,0,2},{12173,4577,0,0,2},
{12174,4579,0,0,2},{12175,4581,0,0,2},{12176,4583,0,0,2},{12177,4585,0,0,2},
{12178,4587,0,0,2},{12179,4589,0,0,2},{12180,4591,0,0,2},{12181,4593,0,0,2},
{12182,4595,0,0,2},{12183,4597,0,0,2},{12184,4599,0,0,2},{12185,4601,0,0,2},
{12186,4603,0,0,2},{12187,4605,0,0,2},{12188,4607,0,0,2},{12189,4609,0,0,2},
{12190,4611,0,0,2},{12191,4613,0,0,2},{12192,4615,0,0,2},{12193,4617,0,0,2},
{12194,4619,0,0,2},{12195,4621,0,0,2},{12196,4623,0,0,2},{12197,4625,0,0,2},
{12198,4627,0,0,2},{12199,4629,0,0,2},{12200,4631,0,0,2},{12201,4633,0,0,2},
{12202,4635,0,0,2},{12203,4637,0,0,2},{12204,4639,0,0,2},{12205,4641,0,0,2},
{12206,4643,0,0,2},{12207,4645,0,0,2},{12208,4647,0,0,2},{12209,4649,0,0,2},
{12210,4651,0,0,2},{12211,4653,0,0,2},{12212,4655,0,0,2},{12213,4657,0,0,2},
{12214,4659,0,0,2},{12215,4661,0,0,2},{12216,4663,0,0,2},{12217,4665,0,0,2},
{12218,4667,0,0,2},{12219,4669,0,0,2},{12220,4671,0,0,2},{12221,4673,0,0,2},
{12222,4675,0,0,2},{12223,4677,0,0,2},{12224,4679,0,0,2},{12225,4681,0,0,2},
{12226,4683,0,0,2},{12227,4685,0,0,2},{12228,4687,0,0,2},{12229,4689,0,0,2},
{12230,4691,0,0,2},{12231,4693,0,0,2},{12232,4695,0,0,2},{12233,4697,0,0,2},
{12234,4699,0,0,2},{12235,4701,0,0,2},{12236,4703,0,0,2},{12237,4705,0,0,2},
{12238,4707,0,0,2},{12239,4709,0,0,2},{12240,4711,0,0,2},{12241,4713,0,0,2},
{12242,4715,0,0,2},{12243,4717,0,0,2},{12244,4719,0,0,2},{12245,4721,0,0,2},
{12294,4723,0,0,2},{12338,4725,0,0,2},{12340,4727,0,0,2},{12344,4729,0,0,2},
{12345,4731,0,0,2},{12346,4733,0,0,2},{12348,4735,0,0,2},{12364,4737,0,0,2},
{12366,4739,0,0,2},{12368,4741,0,0,2},{12370,4743,0,0,2},{12372,4745,0,0,2},
{12374,4747,0,0,2},{12376,4749,0,0,2},{12378,4751,0,0,2},{12380,4753,0,0,2},
{12382,4755,0,0,2},{12384,4757,0,0,2},{12386,4759,0,0,2},{12389,4761,0,0,2},
{12391,4763,0,0,2},{12393,4765,0,0,2},{12400,4767,0,0,2},{12401,4769,0,0,2},
{12403,4771,0,0,2},{12404,4773,0,0,2},{12406,4775,0,0,2},{12407,4777,0,0,2},
{12409,4779,0,0,2},{12410,4781,0,0,2},{12412,4783,0,0,2},{12413,4785,0,0,2},
{12436,4787,0,0,2},{12446,4789,0,0,2},{12447,4791,0,0,2},{12460,4793,0,0,2},
{12462,4795,0,0,2},{12464,4797,0,0,2},{12466,4799,0,0,2},{12468,4801,0,0,2},
{12470,4803,0,0,2},{12472,4805,0,0,2},{12474,4807,0,0,2},{12476,4809,0,0,2},
{12478,4811,0,0,2},{12480,4813,0,0,2},{12482,4815,0,0,2},{12485,4817,0,0,2},
{12487,4819,0,0,2},{12489,4821,0,0,2},{12496,4823,0,0,2},{12497,4825,0,0,2},
{12499,4827,0,0,2},{12500,4829,0,0,2},{12502,4831,0,0,2},{12503,4833,0,0,2},
{12505,4835,0,0,2},{12506,4837,0,0,2},{12508,4839,0,0,2},{12509,4841,0,0,2},
{12532,4843,0,0,2},{12535,4845,0,0,2},{12536,4847,0,0,2},{12537,4849,0,0,2},
{12538,4851,0,0,2},{12542,4853,0,0,2},{12543,4855,0,0,2},{12690,4857,0,0,2},
{12691,4859,0,0,2},{12692,4861,0,0,2},{12693,4863,0,0,2},{12694,4865,0,0,2},
{12695,4867,0,0,2},{12696,4869,0,0,2},{12697,4871,0,0,2},{12698,4873,0,0,2},
{12699,4875,0,0,2},{12700,4877,0,0,2},{12701,4879,0,0,2},{12702,4881,0,0,2},
{12703,4883,0,0,2},{12704,4885,0,0,2},{12705,4887,0,0,2},{12706,4889,0,0,2},
{12707,4891,0,0,2},{12709,4893,0,0,2},{12711,4895,0,0,2},{12712,4897,0,0,2},
{12713,4899,0,0,2},{12714,4901,0,0,2},{12715,4903,0,0,2},{12718,4905,0,0,2},
{12719,4907,0,0,2},{12723,4909,0,0,2},{12800,4911,0,0,3},{12801,4914,0,0,3},
{12802,4917,0,0,3},{12803,4920,0,0,3},{12804,4923,0,0,3},{12805,4926,0,0,3},
{12806,4929,0,0,3},{12807,4932,0,0,3},{12808,4935,0,0,3},{12809,4938,0,0,3},
{12810,4941,0,0,3},{12811,4944,0,0,3},{12812,4947,0,0,3},{12813,4950,0,0,3},
{12814,4953,0,0,4},{12815,4957,0,0,4},{12816,4961,0,0,4},{12817,4965,0,0,4},
{12818,4969,0,0,4},{12819,4973,0,0,4},{12820,4977,0,0,4},{12821,4981,0,0,4},
{12822,4985,0,0,4},{12823,4989,0,0,4},{12824,4993,0,0,4},{12825,4997,0,0,4},
{12826,5001,0,0,4},{12827,5005,0,0,4},{12828,5009,0,0,4},{12829,5013,0,0,7},
{12830,5020,0,0,6},{12832,5026,0,0,4},{12833,5030,0,0,4},{12834,5034,0,0,4},
{12835,5038,0,0,4},{12836,5042,0,0,4},{12837,5046,0,0,4},{12838,5050,0,0,4},
{12839,5054,0,0,4},{12840,5058,0,0,4},{12841,5062,0,0,4},{12842,5066,0,0,4},
{12843,5070,0,0,4},{12844,5074,0,0,4},{12845,5078,0,0,4},{12846,5082,0,0,4},
{12847,5086,0,0,4},{12848,5090,0,0,4},{12849,5094,0,0,4},{12850,5098,0,0,4},
{12851,5102,0,0,4},{12852,5106,0,0,4},{12853,5110,0,0,4},{12854,5114,0,0,4},
{12855,5118,0,0,4},{12856,5122,0,0,4},{12857,5126,0,0,4},{12858,5130,0,0,4},
{12859,5134,0,0,4},{12860,5138,0,0,4},{12861,5142,0,0,4},{12862,5146,0,0,4},
{12863,5150,0,0,4},{12864,5154,0,0,4},{12865,5158,0,0,4},{12866,5162,0,0,4},
{12867,5166,0,0,4},{12868,5170,0,0,2},{12869,5172,0,0,2},{12870,5174,0,0,2},
{12871,5176,0,0,2},{12872,5178,0,0,2},{12873,5180,0,0,2},{12874,5182,0,0,2},
{12875,5184,0,0,2},{12876,5186,0,0,2},{12877,5188,0,0,2},{12878,5190,0,0,2},
{12879,5192,0,0,2},{12880,5194,0,0,3},{12881,5197,0,0,2},{12882,5199,0,0,2},
{12883,5201,0,0,2},{12884,5203,0,0,2},{12885,5205,0,0,2},{12886,5207,0,0,2},
{12887,5209,0,0,2},{12888,5211,0,0,2},{12889,5213,0,0,2},{12890,5215,0,0,2},
{12891,5217,0,0,2},{12892,5219,0,0,2},{12893,5221,0,0,2},{12894,5223,0,0,2},
{12895,5225,0,0,2},{12910,5227,0,0,2},{12911,5229,0,0,2},{12912,5231,0,0,2},
{12913,5233,0,0,2},{12914,5235,0,0,2},{12915,5237,0,0,2},{12916,5239,0,0,2},
{12917,5241,0,0,2},{12918,5243,0,0,2},{12919,5245,0,0,2},{12920,5247,0,0,2},
{12921,5249,0,0,2},{12922,5251,0,0,2},{12923,5253,0,0,2},{12924,5255,0,0,5},
{12925,5260,0,0,4},{12926,5264,0,0,2},{12928,5266,0,0,2},{12929,5268,0,0,2},
{12930,5270,0,0,2},{12931,5272,0,0,2},{12932,5274,0,0,2},{12933,5276,0,0,2},
{12934,5278,0,0,2},{12935,5280,0,0,2},{12936,5282,0,0,2},{12937,5284,0,0,2},
{12938,5286,0,0,2},{12939,5288,0,0,2},{12940,5290,0,0,2},{12941,5292,0,0,2},
{12942,5294,0,0,2},{12943,5296,0,0,2},{12944,5298,0,0,2},{12945,5300,0,0,2},
{12946,5302,0,0,2},{12947,5304,0,0,2},{12948,5306,0,0,2},{12949,5308,0,0,2},
{12950,5310,0,0,2},{12951,5312,0,0,2},{12952,5314,0,0,2},{12953,5316,0,0,2},
{12954,5318,0,0,2},{12955,5320,0,0,2},{12956,5322,0,0,2},{12957,5324,0,0,2},
{12958,5326,0,0,2},{12959,5328,0,0,2},{12960,5330,0,0,2},{12961,5332,0,0,2},
{12962,5334,0,0,2},{12963,5336,0,0,2},{12964,5338,0,0,2},{12965,5340,0,0,2},
{12966,5342,0,0,2},{12967,5344,0,0,2},{12968,5346,0,0,2},{12969,5348,0,0,2},
{12970,5350,0,0,2},{12971,5352,0,0,2},{12972,5354,0,0,2},{12973,5356,0,0,2},
{12974,5358,0,0,2},{12975,5360,0,0,2},{12976,5362,0,0,2},{12977,5364,0,0,2},
{12978,5366,0,0,2},{12979,5368,0,0,2},{12980,5370,0,0,2},{12981,5372,0,0,2},
{12982,5374,0,0,2},{12983,5376,0,0,2},{12984,5378,0,0,2},{12985,5380,0,0,2},
{12986,5382,0,0,2},{12987,5384,0,0,2},{12988,5386,0,0,2},{12989,5388,0,0,2},
{12990,5390,0,0,2},{12991,5392,0,0,2},{12992,5394,0,0,3},{12993,5397,0,0,3},
{12994,5400,0,0,3},{12995,5403,0,0,3},{12996,5406,0,0,3},{12997,5409,0,0,3},
{12998,5412,0,0,3},{12999,5415,0,0,3},{13000,5418,0,0,3},{13001,5421,0,0,4},
{13002,5425,0,0,4},{13003,5429,0,0,4},{13004,5433,0,0,2},{13005,5435,0,0,3},
{13006,5438,0,0,2},{13007,5440,0,0,3},{13056,5443,0,0,5},{13057,5448,0,0,4},
{13058,5452,0,0,5},{13059,5457,0,0,3},{13060,5460,0,0,5},{13061,5465,0,0,3},
{13062,5468,0,0,3},{13063,5471,0,0,6},{13064,5477,0,0,4},{13065,5481,0,0,3},
{13066,5484,0,0,3},{13067,5487,0,0,3},{13068,5490,0,0,4},{13069,5494,0,0,4},
{13070,5498,0,0,4},{13071,5502,0,0,4},{13072,5506,0,0,4},{13073,5510,0,0,4},
{13074,5514,0,0,4},{13075,5518,0,0,6},{13076,5524,0,0,2},{13077,5526,0,0,6},
{13078,5532,0,0,6},{13079,5538,0,0,5},{13080,5543,0,0,4},{13081,5547,0,0,6},
{13082,5553,0,0,6},{13083,5559,0,0,4},{13084,5563,0,0,3},{13085,5566,0,0,3},
{13086,5569,0,0,4},{13087,5573,0,0,4},{13088,5577,0,0,5},{13089,5582,0,0,5},
{13090,5587,0,0,3},{13091,5590,0,0,3},{13092,5593,0,0,4},{13093,5597,0,0,3},
{13094,5600,0,0,3},{13095,5603,0,0,2},{13096,5605,0,0,2},{13097,5607,0,0,3},
{13098,5610,0,0,3},{13099,5613,0,0,6},{13100,5619,0,0,4},{13101,5623,0,0,5},
{13102,5628,0,0,6},{13103,5634,0,0,4},{13104,5638,0,0,3},{13105,5641,0,0,3},
{13106,5644,0,0,6},{13107,5650,0,0,4},{13108,5654,0,0,6},{13109,5660,0,0,3},
{13110,5663,0,0,5},{13111,5668,0,0,3},{13112,5671,0,0,4},{13113,5675,0,0,3},
{13114,5678,0,0,4},{13115,5682,0,0,5},{13116,5687,0,0,4},{13117,5691,0,0,5},
{13118,5696,0,0,4},{13119,5700,0,0,2},{13120,5702,0,0,5},{13121,5707,0,0,3},
{13122,5710,0,0,3},{13123,5713,0,0,4},{13124,5717,0,0,3},{13125,5720,0,0,3},
{13126,5723,0,0,3},{13127,5726,0,0,5},{13128,5731,0,0,4},{13129,5735,0,0,2},
{13130,5737,0,0,6},{13131,5743,0,0,3},{13132,5746,0,0,5},{13133,5751,0,0,4},
{13134,5755,0,0,4},{13135,5759,0,0,3},{13136,5762,0,0,3},{13137,5765,0,0,4},
{13138,5769,0,0,2},{13139,5771,0,0,4},{13140,5775,0,0,5},{13141,5780,0,0,2},
{13142,5782,0,0,6},{13143,5788,0,0,3},{13144,5791,0,0,3},{13145,5794,0,0,3},
{13146,5797,0,0,3},{13147,5800,0,0,3},{13148,5803,0,0,3},{13149,5806,0,0,3},
{13150,5809,0,0,3},{13151,5812,0,0,3},{13152,5815,0,0,3},{13153,5818,0,0,3},
{13154,5821,0,0,4},{13155,5825,0,0,4},{13156,5829,0,0,4},{13157,5833,0,0,4},
{13158,5837,0,0,4},{13159,5841,0,0,4},{13160,5845,0,0,4},{13161,5849,0,0,4},
{13162,5853,0,0,4},{13163,5857,0,0,4},{13164,5861,0,0,4},{13165,5865,0,0,4},
{13166,5869,0,0,4},{13167,5873,0,0,4},{13168,5877,0,0,4},{13169,5881,0,0,3},
{13170,5884,0,0,2},{13171,5886,0,0,2},{13172,5888,0,0,3},{13173,5891,0,0,2},
{13174,5893,0,0,2},{13175,5895,0,0,2},{13176,5897,0,0,3},{13177,5900,0,0,3},
{13178,5903,0,0,2},{13179,5905,0,0,4},{13180,5909,0,0,4},{13181,5913,0,0,4},
{13182,5917,0,0,4},{13183,5921,0,0,8},{13184,5929,0,0,2},{13185,5931,0,0,2},
{13186,5933,0,0,2},{13187,5935,0,0,2},{13188,5937,0,0,2},{13189,5939,0,0,2},
{13190,5941,0,0,2},{13191,5943,0,0,2},{13192,5945,0,0,3},{13193,5948,0,0,4},
{13194,5952,0,0,2},{13195,5954,0,0,2},{13196,5956,0,0,2},{13197,5958,0,0,2},
{13198,5960,0,0,2},{13199,5962,0,0,2},{13200,5964,0,0,2},{13201,5966,0,0,3},
{13202,5969,0,0,3},{13203,5972,0,0,3},{13204,5975,0,0,3},{13205,5978,0,0,2},
{13206,5980,0,0,2},{13207,5982,0,0,2},{13208,5984,0,0,2},{13209,5986,0,0,2},
{13210,5988,0,0,2},{13211,5990,0,0,2},{13212,5992,0,0,2},{13213,5994,0,0,2},
{13214,5996,0,0,2},{13215,5998,0,0,3},{13216,6001,0,0,3},{13217,6004,0,0,2},
{13218,6006,0,0,3},{13219,6009,0,0,3},{13220,6012,0,0,3},{13221,6015,0,0,2},
{13222,6017,0,0,3},{13223,6020,0,0,3},{13224,6023,0,0,4},{13225,6027,0,0,2},
{13226,6029,0,0,3},{13227,6032,0,0,3},{13228,6035,0,0,3},{13229,6038,0,0,3},
{13230,6041,0,0,5},{13231,6046,0,0,6},{13232,6052,0,0,2},{13233,6054,0,0,2},
{13234,6056,0,0,2},{13235,6058,0,0,2},{13236,6060,0,0,2},{13237,6062,0,0,2},
{13238,6064,0,0,2},{13239,6066,0,0,2},{13240,6068,0,0,2},{13241,6070,0,0,2},
{13242,6072,0,0,2},{13243,6074,0,0,2},{13244,6076,0,0,2},{13245,6078,0,0,2},
{13246,6080,0,0,2},{13247,6082,0,0,2},{13248,6084,0,0,2},{13249,6086,0,0,2},
{13250,6088,0,0,4},{13251,6092,0,0,2},{13252,6094,0,0,2},{13253,6096,0,0,2},
{13254,6098,0,0,4},{13255,6102,0,0,3},{13256,6105,0,0,2},{13257,6107,0,0,2},
{13258,6109,0,0,2},{13259,6111,0,0,2},{13260,6113,0,0,2},{13261,6115,0,0,2},
{13262,6117,0,0,2},{13263,6119,0,0,2},{13264,6121,0,0,2},{13265,6123,0,0,2},
{13266,6125,0,0,3},{13267,6128,0,0,2},{13268,6130,0,0,2},{13269,6132,0,0,3},
{13270,6135,0,0,3},{13271,6138,0,0,2},{13272,6140,0,0,4},{13273,6144,0,0,3},
{13274,6147,0,0,2},{13275,6149,0,0,2},{13276,6151,0,0,2},{13277,6153,0,0,2},
{13278,6155,0,0,3},{13279,6158,0,0,3},{13280,6161,0,0,3},{13281,6164,0,0,3},
{13282,6167,0,0,3},{13283,6170,0,0,3},{13284,6173,0,0,3},{13285,6176,0,0,3},
{13286,6179,0,0,3},{13287,6182,0,0,3},{13288,6185,0,0,3},{13289,6188,0,0,4},
{13290,6192,0,0,4},{13291,6196,0,0,4},{13292,6200,0,0,4},{13293,6204,0,0,4},
{13294,6208,0,0,4},{13295,6212,0,0,4},{13296,6216,0,0,4},{13297,6220,0,0,4},
{13298,6224,0,0,4},{13299,6228,0,0,4},{13300,6232,0,0,4},{13301,6236,0,0,4},
{13302,6240,0,0,4},{13303,6244,0,0,4},{13304,6248,0,0,4},{13305,6252,0,0,4},
{13306,6256,0,0,4},{13307,6260,0,0,4},{13308,6264,0,0,4},{13309,6268,0,0,4},
{13310,6272,0,0,4},{13311,6276,0,0,3},{13470,6279,0,0,2},{13497,6281,0,0,2},
{13499,6283,0,0,2},{13535,6285,0,0,2},{13589,6287,0,0,2},{14062,6289,0,0,2},
{14076,6291,0,0,2},{14209,6293,0,0,2},{14383,6295,0,0,2},{14434,6297,0,0,2},
{14460,6299,0,0,2},{14535,6301,0,0,2},{14563,6303,0,0,2},{14620,6305,0,0,2},
{14650,6307,0,0,2},{14894,6309,0,0,2},{14956,6311,0,0,2},{15076,6313,0,0,2},
{15112,6315,0,0,2},{15129,6317,0,0,2},{15177,6319,0,0,2},{15261,6321,0,0,2},
{15384,6323,0,0,2},{15438,6325,0,0,2},{15667,6327,0,0,2},{15766,6329,0,0,2},
{16044,6331,0,0,2},{16056,6333,0,0,2},{16155,6335,0,0,2},{16380,6337,0,0,2},
{16392,6339,0,0,2},{16408,6341,0,0,2},{16441,6343,0,0,2},{16454,6345,0,0,2},
{16534,6347,0,0,2},{16611,6349,0,0,2},{16687,6351,0,0,2},{16898,6353,0,0,2},
{16935,6355,0,0,2},{17056,6357,0,0,2},{17153,6359,0,0,2},{17204,6361,0,0,2},
{17241,6363,0,0,2},{17365,6365,0,0,2},{17369,6367,0,0,2},{17419,6369,0,0,2},
{17515,6371,0,0,2},{17707,6373,0,0,2},{17757,6375,0,0,2},{17761,6377,0,0,2},
{17771,6379,0,0,2},{17879,6381,0,0,2},{17913,6383,0,0,2},{17973,6385,0,0,2},
{18110,6387,0,0,2},{18119,6389,0,0,2},{18837,6391,0,0,2},{18918,6393,0,0,2},
{19054,6395,0,0,2},{19062,6397,0,0,2},{19122,6399,0,0,2},{19251,6401,0,0,2},
{19406,6403,0,0,2},{19662,6405,0,0,2},{19693,6407,0,0,2},{19704,6409,0,0,2},
{19798,6411,0,0,2},{19981,6413,0,0,2},{20006,6415,0,0,2},{20018,6417,0,0,2},
{20024,6419,0,0,2},{20025,6421,0,0,2},{20029,6423,0,0,2},{20033,6425,0,0,2},
{20098,6427,0,0,2},{20102,6429,0,0,2},{20142,6431,0,0,2},{20160,6433,0,0,2},
{20172,6435,0,0,2},{20196,6437,0,0,2},{20320,6439,0,0,2},{20352,6441,0,0,2},
{20358,6443,0,0,2},{20363,6445,0,0,2},{20398,6447,0,0,2},{20411,6449,0,0,2},
{20415,6451,0,0,2},{20482,6453,0,0,2},{20523,6455,0,0,2},{20602,6457,0,0,2},
{20633,6459,0,0,2},{20687,6461,0,0,2},{20698,6463,0,0,2},{20711,6465,0,0,2},
{20800,6467,0,0,2},{20805,6469,0,0,2},{20813,6471,0,0,2},{20820,6473,0,0,2},
{20836,6475,0,0,2},{20839,6477,0,0,2},{20840,6479,0,0,2},{20841,6481,0,0,2},
{20845,6483,0,0,2},{20855,6485,0,0,2},{20864,6487,0,0,2},{20877,6489,0,0,2},
{20882,6491,0,0,2},{20885,6493,0,0,2},{20887,6495,0,0,2},{20900,6497,0,0,2},
{20908,6499,0,0,2},{20917,6501,0,0,2},{20919,6503,0,0,2},{20937,6505,0,0,2},
{20940,6507,0,0,2},{20956,6509,0,0,2},{20958,6511,0,0,2},{20981,6513,0,0,2},
{20995,6515,0,0,2},{20999,6517,0,0,2},{21015,6519,0,0,2},{21033,6521,0,0,2},
{21050,6523,0,0,2},{21051,6525,0,0,2},{21062,6527,0,0,2},{21106,6529,0,0,2},
{21111,6531,0,0,2},{21129,6533,0,0,2},{21147,6535,0,0,2},{21155,6537,0,0,2},
{21171,6539,0,0,2},{21191,6541,0,0,2},{21193,6543,0,0,2},{21202,6545,0,0,2},
{21214,6547,0,0,2},{21220,6549,0,0,2},{21237,6551,0,0,2},{21242,6553,0,0,2},
{21253,6555,0,0,2},{21254,6557,0,0,2},{21271,6559,0,0,2},{21311,6561,0,0,2},
{21321,6563,0,0,2},{21329,6565,0,0,2},{21338,6567,0,0,2},{21363,6569,0,0,2},
{21365,6571,0,0,2},{21373,6573,0,0,2},{21375,6575,0,0,2},{21443,6577,0,0,2},
{21450,6579,0,0,2},{21471,6581,0,0,2},{21477,6583,0,0,2},{21483,6585,0,0,2},
{21489,6587,0,0,2},{21510,6589,0,0,2},{21519,6591,0,0,2},{21533,6593,0,0,2},
{21560,6595,0,0,2},{21570,6597,0,0,2},{21576,6599,0,0,2},{21608,6601,0,0,2},
{21662,6603,0,0,2},{21666,6605,0,0,2},{21693,6607,0,0,2},{21750,6609,0,0,2},
{21776,6611,0,0,2},{21843,6613,0,0,2},{21845,6615,0,0,2},{21859,6617,0,0,2},
{21892,6619,0,0,2},{21895,6621,0,0,2},{21913,6623,0,0,2},{21917,6625,0,0,2},
{21931,6627,0,0,2},{21939,6629,0,0,2},{21952,6631,0,0,2},{21954,6633,0,0,2},
{21986,6635,0,0,2},{22022,6637,0,0,2},{22097,6639,0,0,2},{22120,6641,0,0,2},
{22132,6643,0,0,2},{22265,6645,0,0,2},{22294,6647,0,0,2},{22295,6649,0,0,2},
{22411,6651,0,0,2},{22478,6653,0,0,2},{22516,6655,0,0,2},{22541,6657,0,0,2},
{22577,6659,0,0,2},{22578,6661,0,0,2},{22592,6663,0,0,2},{22618,6665,0,0,2},
{22622,6667,0,0,2},{22696,6669,0,0,2},{22700,6671,0,0,2},{22707,6673,0,0,2},
{22744,6675,0,0,2},{22751,6677,0,0,2},{22766,6679,0,0,2},{22770,6681,0,0,2},
{22775,6683,0,0,2},{22790,6685,0,0,2},{22810,6687,0,0,2},{22818,6689,0,0,2},
{22852,6691,0,0,2},{22856,6693,0,0,2},{22865,6695,0,0,2},{22868,6697,0,0,2},
{22882,6699,0,0,2},{22899,6701,0,0,2},{23000,6703,0,0,2},{23020,6705,0,0,2},
{23067,6707,0,0,2},{23079,6709,0,0,2},{23138,6711,0,0,2},{23142,6713,0,0,2},
{23221,6715,0,0,2},{23304,6717,0,0,2},{23336,6719,0,0,2},{23358,6721,0,0,2},
{23429,6723,0,0,2},{23491,6725,0,0,2},{23512,6727,0,0,2},{23527,6729,0,0,2},
{23534,6731,0,0,2},{23539,6733,0,0,2},{23551,6735,0,0,2},{23558,6737,0,0,2},
{23586,6739,0,0,2},{23615,6741,0,0,2},{23648,6743,0,0,2},{23650,6745,0,0,2},
{23652,6747,0,0,2},{23653,6749,0,0,2},{23662,6751,0,0,2},{23693,6753,0,0,2},
{23744,6755,0,0,2},{23833,6757,0,0,2},{23875,6759,0,0,2},{23888,6761,0,0,2},
{23915,6763,0,0,2},{23918,6765,0,0,2},{23932,6767,0,0,2},{23986,6769,0,0,2},
{23994,6771,0,0,2},{24033,6773,0,0,2},{24034,6775,0,0,2},{24061,6777,0,0,2},
{24104,6779,0,0,2},{24125,6781,0,0,2},{24169,6783,0,0,2},{24180,6785,0,0,2},
{24230,6787,0,0,2},{24240,6789,0,0,2},{24243,6791,0,0,2},{24246,6793,0,0,2},
{24265,6795,0,0,2},{24266,6797,0,0,2},{24274,6799,0,0,2},{24275,6801,0,0,2},
{24281,6803,0,0,2},{24300,6805,0,0,2},{24318,6807,0,0,2},{24324,6809,0,0,2},
{24354,6811,0,0,2},{24403,6813,0,0,2},{24418,6815,0,0,2},{24425,6817,0,0,2},
{24427,6819,0,0,2},{24459,6821,0,0,2},{24474,6823,0,0,2},{24489,6825,0,0,2},
{24493,6827,0,0,2},{24525,6829,0,0,2},{24535,6831,0,0,2},{24565,6833,0,0,2},
{24569,6835,0,0,2},{24594,6837,0,0,2},{24604,6839,0,0,2},{24693,6841,0,0,2},
{24705,6843,0,0,2},{24724,6845,0,0,2},{24775,6847,0,0,2},{24792,6849,0,0,2},
{24801,6851,0,0,2},{24840,6853,0,0,2},{24900,6855,0,0,2},{24904,6857,0,0,2},
{24908,6859,0,0,2},{24910,6861,0,0,2},{24928,6863,0,0,2},{24936,6865,0,0,2},
{24954,6867,0,0,2},{24974,6869,0,0,2},{24976,6871,0,0,2},{24996,6873,0,0,2},
{25007,6875,0,0,2},{25010,6877,0,0,2},{25054,6879,0,0,2},{25074,6881,0,0,2},
{25078,6883,0,0,2},{25088,6885,0,0,2},{25104,6887,0,0,2},{25115,6889,0,0,2},
{25134,6891,0,0,2},{25140,6893,0,0,2},{25181,6895,0,0,2},{25265,6897,0,0,2},
{25289,6899,0,0,2},{25295,6901,0,0,2},{25299,6903,0,0,2},{25300,6905,0,0,2},
{25340,6907,0,0,2},{25342,6909,0,0,2},{25405,6911,0,0,2},{25424,6913,0,0,2},
{25448,6915,0,0,2},{25467,6917,0,0,2},{25475,6919,0,0,2},{25504,6921,0,0,2},
{25513,6923,0,0,2},{25540,6925,0,0,2},{25541,6927,0,0,2},{25572,6929,0,0,2},
{25628,6931,0,0,2},{25634,6933,0,0,2},{25682,6935,0,0,2},{25705,6937,0,0,2},
{25719,6939,0,0,2},{25726,6941,0,0,2},{25754,6943,0,0,2},{25757,6945,0,0,2},
{25796,6947,0,0,2},{25935,6949,0,0,2},{25942,6951,0,0,2},{25964,6953,0,0,2},
{25976,6955,0,0,2},{26009,6957,0,0,2},{26053,6959,0,0,2},{26082,6961,0,0,2},
{26083,6963,0,0,2},{26131,6965,0,0,2},{26185,6967,0,0,2},{26228,6969,0,0,2},
{26248,6971,0,0,2},{26257,6973,0,0,2},{26268,6975,0,0,2},{26292,6977,0,0,2},
{26310,6979,0,0,2},{26356,6981,0,0,2},{26360,6983,0,0,2},{26368,6985,0,0,2},
{26391,6987,0,0,2},{26395,6989,0,0,2},{26401,6991,0,0,2},{26446,6993,0,0,2},
{26451,6995,0,0,2},{26454,6997,0,0,2},{26462,6999,0,0,2},{26491,7001,0,0,2},
{26501,7003,0,0,2},{26519,7005,0,0,2},{26611,7007,0,0,2},{26618,7009,0,0,2},
{26647,7011,0,0,2},{26655,7013,0,0,2},{26706,7015,0,0,2},{26753,7017,0,0,2},
{26757,7019,0,0,2},{26766,7021,0,0,2},{26792,7023,0,0,2},{26900,7025,0,0,2},
{26946,7027,0,0,2},{27043,7029,0,0,2},{27114,7031,0,0,2},{27138,7033,0,0,2},
{27155,7035,0,0,2},{27304,7037,0,0,2},{27347,7039,0,0,2},{27355,7041,0,0,2},
{27396,7043,0,0,2},{27425,7045,0,0,2},{27476,7047,0,0,2},{27506,7049,0,0,2},
{27511,7051,0,0,2},{27513,7053,0,0,2},{27551,7055,0,0,2},{27566,7057,0,0,2},
{27578,7059,0,0,2},{27579,7061,0,0,2},{27726,7063,0,0,2},{27751,7065,0,0,2},
{27784,7067,0,0,2},{27839,7069,0,0,2},{27852,7071,0,0,2},{27853,7073,0,0,2},
{27877,7075,0,0,2},{27926,7077,0,0,2},{27931,7079,0,0,2},{27934,7081,0,0,2},
{27956,7083,0,0,2},{27966,7085,0,0,2},{27969,7087,0,0,2},{28009,7089,0,0,2},
{28010,7091,0,0,2},{28023,7093,0,0,2},{28024,7095,0,0,2},{28037,7097,0,0,2},
{28107,7099,0,0,2},{28122,7101,0,0,2},{28138,7103,0,0,2},{28153,7105,0,0,2},
{28186,7107,0,0,2},{28207,7109,0,0,2},{28270,7111,0,0,2},{28316,7113,0,0,2},
{28346,7115,0,0,2},{28359,7117,0,0,2},{28363,7119,0,0,2},{28369,7121,0,0,2},
{28379,7123,0,0,2},{28431,7125,0,0,2},{28450,7127,0,0,2},{28451,7129,0,0,2},
{28526,7131,0,0,2},{28614,7133,0,0,2},{28651,7135,0,0,2},{28670,7137,0,0,2},
{28699,7139,0,0,2},{28702,7141,0,0,2},{28729,7143,0,0,2},{28746,7145,0,0,2},
{28784,7147,0,0,2},{28791,7149,0,0,2},{28797,7151,0,0,2},{28825,7153,0,0,2},
{28845,7155,0,0,2},{28872,7157,0,0,2},{28889,7159,0,0,2},{28997,7161,0,0,2},
{29001,7163,0,0,2},{29038,7165,0,0,2},{29084,7167,0,0,2},{29134,7169,0,0,2},
{29136,7171,0,0,2},{29200,7173,0,0,2},{29211,7175,0,0,2},{29224,7177,0,0,2},
{29227,7179,0,0,2},{29237,7181,0,0,2},{29264,7183,0,0,2},{29282,7185,0,0,2},
{29312,7187,0,0,2},{29333,7189,0,0,2},{29359,7191,0,0,2},{29376,7193,0,0,2},
{29436,7195,0,0,2},{29482,7197,0,0,2},{29557,7199,0,0,2},{29562,7201,0,0,2},
{29575,7203,0,0,2},{29579,7205,0,0,2},{29605,7207,0,0,2},{29618,7209,0,0,2},
{29662,7211,0,0,2},{29702,7213,0,0,2},{29705,7215,0,0,2},{29730,7217,0,0,2},
{29767,7219,0,0,2},{29788,7221,0,0,2},{29801,7223,0,0,2},{29809,7225,0,0,2},
{29829,7227,0,0,2},{29833,7229,0,0,2},{29848,7231,0,0,2},{29898,7233,0,0,2},
{29958,7235,0,0,2},{29988,7237,0,0,2},{30011,7239,0,0,2},{30014,7241,0,0,2},
{30041,7243,0,0,2},{30053,7245,0,0,2},{30064,7247,0,0,2},{30178,7249,0,0,2},
{30224,7251,0,0,2},{30237,7253,0,0,2},{30239,7255,0,0,2},{30274,7257,0,0,2},
{30313,7259,0,0,2},{30410,7261,0,0,2},{30427,7263,0,0,2},{30439,7265,0,0,2},
{30452,7267,0,0,2},{30465,7269,0,0,2},{30494,7271,0,0,2},{30495,7273,0,0,2},
{30528,7275,0,0,2},{30538,7277,0,0,2},{30603,7279,0,0,2},{30631,7281,0,0,2},
{30798,7283,0,0,2},{30827,7285,0,0,2},{30860,7287,0,0,2},{30865,7289,0,0,2},
{30922,7291,0,0,2},{30924,7293,0,0,2},{30971,7295,0,0,2},{31018,7297,0,0,2},
{31036,7299,0,0,2},{31038,7301,0,0,2},{31048,7303,0,0,2},{31049,7305,0,0,2},
{31056,7307,0,0,2},{31062,7309,0,0,2},{31069,7311,0,0,2},{31070,7313,0,0,2},
{31077,7315,0,0,2},{31103,7317,0,0,2},{31117,7319,0,0,2},{31118,7321,0,0,2},
{31119,7323,0,0,2},{31150,7325,0,0,2},{31178,7327,0,0,2},{31211,7329,0,0,2},
{31260,7331,0,0,2},{31296,7333,0,0,2},{31306,7335,0,0,2},{31311,7337,0,0,2},
{31361,7339,0,0,2},{31409,7341,0,0,2},{31435,7343,0,0,2},{31470,7345,0,0,2},
{31520,7347,0,0,2},{31680,7349,0,0,2},{31686,7351,0,0,2},{31689,7353,0,0,2},
{31806,7355,0,0,2},{31840,7357,0,0,2},{31867,7359,0,0,2},{31890,7361,0,0,2},
{31934,7363,0,0,2},{31954,7365,0,0,2},{31958,7367,0,0,2},{31971,7369,0,0,2},
{31975,7371,0,0,2},{31976,7373,0,0,2},{32000,7375,0,0,2},{32016,7377,0,0,2},
{32034,7379,0,0,2},{32047,7381,0,0,2},{32091,7383,0,0,2},{32099,7385,0,0,2},
{32160,7387,0,0,2},{32190,7389,0,0,2},{32199,7391,0,0,2},{32244,7393,0,0,2},
{32258,7395,0,0,2},{32265,7397,0,0,2},{32311,7399,0,0,2},{32321,7401,0,0,2},
{32325,7403,0,0,2},{32574,7405,0,0,2},{32626,7407,0,0,2},{32633,7409,0,0,2},
{32634,7411,0,0,2},{32645,7413,0,0,2},{32661,7415,0,0,2},{32666,7417,0,0,2},
{32701,7419,0,0,2},{32762,7421,0,0,2},{32769,7423,0,0,2},{32773,7425,0,0,2},
{32838,7427,0,0,2},{32864,7429,0,0,2},{32879,7431,0,0,2},{32880,7433,0,0,2},
{32894,7435,0,0,2},{32907,7437,0,0,2},{32941,7439,0,0,2},{32946,7441,0,0,2},
{33027,7443,0,0,2},{33086,7445,0,0,2},{33240,7447,0,0,2},{33256,7449,0,0,2},
{33261,7451,0,0,2},{33281,7453,0,0,2},{33284,7455,0,0,2},{33304,7457,0,0,2},
{33391,7459,0,0,2},{33401,7461,0,0,2},{33419,7463,0,0,2},{33425,7465,0,0,2},
{33437,7467,0,0,2},{33457,7469,0,0,2},{33459,7471,0,0,2},{33469,7473,0,0,2},
{33509,7475,0,0,2},{33510,7477,0,0,2},{33565,7479,0,0,2},{33571,7481,0,0,2},
{33590,7483,0,0,2},{33618,7485,0,0,2},{33619,7487,0,0,2},{33635,7489,0,0,2},
{33709,7491,0,0,2},{33725,7493,0,0,2},{33737,7495,0,0,2},{33738,7497,0,0,2},
{33740,7499,0,0,2},{33756,7501,0,0,2},{33767,7503,0,0,2},{33775,7505,0,0,2},
{33777,7507,0,0,2},{33853,7509,0,0,2},{33865,7511,0,0,2},{33879,7513,0,0,2},
{34030,7515,0,0,2},{34033,7517,0,0,2},{34035,7519,0,0,2},{34044,7521,0,0,2},
{34070,7523,0,0,2},{34148,7525,0,0,2},{34253,7527,0,0,2},{34298,7529,0,0,2},
{34310,7531,0,0,2},{34322,7533,0,0,2},{34349,7535,0,0,2},{34367,7537,0,0,2},
{34384,7539,0,0,2},{34396,7541,0,0,2},{34407,7543,0,0,2},{34409,7545,0,0,2},
{34440,7547,0,0,2},{34473,7549,0,0,2},{34530,7551,0,0,2},{34574,7553,0,0,2},
{34600,7555,0,0,2},{34667,7557,0,0,2},{34681,7559,0,0,2},{34694,7561,0,0,2},
{34746,7563,0,0,2},{34785,7565,0,0,2},{34817,7567,0,0,2},{34847,7569,0,0,2},
{34892,7571,0,0,2},{34912,7573,0,0,2},{34915,7575,0,0,2},{35010,7577,0,0,2},
{35023,7579,0,0,2},{35031,7581,0,0,2},{35038,7583,0,0,2},{35041,7585,0,0,2},
{35064,7587,0,0,2},{35066,7589,0,0,2},{35088,7591,0,0,2},{35137,7593,0,0,2},
{35172,7595,0,0,2},{35206,7597,0,0,2},{35211,7599,0,0,2},{35222,7601,0,0,2},
{35488,7603,0,0,2},{35498,7605,0,0,2},{35519,7607,0,0,2},{35531,7609,0,0,2},
{35538,7611,0,0,2},{35542,7613,0,0,2},{35565,7615,0,0,2},{35576,7617,0,0,2},
{35582,7619,0,0,2},{35585,7621,0,0,2},{35641,7623,0,0,2},{35672,7625,0,0,2},
{35712,7627,0,0,2},{35722,7629,0,0,2},{35912,7631,0,0,2},{35925,7633,0,0,2},
{36011,7635,0,0,2},{36033,7637,0,0,2},{36034,7639,0,0,2},{36040,7641,0,0,2},
{36051,7643,0,0,2},{36104,7645,0,0,2},{36123,7647,0,0,2},{36215,7649,0,0,2},
{36284,7651,0,0,2},{36299,7653,0,0,2},{36335,7655,0,0,2},{36336,7657,0,0,2},
{36554,7659,0,0,2},{36564,7661,0,0,2},{36646,7663,0,0,2},{36650,7665,0,0,2},
{36664,7667,0,0,2},{36667,7669,0,0,2},{36706,7671,0,0,2},{36766,7673,0,0,2},
{36784,7675,0,0,2},{36790,7677,0,0,2},{36899,7679,0,0,2},{36920,7681,0,0,2},
{36978,7683,0,0,2},{36988,7685,0,0,2},{37007,7687,0,0,2},{37012,7689,0,0,2},
{37070,7691,0,0,2},{37086,7693,0,0,2},{37105,7695,0,0,2},{37117,7697,0,0,2},
{37137,7699,0,0,2},{37147,7701,0,0,2},{37226,7703,0,0,2},{37273,7705,0,0,2},
{37300,7707,0,0,2},{37324,7709,0,0,2},{37327,7711,0,0,2},{37329,7713,0,0,2},
{37428,7715,0,0,2},{37432,7717,0,0,2},{37494,7719,0,0,2},{37500,7721,0,0,2},
{37591,7723,0,0,2},{37592,7725,0,0,2},{37636,7727,0,0,2},{37706,7729,0,0,2},
{37881,7731,0,0,2},{37909,7733,0,0,2},{38283,7735,0,0,2},{38317,7737,0,0,2},
{38327,7739,0,0,2},{38446,7741,0,0,2},{38475,7743,0,0,2},{38477,7745,0,0,2},
{38517,7747,0,0,2},{38520,7749,0,0,2},{38524,7751,0,0,2},{38534,7753,0,0,2},
{38563,7755,0,0,2},{38583,7757,0,0,2},{38584,7759,0,0,2},{38595,7761,0,0,2},
{38626,7763,0,0,2},{38627,7765,0,0,2},{38646,7767,0,0,2},{38647,7769,0,0,2},
{38691,7771,0,0,2},{38706,7773,0,0,2},{38728,7775,0,0,2},{38742,7777,0,0,2},
{38875,7779,0,0,2},{38880,7781,0,0,2},{38911,7783,0,0,2},{38923,7785,0,0,2},
{38936,7787,0,0,2},{38953,7789,0,0,2},{38971,7791,0,0,2},{39006,7793,0,0,2},
{39138,7795,0,0,2},{39151,7797,0,0,2},{39164,7799,0,0,2},{39208,7801,0,0,2},
{39209,7803,0,0,2},{39335,7805,0,0,2},{39362,7807,0,0,2},{39409,7809,0,0,2},
{39422,7811,0,0,2},{39530,7813,0,0,2},{39698,7815,0,0,2},{39791,7817,0,0,2},
{40000,7819,0,0,2},{40023,7821,0,0,2},{40189,7823,0,0,2},{40295,7825,0,0,2},
{40372,7827,0,0,2},{40442,7829,0,0,2},{40478,7831,0,0,2},{40575,7833,0,0,2},
{40599,7835,0,0,2},{40607,7837,0,0,2},{40635,7839,0,0,2},{40654,7841,0,0,2},
{40697,7843,0,0,2},{40702,7845,0,0,2},{40709,7847,0,0,2},{40719,7849,0,0,2},
{40726,7851,0,0,2},{40763,7853,0,0,2},{40771,7855,0,0,2},{40845,7857,0,0,2},
{40846,7859,0,0,2},{40860,7861,0,0,2},{42515,7863,0,0,2},{42516,7865,0,0,2},
{42517,7867,0,0,2},{42518,7869,0,0,2},{42519,7871,0,0,2},{42520,7873,0,0,2},
{42521,7875,0,0,2},{42522,7877,0,0,2},{42523,7879,0,0,2},{42524,7881,0,0,2},
{42525,7883,0,0,2},{42526,7885,0,0,2},{42527,7887,0,0,2},{42614,7889,0,0,2},
{42792,7891,0,0,2},{42793,7893,0,0,2},{42802,7895,0,0,2},{42803,7897,0,0,2},
{42804,7899,0,0,2},{42805,7901,0,0,2},{42806,7903,0,0,2},{42807,7905,0,0,2},
{42808,7907,0,0,2},{42809,7909,0,0,2},{42810,7911,0,0,3},{42811,7914,0,0,3},
{42812,7917,0,0,2},{42813,7919,0,0,2},{42830,7921,0,0,2},{42831,7923,0,0,2},
{42848,7925,0,0,2},{42849,7927,0,0,2},{42873,7929,0,0,2},{42874,7931,0,0,2},
{42875,7933,0,0,2},{42876,7935,0,0,2},{42877,7937,0,0,2},{42882,7939,0,0,2},
{42883,7941,0,0,2},{42884,7943,0,0,2},{42885,7945,0,0,2},{42886,7947,0,0,2},
{42887,7949,0,0,2},{42906,7951,0,0,2},{42907,7953,0,0,2},{42908,7955,0,0,2},
{42909,7957,0,0,2},{42910,7959,0,0,2},{42911,7961,0,0,2},{42912,7963,0,0,2},
{42913,7965,0,0,2},{42914,7967,0,0,2},{42915,7969,0,0,2},{42916,7971,0,0,2},
{42917,7973,0,0,2},{42918,7975,0,0,2},{42919,7977,0,0,2},{42920,7979,0,0,2},
{42921,7981,0,0,2},{43000,7983,0,0,2},{43001,7985,0,0,3},{43701,0,4457,48,0},
{43702,0,4505,48,0},{43705,0,4553,48,0},{43707,0,4601,48,0},{43708,0,4649,48,0},
{64014,8468,0,0,2},{64015,8470,0,0,2},{64017,8472,0,0,2},{64019,8474,0,0,2},
{64020,8476,0,0,2},{64031,8478,0,0,2},{64033,8480,0,0,2},{64035,8482,0,0,2},
{64036,8484,0,0,2},{64039,8486,0,0,2},{64040,8488,0,0,2},{64041,8490,0,0,2},
{64256,8492,0,0,2},{64257,8494,0,0,2},{64258,8496,0,0,2},{64259,8498,0,0,3},
{64260,8501,0,0,3},{64261,8504,0,0,3},{64262,8507,0,0,2},{64275,8509,0,0,2},
{64276,8511,0,0,2},{64277,8513,0,0,2},{64278,8515,0,0,2},{64279,8517,0,0,2},
{64335,8519,0,0,2},{64420,8521,0,0,2},{64421,8523,0,0,2},{64432,8525,0,0,2},
{64433,8527,0,0,2},{64477,8529,0,0,2},{64490,8531,0,0,2},{64491,8533,0,0,2},
{64492,8535,0,0,2},{64493,8537,0,0,2},{64494,8539,0,0,2},{64495,8541,0,0,2},
{64496,8543,0,0,2},{64497,8545,0,0,2},{64498,8547,0,0,2},{64499,8549,0,0,2},
{64500,8551,0,0,2},{64501,8553,0,0,2},{64502,8555,0,0,2},{64503,8557,0,0,2},
{64504,8559,0,0,2},{64505,8561,0,0,2},{64506,8563,0,0,2},{64507,8565,0,0,2},
{64512,8567,0,0,2},{64513,8569,0,0,2},{64514,8571,0,0,2},{64515,8573,0,0,2},
{64516,8575,0,0,2},{64517,8577,0,0,2},{64518,8579,0,0,2},{64519,8581,0,0,2},
{64520,8583,0,0,2},{64521,8585,0,0,2},{64522,8587,0,0,2},{64523,8589,0,0,2},
{64524,8591,0,0,2},{64525,8593,0,0,2},{64526,8595,0,0,2},{64527,8597,0,0,2},
{64528,8599,0,0,2},{64529,8601,0,0,2},{64530,8603,0,0,2},{64531,8605,0,0,2},
{64532,8607,0,0,2},{64533,8609,0,0,2},{64534,8611,0,0,2},{64535,8613,0,0,2},
{64536,8615,0,0,2},{64537,8617,0,0,2},{64538,8619,0,0,2},{64539,8621,0,0,2},
{64540,8623,0,0,2},{64541,8625,0,0,2},{64542,8627,0,0,2},{64543,8629,0,0,2},
{64544,8631,0,0,2},{64545,8633,0,0,2},{64546,8635,0,0,2},{64547,8637,0,0,2},
{64548,8639,0,0,2},{64549,8641,0,0,2},{64550,8643,0,0,2},{64551,8645,0,0,2},
{64552,8647,0,0,2},{64553,8649,0,0,2},{64554,8651,0,0,2},{64555,8653,0,0,2},
{64556,8655,0,0,2},{64557,8657,0,0,2},{64558,8659,0,0,2},{64559,8661,0,0,2},
{64560,8663,0,0,2},{64561,8665,0,0,2},{64562,8667,0,0,2},{64563,8669,0,0,2},
{64564,8671,0,0,2},{64565,8673,0,0,2},{64566,8675,0,0,2},{64567,8677,0,0,2},
{64568,8679,0,0,2},{64569,8681,0,0,2},{64570,8683,0,0,2},{64571,8685,0,0,2},
{64572,8687,0,0,2},{64573,8689,0,0,2},{64574,8691,0,0,2},{64575,8693,0,0,2},
{64576,8695,0,0,2},{64577,8697,0,0,2},{64578,8699,0,0,2},{64579,8701,0,0,2},
{64580,8703,0,0,2},{64581,8705,0,0,2},{64582,8707,0,0,2},{64583,8709,0,0,2},
{64584,8711,0,0,2},{64585,8713,0,0,2},{64586,8715,0,0,2},{64587,8717,0,0,2},
{64588,8719,0,0,2},{64589,8721,0,0,2},{64590,8723,0,0,2},{64591,8725,0,0,2},
{64592,8727,0,0,2},{64593,8729,0,0,2},{64594,8731,0,0,2},{64595,8733,0,0,2},
{64596,8735,0,0,2},{64597,8737,0,0,2},{64598,8739,0,0,2},{64599,8741,0,0,2},
{64600,8743,0,0,2},{64601,8745,0,0,2},{64602,8747,0,0,2},{64603,8749,0,0,2},
{64604,8751,0,0,2},{64605,8753,0,0,2},{64606,8755,0,0,2},{64607,8757,0,0,2},
{64608,8759,0,0,2},{64609,8761,0,0,2},{64610,8763,0,0,2},{64611,8765,0,0,2},
{64612,8767,0,0,2},{64613,8769,0,0,2},{64614,8771,0,0,2},{64615,8773,0,0,2},
{64616,8775,0,0,2},{64617,8777,0,0,2},{64618,8779,0,0,2},{64619,8781,0,0,2},
{64620,8783,0,0,2},{64621,8785,0,0,2},{64622,8787,0,0,2},{64623,8789,0,0,2},
{64624,8791,0,0,2},{64625,8793,0,0,2},{64626,8795,0,0,2},{64627,8797,0,0,2},
{64628,8799,0,0,2},{64629,8801,0,0,2},{64630,8803,0,0,2},{64631,8805,0,0,2},
{64632,8807,0,0,2},{64633,8809,0,0,2},{64634,8811,0,0,2},{64635,8813,0,0,2},
{64636,8815,0,0,2},{64637,8817,0,0,2},{64638,8819,0,0,2},{64639,8821,0,0,2},
{64640,8823,0,0,2},{64641,8825,0,0,2},{64642,8827,0,0,2},{64643,8829,0,0,2},
{64644,8831,0,0,2},{64645,8833,0,0,2},{64646,8835,0,0,2},{64647,8837,0,0,2},
{64648,8839,0,0,2},{64649,8841,0,0,2},{64650,8843,0,0,2},{64651,8845,0,0,2},
{64652,8847,0,0,2},{64653,8849,0,0,2},{64654,8851,0,0,2},{64655,8853,0,0,2},
{64656,8855,0,0,2},{64657,8857,0,0,2},{64658,8859,0,0,2},{64659,8861,0,0,2},
{64660,8863,0,0,2},{64661,8865,0,0,2},{64662,8867,0,0,2},{64663,8869,0,0,2},
{64664,8871,0,0,2},{64665,8873,0,0,2},{64666,8875,0,0,2},{64667,8877,0,0,2},
{64668,8879,0,0,2},{64669,8881,0,0,2},{64670,8883,0,0,2},{64671,8885,0,0,2},
{64672,8887,0,0,2},{64673,8889,0,0,2},{64674,8891,0,0,2},{64675,8893,0,0,2},
{64676,8895,0,0,2},{64677,8897,0,0,2},{64678,8899,0,0,2},{64679,8901,0,0,2},
{64680,8903,0,0,2},{64681,8905,0,0,2},{64682,8907,0,0,2},{64683,8909,0,0,2},
{64684,8911,0,0,2},{64685,8913,0,0,2},{64686,8915,0,0,2},{64687,8917,0,0,2},
{64688,8919,0,0,2},{64689,8921,0,0,2},{64690,8923,0,0,2},{64691,8925,0,0,2},
{64692,8927,0,0,2},{64693,8929,0,0,2},{64694,8931,0,0,2},{64695,8933,0,0,2},
{64696,8935,0,0,2},{64697,8937,0,0,2},{64698,8939,0,0,2},{64699,8941,0,0,2},
{64700,8943,0,0,2},{64701,8945,0,0,2},{64702,8947,0,0,2},{64703,8949,0,0,2},
{64704,8951,0,0,2},{64705,8953,0,0,2},{64706,8955,0,0,2},{64707,8957,0,0,2},
{64708,8959,0,0,2},{64709,8961,0,0,2},{64710,8963,0,0,2},{64711,8965,0,0,2},
{64712,8967,0,0,2},{64713,8969,0,0,2},{64714,8971,0,0,2},{64715,8973,0,0,2},
{64716,8975,0,0,2},{64717,8977,0,0,2},{64718,8979,0,0,2},{64719,8981,0,0,2},
{64720,8983,0,0,2},{64721,8985,0,0,2},{64722,8987,0,0,2},{64723,8989,0,0,2},
{64724,8991,0,0,2},{64725,8993,0,0,2},{64726,8995,0,0,2},{64727,8997,0,0,2},
{64728,8999,0,0,2},{64729,9001,0,0,2},{64730,9003,0,0,2},{64731,9005,0,0,2},
{64732,9007,0,0,2},{64733,9009,0,0,2},{64734,9011,0,0,2},{64735,9013,0,0,2},
{64736,9015,0,0,2},{64737,9017,0,0,2},{64738,9019,0,0,2},{64739,9021,0,0,2},
{64740,9023,0,0,2},{64741,9025,0,0,2},{64742,9027,0,0,2},{64743,9029,0,0,2},
{64744,9031,0,0,2},{64745,9033,0,0,2},{64746,9035,0,0,2},{64747,9037,0,0,2},
{64748,9039,0,0,2},{64749,9041,0,0,2},{64750,9043,0,0,2},{64751,9045,0,0,2},
{64752,9047,0,0,2},{64753,9049,0,0,2},{64754,9051,0,0,2},{64755,9053,0,0,2},
{64756,9055,0,0,2},{64757,9057,0,0,2},{64758,9059,0,0,2},{64759,9061,0,0,2},
{64760,9063,0,0,2},{64761,9065,0,0,2},{64762,9067,0,0,2},{64763,9069,0,0,2},
{64764,9071,0,0,2},{64765,9073,0,0,2},{64766,9075,0,0,2},{64767,9077,0,0,2},
{64768,9079,0,0,2},{64769,9081,0,0,2},{64770,9083,0,0,2},{64771,9085,0,0,2},
{64772,9087,0,0,2},{64773,9089,0,0,2},{64774,9091,0,0,2},{64775,9093,0,0,2},
{64776,9095,0,0,2},{64777,9097,0,0,2},{64778,9099,0,0,2},{64779,9101,0,0,2},
{64780,9103,0,0,2},{64781,9105,0,0,2},{64782,9107,0,0,2},{64783,9109,0,0,2},
{64784,9111,0,0,2},{64785,9113,0,0,2},{64786,9115,0,0,2},{64787,9117,0,0,2},
{64788,9119,0,0,2},{64789,9121,0,0,2},{64790,9123,0,0,2},{64791,9125,0,0,2},
{64792,9127,0,0,2},{64793,9129,0,0,2},{64794,9131,0,0,2},{64795,9133,0,0,2},
{64796,9135,0,0,2},{64797,9137,0,0,2},{64798,9139,0,0,2},{64799,9141,0,0,2},
{64800,9143,0,0,2},{64801,9145,0,0,2},{64802,9147,0,0,2},{64803,9149,0,0,2},
{64804,9151,0,0,2},{64805,9153,0,0,2},{64806,9155,0,0,2},{64807,9157,0,0,2},
{64808,9159,0,0,2},{64809,9161,0,0,2},{64810,9163,0,0,2},{64811,9165,0,0,2},
{64812,9167,0,0,2},{64813,9169,0,0,2},{64814,9171,0,0,2},{64815,9173,0,0,2},
{64816,9175,0,0,2},{64817,9177,0,0,2},{64818,9179,0,0,2},{64819,9181,0,0,2},
{64820,9183,0,0,2},{64821,9185,0,0,2},{64822,9187,0,0,2},{64823,9189,0,0,2},
{64824,9191,0,0,2},{64825,9193,0,0,2},{64826,9195,0,0,2},{64827,9197,0,0,2},
{64828,9199,0,0,2},{64829,9201,0,0,2},{64848,9203,0,0,3},{64849,9206,0,0,3},
{64850,9209,0,0,3},{64851,9212,0,0,3},{64852,9215,0,0,3},{64853,9218,0,0,3},
{64854,9221,0,0,3},{64855,9224,0,0,3},{64856,9227,0,0,3},{64857,9230,0,0,3},
{64858,9233,0,0,3},{64859,9236,0,0,3},{64860,9239,0,0,3},{64861,9242,0,0,3},
{64862,9245,0,0,3},{64863,9248,0,0,3},{64864,9251,0,0,3},{64865,9254,0,0,3},
{64866,9257,0,0,3},{64867,9260,0,0,3},{64868,9263,0,0,3},{64869,9266,0,0,3},
{64870,9269,0,0,3},{64871,9272,0,0,3},{64872,9275,0,0,3},{64873,9278,0,0,3},
{64874,9281,0,0,3},{64875,9284,0,0,3},{64876,9287,0,0,3},{64877,9290,0,0,3},
{64878,9293,0,0,3},{64879,9296,0,0,3},{64880,9299,0,0,3},{64881,9302,0,0,3},
{64882,9305,0,0,3},{64883,9308,0,0,3},{64884,9311,0,0,3},{64885,9314,0,0,3},
{64886,9317,0,0,3},{64887,9320,0,0,3},{64888,9323,0,0,3},{64889,9326,0,0,3},
{64890,9329,0,0,3},{64891,9332,0,0,3},{64892,9335,0,0,3},{64893,9338,0,0,3},
{64894,9341,0,0,3},{64895,9344,0,0,3},{64896,9347,0,0,3},{64897,9350,0,0,3},
{64898,9353,0,0,3},{64899,9356,0,0,3},{64900,9359,0,0,3},{64901,9362,0,0,3},
{64902,9365,0,0,3},{64903,9368,0,0,3},{64904,9371,0,0,3},{64905,9374,0,0,3},
{64906,9377,0,0,3},{64907,9380,0,0,3},{64908,9383,0,0,3},{64909,9386,0,0,3},
{64910,9389,0,0,3},{64911,9392,0,0,3},{64914,9395,0,0,3},{64915,9398,0,0,3},
{64916,9401,0,0,3},{64917,9404,0,0,3},{64918,9407,0,0,3},{64919,9410,0,0,3},
{64920,9413,0,0,3},{64921,9416,0,0,3},{64922,9419,0,0,3},{64923,9422,0,0,3},
{64924,9425,0,0,3},{64925,9428,0,0,3},{64926,9431,0,0,3},{64927,9434,0,0,3},
{64928,9437,0,0,3},{64929,9440,0,0,3},{64930,9443,0,0,3},{64931,9446,0,0,3},
{64932,9449,0,0,3},{64933,9452,0,0,3},{64934,9455,0,0,3},{64935,9458,0,0,3},
{64936,9461,0,0,3},{64937,9464,0,0,3},{64938,9467,0,0,3},{64939,9470,0,0,3},
{64940,9473,0,0,3},{64941,9476,0,0,3},{64942,9479,0,0,3},{64943,9482,0,0,3},
{64944,9485,0,0,3},{64945,9488,0,0,3},{64946,9491,0,0,3},{64947,9494,0,0,3},
{64948,9497,0,0,3},{64949,9500,0,0,3},{64950,9503,0,0,3},{64951,9506,0,0,3},
{64952,9509,0,0,3},{64953,9512,0,0,3},{64954,9515,0,0,3},{64955,9518,0,0,3},
{64956,9521,0,0,3},{64957,9524,0,0,3},{64958,9527,0,0,3},{64959,9530,0,0,3},
{64960,9533,0,0,3},{64961,9536,0,0,3},{64962,9539,0,0,3},{64963,9542,0,0,3},
{64964,9545,0,0,3},{64965,9548,0,0,3},{64966,9551,0,0,3},{64967,9554,0,0,3},
{65008,9557,0,0,3},{65009,9560,0,0,3},{65010,9563,0,0,4},{65011,9567,0,0,4},
{65012,9571,0,0,4},{65013,9575,0,0,4},{65014,9579,0,0,4},{65015,9583,0,0,4},
{65016,9587,0,0,4},{65017,9591,0,0,3},{65018,9594,0,0,18},{65019,9612,0,0,8},
{65020,9620,0,0,4},{65049,9624,0,0,3},{65072,9627,0,0,2},{65269,9629,0,0,2},
{65270,9631,0,0,2},{65271,9633,0,0,2},{65272,9635,0,0,2},{65273,9637,0,0,2},
{65274,9639,0,0,2},{65275,9641,0,0,2},{65276,9643,0,0,2},{67968,9645,0,0,2},
{67969,9647,0,0,2},{67970,9649,0,0,2},{67971,9651,0,0,2},{67972,9653,0,0,2},
{67973,9655,0,0,2},{67974,9657,0,0,2},{67975,9659,0,0,2},{67976,9661,0,0,2},
{67977,9663,0,0,2},{67978,9665,0,0,2},{67979,9667,0,0,2},{67980,9669,0,0,2},
{67981,9671,0,0,2},{67982,9673,0,0,2},{67983,9675,0,0,2},{67984,9677,0,0,2},
{67985,9679,0,0,2},{67986,9681,0,0,2},{67987,9683,0,0,2},{67988,9685,0,0,2},
{67989,9687,0,0,2},{67990,9689,0,0,2},{67991,9691,0,0,2},{67992,9693,0,0,2},
{67993,9695,0,0,2},{67994,9697,0,0,2},{67995,9699,0,0,2},{67996,9701,0,0,2},
{67997,9703,0,0,2},{68016,9705,0,0,2},{68296,9707,0,0,2},{68398,9709,0,0,2},
{68609,9711,0,0,2},{68612,9713,0,0,2},{68616,9715,0,0,2},{68618,9717,0,0,2},
{68620,9719,0,0,2},{68622,9721,0,0,2},{68624,9723,0,0,2},{68626,9725,0,0,2},
{68629,9727,0,0,2},{68631,9729,0,0,2},{68633,9731,0,0,2},{68635,9733,0,0,2},
{68637,9735,0,0,2},{68639,9737,0,0,2},{68645,9739,0,0,2},{68647,9741,0,0,2},
{68649,9743,0,0,2},{68651,9745,0,0,2},{68654,9747,0,0,2},{68659,9749,0,0,2},
{68661,9751,0,0,2},{68663,9753,0,0,2},{68665,9755,0,0,2},{68667,9757,0,0,2},
{68672,9759,0,0,2},{68674,9761,0,0,2},{68676,9763,0,0,2},{68678,9765,0,0,2},
{68737,9767,0,0,2},{68746,9769,0,0,2},{68747,9771,0,0,2},{68753,9773,0,0,2},
{68764,9775,0,0,2},{68766,9777,0,0,2},{68767,9779,0,0,2},{68771,9781,0,0,2},
{68779,9783,0,0,2},{68781,9785,0,0,2},{68801,9787,0,0,2},{68810,9789,0,0,2},
{68811,9791,0,0,2},{68817,9793,0,0,2},{68828,9795,0,0,2},{68830,9797,0,0,2},
{68831,9799,0,0,2},{68835,9801,0,0,2},{68843,9803,0,0,2},{68845,9805,0,0,2},
{69392,9807,0,0,2},{69395,9809,0,0,2},{69399,9811,0,0,2},{69404,9813,0,0,2},
{69415,9815,0,0,2},{69445,9817,0,0,2},{69786,9819,0,0,2},{69788,9821,0,0,2},
{69803,9823,0,0,2},{71128,9825,0,0,2},{71129,9827,0,0,2},{71130,9829,0,0,2},
{71131,9831,0,0,2},{71132,9833,0,0,2},{71133,9835,0,0,2},{71429,9837,0,0,2},
{71446,9839,0,0,2},{71450,9841,0,0,2},{93844,9843,0,0,2},{93845,9845,0,0,2},
{93846,9847,0,0,2},{119127,0,4697,1,0},{119128,0,4698,1,0},{119225,0,4704,1,0},
{119226,0,4707,1,0},{126129,9884,0,0,2},{126130,9886,0,0,2},{127232,9888,0,0,2},
{127233,9890,0,0,2},{127234,9892,0,0,2},{127235,9894,0,0,2},{127236,9896,0,0,2},
{127237,9898,0,0,2},{127238,9900,0,0,2},{127239,9902,0,0,2},{127240,9904,0,0,2},
{127241,9906,0,0,2},{127242,9908,0,0,2},{127248,9910,0,0,3},{127249,9913,0,0,3},
{127250,9916,0,0,3},{127251,9919,0,0,3},{127252,9922,0,0,3},{127253,9925,0,0,3},
{127254,9928,0,0,3},{127255,9931,0,0,3},{127256,9934,0,0,3},{127257,9937,0,0,3},
{127258,9940,0,0,3},{127259,9943,0,0,3},{127260,9946,0,0,3},{127261,9949,0,0,3},
{127262,9952,0,0,3},{127263,9955,0,0,3},{127264,9958,0,0,3},{127265,9961,0,0,3},
{127266,9964,0,0,3},{127267,9967,0,0,3},{127268,9970,0,0,3},{127269,9973,0,0,3},
{127270,9976,0,0,3},{127271,9979,0,0,3},{127272,9982,0,0,3},{127273,9985,0,0,3},
{127274,9988,0,0,3},{127277,9991,0,0,2},{127278,9993,0,0,2},{127306,9995,0,0,2},
{127307,9997,0,0,2},{127308,9999,0,0,2},{127309,10001,0,0,2},{127310,10003,0,0,
3},{127311,10006,0,0,2},{127338,10008,0,0,2},{127339,10010,0,0,2},{127371,10012,
0,0,2},{127372,10014,0,0,2},{127373,10016,0,0,2},{127374,10018,0,0,2},{127375,
10020,0,0,2},{127376,10022,0,0,2},{127377,10024,0,0,2},{127378,10026,0,0,4},
{127379,10030,0,0,4},{127380,10034,0,0,2},{127381,10036,0,0,3},{127382,10039,0,
0,2},{127383,10041,0,0,2},{127384,10043,0,0,3},{127385,10046,0,0,3},{127386,
10049,0,0,2},{127387,10051,0,0,2},{127388,10053,0,0,7},{127389,10060,0,0,2},
{127390,10062,0,0,2},{127391,10064,0,0,2},{127392,10066,0,0,3},{127393,10069,0,
0,3},{127394,10072,0,0,4},{127395,10076,0,0,3},{127396,10079,0,0,4},{127398,
10083,0,0,2},{127399,10085,0,0,3},{127400,10088,0,0,6},{127401,10094,0,0,8},
{127402,10102,0,0,3},{127403,10105,0,0,3},{127404,10108,0,0,3},{127488,10111,0,
0,2},{127489,10113,0,0,2},{127504,10115,0,0,2},{127505,10117,0,0,2},{127506,
10119,0,0,2},{127507,10121,0,0,2},{127508,10123,0,0,2},{127509,10125,0,0,2},
{127510,10127,0,0,2},{127511,10129,0,0,2},{127512,10131,0,0,2},{127513,10133,0,
0,2},{127514,10135,0,0,2},{127515,10137,0,0,2},{127516,10139,0,0,2},{127517,
10141,0,0,2},{127518,10143,0,0,2},{127519,10145,0,0,2},{127520,10147,0,0,2},
{127521,10149,0,0,2},{127522,10151,0,0,2},{127523,10153,0,0,2},{127524,10155,0,
0,2},{127525,10157,0,0,2},{127526,10159,0,0,2},{127527,10161,0,0,2},{127528,
10163,0,0,2},{127529,10165,0,0,2},{127530,10167,0,0,2},{127531,10169,0,0,2},
{127532,10171,0,0,2},{127533,10173,0,0,2},{127534,10175,0,0,2},{127535,10177,0,
0,2},{127536,10179,0,0,2},{127537,10181,0,0,2},{127538,10183,0,0,2},{127539,
10185,0,0,2},{127540,10187,0,0,2},{127541,10189,0,0,2},{127542,10191,0,0,2},
{127543,10193,0,0,2},{127544,10195,0,0,2},{127545,10197,0,0,2},{127546,10199,0,
0,2},{127547,10201,0,0,2},{127552,10203,0,0,4},{127553,10207,0,0,4},{127554,
10211,0,0,4},{127555,10215,0,0,4},{127556,10219,0,0,4},{127557,10223,0,0,4},
{127558,10227,0,0,4},{127559,10231,0,0,4},{127560,10235,0,0,4},{127568,10239,0,
0,2},{127569,10241,0,0,2},{131362,10243,0,0,2},{132380,10245,0,0,2},{132389,
10247,0,0,2},{132427,10249,0,0,2},{132666,10251,0,0,2},{133124,10253,0,0,2},
{133342,10255,0,0,2},{133676,10257,0,0,2},{133987,10259,0,0,2},{136420,10261,0,
0,2},{136872,10263,0,0,2},{136938,10265,0,0,2},{137672,10267,0,0,2},{138008,
10269,0,0,2},{138507,10271,0,0,2},{138724,10273,0,0,2},{138726,10275,0,0,2},
{139651,10277,0,0,2},{139679,10279,0,0,2},{140081,10281,0,0,2},{141012,10283,0,
0,2},{141380,10285,0,0,2},{141386,10287,0,0,2},{142092,10289,0,0,2},{142321,
10291,0,0,2},{143370,10293,0,0,2},{144056,10295,0,0,2},{144223,10297,0,0,2},
{144275,10299,0,0,2},{144284,10301,0,0,2},{144323,10303,0,0,2},{144341,10305,0,
0,2},{144493,10307,0,0,2},{145059,10309,0,0,2},{145575,10311,0,0,2},{146061,
10313,0,0,2},{146170,10315,0,0,2},{146620,10317,0,0,2},{146718,10319,0,0,2},
{147153,10321,0,0,2},{147294,10323,0,0,2},{147342,10325,0,0,2},{148067,10327,0,
0,2},{148206,10329,0,0,2},{148395,10331,0,0,2},{149000,10333,0,0,2},{149301,
10335,0,0,2},{149524,10337,0,0,2},{150582,10339,0,0,2},{150674,10341,0,0,2},
{151457,10343,0,0,2},{151480,10345,0,0,2},{151620,10347,0,0,2},{151794,10349,0,
0,2},{151795,10351,0,0,2},{151833,10353,0,0,2},{151859,10355,0,0,2},{152137,
10357,0,0,2},{152605,10359,0,0,2},{153126,10361,0,0,2},{153242,10363,0,0,2},
{153285,10365,0,0,2},{153980,10367,0,0,2},{154279,10369,0,0,2},{154539,10371,0,
0,2},{154752,10373,0,0,2},{154832,10375,0,0,2},{155526,10377,0,0,2},{156122,
10379,0,0,2},{156200,10381,0,0,2},{156231,10383,0,0,2},{156377,10385,0,0,2},
{156478,10387,0,0,2},{156890,10389,0,0,2},{156963,10391,0,0,2},{157096,10393,0,
0,2},{157607,10395,0,0,2},{157621,10397,0,0,2},{158524,10399,0,0,2},{158774,
10401,0,0,2},{158933,10403,0,0,2},{159083,10405,0,0,2},{159532,10407,0,0,2},
{159665,10409,0,0,2},{159954,10411,0,0,2},{160714,10413,0,0,2},{161383,10415,0,
0,2},{161966,10417,0,0,2},{162150,10419,0,0,2},{162984,10421,0,0,2},{163539,
10423,0,0,2},{163631,10425,0,0,2},{165330,10427,0,0,2},{165357,10429,0,0,2},
{165678,10431,0,0,2},{166906,10433,0,0,2},{167287,10435,0,0,2},{168261,10437,0,
0,2},{168415,10439,0,0,2},{168474,10441,0,0,2},{168970,10443,0,0,2},{169110,
10445,0,0,2},{169398,10447,0,0,2},{170800,10449,0,0,2},{172238,10451,0,0,2},
{172293,10453,0,0,2},{172558,10455,0,0,2},{172689,10457,0,0,2},{172946,10459,0,
0,2},{173568,10461,0,0,2},{183,0,0,0,2},{183,2,0,0,2},{769,649,0,0,2},{1463,811,
0,0,2},{1464,813,0,0,2},{1468,815,0,0,2},{1468,817,0,0,2},{1471,819,0,0,2},
{1468,821,0,0,2},{1468,823,0,0,2},{1468,825,0,0,2},{1465,827,0,0,2},{1468,829,0,
0,2},{1468,831,0,0,2},{1468,833,0,0,2},{1460,835,0,0,2},{1468,837,0,0,2},{1468,
839,0,0,2},{1468,841,0,0,2},{1471,843,0,0,2},{1468,845,0,0,2},{1468,847,0,0,2},
{1468,849,0,0,2},{1468,851,0,0,2},{1468,853,0,0,2},{1468,855,0,0,2},{1471,857,0,
0,2},{1468,859,0,0,2},{1468,861,0,0,2},{1468,863,0,0,2},{1468,865,3847,2,2},
{1473,867,0,0,3},{1474,870,0,0,3},{1473,873,0,0,2},{1474,875,0,0,2},{1468,877,0,
0,2},{1463,889,0,0,3},{2364,928,0,0,2},{2364,930,0,0,2},{2364,932,0,0,2},{2364,
934,0,0,2},{2364,936,0,0,2},{2364,938,0,0,2},{2364,942,0,0,2},{2364,944,0,0,2},
{2492,950,0,0,2},{2492,952,0,0,2},{2492,954,0,0,2},{2620,958,0,0,2},{2620,960,0,
0,2},{2620,962,0,0,2},{2620,964,0,0,2},{2620,966,0,0,2},{2620,968,0,0,2},{2876,
970,0,0,2},{2876,972,0,0,2},{3585,994,0,0,2},{3586,996,0,0,2},{3587,998,0,0,2},
{3588,1000,0,0,2},{3589,1002,0,0,2},{3590,1004,0,0,2},{3591,1006,0,0,2},{3592,
1008,0,0,2},{3593,1010,0,0,2},{3594,1012,0,0,2},{3595,1014,0,0,2},{3596,1016,0,
0,2},{3597,1018,0,0,2},{3598,1020,0,0,2},{3599,1022,0,0,2},{3600,1024,0,0,2},
{3601,1026,0,0,2},{3602,1028,0,0,2},{3603,1030,0,0,2},{3604,1032,0,0,2},{3605,
1034,0,0,2},{3606,1036,0,0,2},{3607,1038,0,0,2},{3608,1040,0,0,2},{3609,1042,0,
0,2},{3610,1044,0,0,2},{3611,1046,0,0,2},{3612,1048,0,0,2},{3613,1050,0,0,2},
{3614,1052,0,0,2},{3615,1054,0,0,2},{3616,1056,0,0,2},{3617,1058,0,0,2},{3618,
1060,0,0,2},{3619,1062,0,0,2},{3620,1064,0,0,2},{3621,1066,0,0,2},{3622,1068,0,
0,2},{3623,1070,0,0,2},{3624,1072,0,0,2},{3625,1074,0,0,2},{3626,1076,0,0,2},
{3627,1078,0,0,2},{3628,1080,0,0,2},{3629,1082,0,0,2},{3630,1084,0,0,2},{3585,
1086,0,0,2},{3586,1088,0,0,2},{3587,1090,0,0,2},{3588,1092,0,0,2},{3589,1094,0,
0,2},{3590,1096,0,0,2},{3591,1098,0,0,2},{3592,1100,0,0,2},{3593,1102,0,0,2},
{3594,1104,0,0,2},{3595,1106,0,0,2},{3596,1108,0,0,2},{3597,1110,0,0,2},{3598,
1112,0,0,2},{3599,1114,0,0,2},{3600,1116,0,0,2},{3601,1118,0,0,2},{3602,1120,0,
0,2},{3603,1122,0,0,2},{3604,1124,0,0,2},{3605,1126,0,0,2},{3606,1128,0,0,2},
{3607,1130,0,0,2},{3608,1132,0,0,2},{3609,1134,0,0,2},{3610,1136,0,0,2},{3611,
1138,0,0,2},{3612,1140,0,0,2},{3613,1142,0,0,2},{3614,1144,0,0,2},{3615,1146,0,
0,2},{3616,1148,0,0,2},{3617,1150,0,0,2},{3618,1152,0,0,2},{3619,1154,0,0,2},
{3620,1156,0,0,2},{3621,1158,0,0,2},{3622,1160,0,0,2},{3623,1162,0,0,2},{3624,
1164,0,0,2},{3625,1166,0,0,2},{3626,1168,0,0,2},{3627,1170,0,0,2},{3628,1172,0,
0,2},{3629,1174,0,0,2},{3630,1176,0,0,2},{3585,1178,0,0,2},{3586,1180,0,0,2},
{3587,1182,0,0,2},{3588,1184,0,0,2},{3589,1186,0,0,2},{3590,1188,0,0,2},{3591,
1190,0,0,2},{3592,1192,0,0,2},{3593,1194,0,0,2},{3594,1196,0,0,2},{3595,1198,0,
0,2},{3596,1200,0,0,2},{3597,1202,0,0,2},{3598,1204,0,0,2},{3599,1206,0,0,2},
{3600,1208,0,0,2},{3601,1210,0,0,2},{3602,1212,0,0,2},{3603,1214,0,0,2},{3604,
1216,0,0,2},{3605,1218,0,0,2},{3606,1220,0,0,2},{3607,1222,0,0,2},{3608,1224,0,
0,2},{3609,1226,0,0,2},{3610,1228,0,0,2},{3611,1230,0,0,2},{3612,1232,0,0,2},
{3613,1234,0,0,2},{3614,1236,0,0,2},{3615,1238,0,0,2},{3616,1240,0,0,2},{3617,
1242,0,0,2},{3618,1244,0,0,2},{3619,1246,0,0,2},{3620,1248,0,0,2},{3621,1250,0,
0,2},{3622,1252,0,0,2},{3623,1254,0,0,2},{3624,1256,0,0,2},{3625,1258,0,0,2},
{3626,1260,0,0,2},{3627,1262,0,0,2},{3628,1264,0,0,2},{3629,1266,0,0,2},{3630,
1268,0,0,2},{3585,1270,0,0,2},{3586,1272,0,0,2},{3587,1274,0,0,2},{3588,1276,0,
0,2},{3589,1278,0,0,2},{3590,1280,0,0,2},{3591,1282,0,0,2},{3592,1284,0,0,2},
{3593,1286,0,0,2},{3594,1288,0,0,2},{3595,1290,0,0,2},{3596,1292,0,0,2},{3597,
1294,0,0,2},{3598,1296,0,0,2},{3599,1298,0,0,2},{3600,1300,0,0,2},{3601,1302,0,
0,2},{3602,1304,0,0,2},{3603,1306,0,0,2},{3604,1308,0,0,2},{3605,1310,0,0,2},
{3606,1312,0,0,2},{3607,1314,0,0,2},{3608,1316,0,0,2},{3609,1318,0,0,2},{3610,
1320,0,0,2},{3611,1322,0,0,2},{3612,1324,0,0,2},{3613,1326,0,0,2},{3614,1328,0,
0,2},{3615,1330,0,0,2},{3616,1332,0,0,2},{3617,1334,0,0,2},{3618,1336,0,0,2},
{3619,1338,0,0,2},{3620,1340,0,0,2},{3621,1342,0,0,2},{3622,1344,0,0,2},{3623,
1346,0,0,2},{3624,1348,0,0,2},{3625,1350,0,0,2},{3626,1352,0,0,2},{3627,1354,0,
0,2},{3628,1356,0,0,2},{3629,1358,0,0,2},{3630,1360,0,0,2},{3585,1362,0,0,2},
{3586,1364,0,0,2},{3587,1366,0,0,2},{3588,1368,0,0,2},{3589,1370,0,0,2},{3590,
1372,0,0,2},{3591,1374,0,0,2},{3592,1376,0,0,2},{3593,1378,0,0,2},{3594,1380,0,
0,2},{3595,1382,0,0,2},{3596,1384,0,0,2},{3597,1386,0,0,2},{3598,1388,0,0,2},
{3599,1390,0,0,2},{3600,1392,0,0,2},{3601,1394,0,0,2},{3602,1396,0,0,2},{3603,
1398,0,0,2},{3604,1400,0,0,2},{3605,1402,0,0,2},{3606,1404,0,0,2},{3607,1406,0,
0,2},{3608,1408,0,0,2},{3609,1410,0,0,2},{3610,1412,0,0,2},{3611,1414,0,0,2},
{3612,1416,0,0,2},{3613,1418,0,0,2},{3614,1420,0,0,2},{3615,1422,0,0,2},{3616,
1424,0,0,2},{3617,1426,0,0,2},{3618,1428,0,0,2},{3619,1430,0,0,2},{3620,1432,0,
0,2},{3621,1434,0,0,2},{3622,1436,0,0,2},{3623,1438,0,0,2},{3624,1440,0,0,2},
{3625,1442,0,0,2},{3626,1444,0,0,2},{3627,1446,0,0,2},{3628,1448,0,0,2},{3629,
1450,0,0,2},{3630,1452,0,0,2},{3634,1454,0,0,1},{3713,1455,0,0,2},{3714,1457,0,
0,2},{3716,1459,0,0,2},{3719,1461,0,0,2},{3720,1463,0,0,2},{3722,1465,0,0,2},
{3725,1467,0,0,2},{3732,1469,0,0,2},{3733,1471,0,0,2},{3734,1473,0,0,2},{3735,
1475,0,0,2},{3737,1477,0,0,2},{3738,1479,0,0,2},{3739,1481,0,0,2},{3740,1483,0,
0,2},{3741,1485,0,0,2},{3742,1487,0,0,2},{3743,1489,0,0,2},{3745,1491,0,0,2},
{3746,1493,0,0,2},{3747,1495,0,0,2},{3749,1497,0,0,2},{3751,1499,0,0,2},{3754,
1501,0,0,2},{3755,1503,0,0,2},{3757,1505,0,0,2},{3758,1507,0,0,2},{3804,1509,0,
0,3},{3805,1512,0,0,3},{3806,1515,0,0,2},{3807,1517,0,0,2},{3713,1519,0,0,2},
{3714,1521,0,0,2},{3716,1523,0,0,2},{3719,1525,0,0,2},{3720,1527,0,0,2},{3722,
1529,0,0,2},{3725,1531,0,0,2},{3732,1533,0,0,2},{3733,1535,0,0,2},{3734,1537,0,
0,2},{3735,1539,0,0,2},{3737,1541,0,0,2},{3738,1543,0,0,2},{3739,1545,0,0,2},
{3740,1547,0,0,2},{3741,1549,0,0,2},{3742,1551,0,0,2},{3743,1553,0,0,2},{3745,
1555,0,0,2},{3746,1557,0,0,2},{3747,1559,0,0,2},{3749,1561,0,0,2},{3751,1563,0,
0,2},{3754,1565,0,0,2},{3755,1567,0,0,2},{3757,1569,0,0,2},{3758,1571,0,0,2},
{3804,1573,0,0,3},{3805,1576,0,0,3},{3806,1579,0,0,2},{3807,1581,0,0,2},{3713,
1583,0,0,2},{3714,1585,0,0,2},{3716,1587,0,0,2},{3719,1589,0,0,2},{3720,1591,0,
0,2},{3722,1593,0,0,2},{3725,1595,0,0,2},{3732,1597,0,0,2},{3733,1599,0,0,2},
{3734,1601,0,0,2},{3735,1603,0,0,2},{3737,1605,0,0,2},{3738,1607,0,0,2},{3739,
1609,0,0,2},{3740,1611,0,0,2},{3741,1613,0,0,2},{3742,1615,0,0,2},{3743,1617,0,
0,2},{3745,1619,0,0,2},{3746,1621,0,0,2},{3747,1623,0,0,2},{3749,1625,0,0,2},
{3751,1627,0,0,2},{3754,1629,0,0,2},{3755,1631,0,0,2},{3757,1633,0,0,2},{3758,
1635,0,0,2},{3804,1637,0,0,3},{3805,1640,0,0,3},{3806,1643,0,0,2},{3807,1645,0,
0,2},{3713,1647,0,0,2},{3714,1649,0,0,2},{3716,1651,0,0,2},{3719,1653,0,0,2},
{3720,1655,0,0,2},{3722,1657,0,0,2},{3725,1659,0,0,2},{3732,1661,0,0,2},{3733,
1663,0,0,2},{3734,1665,0,0,2},{3735,1667,0,0,2},{3737,1669,0,0,2},{3738,1671,0,
0,2},{3739,1673,0,0,2},{3740,1675,0,0,2},{3741,1677,0,0,2},{3742,1679,0,0,2},
{3743,1681,0,0,2},{3745,1683,0,0,2},{3746,1685,0,0,2},{3747,1687,0,0,2},{3749,
1689,0,0,2},{3751,1691,0,0,2},{3754,1693,0,0,2},{3755,1695,0,0,2},{3757,1697,0,
0,2},{3758,1699,0,0,2},{3804,1701,0,0,3},{3805,1704,0,0,3},{3806,1707,0,0,2},
{3807,1709,0,0,2},{3713,1711,0,0,2},{3714,1713,0,0,2},{3716,1715,0,0,2},{3719,
1717,0,0,2},{3720,1719,0,0,2},{3722,1721,0,0,2},{3725,1723,0,0,2},{3732,1725,0,
0,2},{3733,1727,0,0,2},{3734,1729,0,0,2},{3735,1731,0,0,2},{3737,1733,0,0,2},
{3738,1735,0,0,2},{3739,1737,0,0,2},{3740,1739,0,0,2},{3741,1741,0,0,2},{3742,
1743,0,0,2},{3743,1745,0,0,2},{3745,1747,0,0,2},{3746,1749,0,0,2},{3747,1751,0,
0,2},{3749,1753,0,0,2},{3751,1755,0,0,2},{3754,1757,0,0,2},{3755,1759,0,0,2},
{3757,1761,0,0,2},{3758,1763,0,0,2},{3804,1765,0,0,3},{3805,1768,0,0,3},{3806,
1771,0,0,2},{3807,1773,0,0,2},{3762,1775,0,0,1},{4021,1783,0,0,2},{4023,1785,0,
0,2},{4023,1787,0,0,2},{4023,1789,0,0,2},{4023,1791,0,0,2},{4023,1793,0,0,2},
{3954,1797,0,0,1},{3956,1798,0,0,1},{3968,1799,0,0,1},{4021,1800,0,0,2},{4023,
1802,0,0,2},{4023,1804,0,0,2},{4023,1806,0,0,2},{4023,1808,0,0,2},{4023,1810,0,
0,2},{3953,0,4275,1,0},{3968,1812,0,0,1},{3968,1813,0,0,1},{3953,0,4278,1,0},
{3968,1814,0,0,1},{3968,1815,0,0,1},{6528,1911,0,0,2},{6529,1913,0,0,2},{6530,
1915,0,0,2},{6531,1917,0,0,2},{6532,1919,0,0,2},{6533,1921,0,0,2},{6534,1923,0,
0,2},{6535,1925,0,0,2},{6536,1927,0,0,2},{6537,1929,0,0,2},{6538,1931,0,0,2},
{6539,1933,0,0,2},{6540,1935,0,0,2},{6541,1937,0,0,2},{6542,1939,0,0,2},{6543,
1941,0,0,2},{6544,1943,0,0,2},{6545,1945,0,0,2},{6546,1947,0,0,2},{6547,1949,0,
0,2},{6548,1951,0,0,2},{6549,1953,0,0,2},{6550,1955,0,0,2},{6551,1957,0,0,2},
{6552,1959,0,0,2},{6553,1961,0,0,2},{6554,1963,0,0,2},{6555,1965,0,0,2},{6556,
1967,0,0,2},{6557,1969,0,0,2},{6558,1971,0,0,2},{6559,1973,0,0,2},{6560,1975,0,
0,2},{6561,1977,0,0,2},{6562,1979,0,0,2},{6563,1981,0,0,2},{6564,1983,0,0,2},
{6565,1985,0,0,2},{6566,1987,0,0,2},{6567,1989,0,0,2},{6568,1991,0,0,2},{6569,
1993,0,0,2},{6570,1995,0,0,2},{6571,1997,0,0,2},{6528,1999,0,0,2},{6529,2001,0,
0,2},{6530,2003,0,0,2},{6531,2005,0,0,2},{6532,2007,0,0,2},{6533,2009,0,0,2},
{6534,2011,0,0,2},{6535,2013,0,0,2},{6536,2015,0,0,2},{6537,2017,0,0,2},{6538,
2019,0,0,2},{6539,2021,0,0,2},{6540,2023,0,0,2},{6541,2025,0,0,2},{6542,2027,0,
0,2},{6543,2029,0,0,2},{6544,2031,0,0,2},{6545,2033,0,0,2},{6546,2035,0,0,2},
{6547,2037,0,0,2},{6548,2039,0,0,2},{6549,2041,0,0,2},{6550,2043,0,0,2},{6551,
2045,0,0,2},{6552,2047,0,0,2},{6553,2049,0,0,2},{6554,2051,0,0,2},{6555,2053,0,
0,2},{6556,2055,0,0,2},{6557,2057,0,0,2},{6558,2059,0,0,2},{6559,2061,0,0,2},
{6560,2063,0,0,2},{6561,2065,0,0,2},{6562,2067,0,0,2},{6563,2069,0,0,2},{6564,
2071,0,0,2},{6565,2073,0,0,2},{6566,2075,0,0,2},{6567,2077,0,0,2},{6568,2079,0,
0,2},{6569,2081,0,0,2},{6570,2083,0,0,2},{6571,2085,0,0,2},{6528,2087,0,0,2},
{6529,2089,0,0,2},{6530,2091,0,0,2},{6531,2093,0,0,2},{6532,2095,0,0,2},{6533,
2097,0,0,2},{6534,2099,0,0,2},{6535,2101,0,0,2},{6536,2103,0,0,2},{6537,2105,0,
0,2},{6538,2107,0,0,2},{6539,2109,0,0,2},{6540,2111,0,0,2},{6541,2113,0,0,2},
{6542,2115,0,0,2},{6543,2117,0,0,2},{6544,2119,0,0,2},{6545,2121,0,0,2},{6546,
2123,0,0,2},{6547,2125,0,0,2},{6548,2127,0,0,2},{6549,2129,0,0,2},{6550,2131,0,
0,2},{6551,2133,0,0,2},{6552,2135,0,0,2},{6553,2137,0,0,2},{6554,2139,0,0,2},
{6555,2141,0,0,2},{6556,2143,0,0,2},{6557,2145,0,0,2},{6558,2147,0,0,2},{6559,
2149,0,0,2},{6560,2151,0,0,2},{6561,2153,0,0,2},{6562,2155,0,0,2},{6563,2157,0,
0,2},{6564,2159,0,0,2},{6565,2161,0,0,2},{6566,2163,0,0,2},{6567,2165,0,0,2},
{6568,2167,0,0,2},{6569,2169,0,0,2},{6570,2171,0,0,2},{6571,2173,0,0,2},{6528,
2175,0,0,2},{6529,2177,0,0,2},{6530,2179,0,0,2},{6531,2181,0,0,2},{6532,2183,0,
0,2},{6533,2185,0,0,2},{6534,2187,0,0,2},{6535,2189,0,0,2},{6536,2191,0,0,2},
{6537,2193,0,0,2},{6538,2195,0,0,2},{6539,2197,0,0,2},{6540,2199,0,0,2},{6541,
2201,0,0,2},{6542,2203,0,0,2},{6543,2205,0,0,2},{6544,2207,0,0,2},{6545,2209,0,
0,2},{6546,2211,0,0,2},{6547,2213,0,0,2},{6548,2215,0,0,2},{6549,2217,0,0,2},
{6550,2219,0,0,2},{6551,2221,0,0,2},{6552,2223,0,0,2},{6553,2225,0,0,2},{6554,
2227,0,0,2},{6555,2229,0,0,2},{6556,2231,0,0,2},{6557,2233,0,0,2},{6558,2235,0,
0,2},{6559,2237,0,0,2},{6560,2239,0,0,2},{6561,2241,0,0,2},{6562,2243,0,0,2},
{6563,2245,0,0,2},{6564,2247,0,0,2},{6565,2249,0,0,2},{6566,2251,0,0,2},{6567,
2253,0,0,2},{6568,2255,0,0,2},{6569,2257,0,0,2},{6570,2259,0,0,2},{6571,2261,0,
0,2},{824,4007,0,0,2},{43648,7988,0,0,2},{43649,7990,0,0,2},{43650,7992,0,0,2},
{43651,7994,0,0,2},{43652,7996,0,0,2},{43653,7998,0,0,2},{43654,8000,0,0,2},
{43655,8002,0,0,2},{43656,8004,0,0,2},{43657,8006,0,0,2},{43658,8008,0,0,2},
{43659,8010,0,0,2},{43660,8012,0,0,2},{43661,8014,0,0,2},{43662,8016,0,0,2},
{43663,8018,0,0,2},{43664,8020,0,0,2},{43665,8022,0,0,2},{43666,8024,0,0,2},
{43667,8026,0,0,2},{43668,8028,0,0,2},{43669,8030,0,0,2},{43670,8032,0,0,2},
{43671,8034,0,0,2},{43672,8036,0,0,2},{43673,8038,0,0,2},{43674,8040,0,0,2},
{43675,8042,0,0,2},{43676,8044,0,0,2},{43677,8046,0,0,2},{43678,8048,0,0,2},
{43679,8050,0,0,2},{43680,8052,0,0,2},{43681,8054,0,0,2},{43682,8056,0,0,2},
{43683,8058,0,0,2},{43684,8060,0,0,2},{43685,8062,0,0,2},{43686,8064,0,0,2},
{43687,8066,0,0,2},{43688,8068,0,0,2},{43689,8070,0,0,2},{43690,8072,0,0,2},
{43691,8074,0,0,2},{43692,8076,0,0,2},{43693,8078,0,0,2},{43694,8080,0,0,2},
{43695,8082,0,0,2},{43648,8084,0,0,2},{43649,8086,0,0,2},{43650,8088,0,0,2},
{43651,8090,0,0,2},{43652,8092,0,0,2},{43653,8094,0,0,2},{43654,8096,0,0,2},
{43655,8098,0,0,2},{43656,8100,0,0,2},{43657,8102,0,0,2},{43658,8104,0,0,2},
{43659,8106,0,0,2},{43660,8108,0,0,2},{43661,8110,0,0,2},{43662,8112,0,0,2},
{43663,8114,0,0,2},{43664,8116,0,0,2},{43665,8118,0,0,2},{43666,8120,0,0,2},
{43667,8122,0,0,2},{43668,8124,0,0,2},{43669,8126,0,0,2},{43670,8128,0,0,2},
{43671,8130,0,0,2},{43672,8132,0,0,2},{43673,8134,0,0,2},{43674,8136,0,0,2},
{43675,8138,0,0,2},{43676,8140,0,0,2},{43677,8142,0,0,2},{43678,8144,0,0,2},
{43679,8146,0,0,2},{43680,8148,0,0,2},{43681,8150,0,0,2},{43682,8152,0,0,2},
{43683,8154,0,0,2},{43684,8156,0,0,2},{43685,8158,0,0,2},{43686,8160,0,0,2},
{43687,8162,0,0,2},{43688,8164,0,0,2},{43689,8166,0,0,2},{43690,8168,0,0,2},
{43691,8170,0,0,2},{43692,8172,0,0,2},{43693,8174,0,0,2},{43694,8176,0,0,2},
{43695,8178,0,0,2},{43648,8180,0,0,2},{43649,8182,0,0,2},{43650,8184,0,0,2},
{43651,8186,0,0,2},{43652,8188,0,0,2},{43653,8190,0,0,2},{43654,8192,0,0,2},
{43655,8194,0,0,2},{43656,8196,0,0,2},{43657,8198,0,0,2},{43658,8200,0,0,2},
{43659,8202,0,0,2},{43660,8204,0,0,2},{43661,8206,0,0,2},{43662,8208,0,0,2},
{43663,8210,0,0,2},{43664,8212,0,0,2},{43665,8214,0,0,2},{43666,8216,0,0,2},
{43667,8218,0,0,2},{43668,8220,0,0,2},{43669,8222,0,0,2},{43670,8224,0,0,2},
{43671,8226,0,0,2},{43672,8228,0,0,2},{43673,8230,0,0,2},{43674,8232,0,0,2},
{43675,8234,0,0,2},{43676,8236,0,0,2},{43677,8238,0,0,2},{43678,8240,0,0,2},
{43679,8242,0,0,2},{43680,8244,0,0,2},{43681,8246,0,0,2},{43682,8248,0,0,2},
{43683,8250,0,0,2},{43684,8252,0,0,2},{43685,8254,0,0,2},{43686,8256,0,0,2},
{43687,8258,0,0,2},{43688,8260,0,0,2},{43689,8262,0,0,2},{43690,8264,0,0,2},
{43691,8266,0,0,2},{43692,8268,0,0,2},{43693,8270,0,0,2},{43694,8272,0,0,2},
{43695,8274,0,0,2},{43648,8276,0,0,2},{43649,8278,0,0,2},{43650,8280,0,0,2},
{43651,8282,0,0,2},{43652,8284,0,0,2},{43653,8286,0,0,2},{43654,8288,0,0,2},
{43655,8290,0,0,2},{43656,8292,0,0,2},{43657,8294,0,0,2},{43658,8296,0,0,2},
{43659,8298,0,0,2},{43660,8300,0,0,2},{43661,8302,0,0,2},{43662,8304,0,0,2},
{43663,8306,0,0,2},{43664,8308,0,0,2},{43665,8310,0,0,2},{43666,8312,0,0,2},
{43667,8314,0,0,2},{43668,8316,0,0,2},{43669,8318,0,0,2},{43670,8320,0,0,2},
{43671,8322,0,0,2},{43672,8324,0,0,2},{43673,8326,0,0,2},{43674,8328,0,0,2},
{43675,8330,0,0,2},{43676,8332,0,0,2},{43677,8334,0,0,2},{43678,8336,0,0,2},
{43679,8338,0,0,2},{43680,8340,0,0,2},{43681,8342,0,0,2},{43682,8344,0,0,2},
{43683,8346,0,0,2},{43684,8348,0,0,2},{43685,8350,0,0,2},{43686,8352,0,0,2},
{43687,8354,0,0,2},{43688,8356,0,0,2},{43689,8358,0,0,2},{43690,8360,0,0,2},
{43691,8362,0,0,2},{43692,8364,0,0,2},{43693,8366,0,0,2},{43694,8368,0,0,2},
{43695,8370,0,0,2},{43648,8372,0,0,2},{43649,8374,0,0,2},{43650,8376,0,0,2},
{43651,8378,0,0,2},{43652,8380,0,0,2},{43653,8382,0,0,2},{43654,8384,0,0,2},
{43655,8386,0,0,2},{43656,8388,0,0,2},{43657,8390,0,0,2},{43658,8392,0,0,2},
{43659,8394,0,0,2},{43660,8396,0,0,2},{43661,8398,0,0,2},{43662,8400,0,0,2},
{43663,8402,0,0,2},{43664,8404,0,0,2},{43665,8406,0,0,2},{43666,8408,0,0,2},
{43667,8410,0,0,2},{43668,8412,0,0,2},{43669,8414,0,0,2},{43670,8416,0,0,2},
{43671,8418,0,0,2},{43672,8420,0,0,2},{43673,8422,0,0,2},{43674,8424,0,0,2},
{43675,8426,0,0,2},{43676,8428,0,0,2},{43677,8430,0,0,2},{43678,8432,0,0,2},
{43679,8434,0,0,2},{43680,8436,0,0,2},{43681,8438,0,0,2},{43682,8440,0,0,2},
{43683,8442,0,0,2},{43684,8444,0,0,2},{43685,8446,0,0,2},{43686,8448,0,0,2},
{43687,8450,0,0,2},{43688,8452,0,0,2},{43689,8454,0,0,2},{43690,8456,0,0,2},
{43691,8458,0,0,2},{43692,8460,0,0,2},{43693,8462,0,0,2},{43694,8464,0,0,2},
{43695,8466,0,0,2},{119141,9849,0,0,2},{119141,9851,4699,5,2},{119150,9853,0,0,
3},{119151,9856,0,0,3},{119152,9859,0,0,3},{119153,9862,0,0,3},{119154,9865,0,0,
3},{119141,9868,4705,2,2},{119150,9870,0,0,3},{119151,9873,0,0,3},{119141,9876,
4708,2,2},{119150,9878,0,0,3},{119151,9881,0,0,3}};

struct collation_key special_collation_keys[10463] = {
{7870,8,0,32},{0,2,0,274},{7870,2,0,32},{0,2,0,274},{7557,30,0,32},{1615,30,1,
32},{7560,30,0,32},{7557,30,0,32},{1615,30,1,32},{7558,30,0,32},{7559,30,0,32},
{1615,30,1,32},{7560,30,0,32},{7566,8,0,32},{0,2,0,37},{7566,8,0,32},{0,2,0,36},
{7566,8,0,32},{0,2,0,39},{7566,8,0,32},{0,2,0,45},{7566,8,0,32},{0,2,0,43},
{7566,8,0,32},{0,2,0,41},{7566,10,0,32},{0,4,0,274},{7665,10,0,32},{7617,8,0,
32},{0,2,0,48},{7665,8,0,32},{0,2,0,37},{7665,8,0,32},{0,2,0,36},{7665,8,0,32},
{0,2,0,39},{7665,8,0,32},{0,2,0,43},{7801,8,0,32},{0,2,0,37},{7801,8,0,32},{0,2,
0,36},{7801,8,0,32},{0,2,0,39},{7801,8,0,32},{0,2,0,43},{7638,10,0,32},{0,4,0,
274},{7936,8,0,32},{0,2,0,45},{7972,8,0,32},{0,2,0,37},{7972,8,0,32},{0,2,0,36},
{7972,8,0,32},{0,2,0,39},{7972,8,0,32},{0,2,0,45},{7972,8,0,32},{0,2,0,43},
{7972,8,0,32},{0,2,0,47},{8189,8,0,32},{0,2,0,37},{8189,8,0,32},{0,2,0,36},
{8189,8,0,32},{0,2,0,39},{8189,8,0,32},{0,2,0,43},{8276,8,0,32},{0,2,0,36},
{8121,4,0,32},{0,4,0,274},{8121,4,0,32},{7566,2,0,32},{0,2,0,37},{7566,2,0,32},
{0,2,0,36},{7566,2,0,32},{0,2,0,39},{7566,2,0,32},{0,2,0,45},{7566,2,0,32},{0,2,
0,43},{7566,2,0,32},{0,2,0,41},{7566,4,0,32},{0,4,0,274},{7665,4,0,32},{7617,2,
0,32},{0,2,0,48},{7665,2,0,32},{0,2,0,37},{7665,2,0,32},{0,2,0,36},{7665,2,0,
32},{0,2,0,39},{7665,2,0,32},{0,2,0,43},{7801,2,0,32},{0,2,0,37},{7801,2,0,32},
{0,2,0,36},{7801,2,0,32},{0,2,0,39},{7801,2,0,32},{0,2,0,43},{7638,4,0,32},{0,4,
0,274},{7936,2,0,32},{0,2,0,45},{7972,2,0,32},{0,2,0,37},{7972,2,0,32},{0,2,0,
36},{7972,2,0,32},{0,2,0,39},{7972,2,0,32},{0,2,0,45},{7972,2,0,32},{0,2,0,43},
{7972,2,0,32},{0,2,0,47},{8189,2,0,32},{0,2,0,37},{8189,2,0,32},{0,2,0,36},
{8189,2,0,32},{0,2,0,39},{8189,2,0,32},{0,2,0,43},{8276,2,0,32},{0,2,0,36},
{8276,2,0,32},{0,2,0,43},{7566,8,0,32},{0,2,0,50},{7566,2,0,32},{0,2,0,50},
{7566,8,0,32},{0,2,0,38},{7566,2,0,32},{0,2,0,38},{7566,8,0,32},{0,2,0,49},
{7566,2,0,32},{0,2,0,49},{7617,8,0,32},{0,2,0,36},{7617,2,0,32},{0,2,0,36},
{7617,8,0,32},{0,2,0,39},{7617,2,0,32},{0,2,0,39},{7617,8,0,32},{0,2,0,46},
{7617,2,0,32},{0,2,0,46},{7617,8,0,32},{0,2,0,40},{7617,2,0,32},{0,2,0,40},
{7638,8,0,32},{0,2,0,40},{7638,2,0,32},{0,2,0,40},{7638,8,0,32},{0,2,0,57},
{7638,2,0,32},{0,2,0,57},{7665,8,0,32},{0,2,0,50},{7665,2,0,32},{0,2,0,50},
{7665,8,0,32},{0,2,0,38},{7665,2,0,32},{0,2,0,38},{7665,8,0,32},{0,2,0,46},
{7665,2,0,32},{0,2,0,46},{7665,8,0,32},{0,2,0,49},{7665,2,0,32},{0,2,0,49},
{7665,8,0,32},{0,2,0,40},{7665,2,0,32},{0,2,0,40},{7739,8,0,32},{0,2,0,39},
{7739,2,0,32},{0,2,0,39},{7739,8,0,32},{0,2,0,38},{7739,2,0,32},{0,2,0,38},
{7739,8,0,32},{0,2,0,46},{7739,2,0,32},{0,2,0,46},{7739,8,0,32},{0,2,0,48},
{7739,2,0,32},{0,2,0,48},{7775,8,0,32},{0,2,0,39},{7775,2,0,32},{0,2,0,39},
{7775,8,0,32},{0,2,0,57},{7775,2,0,32},{0,2,0,57},{7801,8,0,32},{0,2,0,45},
{7801,2,0,32},{0,2,0,45},{7801,8,0,32},{0,2,0,50},{7801,2,0,32},{0,2,0,50},
{7801,8,0,32},{0,2,0,38},{7801,2,0,32},{0,2,0,38},{7801,8,0,32},{0,2,0,49},
{7801,2,0,32},{0,2,0,49},{7801,8,0,32},{0,2,0,46},{7801,10,0,32},{7827,10,0,32},
{7801,4,0,32},{7827,4,0,32},{7827,8,0,32},{0,2,0,39},{7827,2,0,32},{0,2,0,39},
{7852,8,0,32},{0,2,0,48},{7852,2,0,32},{0,2,0,48},{7870,8,0,32},{0,2,0,36},
{7870,2,0,32},{0,2,0,36},{7870,8,0,32},{0,2,0,48},{7870,2,0,32},{0,2,0,48},
{7870,8,0,32},{0,2,0,40},{7870,2,0,32},{0,2,0,40},{7870,8,0,32},{0,2,0,274},
{7870,2,0,32},{0,2,0,274},{7870,8,0,32},{0,2,0,57},{7870,2,0,32},{0,2,0,57},
{7936,8,0,32},{0,2,0,36},{7936,2,0,32},{0,2,0,36},{7936,8,0,32},{0,2,0,48},
{7936,2,0,32},{0,2,0,48},{7936,8,0,32},{0,2,0,40},{7936,2,0,32},{0,2,0,40},
{8391,4,0,32},{7936,4,0,32},{7972,8,0,32},{0,2,0,50},{7972,2,0,32},{0,2,0,50},
{7972,8,0,32},{0,2,0,38},{7972,2,0,32},{0,2,0,38},{7972,8,0,32},{0,2,0,44},
{7972,2,0,32},{0,2,0,44},{7972,10,0,32},{0,4,0,274},{7665,10,0,32},{7972,4,0,
32},{0,4,0,274},{7665,4,0,32},{8059,8,0,32},{0,2,0,36},{8059,2,0,32},{0,2,0,36},
{8059,8,0,32},{0,2,0,48},{8059,2,0,32},{0,2,0,48},{8059,8,0,32},{0,2,0,40},
{8059,2,0,32},{0,2,0,40},{8121,8,0,32},{0,2,0,36},{8121,2,0,32},{0,2,0,36},
{8121,8,0,32},{0,2,0,39},{8121,2,0,32},{0,2,0,39},{8121,8,0,32},{0,2,0,48},
{8121,2,0,32},{0,2,0,48},{8121,8,0,32},{0,2,0,40},{8121,2,0,32},{0,2,0,40},
{8157,8,0,32},{0,2,0,48},{8157,2,0,32},{0,2,0,48},{8157,8,0,32},{0,2,0,40},
{8157,2,0,32},{0,2,0,40},{8189,8,0,32},{0,2,0,45},{8189,2,0,32},{0,2,0,45},
{8189,8,0,32},{0,2,0,50},{8189,2,0,32},{0,2,0,50},{8189,8,0,32},{0,2,0,38},
{8189,2,0,32},{0,2,0,38},{8189,8,0,32},{0,2,0,41},{8189,2,0,32},{0,2,0,41},
{8189,8,0,32},{0,2,0,44},{8189,2,0,32},{0,2,0,44},{8189,8,0,32},{0,2,0,49},
{8189,2,0,32},{0,2,0,49},{8254,8,0,32},{0,2,0,39},{8254,2,0,32},{0,2,0,39},
{8276,8,0,32},{0,2,0,39},{8276,2,0,32},{0,2,0,39},{8276,8,0,32},{0,2,0,43},
{8298,8,0,32},{0,2,0,36},{8298,2,0,32},{0,2,0,36},{8298,8,0,32},{0,2,0,46},
{8298,2,0,32},{0,2,0,46},{8298,8,0,32},{0,2,0,40},{8298,2,0,32},{0,2,0,40},
{8121,4,0,32},{0,4,0,275},{8298,4,0,32},{8254,4,0,32},{7972,8,0,32},{0,2,0,63},
{7972,2,0,32},{0,2,0,63},{8189,8,0,32},{0,2,0,63},{8189,2,0,32},{0,2,0,63},
{8157,4,0,32},{8121,4,0,32},{7638,10,0,32},{8298,10,0,32},{0,4,0,40},{7638,10,0,
32},{8298,4,0,32},{0,4,0,40},{7638,4,0,32},{8298,4,0,32},{0,4,0,40},{7870,10,0,
32},{7827,10,0,32},{7870,10,0,32},{7827,4,0,32},{7870,4,0,32},{7827,4,0,32},
{7936,10,0,32},{7827,10,0,32},{7936,10,0,32},{7827,4,0,32},{7936,4,0,32},{7827,
4,0,32},{7566,8,0,32},{0,2,0,40},{7566,2,0,32},{0,2,0,40},{7801,8,0,32},{0,2,0,
40},{7801,2,0,32},{0,2,0,40},{7972,8,0,32},{0,2,0,40},{7972,2,0,32},{0,2,0,40},
{8189,8,0,32},{0,2,0,40},{8189,2,0,32},{0,2,0,40},{8189,8,0,32},{0,2,0,43},{0,2,
0,50},{8189,2,0,32},{0,2,0,43},{0,2,0,50},{8189,8,0,32},{0,2,0,43},{0,2,0,36},
{8189,2,0,32},{0,2,0,43},{0,2,0,36},{8189,8,0,32},{0,2,0,43},{0,2,0,40},{8189,2,
0,32},{0,2,0,43},{0,2,0,40},{8189,8,0,32},{0,2,0,43},{0,2,0,37},{8189,2,0,32},
{0,2,0,43},{0,2,0,37},{7566,8,0,32},{0,2,0,43},{0,2,0,50},{7566,2,0,32},{0,2,0,
43},{0,2,0,50},{7566,8,0,32},{0,2,0,46},{0,2,0,50},{7566,2,0,32},{0,2,0,46},{0,
2,0,50},{7566,10,0,32},{0,4,0,274},{7665,10,0,32},{0,2,0,50},{7566,4,0,32},{0,4,
0,274},{7665,4,0,32},{0,2,0,50},{7739,8,0,32},{0,2,0,40},{7739,2,0,32},{0,2,0,
40},{7852,8,0,32},{0,2,0,40},{7852,2,0,32},{0,2,0,40},{7972,8,0,32},{0,2,0,49},
{7972,2,0,32},{0,2,0,49},{7972,8,0,32},{0,2,0,49},{0,2,0,50},{7972,2,0,32},{0,2,
0,49},{0,2,0,50},{8327,8,0,32},{0,2,0,40},{8327,2,0,32},{0,2,0,40},{7827,2,0,
32},{0,2,0,40},{7638,10,0,32},{8298,10,0,32},{7638,10,0,32},{8298,4,0,32},{7638,
4,0,32},{8298,4,0,32},{7739,8,0,32},{0,2,0,36},{7739,2,0,32},{0,2,0,36},{7936,8,
0,32},{0,2,0,37},{7936,2,0,32},{0,2,0,37},{7566,8,0,32},{0,2,0,41},{0,2,0,36},
{7566,2,0,32},{0,2,0,41},{0,2,0,36},{7566,10,0,32},{0,4,0,274},{7665,10,0,32},
{0,2,0,36},{7566,4,0,32},{0,4,0,274},{7665,4,0,32},{0,2,0,36},{7972,8,0,32},{0,
2,0,47},{0,2,0,36},{7972,2,0,32},{0,2,0,47},{0,2,0,36},{7566,8,0,32},{0,2,0,60},
{7566,2,0,32},{0,2,0,60},{7566,8,0,32},{0,2,0,62},{7566,2,0,32},{0,2,0,62},
{7665,8,0,32},{0,2,0,60},{7665,2,0,32},{0,2,0,60},{7665,8,0,32},{0,2,0,62},
{7665,2,0,32},{0,2,0,62},{7801,8,0,32},{0,2,0,60},{7801,2,0,32},{0,2,0,60},
{7801,8,0,32},{0,2,0,62},{7801,2,0,32},{0,2,0,62},{7972,8,0,32},{0,2,0,60},
{7972,2,0,32},{0,2,0,60},{7972,8,0,32},{0,2,0,62},{7972,2,0,32},{0,2,0,62},
{8059,8,0,32},{0,2,0,60},{8059,2,0,32},{0,2,0,60},{8059,8,0,32},{0,2,0,62},
{8059,2,0,32},{0,2,0,62},{8189,8,0,32},{0,2,0,60},{8189,2,0,32},{0,2,0,60},
{8189,8,0,32},{0,2,0,62},{8189,2,0,32},{0,2,0,62},{8121,8,0,32},{0,2,0,69},
{8121,2,0,32},{0,2,0,69},{8157,8,0,32},{0,2,0,69},{8157,2,0,32},{0,2,0,69},
{7775,8,0,32},{0,2,0,40},{7775,2,0,32},{0,2,0,40},{7566,8,0,32},{0,2,0,46},
{7566,2,0,32},{0,2,0,46},{7665,8,0,32},{0,2,0,48},{7665,2,0,32},{0,2,0,48},
{7972,8,0,32},{0,2,0,43},{0,2,0,50},{7972,2,0,32},{0,2,0,43},{0,2,0,50},{7972,8,
0,32},{0,2,0,45},{0,2,0,50},{7972,2,0,32},{0,2,0,45},{0,2,0,50},{7972,8,0,32},
{0,2,0,46},{7972,2,0,32},{0,2,0,46},{7972,8,0,32},{0,2,0,46},{0,2,0,50},{7972,2,
0,32},{0,2,0,46},{0,2,0,50},{8276,8,0,32},{0,2,0,50},{8276,2,0,32},{0,2,0,50},
{7638,4,0,32},{7591,4,0,32},{8040,4,0,32},{8019,4,0,32},{7638,4,0,32},{8298,4,0,
32},{7638,4,0,32},{8327,4,0,32},{7638,4,0,32},{8317,4,0,32},{8157,4,0,32},{8121,
4,0,32},{8157,4,0,32},{8138,4,0,32},{8157,4,0,32},{7632,4,0,32},{7724,4,0,32},
{7967,4,0,32},{7870,4,0,32},{8121,4,0,32},{7870,4,0,32},{8298,4,0,32},{0,2,0,
43},{0,2,0,36},{1201,2,1,32},{0,2,0,36},{8450,8,0,32},{0,2,0,36},{8455,8,0,32},
{0,2,0,36},{8461,8,0,32},{0,2,0,36},{8463,8,0,32},{0,2,0,36},{8471,8,0,32},{0,2,
0,36},{8485,8,0,32},{0,2,0,36},{8490,8,0,32},{0,2,0,36},{8463,2,0,32},{0,2,0,
43},{0,2,0,36},{8463,8,0,32},{0,2,0,43},{8485,8,0,32},{0,2,0,43},{8450,2,0,32},
{0,2,0,36},{8455,2,0,32},{0,2,0,36},{8461,2,0,32},{0,2,0,36},{8463,2,0,32},{0,2,
0,36},{8485,2,0,32},{0,2,0,43},{0,2,0,36},{8463,2,0,32},{0,2,0,43},{8485,2,0,
32},{0,2,0,43},{8471,2,0,32},{0,2,0,36},{8485,2,0,32},{0,2,0,36},{8490,2,0,32},
{0,2,0,36},{8465,10,0,32},{8450,4,0,32},{8463,4,0,32},{8485,10,0,32},{0,2,0,36},
{8485,10,0,32},{0,2,0,43},{8465,4,0,32},{8450,4,0,32},{8463,4,0,32},{8611,8,0,
32},{0,2,0,37},{8611,8,0,32},{0,2,0,43},{8575,8,0,32},{0,2,0,36},{8657,8,0,32},
{0,2,0,43},{8671,8,0,32},{0,2,0,36},{8649,8,0,32},{0,2,0,37},{8806,8,0,32},{0,2,
0,38},{8611,2,0,32},{0,2,0,37},{8611,2,0,32},{0,2,0,43},{8575,2,0,32},{0,2,0,
36},{8657,2,0,32},{0,2,0,43},{8671,2,0,32},{0,2,0,36},{8649,2,0,32},{0,2,0,37},
{8806,2,0,32},{0,2,0,38},{8992,8,0,32},{0,2,0,60},{8992,2,0,32},{0,2,0,60},
{8575,10,0,32},{0,4,0,275},{8575,4,0,32},{0,4,0,275},{8619,8,0,32},{0,2,0,38},
{8619,2,0,32},{0,2,0,38},{8555,8,0,32},{0,2,0,38},{8555,2,0,32},{0,2,0,38},
{8555,8,0,32},{0,2,0,43},{8555,2,0,32},{0,2,0,43},{8611,8,0,32},{0,2,0,38},
{8611,2,0,32},{0,2,0,38},{8559,8,0,32},{0,2,0,43},{8559,2,0,32},{0,2,0,43},
{8619,8,0,32},{0,2,0,43},{8619,2,0,32},{0,2,0,43},{8629,8,0,32},{0,2,0,43},
{8629,2,0,32},{0,2,0,43},{8649,8,0,32},{0,2,0,50},{8649,2,0,32},{0,2,0,50},
{8649,8,0,32},{0,2,0,43},{8649,2,0,32},{0,2,0,43},{8752,8,0,32},{0,2,0,43},
{8752,2,0,32},{0,2,0,43},{8756,8,0,32},{0,2,0,43},{8756,2,0,32},{0,2,0,43},
{8942,8,0,32},{0,2,0,43},{8942,2,0,32},{0,2,0,43},{8806,8,0,32},{0,2,0,50},
{8806,2,0,32},{0,2,0,50},{8806,8,0,32},{0,2,0,43},{8806,2,0,32},{0,2,0,43},
{8806,8,0,32},{0,2,0,44},{8806,2,0,32},{0,2,0,44},{8877,8,0,32},{0,2,0,43},
{8877,2,0,32},{0,2,0,43},{8925,8,0,32},{0,2,0,43},{8925,2,0,32},{0,2,0,43},
{9182,4,0,32},{9212,4,0,32},{9218,2,0,32},{0,2,0,89},{9218,2,0,32},{0,2,0,90},
{9218,2,0,32},{0,2,0,95},{9219,2,0,32},{0,2,0,95},{9219,2,0,32},{0,2,0,96},
{9220,2,0,32},{0,2,0,95},{9221,2,0,32},{0,2,0,95},{9222,2,0,32},{0,2,0,95},
{9223,2,0,32},{0,2,0,91},{9223,2,0,32},{0,2,0,95},{9224,2,0,32},{0,2,0,95},
{9226,2,0,32},{0,2,0,95},{9227,2,0,32},{0,2,0,86},{9227,2,0,32},{0,2,0,95},
{9228,25,0,32},{0,2,0,95},{9228,2,0,32},{0,2,0,95},{9228,2,0,32},{0,2,0,96},
{9229,2,0,32},{0,2,0,95},{9230,2,0,32},{0,2,0,95},{9231,2,0,32},{0,2,0,95},
{9232,2,0,32},{0,2,0,95},{9234,25,0,32},{0,2,0,95},{9234,2,0,32},{0,2,0,95},
{9234,2,0,32},{0,2,0,96},{9235,2,0,32},{0,2,0,95},{9236,2,0,32},{0,2,0,95},
{9237,2,0,32},{0,2,0,95},{9238,2,0,32},{0,2,0,95},{9238,2,0,32},{0,2,0,95},{0,2,
0,94},{9238,2,0,32},{0,2,0,95},{0,2,0,93},{9238,2,0,32},{0,2,0,94},{9238,2,0,
32},{0,2,0,93},{9239,2,0,32},{0,2,0,95},{9227,4,0,32},{9222,4,0,32},{9223,4,0,
32},{9222,4,0,32},{9223,4,0,32},{9223,4,0,32},{9223,4,0,32},{9227,4,0,32},{9227,
4,0,32},{9227,4,0,32},{9227,4,0,32},{9227,4,0,32},{0,2,0,89},{9302,4,0,32},
{9288,4,0,32},{9474,4,0,32},{9288,4,0,32},{9478,4,0,32},{9288,4,0,32},{9489,4,0,
32},{9288,4,0,32},{9473,2,0,32},{0,2,0,131},{9470,2,0,32},{0,2,0,131},{9503,2,0,
32},{0,2,0,131},{9288,4,0,32},{0,4,0,275},{9454,4,0,32},{0,4,0,275},{9508,4,0,
32},{0,4,0,275},{9516,4,0,32},{0,4,0,275},{9526,4,0,32},{0,4,0,275},{9507,4,0,
32},{0,4,0,276},{9508,4,0,32},{0,4,0,276},{9510,4,0,32},{0,4,0,276},{9631,4,0,
32},{0,4,0,274},{9632,4,0,32},{0,4,0,274},{9634,4,0,32},{0,4,0,274},{10189,2,0,
32},{0,2,0,194},{10190,2,0,32},{0,2,0,194},{10191,2,0,32},{0,2,0,194},{10197,2,
0,32},{0,2,0,194},{10205,2,0,32},{0,2,0,194},{10207,2,0,32},{0,2,0,194},{10213,
2,0,32},{0,2,0,194},{10215,2,0,32},{0,2,0,194},{10220,2,0,32},{0,2,0,194},
{10222,2,0,32},{0,2,0,194},{10224,2,0,32},{0,2,0,194},{10290,2,0,32},{0,2,0,
194},{10291,2,0,32},{0,2,0,194},{10303,2,0,32},{0,2,0,194},{10293,4,0,32},
{10326,4,0,32},{10346,2,0,32},{0,2,0,194},{10347,2,0,32},{0,2,0,194},{10352,2,0,
32},{0,2,0,194},{10366,2,0,32},{0,2,0,194},{10373,2,0,32},{0,2,0,194},{10342,2,
0,32},{0,2,0,194},{10481,2,0,32},{0,2,0,194},{10482,2,0,32},{0,2,0,194},{10764,
4,0,32},{10792,4,0,32},{10762,4,0,32},{10792,4,0,32},{10763,4,0,32},{10792,4,0,
32},{10772,4,0,32},{10792,4,0,32},{10751,4,0,32},{10792,4,0,32},{10756,4,0,32},
{10792,4,0,32},{10764,4,0,32},{10792,4,0,32},{10765,4,0,32},{10792,4,0,32},
{10771,4,0,32},{10792,4,0,32},{10737,4,0,32},{10792,4,0,32},{12148,2,0,32},
{12206,2,0,32},{12149,2,0,32},{12206,2,0,32},{12150,2,0,32},{12206,2,0,32},
{12151,2,0,32},{12206,2,0,32},{12152,2,0,32},{12206,2,0,32},{12153,2,0,32},
{12206,2,0,32},{12154,2,0,32},{12206,2,0,32},{12155,2,0,32},{12206,2,0,32},
{12156,2,0,32},{12206,2,0,32},{12157,2,0,32},{12206,2,0,32},{12158,2,0,32},
{12206,2,0,32},{12159,2,0,32},{12206,2,0,32},{12160,2,0,32},{12206,2,0,32},
{12161,2,0,32},{12206,2,0,32},{12162,2,0,32},{12206,2,0,32},{12163,2,0,32},
{12206,2,0,32},{12164,2,0,32},{12206,2,0,32},{12165,2,0,32},{12206,2,0,32},
{12166,2,0,32},{12206,2,0,32},{12167,2,0,32},{12206,2,0,32},{12168,2,0,32},
{12206,2,0,32},{12169,2,0,32},{12206,2,0,32},{12170,2,0,32},{12206,2,0,32},
{12171,2,0,32},{12206,2,0,32},{12172,2,0,32},{12206,2,0,32},{12173,2,0,32},
{12206,2,0,32},{12174,2,0,32},{12206,2,0,32},{12175,2,0,32},{12206,2,0,32},
{12176,2,0,32},{12206,2,0,32},{12177,2,0,32},{12206,2,0,32},{12178,2,0,32},
{12206,2,0,32},{12179,2,0,32},{12206,2,0,32},{12180,2,0,32},{12206,2,0,32},
{12181,2,0,32},{12206,2,0,32},{12182,2,0,32},{12206,2,0,32},{12183,2,0,32},
{12206,2,0,32},{12184,2,0,32},{12206,2,0,32},{12185,2,0,32},{12206,2,0,32},
{12186,2,0,32},{12206,2,0,32},{12187,2,0,32},{12206,2,0,32},{12188,2,0,32},
{12206,2,0,32},{12189,2,0,32},{12206,2,0,32},{12190,2,0,32},{12206,2,0,32},
{12191,2,0,32},{12206,2,0,32},{12192,2,0,32},{12206,2,0,32},{12193,2,0,32},
{12206,2,0,32},{12148,2,0,32},{12207,2,0,32},{12149,2,0,32},{12207,2,0,32},
{12150,2,0,32},{12207,2,0,32},{12151,2,0,32},{12207,2,0,32},{12152,2,0,32},
{12207,2,0,32},{12153,2,0,32},{12207,2,0,32},{12154,2,0,32},{12207,2,0,32},
{12155,2,0,32},{12207,2,0,32},{12156,2,0,32},{12207,2,0,32},{12157,2,0,32},
{12207,2,0,32},{12158,2,0,32},{12207,2,0,32},{12159,2,0,32},{12207,2,0,32},
{12160,2,0,32},{12207,2,0,32},{12161,2,0,32},{12207,2,0,32},{12162,2,0,32},
{12207,2,0,32},{12163,2,0,32},{12207,2,0,32},{12164,2,0,32},{12207,2,0,32},
{12165,2,0,32},{12207,2,0,32},{12166,2,0,32},{12207,2,0,32},{12167,2,0,32},
{12207,2,0,32},{12168,2,0,32},{12207,2,0,32},{12169,2,0,32},{12207,2,0,32},
{12170,2,0,32},{12207,2,0,32},{12171,2,0,32},{12207,2,0,32},{12172,2,0,32},
{12207,2,0,32},{12173,2,0,32},{12207,2,0,32},{12174,2,0,32},{12207,2,0,32},
{12175,2,0,32},{12207,2,0,32},{12176,2,0,32},{12207,2,0,32},{12177,2,0,32},
{12207,2,0,32},{12178,2,0,32},{12207,2,0,32},{12179,2,0,32},{12207,2,0,32},
{12180,2,0,32},{12207,2,0,32},{12181,2,0,32},{12207,2,0,32},{12182,2,0,32},
{12207,2,0,32},{12183,2,0,32},{12207,2,0,32},{12184,2,0,32},{12207,2,0,32},
{12185,2,0,32},{12207,2,0,32},{12186,2,0,32},{12207,2,0,32},{12187,2,0,32},
{12207,2,0,32},{12188,2,0,32},{12207,2,0,32},{12189,2,0,32},{12207,2,0,32},
{12190,2,0,32},{12207,2,0,32},{12191,2,0,32},{12207,2,0,32},{12192,2,0,32},
{12207,2,0,32},{12193,2,0,32},{12207,2,0,32},{12148,2,0,32},{12208,2,0,32},
{12149,2,0,32},{12208,2,0,32},{12150,2,0,32},{12208,2,0,32},{12151,2,0,32},
{12208,2,0,32},{12152,2,0,32},{12208,2,0,32},{12153,2,0,32},{12208,2,0,32},
{12154,2,0,32},{12208,2,0,32},{12155,2,0,32},{12208,2,0,32},{12156,2,0,32},
{12208,2,0,32},{12157,2,0,32},{12208,2,0,32},{12158,2,0,32},{12208,2,0,32},
{12159,2,0,32},{12208,2,0,32},{12160,2,0,32},{12208,2,0,32},{12161,2,0,32},
{12208,2,0,32},{12162,2,0,32},{12208,2,0,32},{12163,2,0,32},{12208,2,0,32},
{12164,2,0,32},{12208,2,0,32},{12165,2,0,32},{12208,2,0,32},{12166,2,0,32},
{12208,2,0,32},{12167,2,0,32},{12208,2,0,32},{12168,2,0,32},{12208,2,0,32},
{12169,2,0,32},{12208,2,0,32},{12170,2,0,32},{12208,2,0,32},{12171,2,0,32},
{12208,2,0,32},{12172,2,0,32},{12208,2,0,32},{12173,2,0,32},{12208,2,0,32},
{12174,2,0,32},{12208,2,0,32},{12175,2,0,32},{12208,2,0,32},{12176,2,0,32},
{12208,2,0,32},{12177,2,0,32},{12208,2,0,32},{12178,2,0,32},{12208,2,0,32},
{12179,2,0,32},{12208,2,0,32},{12180,2,0,32},{12208,2,0,32},{12181,2,0,32},
{12208,2,0,32},{12182,2,0,32},{12208,2,0,32},{12183,2,0,32},{12208,2,0,32},
{12184,2,0,32},{12208,2,0,32},{12185,2,0,32},{12208,2,0,32},{12186,2,0,32},
{12208,2,0,32},{12187,2,0,32},{12208,2,0,32},{12188,2,0,32},{12208,2,0,32},
{12189,2,0,32},{12208,2,0,32},{12190,2,0,32},{12208,2,0,32},{12191,2,0,32},
{12208,2,0,32},{12192,2,0,32},{12208,2,0,32},{12193,2,0,32},{12208,2,0,32},
{12148,2,0,32},{12209,2,0,32},{12149,2,0,32},{12209,2,0,32},{12150,2,0,32},
{12209,2,0,32},{12151,2,0,32},{12209,2,0,32},{12152,2,0,32},{12209,2,0,32},
{12153,2,0,32},{12209,2,0,32},{12154,2,0,32},{12209,2,0,32},{12155,2,0,32},
{12209,2,0,32},{12156,2,0,32},{12209,2,0,32},{12157,2,0,32},{12209,2,0,32},
{12158,2,0,32},{12209,2,0,32},{12159,2,0,32},{12209,2,0,32},{12160,2,0,32},
{12209,2,0,32},{12161,2,0,32},{12209,2,0,32},{12162,2,0,32},{12209,2,0,32},
{12163,2,0,32},{12209,2,0,32},{12164,2,0,32},{12209,2,0,32},{12165,2,0,32},
{12209,2,0,32},{12166,2,0,32},{12209,2,0,32},{12167,2,0,32},{12209,2,0,32},
{12168,2,0,32},{12209,2,0,32},{12169,2,0,32},{12209,2,0,32},{12170,2,0,32},
{12209,2,0,32},{12171,2,0,32},{12209,2,0,32},{12172,2,0,32},{12209,2,0,32},
{12173,2,0,32},{12209,2,0,32},{12174,2,0,32},{12209,2,0,32},{12175,2,0,32},
{12209,2,0,32},{12176,2,0,32},{12209,2,0,32},{12177,2,0,32},{12209,2,0,32},
{12178,2,0,32},{12209,2,0,32},{12179,2,0,32},{12209,2,0,32},{12180,2,0,32},
{12209,2,0,32},{12181,2,0,32},{12209,2,0,32},{12182,2,0,32},{12209,2,0,32},
{12183,2,0,32},{12209,2,0,32},{12184,2,0,32},{12209,2,0,32},{12185,2,0,32},
{12209,2,0,32},{12186,2,0,32},{12209,2,0,32},{12187,2,0,32},{12209,2,0,32},
{12188,2,0,32},{12209,2,0,32},{12189,2,0,32},{12209,2,0,32},{12190,2,0,32},
{12209,2,0,32},{12191,2,0,32},{12209,2,0,32},{12192,2,0,32},{12209,2,0,32},
{12193,2,0,32},{12209,2,0,32},{12148,2,0,32},{12210,2,0,32},{12149,2,0,32},
{12210,2,0,32},{12150,2,0,32},{12210,2,0,32},{12151,2,0,32},{12210,2,0,32},
{12152,2,0,32},{12210,2,0,32},{12153,2,0,32},{12210,2,0,32},{12154,2,0,32},
{12210,2,0,32},{12155,2,0,32},{12210,2,0,32},{12156,2,0,32},{12210,2,0,32},
{12157,2,0,32},{12210,2,0,32},{12158,2,0,32},{12210,2,0,32},{12159,2,0,32},
{12210,2,0,32},{12160,2,0,32},{12210,2,0,32},{12161,2,0,32},{12210,2,0,32},
{12162,2,0,32},{12210,2,0,32},{12163,2,0,32},{12210,2,0,32},{12164,2,0,32},
{12210,2,0,32},{12165,2,0,32},{12210,2,0,32},{12166,2,0,32},{12210,2,0,32},
{12167,2,0,32},{12210,2,0,32},{12168,2,0,32},{12210,2,0,32},{12169,2,0,32},
{12210,2,0,32},{12170,2,0,32},{12210,2,0,32},{12171,2,0,32},{12210,2,0,32},
{12172,2,0,32},{12210,2,0,32},{12173,2,0,32},{12210,2,0,32},{12174,2,0,32},
{12210,2,0,32},{12175,2,0,32},{12210,2,0,32},{12176,2,0,32},{12210,2,0,32},
{12177,2,0,32},{12210,2,0,32},{12178,2,0,32},{12210,2,0,32},{12179,2,0,32},
{12210,2,0,32},{12180,2,0,32},{12210,2,0,32},{12181,2,0,32},{12210,2,0,32},
{12182,2,0,32},{12210,2,0,32},{12183,2,0,32},{12210,2,0,32},{12184,2,0,32},
{12210,2,0,32},{12185,2,0,32},{12210,2,0,32},{12186,2,0,32},{12210,2,0,32},
{12187,2,0,32},{12210,2,0,32},{12188,2,0,32},{12210,2,0,32},{12189,2,0,32},
{12210,2,0,32},{12190,2,0,32},{12210,2,0,32},{12191,2,0,32},{12210,2,0,32},
{12192,2,0,32},{12210,2,0,32},{12193,2,0,32},{12210,2,0,32},{12198,2,0,32},
{12213,2,0,32},{12255,2,0,32},{12214,2,0,32},{12255,2,0,32},{12215,2,0,32},
{12255,2,0,32},{12216,2,0,32},{12255,2,0,32},{12217,2,0,32},{12255,2,0,32},
{12219,2,0,32},{12255,2,0,32},{12221,2,0,32},{12255,2,0,32},{12222,2,0,32},
{12255,2,0,32},{12223,2,0,32},{12255,2,0,32},{12224,2,0,32},{12255,2,0,32},
{12225,2,0,32},{12255,2,0,32},{12226,2,0,32},{12255,2,0,32},{12227,2,0,32},
{12255,2,0,32},{12228,2,0,32},{12255,2,0,32},{12229,2,0,32},{12255,2,0,32},
{12230,2,0,32},{12255,2,0,32},{12231,2,0,32},{12255,2,0,32},{12232,2,0,32},
{12255,2,0,32},{12233,2,0,32},{12255,2,0,32},{12234,2,0,32},{12255,2,0,32},
{12235,2,0,32},{12255,2,0,32},{12236,2,0,32},{12255,2,0,32},{12237,2,0,32},
{12255,2,0,32},{12218,2,0,32},{12255,2,0,32},{12238,2,0,32},{12255,2,0,32},
{12239,2,0,32},{12255,2,0,32},{12240,2,0,32},{12255,2,0,32},{12238,4,0,32},
{12226,4,0,32},{12255,2,0,32},{12238,4,0,32},{12233,4,0,32},{12255,2,0,32},
{12212,2,0,32},{12255,2,0,32},{12220,2,0,32},{12255,2,0,32},{12213,2,0,32},
{12256,2,0,32},{12214,2,0,32},{12256,2,0,32},{12215,2,0,32},{12256,2,0,32},
{12216,2,0,32},{12256,2,0,32},{12217,2,0,32},{12256,2,0,32},{12219,2,0,32},
{12256,2,0,32},{12221,2,0,32},{12256,2,0,32},{12222,2,0,32},{12256,2,0,32},
{12223,2,0,32},{12256,2,0,32},{12224,2,0,32},{12256,2,0,32},{12225,2,0,32},
{12256,2,0,32},{12226,2,0,32},{12256,2,0,32},{12227,2,0,32},{12256,2,0,32},
{12228,2,0,32},{12256,2,0,32},{12229,2,0,32},{12256,2,0,32},{12230,2,0,32},
{12256,2,0,32},{12231,2,0,32},{12256,2,0,32},{12232,2,0,32},{12256,2,0,32},
{12233,2,0,32},{12256,2,0,32},{12234,2,0,32},{12256,2,0,32},{12235,2,0,32},
{12256,2,0,32},{12236,2,0,32},{12256,2,0,32},{12237,2,0,32},{12256,2,0,32},
{12218,2,0,32},{12256,2,0,32},{12238,2,0,32},{12256,2,0,32},{12239,2,0,32},
{12256,2,0,32},{12240,2,0,32},{12256,2,0,32},{12238,4,0,32},{12226,4,0,32},
{12256,2,0,32},{12238,4,0,32},{12233,4,0,32},{12256,2,0,32},{12212,2,0,32},
{12256,2,0,32},{12220,2,0,32},{12256,2,0,32},{12213,2,0,32},{12257,2,0,32},
{12214,2,0,32},{12257,2,0,32},{12215,2,0,32},{12257,2,0,32},{12216,2,0,32},
{12257,2,0,32},{12217,2,0,32},{12257,2,0,32},{12219,2,0,32},{12257,2,0,32},
{12221,2,0,32},{12257,2,0,32},{12222,2,0,32},{12257,2,0,32},{12223,2,0,32},
{12257,2,0,32},{12224,2,0,32},{12257,2,0,32},{12225,2,0,32},{12257,2,0,32},
{12226,2,0,32},{12257,2,0,32},{12227,2,0,32},{12257,2,0,32},{12228,2,0,32},
{12257,2,0,32},{12229,2,0,32},{12257,2,0,32},{12230,2,0,32},{12257,2,0,32},
{12231,2,0,32},{12257,2,0,32},{12232,2,0,32},{12257,2,0,32},{12233,2,0,32},
{12257,2,0,32},{12234,2,0,32},{12257,2,0,32},{12235,2,0,32},{12257,2,0,32},
{12236,2,0,32},{12257,2,0,32},{12237,2,0,32},{12257,2,0,32},{12218,2,0,32},
{12257,2,0,32},{12238,2,0,32},{12257,2,0,32},{12239,2,0,32},{12257,2,0,32},
{12240,2,0,32},{12257,2,0,32},{12238,4,0,32},{12226,4,0,32},{12257,2,0,32},
{12238,4,0,32},{12233,4,0,32},{12257,2,0,32},{12212,2,0,32},{12257,2,0,32},
{12220,2,0,32},{12257,2,0,32},{12213,2,0,32},{12258,2,0,32},{12214,2,0,32},
{12258,2,0,32},{12215,2,0,32},{12258,2,0,32},{12216,2,0,32},{12258,2,0,32},
{12217,2,0,32},{12258,2,0,32},{12219,2,0,32},{12258,2,0,32},{12221,2,0,32},
{12258,2,0,32},{12222,2,0,32},{12258,2,0,32},{12223,2,0,32},{12258,2,0,32},
{12224,2,0,32},{12258,2,0,32},{12225,2,0,32},{12258,2,0,32},{12226,2,0,32},
{12258,2,0,32},{12227,2,0,32},{12258,2,0,32},{12228,2,0,32},{12258,2,0,32},
{12229,2,0,32},{12258,2,0,32},{12230,2,0,32},{12258,2,0,32},{12231,2,0,32},
{12258,2,0,32},{12232,2,0,32},{12258,2,0,32},{12233,2,0,32},{12258,2,0,32},
{12234,2,0,32},{12258,2,0,32},{12235,2,0,32},{12258,2,0,32},{12236,2,0,32},
{12258,2,0,32},{12237,2,0,32},{12258,2,0,32},{12218,2,0,32},{12258,2,0,32},
{12238,2,0,32},{12258,2,0,32},{12239,2,0,32},{12258,2,0,32},{12240,2,0,32},
{12258,2,0,32},{12238,4,0,32},{12226,4,0,32},{12258,2,0,32},{12238,4,0,32},
{12233,4,0,32},{12258,2,0,32},{12212,2,0,32},{12258,2,0,32},{12220,2,0,32},
{12258,2,0,32},{12213,2,0,32},{12259,2,0,32},{12214,2,0,32},{12259,2,0,32},
{12215,2,0,32},{12259,2,0,32},{12216,2,0,32},{12259,2,0,32},{12217,2,0,32},
{12259,2,0,32},{12219,2,0,32},{12259,2,0,32},{12221,2,0,32},{12259,2,0,32},
{12222,2,0,32},{12259,2,0,32},{12223,2,0,32},{12259,2,0,32},{12224,2,0,32},
{12259,2,0,32},{12225,2,0,32},{12259,2,0,32},{12226,2,0,32},{12259,2,0,32},
{12227,2,0,32},{12259,2,0,32},{12228,2,0,32},{12259,2,0,32},{12229,2,0,32},
{12259,2,0,32},{12230,2,0,32},{12259,2,0,32},{12231,2,0,32},{12259,2,0,32},
{12232,2,0,32},{12259,2,0,32},{12233,2,0,32},{12259,2,0,32},{12234,2,0,32},
{12259,2,0,32},{12235,2,0,32},{12259,2,0,32},{12236,2,0,32},{12259,2,0,32},
{12237,2,0,32},{12259,2,0,32},{12218,2,0,32},{12259,2,0,32},{12238,2,0,32},
{12259,2,0,32},{12239,2,0,32},{12259,2,0,32},{12240,2,0,32},{12259,2,0,32},
{12238,4,0,32},{12226,4,0,32},{12259,2,0,32},{12238,4,0,32},{12233,4,0,32},
{12259,2,0,32},{12212,2,0,32},{12259,2,0,32},{12220,2,0,32},{12259,2,0,32},
{12245,2,0,32},{12238,4,0,32},{12226,4,0,32},{12238,4,0,32},{12233,4,0,32},
{12397,4,0,32},{12420,4,0,32},{0,4,0,196},{12327,2,0,32},{12392,2,0,32},{12332,
2,0,32},{12396,2,0,32},{12348,2,0,32},{12396,2,0,32},{12356,2,0,32},{12396,2,0,
32},{12364,2,0,32},{12396,2,0,32},{12372,2,0,32},{12396,2,0,32},{12384,4,0,32},
{0,4,0,275},{12409,2,0,32},{12413,2,0,32},{12411,2,0,32},{12328,2,0,32},{12392,
2,0,32},{12333,2,0,32},{12396,2,0,32},{12349,2,0,32},{12396,2,0,32},{12357,2,0,
32},{12396,2,0,32},{12365,2,0,32},{12396,2,0,32},{12373,2,0,32},{12396,2,0,32},
{12415,2,0,32},{12414,2,0,32},{12417,2,0,32},{12416,2,0,32},{12375,4,0,32},{0,4,
0,275},{12383,4,0,32},{0,4,0,275},{12385,4,0,32},{0,4,0,275},{13077,4,0,32},
{13134,4,0,32},{13077,4,0,32},{14721,4,0,32},{0,4,0,274},{14722,4,0,32},{0,4,0,
274},{14722,4,0,32},{0,4,0,275},{14723,4,0,32},{0,4,0,274},{14724,4,0,32},{0,4,
0,274},{14724,4,0,32},{0,4,0,275},{14724,4,0,32},{0,4,0,276},{14724,4,0,32},{0,
4,0,277},{14729,4,0,32},{0,4,0,274},{14729,4,0,32},{0,4,0,275},{14729,4,0,32},
{0,4,0,276},{14729,4,0,32},{0,4,0,277},{14733,4,0,32},{0,4,0,274},{14733,4,0,
32},{0,4,0,275},{14733,4,0,32},{0,4,0,276},{14734,4,0,32},{0,4,0,274},{14734,4,
0,32},{0,4,0,275},{14735,4,0,32},{0,4,0,274},{14737,4,0,32},{0,4,0,274},{14738,
4,0,32},{0,4,0,274},{14742,4,0,32},{0,4,0,274},{14742,4,0,32},{0,4,0,276},
{14742,4,0,32},{0,4,0,277},{14742,4,0,32},{0,4,0,278},{14744,4,0,32},{0,4,0,
274},{14744,4,0,32},{0,4,0,275},{14745,4,0,32},{0,4,0,274},{14745,4,0,32},{0,4,
0,275},{14740,4,0,32},{0,4,0,274},{14748,4,0,32},{0,4,0,274},{14748,4,0,32},{0,
4,0,275},{14749,4,0,32},{0,4,0,274},{14750,4,0,32},{0,4,0,274},{14766,4,0,32},
{0,4,0,274},{14766,4,0,32},{0,4,0,275},{14732,4,0,32},{0,4,0,274},{14742,4,0,
32},{0,4,0,275},{14738,4,0,32},{14749,4,0,32},{14748,4,0,32},{0,4,0,274},{14748,
4,0,32},{0,4,0,274},{14723,4,0,32},{14723,4,0,32},{12712,4,0,32},{12742,4,0,32},
{12715,4,0,32},{12743,4,0,32},{13353,2,0,32},{13402,2,0,32},{13354,2,0,32},
{13402,2,0,32},{13355,2,0,32},{13402,2,0,32},{13356,2,0,32},{13402,2,0,32},
{13357,2,0,32},{13402,2,0,32},{13358,2,0,32},{13402,2,0,32},{13359,2,0,32},
{13402,2,0,32},{13360,2,0,32},{13402,2,0,32},{13361,2,0,32},{13402,2,0,32},
{13362,2,0,32},{13402,2,0,32},{13363,2,0,32},{13402,2,0,32},{13364,2,0,32},
{13402,2,0,32},{13365,2,0,32},{13402,2,0,32},{13366,2,0,32},{13402,2,0,32},
{13367,2,0,32},{13402,2,0,32},{13368,2,0,32},{13402,2,0,32},{13369,2,0,32},
{13402,2,0,32},{13370,2,0,32},{13402,2,0,32},{13371,2,0,32},{13402,2,0,32},
{13372,2,0,32},{13402,2,0,32},{13373,2,0,32},{13402,2,0,32},{13374,2,0,32},
{13402,2,0,32},{13375,2,0,32},{13402,2,0,32},{13376,2,0,32},{13402,2,0,32},
{13377,2,0,32},{13402,2,0,32},{13378,2,0,32},{13402,2,0,32},{13379,2,0,32},
{13402,2,0,32},{13380,2,0,32},{13402,2,0,32},{13381,2,0,32},{13402,2,0,32},
{13382,2,0,32},{13402,2,0,32},{13383,2,0,32},{13402,2,0,32},{13384,2,0,32},
{13402,2,0,32},{13385,2,0,32},{13402,2,0,32},{13386,2,0,32},{13402,2,0,32},
{13387,2,0,32},{13402,2,0,32},{13388,2,0,32},{13402,2,0,32},{13389,2,0,32},
{13402,2,0,32},{13390,2,0,32},{13402,2,0,32},{13391,2,0,32},{13402,2,0,32},
{13392,2,0,32},{13402,2,0,32},{13393,2,0,32},{13402,2,0,32},{13394,2,0,32},
{13402,2,0,32},{13395,2,0,32},{13402,2,0,32},{13396,2,0,32},{13402,2,0,32},
{13353,2,0,32},{13403,2,0,32},{13354,2,0,32},{13403,2,0,32},{13355,2,0,32},
{13403,2,0,32},{13356,2,0,32},{13403,2,0,32},{13357,2,0,32},{13403,2,0,32},
{13358,2,0,32},{13403,2,0,32},{13359,2,0,32},{13403,2,0,32},{13360,2,0,32},
{13403,2,0,32},{13361,2,0,32},{13403,2,0,32},{13362,2,0,32},{13403,2,0,32},
{13363,2,0,32},{13403,2,0,32},{13364,2,0,32},{13403,2,0,32},{13365,2,0,32},
{13403,2,0,32},{13366,2,0,32},{13403,2,0,32},{13367,2,0,32},{13403,2,0,32},
{13368,2,0,32},{13403,2,0,32},{13369,2,0,32},{13403,2,0,32},{13370,2,0,32},
{13403,2,0,32},{13371,2,0,32},{13403,2,0,32},{13372,2,0,32},{13403,2,0,32},
{13373,2,0,32},{13403,2,0,32},{13374,2,0,32},{13403,2,0,32},{13375,2,0,32},
{13403,2,0,32},{13376,2,0,32},{13403,2,0,32},{13377,2,0,32},{13403,2,0,32},
{13378,2,0,32},{13403,2,0,32},{13379,2,0,32},{13403,2,0,32},{13380,2,0,32},
{13403,2,0,32},{13381,2,0,32},{13403,2,0,32},{13382,2,0,32},{13403,2,0,32},
{13383,2,0,32},{13403,2,0,32},{13384,2,0,32},{13403,2,0,32},{13385,2,0,32},
{13403,2,0,32},{13386,2,0,32},{13403,2,0,32},{13387,2,0,32},{13403,2,0,32},
{13388,2,0,32},{13403,2,0,32},{13389,2,0,32},{13403,2,0,32},{13390,2,0,32},
{13403,2,0,32},{13391,2,0,32},{13403,2,0,32},{13392,2,0,32},{13403,2,0,32},
{13393,2,0,32},{13403,2,0,32},{13394,2,0,32},{13403,2,0,32},{13395,2,0,32},
{13403,2,0,32},{13396,2,0,32},{13403,2,0,32},{13353,2,0,32},{13404,2,0,32},
{13354,2,0,32},{13404,2,0,32},{13355,2,0,32},{13404,2,0,32},{13356,2,0,32},
{13404,2,0,32},{13357,2,0,32},{13404,2,0,32},{13358,2,0,32},{13404,2,0,32},
{13359,2,0,32},{13404,2,0,32},{13360,2,0,32},{13404,2,0,32},{13361,2,0,32},
{13404,2,0,32},{13362,2,0,32},{13404,2,0,32},{13363,2,0,32},{13404,2,0,32},
{13364,2,0,32},{13404,2,0,32},{13365,2,0,32},{13404,2,0,32},{13366,2,0,32},
{13404,2,0,32},{13367,2,0,32},{13404,2,0,32},{13368,2,0,32},{13404,2,0,32},
{13369,2,0,32},{13404,2,0,32},{13370,2,0,32},{13404,2,0,32},{13371,2,0,32},
{13404,2,0,32},{13372,2,0,32},{13404,2,0,32},{13373,2,0,32},{13404,2,0,32},
{13374,2,0,32},{13404,2,0,32},{13375,2,0,32},{13404,2,0,32},{13376,2,0,32},
{13404,2,0,32},{13377,2,0,32},{13404,2,0,32},{13378,2,0,32},{13404,2,0,32},
{13379,2,0,32},{13404,2,0,32},{13380,2,0,32},{13404,2,0,32},{13381,2,0,32},
{13404,2,0,32},{13382,2,0,32},{13404,2,0,32},{13383,2,0,32},{13404,2,0,32},
{13384,2,0,32},{13404,2,0,32},{13385,2,0,32},{13404,2,0,32},{13386,2,0,32},
{13404,2,0,32},{13387,2,0,32},{13404,2,0,32},{13388,2,0,32},{13404,2,0,32},
{13389,2,0,32},{13404,2,0,32},{13390,2,0,32},{13404,2,0,32},{13391,2,0,32},
{13404,2,0,32},{13392,2,0,32},{13404,2,0,32},{13393,2,0,32},{13404,2,0,32},
{13394,2,0,32},{13404,2,0,32},{13395,2,0,32},{13404,2,0,32},{13396,2,0,32},
{13404,2,0,32},{13353,2,0,32},{13407,2,0,32},{13354,2,0,32},{13407,2,0,32},
{13355,2,0,32},{13407,2,0,32},{13356,2,0,32},{13407,2,0,32},{13357,2,0,32},
{13407,2,0,32},{13358,2,0,32},{13407,2,0,32},{13359,2,0,32},{13407,2,0,32},
{13360,2,0,32},{13407,2,0,32},{13361,2,0,32},{13407,2,0,32},{13362,2,0,32},
{13407,2,0,32},{13363,2,0,32},{13407,2,0,32},{13364,2,0,32},{13407,2,0,32},
{13365,2,0,32},{13407,2,0,32},{13366,2,0,32},{13407,2,0,32},{13367,2,0,32},
{13407,2,0,32},{13368,2,0,32},{13407,2,0,32},{13369,2,0,32},{13407,2,0,32},
{13370,2,0,32},{13407,2,0,32},{13371,2,0,32},{13407,2,0,32},{13372,2,0,32},
{13407,2,0,32},{13373,2,0,32},{13407,2,0,32},{13374,2,0,32},{13407,2,0,32},
{13375,2,0,32},{13407,2,0,32},{13376,2,0,32},{13407,2,0,32},{13377,2,0,32},
{13407,2,0,32},{13378,2,0,32},{13407,2,0,32},{13379,2,0,32},{13407,2,0,32},
{13380,2,0,32},{13407,2,0,32},{13381,2,0,32},{13407,2,0,32},{13382,2,0,32},
{13407,2,0,32},{13383,2,0,32},{13407,2,0,32},{13384,2,0,32},{13407,2,0,32},
{13385,2,0,32},{13407,2,0,32},{13386,2,0,32},{13407,2,0,32},{13387,2,0,32},
{13407,2,0,32},{13388,2,0,32},{13407,2,0,32},{13389,2,0,32},{13407,2,0,32},
{13390,2,0,32},{13407,2,0,32},{13391,2,0,32},{13407,2,0,32},{13392,2,0,32},
{13407,2,0,32},{13393,2,0,32},{13407,2,0,32},{13394,2,0,32},{13407,2,0,32},
{13395,2,0,32},{13407,2,0,32},{13396,2,0,32},{13407,2,0,32},{13381,4,0,32},
{13403,4,0,32},{13381,4,0,32},{13403,4,0,32},{13414,4,0,32},{13461,4,0,32},
{13499,4,0,32},{13461,4,0,32},{7566,20,0,32},{0,20,0,274},{7665,20,0,32},{7739,
4,0,32},{0,4,0,275},{8157,4,0,32},{0,4,0,274},{7775,4,0,32},{7638,20,0,32},{0,
20,0,274},{7566,4,0,32},{0,4,0,274},{7566,4,0,32},{0,4,0,274},{7665,4,0,32},
{7566,4,0,32},{7972,4,0,32},{7566,4,0,32},{8236,4,0,32},{7617,4,0,32},{0,4,0,
48},{7638,4,0,32},{0,4,0,275},{7638,4,0,32},{0,4,0,274},{8121,4,0,32},{0,4,0,
275},{7972,4,0,32},{0,4,0,52},{8189,4,0,32},{0,4,0,52},{7566,4,0,32},{0,4,0,43},
{7972,4,0,32},{0,4,0,43},{8189,4,0,32},{0,4,0,43},{7566,8,0,32},{0,2,0,68},
{7566,2,0,32},{0,2,0,68},{7591,8,0,32},{0,2,0,46},{7591,2,0,32},{0,2,0,46},
{7591,8,0,32},{0,2,0,66},{7591,2,0,32},{0,2,0,66},{7591,8,0,32},{0,2,0,73},
{7591,2,0,32},{0,2,0,73},{7617,8,0,32},{0,2,0,48},{0,2,0,36},{7617,2,0,32},{0,2,
0,48},{0,2,0,36},{7638,8,0,32},{0,2,0,46},{7638,2,0,32},{0,2,0,46},{7638,8,0,
32},{0,2,0,66},{7638,2,0,32},{0,2,0,66},{7638,8,0,32},{0,2,0,73},{7638,2,0,32},
{0,2,0,73},{7638,8,0,32},{0,2,0,48},{7638,2,0,32},{0,2,0,48},{7638,8,0,32},{0,2,
0,70},{7638,2,0,32},{0,2,0,70},{7665,8,0,32},{0,2,0,50},{0,2,0,37},{7665,2,0,
32},{0,2,0,50},{0,2,0,37},{7665,8,0,32},{0,2,0,50},{0,2,0,36},{7665,2,0,32},{0,
2,0,50},{0,2,0,36},{7665,8,0,32},{0,2,0,70},{7665,2,0,32},{0,2,0,70},{7665,8,0,
32},{0,2,0,72},{7665,2,0,32},{0,2,0,72},{7665,8,0,32},{0,2,0,48},{0,2,0,38},
{7665,2,0,32},{0,2,0,48},{0,2,0,38},{7724,8,0,32},{0,2,0,46},{7724,2,0,32},{0,2,
0,46},{7739,8,0,32},{0,2,0,50},{7739,2,0,32},{0,2,0,50},{7775,8,0,32},{0,2,0,
46},{7775,2,0,32},{0,2,0,46},{7775,8,0,32},{0,2,0,66},{7775,2,0,32},{0,2,0,66},
{7775,8,0,32},{0,2,0,43},{7775,2,0,32},{0,2,0,43},{7775,8,0,32},{0,2,0,48},
{7775,2,0,32},{0,2,0,48},{7775,8,0,32},{0,2,0,71},{7775,2,0,32},{0,2,0,71},
{7801,8,0,32},{0,2,0,72},{7801,2,0,32},{0,2,0,72},{7801,8,0,32},{0,2,0,43},{0,2,
0,36},{7801,2,0,32},{0,2,0,43},{0,2,0,36},{7852,8,0,32},{0,2,0,36},{7852,2,0,
32},{0,2,0,36},{7852,8,0,32},{0,2,0,66},{7852,2,0,32},{0,2,0,66},{7852,8,0,32},
{0,2,0,73},{7852,2,0,32},{0,2,0,73},{7870,8,0,32},{0,2,0,66},{7870,2,0,32},{0,2,
0,66},{7870,8,0,32},{0,2,0,66},{0,2,0,50},{7870,2,0,32},{0,2,0,66},{0,2,0,50},
{7870,8,0,32},{0,2,0,73},{7870,2,0,32},{0,2,0,73},{7870,8,0,32},{0,2,0,70},
{7870,2,0,32},{0,2,0,70},{7921,8,0,32},{0,2,0,36},{7921,2,0,32},{0,2,0,36},
{7921,8,0,32},{0,2,0,46},{7921,2,0,32},{0,2,0,46},{7921,8,0,32},{0,2,0,66},
{7921,2,0,32},{0,2,0,66},{7936,8,0,32},{0,2,0,46},{7936,2,0,32},{0,2,0,46},
{7936,8,0,32},{0,2,0,66},{7936,2,0,32},{0,2,0,66},{7936,8,0,32},{0,2,0,73},
{7936,2,0,32},{0,2,0,73},{7936,8,0,32},{0,2,0,70},{7936,2,0,32},{0,2,0,70},
{7972,8,0,32},{0,2,0,45},{0,2,0,36},{7972,2,0,32},{0,2,0,45},{0,2,0,36},{7972,8,
0,32},{0,2,0,45},{0,2,0,43},{7972,2,0,32},{0,2,0,45},{0,2,0,43},{7972,8,0,32},
{0,2,0,50},{0,2,0,37},{7972,2,0,32},{0,2,0,50},{0,2,0,37},{7972,8,0,32},{0,2,0,
50},{0,2,0,36},{7972,2,0,32},{0,2,0,50},{0,2,0,36},{8019,8,0,32},{0,2,0,36},
{8019,2,0,32},{0,2,0,36},{8019,8,0,32},{0,2,0,46},{8019,2,0,32},{0,2,0,46},
{8059,8,0,32},{0,2,0,46},{8059,2,0,32},{0,2,0,46},{8059,8,0,32},{0,2,0,66},
{8059,2,0,32},{0,2,0,66},{8059,8,0,32},{0,2,0,66},{0,2,0,50},{8059,2,0,32},{0,2,
0,66},{0,2,0,50},{8059,8,0,32},{0,2,0,73},{8059,2,0,32},{0,2,0,73},{8121,8,0,
32},{0,2,0,46},{8121,2,0,32},{0,2,0,46},{8121,8,0,32},{0,2,0,66},{8121,2,0,32},
{0,2,0,66},{8121,8,0,32},{0,2,0,36},{0,2,0,46},{8121,2,0,32},{0,2,0,36},{0,2,0,
46},{8121,8,0,32},{0,2,0,40},{0,2,0,46},{8121,2,0,32},{0,2,0,40},{0,2,0,46},
{8121,8,0,32},{0,2,0,66},{0,2,0,46},{8121,2,0,32},{0,2,0,66},{0,2,0,46},{8157,8,
0,32},{0,2,0,46},{8157,2,0,32},{0,2,0,46},{8157,8,0,32},{0,2,0,66},{8157,2,0,
32},{0,2,0,66},{8157,8,0,32},{0,2,0,73},{8157,2,0,32},{0,2,0,73},{8157,8,0,32},
{0,2,0,70},{8157,2,0,32},{0,2,0,70},{8189,8,0,32},{0,2,0,67},{8189,2,0,32},{0,2,
0,67},{8189,8,0,32},{0,2,0,72},{8189,2,0,32},{0,2,0,72},{8189,8,0,32},{0,2,0,
70},{8189,2,0,32},{0,2,0,70},{8189,8,0,32},{0,2,0,45},{0,2,0,36},{8189,2,0,32},
{0,2,0,45},{0,2,0,36},{8189,8,0,32},{0,2,0,50},{0,2,0,43},{8189,2,0,32},{0,2,0,
50},{0,2,0,43},{8236,8,0,32},{0,2,0,45},{8236,2,0,32},{0,2,0,45},{8236,8,0,32},
{0,2,0,66},{8236,2,0,32},{0,2,0,66},{8254,8,0,32},{0,2,0,37},{8254,2,0,32},{0,2,
0,37},{8254,8,0,32},{0,2,0,36},{8254,2,0,32},{0,2,0,36},{8254,8,0,32},{0,2,0,
43},{8254,2,0,32},{0,2,0,43},{8254,8,0,32},{0,2,0,46},{8254,2,0,32},{0,2,0,46},
{8254,8,0,32},{0,2,0,66},{8254,2,0,32},{0,2,0,66},{8264,8,0,32},{0,2,0,46},
{8264,2,0,32},{0,2,0,46},{8264,8,0,32},{0,2,0,43},{8264,2,0,32},{0,2,0,43},
{8276,8,0,32},{0,2,0,46},{8276,2,0,32},{0,2,0,46},{8298,8,0,32},{0,2,0,39},
{8298,2,0,32},{0,2,0,39},{8298,8,0,32},{0,2,0,66},{8298,2,0,32},{0,2,0,66},
{8298,8,0,32},{0,2,0,73},{8298,2,0,32},{0,2,0,73},{7775,2,0,32},{0,2,0,73},
{8157,2,0,32},{0,2,0,43},{8254,2,0,32},{0,2,0,41},{8276,2,0,32},{0,2,0,41},
{7566,4,0,32},{8393,4,0,32},{8121,4,0,32},{0,4,0,275},{0,2,0,46},{8121,10,0,32},
{0,4,0,274},{8121,10,0,32},{7566,8,0,32},{0,2,0,66},{7566,2,0,32},{0,2,0,66},
{7566,8,0,32},{0,2,0,59},{7566,2,0,32},{0,2,0,59},{7566,8,0,32},{0,2,0,39},{0,2,
0,36},{7566,2,0,32},{0,2,0,39},{0,2,0,36},{7566,8,0,32},{0,2,0,39},{0,2,0,37},
{7566,2,0,32},{0,2,0,39},{0,2,0,37},{7566,8,0,32},{0,2,0,39},{0,2,0,59},{7566,2,
0,32},{0,2,0,39},{0,2,0,59},{7566,8,0,32},{0,2,0,39},{0,2,0,45},{7566,2,0,32},
{0,2,0,39},{0,2,0,45},{7566,8,0,32},{0,2,0,66},{0,2,0,39},{7566,2,0,32},{0,2,0,
66},{0,2,0,39},{7566,8,0,32},{0,2,0,38},{0,2,0,36},{7566,2,0,32},{0,2,0,38},{0,
2,0,36},{7566,8,0,32},{0,2,0,38},{0,2,0,37},{7566,2,0,32},{0,2,0,38},{0,2,0,37},
{7566,8,0,32},{0,2,0,38},{0,2,0,59},{7566,2,0,32},{0,2,0,38},{0,2,0,59},{7566,8,
0,32},{0,2,0,38},{0,2,0,45},{7566,2,0,32},{0,2,0,38},{0,2,0,45},{7566,8,0,32},
{0,2,0,66},{0,2,0,38},{7566,2,0,32},{0,2,0,66},{0,2,0,38},{7665,8,0,32},{0,2,0,
66},{7665,2,0,32},{0,2,0,66},{7665,8,0,32},{0,2,0,59},{7665,2,0,32},{0,2,0,59},
{7665,8,0,32},{0,2,0,45},{7665,2,0,32},{0,2,0,45},{7665,8,0,32},{0,2,0,39},{0,2,
0,36},{7665,2,0,32},{0,2,0,39},{0,2,0,36},{7665,8,0,32},{0,2,0,39},{0,2,0,37},
{7665,2,0,32},{0,2,0,39},{0,2,0,37},{7665,8,0,32},{0,2,0,39},{0,2,0,59},{7665,2,
0,32},{0,2,0,39},{0,2,0,59},{7665,8,0,32},{0,2,0,39},{0,2,0,45},{7665,2,0,32},
{0,2,0,39},{0,2,0,45},{7665,8,0,32},{0,2,0,66},{0,2,0,39},{7665,2,0,32},{0,2,0,
66},{0,2,0,39},{7801,8,0,32},{0,2,0,59},{7801,2,0,32},{0,2,0,59},{7801,8,0,32},
{0,2,0,66},{7801,2,0,32},{0,2,0,66},{7972,8,0,32},{0,2,0,66},{7972,2,0,32},{0,2,
0,66},{7972,8,0,32},{0,2,0,59},{7972,2,0,32},{0,2,0,59},{7972,8,0,32},{0,2,0,
39},{0,2,0,36},{7972,2,0,32},{0,2,0,39},{0,2,0,36},{7972,8,0,32},{0,2,0,39},{0,
2,0,37},{7972,2,0,32},{0,2,0,39},{0,2,0,37},{7972,8,0,32},{0,2,0,39},{0,2,0,59},
{7972,2,0,32},{0,2,0,39},{0,2,0,59},{7972,8,0,32},{0,2,0,39},{0,2,0,45},{7972,2,
0,32},{0,2,0,39},{0,2,0,45},{7972,8,0,32},{0,2,0,66},{0,2,0,39},{7972,2,0,32},
{0,2,0,66},{0,2,0,39},{7972,8,0,32},{0,2,0,63},{0,2,0,36},{7972,2,0,32},{0,2,0,
63},{0,2,0,36},{7972,8,0,32},{0,2,0,63},{0,2,0,37},{7972,2,0,32},{0,2,0,63},{0,
2,0,37},{7972,8,0,32},{0,2,0,63},{0,2,0,59},{7972,2,0,32},{0,2,0,63},{0,2,0,59},
{7972,8,0,32},{0,2,0,63},{0,2,0,45},{7972,2,0,32},{0,2,0,63},{0,2,0,45},{7972,8,
0,32},{0,2,0,63},{0,2,0,66},{7972,2,0,32},{0,2,0,63},{0,2,0,66},{8189,8,0,32},
{0,2,0,66},{8189,2,0,32},{0,2,0,66},{8189,8,0,32},{0,2,0,59},{8189,2,0,32},{0,2,
0,59},{8189,8,0,32},{0,2,0,63},{0,2,0,36},{8189,2,0,32},{0,2,0,63},{0,2,0,36},
{8189,8,0,32},{0,2,0,63},{0,2,0,37},{8189,2,0,32},{0,2,0,63},{0,2,0,37},{8189,8,
0,32},{0,2,0,63},{0,2,0,59},{8189,2,0,32},{0,2,0,63},{0,2,0,59},{8189,8,0,32},
{0,2,0,63},{0,2,0,45},{8189,2,0,32},{0,2,0,63},{0,2,0,45},{8189,8,0,32},{0,2,0,
63},{0,2,0,66},{8189,2,0,32},{0,2,0,63},{0,2,0,66},{8276,8,0,32},{0,2,0,37},
{8276,2,0,32},{0,2,0,37},{8276,8,0,32},{0,2,0,66},{8276,2,0,32},{0,2,0,66},
{8276,8,0,32},{0,2,0,59},{8276,2,0,32},{0,2,0,59},{8276,8,0,32},{0,2,0,45},
{8276,2,0,32},{0,2,0,45},{7870,10,0,32},{7870,10,0,32},{7870,4,0,32},{7870,4,0,
32},{8450,2,0,32},{0,2,0,34},{8450,2,0,32},{0,2,0,35},{8450,2,0,32},{0,2,0,34},
{0,2,0,37},{8450,2,0,32},{0,2,0,35},{0,2,0,37},{8450,2,0,32},{0,2,0,34},{0,2,0,
36},{8450,2,0,32},{0,2,0,35},{0,2,0,36},{8450,2,0,32},{0,2,0,34},{0,2,0,42},
{8450,2,0,32},{0,2,0,35},{0,2,0,42},{8450,8,0,32},{0,2,0,34},{8450,8,0,32},{0,2,
0,35},{8450,8,0,32},{0,2,0,34},{0,2,0,37},{8450,8,0,32},{0,2,0,35},{0,2,0,37},
{8450,8,0,32},{0,2,0,34},{0,2,0,36},{8450,8,0,32},{0,2,0,35},{0,2,0,36},{8450,8,
0,32},{0,2,0,34},{0,2,0,42},{8450,8,0,32},{0,2,0,35},{0,2,0,42},{8455,2,0,32},
{0,2,0,34},{8455,2,0,32},{0,2,0,35},{8455,2,0,32},{0,2,0,34},{0,2,0,37},{8455,2,
0,32},{0,2,0,35},{0,2,0,37},{8455,2,0,32},{0,2,0,34},{0,2,0,36},{8455,2,0,32},
{0,2,0,35},{0,2,0,36},{8455,8,0,32},{0,2,0,34},{8455,8,0,32},{0,2,0,35},{8455,8,
0,32},{0,2,0,34},{0,2,0,37},{8455,8,0,32},{0,2,0,35},{0,2,0,37},{8455,8,0,32},
{0,2,0,34},{0,2,0,36},{8455,8,0,32},{0,2,0,35},{0,2,0,36},{8461,2,0,32},{0,2,0,
34},{8461,2,0,32},{0,2,0,35},{8461,2,0,32},{0,2,0,34},{0,2,0,37},{8461,2,0,32},
{0,2,0,35},{0,2,0,37},{8461,2,0,32},{0,2,0,34},{0,2,0,36},{8461,2,0,32},{0,2,0,
35},{0,2,0,36},{8461,2,0,32},{0,2,0,34},{0,2,0,42},{8461,2,0,32},{0,2,0,35},{0,
2,0,42},{8461,8,0,32},{0,2,0,34},{8461,8,0,32},{0,2,0,35},{8461,8,0,32},{0,2,0,
34},{0,2,0,37},{8461,8,0,32},{0,2,0,35},{0,2,0,37},{8461,8,0,32},{0,2,0,34},{0,
2,0,36},{8461,8,0,32},{0,2,0,35},{0,2,0,36},{8461,8,0,32},{0,2,0,34},{0,2,0,42},
{8461,8,0,32},{0,2,0,35},{0,2,0,42},{8463,2,0,32},{0,2,0,34},{8463,2,0,32},{0,2,
0,35},{8463,2,0,32},{0,2,0,34},{0,2,0,37},{8463,2,0,32},{0,2,0,35},{0,2,0,37},
{8463,2,0,32},{0,2,0,34},{0,2,0,36},{8463,2,0,32},{0,2,0,35},{0,2,0,36},{8463,2,
0,32},{0,2,0,34},{0,2,0,42},{8463,2,0,32},{0,2,0,35},{0,2,0,42},{8463,8,0,32},
{0,2,0,34},{8463,8,0,32},{0,2,0,35},{8463,8,0,32},{0,2,0,34},{0,2,0,37},{8463,8,
0,32},{0,2,0,35},{0,2,0,37},{8463,8,0,32},{0,2,0,34},{0,2,0,36},{8463,8,0,32},
{0,2,0,35},{0,2,0,36},{8463,8,0,32},{0,2,0,34},{0,2,0,42},{8463,8,0,32},{0,2,0,
35},{0,2,0,42},{8471,2,0,32},{0,2,0,34},{8471,2,0,32},{0,2,0,35},{8471,2,0,32},
{0,2,0,34},{0,2,0,37},{8471,2,0,32},{0,2,0,35},{0,2,0,37},{8471,2,0,32},{0,2,0,
34},{0,2,0,36},{8471,2,0,32},{0,2,0,35},{0,2,0,36},{8471,8,0,32},{0,2,0,34},
{8471,8,0,32},{0,2,0,35},{8471,8,0,32},{0,2,0,34},{0,2,0,37},{8471,8,0,32},{0,2,
0,35},{0,2,0,37},{8471,8,0,32},{0,2,0,34},{0,2,0,36},{8471,8,0,32},{0,2,0,35},
{0,2,0,36},{8485,2,0,32},{0,2,0,34},{8485,2,0,32},{0,2,0,35},{8485,2,0,32},{0,2,
0,34},{0,2,0,37},{8485,2,0,32},{0,2,0,35},{0,2,0,37},{8485,2,0,32},{0,2,0,34},
{0,2,0,36},{8485,2,0,32},{0,2,0,35},{0,2,0,36},{8485,2,0,32},{0,2,0,34},{0,2,0,
42},{8485,2,0,32},{0,2,0,35},{0,2,0,42},{8485,8,0,32},{0,2,0,35},{8485,8,0,32},
{0,2,0,35},{0,2,0,37},{8485,8,0,32},{0,2,0,35},{0,2,0,36},{8485,8,0,32},{0,2,0,
35},{0,2,0,42},{8490,2,0,32},{0,2,0,34},{8490,2,0,32},{0,2,0,35},{8490,2,0,32},
{0,2,0,34},{0,2,0,37},{8490,2,0,32},{0,2,0,35},{0,2,0,37},{8490,2,0,32},{0,2,0,
34},{0,2,0,36},{8490,2,0,32},{0,2,0,35},{0,2,0,36},{8490,2,0,32},{0,2,0,34},{0,
2,0,42},{8490,2,0,32},{0,2,0,35},{0,2,0,42},{8490,8,0,32},{0,2,0,34},{8490,8,0,
32},{0,2,0,35},{8490,8,0,32},{0,2,0,34},{0,2,0,37},{8490,8,0,32},{0,2,0,35},{0,
2,0,37},{8490,8,0,32},{0,2,0,34},{0,2,0,36},{8490,8,0,32},{0,2,0,35},{0,2,0,36},
{8490,8,0,32},{0,2,0,34},{0,2,0,42},{8490,8,0,32},{0,2,0,35},{0,2,0,42},{8450,2,
0,32},{0,2,0,37},{8455,2,0,32},{0,2,0,37},{8461,2,0,32},{0,2,0,37},{8463,2,0,
32},{0,2,0,37},{8471,2,0,32},{0,2,0,37},{8485,2,0,32},{0,2,0,37},{8490,2,0,32},
{0,2,0,37},{8450,2,0,32},{0,2,0,34},{0,2,0,76},{8450,2,0,32},{0,2,0,35},{0,2,0,
76},{8450,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8450,2,0,32},{0,2,0,35},{0,
2,0,37},{0,2,0,76},{8450,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8450,2,0,32},
{0,2,0,35},{0,2,0,36},{0,2,0,76},{8450,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8450,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8450,8,0,32},{0,2,0,34},{0,2,0,
76},{8450,8,0,32},{0,2,0,35},{0,2,0,76},{8450,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8450,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8450,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8450,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8450,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8450,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8461,2,0,32},{0,2,0,34},{0,2,0,76},{8461,2,0,32},{0,2,0,35},{0,2,0,76},
{8461,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8461,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{8461,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8461,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{8461,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8461,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8461,8,0,32},{0,2,0,34},{0,2,0,
76},{8461,8,0,32},{0,2,0,35},{0,2,0,76},{8461,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8461,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8461,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8461,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8461,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8461,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8490,2,0,32},{0,2,0,34},{0,2,0,76},{8490,2,0,32},{0,2,0,35},{0,2,0,76},
{8490,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8490,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{8490,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8490,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{8490,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8490,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8490,8,0,32},{0,2,0,34},{0,2,0,
76},{8490,8,0,32},{0,2,0,35},{0,2,0,76},{8490,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8490,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8490,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8490,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8490,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8490,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8450,2,0,32},{0,2,0,38},{8450,2,0,32},{0,2,0,50},{8450,2,0,32},{0,2,0,37},
{0,2,0,76},{8450,2,0,32},{0,2,0,76},{8450,2,0,32},{0,2,0,36},{0,2,0,76},{8450,2,
0,32},{0,2,0,42},{8450,2,0,32},{0,2,0,42},{0,2,0,76},{8450,8,0,32},{0,2,0,38},
{8450,8,0,32},{0,2,0,50},{8450,8,0,32},{0,2,0,37},{8450,8,0,32},{0,2,0,76},
{1201,2,1,32},{0,2,0,42},{8461,2,0,32},{0,2,0,37},{0,2,0,76},{8461,2,0,32},{0,2,
0,76},{8461,2,0,32},{0,2,0,36},{0,2,0,76},{8461,2,0,32},{0,2,0,42},{8461,2,0,
32},{0,2,0,42},{0,2,0,76},{8455,8,0,32},{0,2,0,37},{8461,8,0,32},{0,2,0,37},
{8461,8,0,32},{0,2,0,76},{1206,2,1,32},{0,2,0,37},{1206,2,1,32},{0,2,0,36},
{1206,2,1,32},{0,2,0,42},{8463,2,0,32},{0,2,0,38},{8463,2,0,32},{0,2,0,50},
{8463,2,0,32},{0,2,0,43},{0,2,0,37},{8463,2,0,32},{0,2,0,42},{8463,2,0,32},{0,2,
0,43},{0,2,0,42},{8463,8,0,32},{0,2,0,38},{8463,8,0,32},{0,2,0,50},{8463,8,0,
32},{0,2,0,37},{1207,2,1,32},{0,2,0,37},{1207,2,1,32},{0,2,0,36},{1207,2,1,32},
{0,2,0,42},{8485,2,0,32},{0,2,0,38},{8485,2,0,32},{0,2,0,50},{8485,2,0,32},{0,2,
0,43},{0,2,0,37},{8477,2,0,32},{0,2,0,34},{8477,2,0,32},{0,2,0,35},{8485,2,0,
32},{0,2,0,42},{8485,2,0,32},{0,2,0,43},{0,2,0,42},{8485,8,0,32},{0,2,0,38},
{8485,8,0,32},{0,2,0,50},{8485,8,0,32},{0,2,0,37},{8477,8,0,32},{0,2,0,35},
{1201,2,1,32},{0,2,0,37},{8490,2,0,32},{0,2,0,37},{0,2,0,76},{8490,2,0,32},{0,2,
0,76},{8490,2,0,32},{0,2,0,36},{0,2,0,76},{8490,2,0,32},{0,2,0,42},{8490,2,0,
32},{0,2,0,42},{0,2,0,76},{8471,8,0,32},{0,2,0,37},{8490,8,0,32},{0,2,0,37},
{8490,8,0,32},{0,2,0,76},{635,4,1,32},{635,4,1,32},{635,4,1,32},{635,4,1,32},
{635,4,1,32},{953,4,1,32},{953,4,1,32},{953,4,1,32},{953,4,1,32},{953,4,1,32},
{954,4,1,32},{954,4,1,32},{954,4,1,32},{954,4,1,32},{954,4,1,32},{612,4,1,32},
{612,4,1,32},{618,4,1,32},{618,4,1,32},{618,4,1,32},{612,4,1,32},{612,4,1,32},
{618,4,1,32},{953,4,1,32},{953,4,1,32},{953,4,1,32},{953,4,1,32},{8059,10,0,32},
{8121,4,0,32},{7566,4,0,32},{929,4,1,32},{7617,4,0,32},{7566,4,0,32},{929,4,1,
32},{8121,4,0,32},{1310,4,1,32},{7617,10,0,32},{7617,4,0,32},{929,4,1,32},{7972,
4,0,32},{7617,4,0,32},{929,4,1,32},{8189,4,0,32},{1310,4,1,32},{7724,10,0,32},
{7775,2,0,32},{0,2,0,57},{7936,10,0,32},{7972,4,0,32},{8121,20,0,32},{7921,20,0,
32},{8157,10,0,32},{7665,10,0,32},{7870,10,0,32},{8157,20,0,32},{7921,20,0,32},
{7724,10,0,32},{7566,10,0,32},{8264,10,0,32},{7566,10,0,32},{929,4,1,32},{8121,
10,0,32},{7557,30,0,32},{1615,30,1,32},{7563,30,0,32},{7557,30,0,32},{1615,30,1,
32},{7565,30,0,32},{7557,30,0,32},{1615,30,1,32},{7557,30,0,32},{7556,30,0,32},
{7557,30,0,32},{1615,30,1,32},{7559,30,0,32},{7558,30,0,32},{1615,30,1,32},
{7559,30,0,32},{7557,30,0,32},{1615,30,1,32},{7561,30,0,32},{7558,30,0,32},
{1615,30,1,32},{7561,30,0,32},{7559,30,0,32},{1615,30,1,32},{7561,30,0,32},
{7560,30,0,32},{1615,30,1,32},{7561,30,0,32},{7557,30,0,32},{1615,30,1,32},
{7562,30,0,32},{7561,30,0,32},{1615,30,1,32},{7562,30,0,32},{7557,30,0,32},
{1615,30,1,32},{7564,30,0,32},{7559,30,0,32},{1615,30,1,32},{7564,30,0,32},
{7561,30,0,32},{1615,30,1,32},{7564,30,0,32},{7563,30,0,32},{1615,30,1,32},
{7564,30,0,32},{7557,30,0,32},{1615,30,1,32},{7801,10,0,32},{7801,10,0,32},
{7801,10,0,32},{7801,10,0,32},{7801,10,0,32},{7801,10,0,32},{8236,10,0,32},
{8236,10,0,32},{7801,10,0,32},{8236,10,0,32},{7801,10,0,32},{7801,10,0,32},
{8236,10,0,32},{7801,10,0,32},{7801,10,0,32},{7801,10,0,32},{7801,10,0,32},
{8264,10,0,32},{8264,10,0,32},{7801,10,0,32},{8264,10,0,32},{7801,10,0,32},
{7801,10,0,32},{7801,4,0,32},{7801,4,0,32},{7801,4,0,32},{7801,4,0,32},{7801,4,
0,32},{7801,4,0,32},{8236,4,0,32},{8236,4,0,32},{7801,4,0,32},{8236,4,0,32},
{7801,4,0,32},{7801,4,0,32},{8236,4,0,32},{7801,4,0,32},{7801,4,0,32},{7801,4,0,
32},{7801,4,0,32},{8264,4,0,32},{8264,4,0,32},{7801,4,0,32},{8264,4,0,32},{7801,
4,0,32},{7801,4,0,32},{7556,30,0,32},{1615,30,1,32},{7559,30,0,32},{1477,2,1,
32},{0,2,0,47},{1478,2,1,32},{0,2,0,47},{1481,2,1,32},{0,2,0,47},{1535,2,1,32},
{0,2,0,47},{1539,2,1,32},{0,2,0,47},{1537,2,1,32},{0,2,0,47},{1586,2,1,32},{0,2,
0,47},{1590,2,1,32},{0,2,0,47},{1592,2,1,32},{0,2,0,47},{1631,2,1,32},{0,2,0,
47},{1632,2,1,32},{0,2,0,47},{1637,4,1,32},{1637,4,1,32},{1637,4,1,32},{1637,4,
1,32},{1637,4,1,32},{1638,4,1,32},{1638,4,1,32},{1638,4,1,32},{1638,4,1,32},
{1638,4,1,32},{1650,2,1,32},{0,2,0,47},{1656,2,1,32},{0,2,0,47},{1657,2,1,32},
{0,2,0,47},{1659,2,1,32},{0,2,0,47},{1604,2,1,32},{0,2,0,47},{1682,2,1,32},{0,2,
0,47},{1663,2,1,32},{0,2,0,47},{1603,2,1,32},{0,2,0,47},{1605,2,1,32},{0,2,0,
47},{1684,2,1,32},{0,2,0,47},{1685,2,1,32},{0,2,0,47},{1693,2,1,32},{0,2,0,47},
{1694,2,1,32},{0,2,0,47},{1695,2,1,32},{0,2,0,47},{1696,2,1,32},{0,2,0,47},
{1697,2,1,32},{0,2,0,47},{1698,2,1,32},{0,2,0,47},{1703,2,1,32},{0,2,0,47},
{1704,2,1,32},{0,2,0,47},{1705,2,1,32},{0,2,0,47},{1706,2,1,32},{0,2,0,47},
{1731,2,1,32},{0,2,0,47},{1737,2,1,32},{0,2,0,47},{1738,2,1,32},{0,2,0,47},
{1740,2,1,32},{0,2,0,47},{1699,2,1,32},{0,2,0,47},{1700,2,1,32},{0,2,0,47},
{1714,2,1,32},{0,2,0,47},{1715,2,1,32},{0,2,0,47},{1743,2,1,32},{0,2,0,47},
{1744,2,1,32},{0,2,0,47},{1745,2,1,32},{0,2,0,47},{1746,2,1,32},{0,2,0,47},
{7557,6,0,32},{7556,6,0,32},{7557,6,0,32},{7557,6,0,32},{7557,6,0,32},{7558,6,0,
32},{7557,6,0,32},{7559,6,0,32},{7557,6,0,32},{7560,6,0,32},{7557,6,0,32},{7561,
6,0,32},{7557,6,0,32},{7562,6,0,32},{7557,6,0,32},{7563,6,0,32},{7557,6,0,32},
{7564,6,0,32},{7557,6,0,32},{7565,6,0,32},{7558,6,0,32},{7556,6,0,32},{803,4,1,
32},{7557,4,0,32},{804,4,1,32},{803,4,1,32},{7558,4,0,32},{804,4,1,32},{803,4,1,
32},{7559,4,0,32},{804,4,1,32},{803,4,1,32},{7560,4,0,32},{804,4,1,32},{803,4,1,
32},{7561,4,0,32},{804,4,1,32},{803,4,1,32},{7562,4,0,32},{804,4,1,32},{803,4,1,
32},{7563,4,0,32},{804,4,1,32},{803,4,1,32},{7564,4,0,32},{804,4,1,32},{803,4,1,
32},{7565,4,0,32},{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7556,4,0,32},{804,4,
1,32},{803,4,1,32},{7557,4,0,32},{7557,4,0,32},{804,4,1,32},{803,4,1,32},{7557,
4,0,32},{7558,4,0,32},{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7559,4,0,32},
{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7560,4,0,32},{804,4,1,32},{803,4,1,32},
{7557,4,0,32},{7561,4,0,32},{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7562,4,0,
32},{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7563,4,0,32},{804,4,1,32},{803,4,1,
32},{7557,4,0,32},{7564,4,0,32},{804,4,1,32},{803,4,1,32},{7557,4,0,32},{7565,4,
0,32},{804,4,1,32},{803,4,1,32},{7558,4,0,32},{7556,4,0,32},{804,4,1,32},{7557,
4,0,32},{635,4,1,32},{7558,4,0,32},{635,4,1,32},{7559,4,0,32},{635,4,1,32},
{7560,4,0,32},{635,4,1,32},{7561,4,0,32},{635,4,1,32},{7562,4,0,32},{635,4,1,
32},{7563,4,0,32},{635,4,1,32},{7564,4,0,32},{635,4,1,32},{7565,4,0,32},{635,4,
1,32},{7557,4,0,32},{7556,4,0,32},{635,4,1,32},{7557,4,0,32},{7557,4,0,32},{635,
4,1,32},{7557,4,0,32},{7558,4,0,32},{635,4,1,32},{7557,4,0,32},{7559,4,0,32},
{635,4,1,32},{7557,4,0,32},{7560,4,0,32},{635,4,1,32},{7557,4,0,32},{7561,4,0,
32},{635,4,1,32},{7557,4,0,32},{7562,4,0,32},{635,4,1,32},{7557,4,0,32},{7563,4,
0,32},{635,4,1,32},{7557,4,0,32},{7564,4,0,32},{635,4,1,32},{7557,4,0,32},{7565,
4,0,32},{635,4,1,32},{7558,4,0,32},{7556,4,0,32},{635,4,1,32},{803,4,1,32},
{7566,4,0,32},{804,4,1,32},{803,4,1,32},{7591,4,0,32},{804,4,1,32},{803,4,1,32},
{7617,4,0,32},{804,4,1,32},{803,4,1,32},{7638,4,0,32},{804,4,1,32},{803,4,1,32},
{7665,4,0,32},{804,4,1,32},{803,4,1,32},{7724,4,0,32},{804,4,1,32},{803,4,1,32},
{7739,4,0,32},{804,4,1,32},{803,4,1,32},{7775,4,0,32},{804,4,1,32},{803,4,1,32},
{7801,4,0,32},{804,4,1,32},{803,4,1,32},{7827,4,0,32},{804,4,1,32},{803,4,1,32},
{7852,4,0,32},{804,4,1,32},{803,4,1,32},{7870,4,0,32},{804,4,1,32},{803,4,1,32},
{7921,4,0,32},{804,4,1,32},{803,4,1,32},{7936,4,0,32},{804,4,1,32},{803,4,1,32},
{7972,4,0,32},{804,4,1,32},{803,4,1,32},{8019,4,0,32},{804,4,1,32},{803,4,1,32},
{8040,4,0,32},{804,4,1,32},{803,4,1,32},{8059,4,0,32},{804,4,1,32},{803,4,1,32},
{8121,4,0,32},{804,4,1,32},{803,4,1,32},{8157,4,0,32},{804,4,1,32},{803,4,1,32},
{8189,4,0,32},{804,4,1,32},{803,4,1,32},{8236,4,0,32},{804,4,1,32},{803,4,1,32},
{8254,4,0,32},{804,4,1,32},{803,4,1,32},{8264,4,0,32},{804,4,1,32},{803,4,1,32},
{8276,4,0,32},{804,4,1,32},{803,4,1,32},{8298,4,0,32},{804,4,1,32},{7557,6,0,
32},{7557,6,0,32},{7557,6,0,32},{7558,6,0,32},{7557,6,0,32},{7559,6,0,32},{7557,
6,0,32},{7560,6,0,32},{7557,6,0,32},{7561,6,0,32},{7557,6,0,32},{7562,6,0,32},
{7557,6,0,32},{7563,6,0,32},{7557,6,0,32},{7564,6,0,32},{7557,6,0,32},{7565,6,0,
32},{7558,6,0,32},{7556,6,0,32},{7557,6,0,32},{7556,6,0,32},{7557,6,0,32},{7556,
6,0,32},{7557,6,0,32},{7556,6,0,32},{7557,6,0,32},{7556,6,0,32},{1637,4,1,32},
{1637,4,1,32},{1637,4,1,32},{1637,4,1,32},{573,4,1,32},{573,4,1,32},{1604,4,1,
32},{1604,4,1,32},{1604,4,1,32},{1604,4,1,32},{1604,4,1,32},{1604,4,1,32},{3279,
2,1,32},{0,2,0,47},{8506,4,0,32},{8495,4,0,32},{8505,4,0,32},{8782,4,0,32},
{8791,4,0,32},{64320,4,0,32},{52790,0,0,0},{0,4,0,274},{64320,4,0,32},{54146,0,
0,0},{0,4,0,274},{64320,4,0,32},{52827,0,0,0},{64320,4,0,32},{52826,0,0,0},
{64320,4,0,32},{52825,0,0,0},{0,4,0,274},{64320,4,0,32},{52923,0,0,0},{64320,4,
0,32},{53634,0,0,0},{0,4,0,274},{64320,4,0,32},{53728,0,0,0},{0,4,0,274},{64320,
4,0,32},{53760,0,0,0},{0,4,0,274},{64320,4,0,32},{53762,0,0,0},{64320,4,0,32},
{54108,0,0,0},{0,4,0,274},{64320,4,0,32},{54121,0,0,0},{0,4,0,274},{64320,4,0,
32},{56335,0,0,0},{0,4,0,274},{64320,4,0,32},{56335,0,0,0},{0,4,0,275},{64320,4,
0,32},{56354,0,0,0},{0,4,0,274},{64320,4,0,32},{56355,0,0,0},{64320,4,0,32},
{56354,0,0,0},{64320,4,0,32},{56355,0,0,0},{0,4,0,274},{64320,4,0,32},{56819,0,
0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{57169,0,0,0},{64320,4,0,32},
{57168,0,0,0},{0,4,0,274},{64320,4,0,32},{57284,0,0,0},{64320,4,0,32},{57283,0,
0,0},{0,4,0,274},{64320,4,0,32},{57932,0,0,0},{64320,4,0,32},{58677,0,0,0},
{64320,4,0,32},{58849,0,0,0},{64320,4,0,32},{58853,0,0,0},{0,4,0,274},{64320,4,
0,32},{59144,0,0,0},{0,4,0,274},{64320,4,0,32},{60282,0,0,0},{0,4,0,274},{64320,
4,0,32},{60365,0,0,0},{64320,4,0,32},{60433,0,0,0},{64320,4,0,32},{60469,0,0,0},
{64320,4,0,32},{60474,0,0,0},{64320,4,0,32},{61548,0,0,0},{64320,4,0,32},{61995,
0,0,0},{64320,4,0,32},{61995,0,0,0},{0,4,0,274},{64320,4,0,32},{52780,0,0,0},
{64320,4,0,32},{62043,0,0,0},{0,4,0,274},{64320,4,0,32},{62125,0,0,0},{64320,4,
0,32},{62347,0,0,0},{0,4,0,274},{64320,4,0,32},{62859,0,0,0},{0,4,0,274},{64320,
4,0,32},{63214,0,0,0},{0,4,0,274},{64320,4,0,32},{63802,0,0,0},{0,4,0,274},
{64320,4,0,32},{63803,0,0,0},{64320,4,0,32},{64249,0,0,0},{0,4,0,274},{64320,4,
0,32},{64761,0,0,0},{64320,4,0,32},{65183,0,0,0},{64320,4,0,32},{65363,0,0,0},
{64320,4,0,32},{65362,0,0,0},{64320,4,0,32},{65363,0,0,0},{0,4,0,274},{64320,4,
0,32},{65363,0,0,0},{0,4,0,275},{64320,4,0,32},{65362,0,0,0},{0,4,0,274},{64320,
4,0,32},{65418,0,0,0},{0,4,0,274},{64320,4,0,32},{65418,0,0,0},{0,4,0,275},
{64320,4,0,32},{65419,0,0,0},{64321,4,0,32},{32770,0,0,0},{64321,4,0,32},{32896,
0,0,0},{64321,4,0,32},{32895,0,0,0},{0,4,0,274},{64321,4,0,32},{32905,0,0,0},{0,
4,0,274},{64321,4,0,32},{33276,0,0,0},{0,4,0,274},{64321,4,0,32},{33401,0,0,0},
{64321,4,0,32},{33401,0,0,0},{0,4,0,274},{64321,4,0,32},{33401,0,0,0},{0,4,0,
275},{64321,4,0,32},{34382,0,0,0},{64321,4,0,32},{34916,0,0,0},{64321,4,0,32},
{35200,0,0,0},{64321,4,0,32},{35199,0,0,0},{64321,4,0,32},{35265,0,0,0},{64321,
4,0,32},{35282,0,0,0},{64321,4,0,32},{35282,0,0,0},{0,4,0,274},{64321,4,0,32},
{35744,0,0,0},{64321,4,0,32},{36125,0,0,0},{64321,4,0,32},{36275,0,0,0},{0,4,0,
274},{64321,4,0,32},{36710,0,0,0},{64321,4,0,32},{36790,0,0,0},{64321,4,0,32},
{36790,0,0,0},{0,4,0,274},{64321,4,0,32},{36790,0,0,0},{0,4,0,275},{64321,4,0,
32},{37009,0,0,0},{0,4,0,274},{64321,4,0,32},{38021,0,0,0},{64321,4,0,32},
{38263,0,0,0},{64321,4,0,32},{38264,0,0,0},{64321,4,0,32},{38271,0,0,0},{64321,
4,0,32},{38376,0,0,0},{64321,4,0,32},{38428,0,0,0},{0,4,0,274},{64321,4,0,32},
{38429,0,0,0},{64321,4,0,32},{38632,0,0,0},{0,4,0,274},{64321,4,0,32},{38738,0,
0,0},{64321,4,0,32},{38886,0,0,0},{64321,4,0,32},{39029,0,0,0},{64321,4,0,32},
{39118,0,0,0},{64321,4,0,32},{39134,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,
4,0,32},{39136,0,0,0},{0,4,0,274},{64321,4,0,32},{39136,0,0,0},{64321,4,0,32},
{39267,0,0,0},{64321,4,0,32},{39318,0,0,0},{0,4,0,274},{64321,4,0,32},{39532,0,
0,0},{64321,4,0,32},{39592,0,0,0},{0,4,0,274},{64321,4,0,32},{39740,0,0,0},{0,4,
0,274},{64321,4,0,32},{40060,0,0,0},{64321,4,0,32},{40479,0,0,0},{64321,4,0,32},
{40565,0,0,0},{0,4,0,274},{64321,4,0,32},{40614,0,0,0},{64321,4,0,32},{40644,0,
0,0},{64321,4,0,32},{40702,0,0,0},{64321,4,0,32},{40778,0,0,0},{0,4,0,274},
{64321,4,0,32},{40784,0,0,0},{64321,4,0,32},{40786,0,0,0},{0,4,0,274},{64321,4,
0,32},{40831,0,0,0},{64321,4,0,32},{40845,0,0,0},{0,4,0,274},{64321,4,0,32},
{40857,0,0,0},{64321,4,0,32},{40860,0,0,0},{0,4,0,274},{64321,4,0,32},{40860,0,
0,0},{0,4,0,275},{64321,4,0,32},{40863,0,0,0},{64320,4,0,32},{52736,0,0,0},
{64320,4,0,32},{52776,0,0,0},{64320,4,0,32},{52790,0,0,0},{64320,4,0,32},{52799,
0,0,0},{64320,4,0,32},{52825,0,0,0},{64320,4,0,32},{52869,0,0,0},{64320,4,0,32},
{52876,0,0,0},{64320,4,0,32},{52896,0,0,0},{64320,4,0,32},{52922,0,0,0},{64320,
4,0,32},{53567,0,0,0},{64320,4,0,32},{53605,0,0,0},{64320,4,0,32},{53611,0,0,0},
{64320,4,0,32},{53634,0,0,0},{64320,4,0,32},{53654,0,0,0},{64320,4,0,32},{53675,
0,0,0},{64320,4,0,32},{53728,0,0,0},{64320,4,0,32},{53749,0,0,0},{64320,4,0,32},
{53760,0,0,0},{64320,4,0,32},{53915,0,0,0},{64320,4,0,32},{54009,0,0,0},{64320,
4,0,32},{54037,0,0,0},{64320,4,0,32},{54042,0,0,0},{64320,4,0,32},{54072,0,0,0},
{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},{54108,0,0,0},{64320,4,0,32},{54121,
0,0,0},{64320,4,0,32},{54146,0,0,0},{64320,4,0,32},{54198,0,0,0},{64320,4,0,32},
{54216,0,0,0},{64320,4,0,32},{54243,0,0,0},{64320,4,0,32},{54999,0,0,0},{64320,
4,0,32},{55071,0,0,0},{64320,4,0,32},{55531,0,0,0},{64320,4,0,32},{55554,0,0,0},
{64320,4,0,32},{55562,0,0,0},{64320,4,0,32},{55573,0,0,0},{64320,4,0,32},{55591,
0,0,0},{64320,4,0,32},{55667,0,0,0},{64320,4,0,32},{56144,0,0,0},{64320,4,0,32},
{56192,0,0,0},{64320,4,0,32},{56312,0,0,0},{64320,4,0,32},{56335,0,0,0},{64320,
4,0,32},{56354,0,0,0},{64320,4,0,32},{56376,0,0,0},{64320,4,0,32},{56430,0,0,0},
{64320,4,0,32},{56433,0,0,0},{64320,4,0,32},{56795,0,0,0},{64320,4,0,32},{56805,
0,0,0},{64320,4,0,32},{56817,0,0,0},{64320,4,0,32},{56830,0,0,0},{64320,4,0,32},
{56946,0,0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{56959,0,0,0},{64320,
4,0,32},{57076,0,0,0},{64320,4,0,32},{57086,0,0,0},{64320,4,0,32},{57099,0,0,0},
{64320,4,0,32},{57107,0,0,0},{64320,4,0,32},{57168,0,0,0},{64320,4,0,32},{57185,
0,0,0},{64320,4,0,32},{57203,0,0,0},{64320,4,0,32},{57283,0,0,0},{64320,4,0,32},
{57864,0,0,0},{64320,4,0,32},{57910,0,0,0},{64320,4,0,32},{57931,0,0,0},{64320,
4,0,32},{58671,0,0,0},{64320,4,0,32},{58676,0,0,0},{64320,4,0,32},{58759,0,0,0},
{64320,4,0,32},{58775,0,0,0},{64320,4,0,32},{58788,0,0,0},{64320,4,0,32},{58809,
0,0,0},{64320,4,0,32},{58848,0,0,0},{64320,4,0,32},{58853,0,0,0},{64320,4,0,32},
{59120,0,0,0},{64320,4,0,32},{59144,0,0,0},{64320,4,0,32},{59176,0,0,0},{64320,
4,0,32},{60192,0,0,0},{64320,4,0,32},{60258,0,0,0},{64320,4,0,32},{60281,0,0,0},
{64320,4,0,32},{60339,0,0,0},{64320,4,0,32},{60363,0,0,0},{64320,4,0,32},{60372,
0,0,0},{64320,4,0,32},{60379,0,0,0},{64320,4,0,32},{60431,0,0,0},{64320,4,0,32},
{60436,0,0,0},{64320,4,0,32},{60468,0,0,0},{64320,4,0,32},{61547,0,0,0},{64320,
4,0,32},{61994,0,0,0},{64320,4,0,32},{62006,0,0,0},{64320,4,0,32},{62011,0,0,0},
{64320,4,0,32},{62015,0,0,0},{64320,4,0,32},{62023,0,0,0},{64320,4,0,32},{62041,
0,0,0},{64320,4,0,32},{62043,0,0,0},{64320,4,0,32},{62124,0,0,0},{64320,4,0,32},
{62340,0,0,0},{64320,4,0,32},{62345,0,0,0},{64320,4,0,32},{62684,0,0,0},{64320,
4,0,32},{62694,0,0,0},{64320,4,0,32},{62744,0,0,0},{64320,4,0,32},{62751,0,0,0},
{64320,4,0,32},{62760,0,0,0},{64320,4,0,32},{62768,0,0,0},{64320,4,0,32},{62859,
0,0,0},{64320,4,0,32},{62866,0,0,0},{64320,4,0,32},{63094,0,0,0},{64320,4,0,32},
{63101,0,0,0},{64320,4,0,32},{63150,0,0,0},{64320,4,0,32},{63167,0,0,0},{64320,
4,0,32},{63214,0,0,0},{64320,4,0,32},{63451,0,0,0},{64320,4,0,32},{63458,0,0,0},
{64320,4,0,32},{63475,0,0,0},{64320,4,0,32},{63802,0,0,0},{64320,4,0,32},{63928,
0,0,0},{64320,4,0,32},{63934,0,0,0},{64320,4,0,32},{64116,0,0,0},{64320,4,0,32},
{64203,0,0,0},{64320,4,0,32},{64249,0,0,0},{64320,4,0,32},{64627,0,0,0},{64320,
4,0,32},{64760,0,0,0},{64320,4,0,32},{65334,0,0,0},{64320,4,0,32},{65361,0,0,0},
{64320,4,0,32},{65418,0,0,0},{64320,4,0,32},{65469,0,0,0},{64321,4,0,32},{32769,
0,0,0},{64321,4,0,32},{32780,0,0,0},{64321,4,0,32},{32786,0,0,0},{64321,4,0,32},
{32819,0,0,0},{64321,4,0,32},{32895,0,0,0},{64321,4,0,32},{32905,0,0,0},{64321,
4,0,32},{33251,0,0,0},{64321,4,0,32},{33258,0,0,0},{64321,4,0,32},{33267,0,0,0},
{64321,4,0,32},{33276,0,0,0},{64321,4,0,32},{33292,0,0,0},{64321,4,0,32},{33307,
0,0,0},{64321,4,0,32},{33311,0,0,0},{64321,4,0,32},{33390,0,0,0},{64321,4,0,32},
{33394,0,0,0},{64321,4,0,32},{33400,0,0,0},{64321,4,0,32},{34381,0,0,0},{64321,
4,0,32},{34411,0,0,0},{64321,4,0,32},{34880,0,0,0},{64321,4,0,32},{34892,0,0,0},
{64321,4,0,32},{34915,0,0,0},{64321,4,0,32},{35198,0,0,0},{64321,4,0,32},{35211,
0,0,0},{64321,4,0,32},{35282,0,0,0},{64321,4,0,32},{35328,0,0,0},{64321,4,0,32},
{35895,0,0,0},{64321,4,0,32},{35910,0,0,0},{64321,4,0,32},{35925,0,0,0},{64321,
4,0,32},{35960,0,0,0},{64321,4,0,32},{35997,0,0,0},{64321,4,0,32},{36196,0,0,0},
{64321,4,0,32},{36208,0,0,0},{64321,4,0,32},{36275,0,0,0},{64321,4,0,32},{36523,
0,0,0},{64321,4,0,32},{36554,0,0,0},{64321,4,0,32},{36763,0,0,0},{64321,4,0,32},
{36784,0,0,0},{64321,4,0,32},{36789,0,0,0},{64321,4,0,32},{37009,0,0,0},{64321,
4,0,32},{37193,0,0,0},{64321,4,0,32},{37318,0,0,0},{64321,4,0,32},{37324,0,0,0},
{64321,4,0,32},{37329,0,0,0},{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},{38272,
0,0,0},{64321,4,0,32},{38428,0,0,0},{64321,4,0,32},{38582,0,0,0},{64321,4,0,32},
{38585,0,0,0},{64321,4,0,32},{38632,0,0,0},{64321,4,0,32},{38737,0,0,0},{64321,
4,0,32},{38750,0,0,0},{64321,4,0,32},{38754,0,0,0},{64321,4,0,32},{38761,0,0,0},
{64321,4,0,32},{38859,0,0,0},{64321,4,0,32},{38893,0,0,0},{64321,4,0,32},{38899,
0,0,0},{64321,4,0,32},{38913,0,0,0},{64321,4,0,32},{39080,0,0,0},{64321,4,0,32},
{39131,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,4,0,32},{39318,0,0,0},{64321,
4,0,32},{39321,0,0,0},{64321,4,0,32},{39340,0,0,0},{64321,4,0,32},{39592,0,0,0},
{64321,4,0,32},{39640,0,0,0},{64321,4,0,32},{39647,0,0,0},{64321,4,0,32},{39717,
0,0,0},{64321,4,0,32},{39727,0,0,0},{64321,4,0,32},{39730,0,0,0},{64321,4,0,32},
{39740,0,0,0},{64321,4,0,32},{39770,0,0,0},{64321,4,0,32},{40165,0,0,0},{64321,
4,0,32},{40565,0,0,0},{64321,4,0,32},{40575,0,0,0},{64321,4,0,32},{40613,0,0,0},
{64321,4,0,32},{40635,0,0,0},{64321,4,0,32},{40643,0,0,0},{64321,4,0,32},{40653,
0,0,0},{64321,4,0,32},{40657,0,0,0},{64321,4,0,32},{40697,0,0,0},{64321,4,0,32},
{40701,0,0,0},{64321,4,0,32},{40718,0,0,0},{64321,4,0,32},{40723,0,0,0},{64321,
4,0,32},{40736,0,0,0},{64321,4,0,32},{40763,0,0,0},{64321,4,0,32},{40778,0,0,0},
{64321,4,0,32},{40786,0,0,0},{64321,4,0,32},{40845,0,0,0},{64321,4,0,32},{40860,
0,0,0},{64321,4,0,32},{40864,0,0,0},{16433,4,0,32},{16455,4,0,32},{7501,2,0,32},
{0,2,0,55},{7502,2,0,32},{0,2,0,55},{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},
{54084,0,0,0},{64320,4,0,32},{54085,0,0,0},{16452,4,0,32},{16434,4,0,32},{16427,
14,0,32},{0,2,0,55},{16428,14,0,32},{0,2,0,55},{16429,14,0,32},{0,2,0,55},
{16430,14,0,32},{0,2,0,55},{16431,14,0,32},{0,2,0,55},{16432,14,0,32},{0,2,0,
55},{16433,14,0,32},{0,2,0,55},{16434,14,0,32},{0,2,0,55},{16435,14,0,32},{0,2,
0,55},{16436,14,0,32},{0,2,0,55},{16437,14,0,32},{0,2,0,55},{16438,14,0,32},{0,
2,0,55},{16439,14,0,32},{0,2,0,55},{16440,14,0,32},{0,2,0,55},{16441,14,0,32},
{0,2,0,55},{16447,14,0,32},{0,2,0,55},{16447,14,0,32},{0,2,0,56},{16448,14,0,
32},{0,2,0,55},{16448,14,0,32},{0,2,0,56},{16449,14,0,32},{0,2,0,55},{16449,14,
0,32},{0,2,0,56},{16450,14,0,32},{0,2,0,55},{16450,14,0,32},{0,2,0,56},{16451,
14,0,32},{0,2,0,55},{16451,14,0,32},{0,2,0,56},{16423,14,0,32},{0,2,0,55},{7504,
2,0,32},{0,2,0,55},{16459,22,0,32},{16461,22,0,32},{16427,17,0,32},{0,2,0,55},
{16428,17,0,32},{0,2,0,55},{16429,17,0,32},{0,2,0,55},{16430,17,0,32},{0,2,0,
55},{16431,17,0,32},{0,2,0,55},{16432,17,0,32},{0,2,0,55},{16433,17,0,32},{0,2,
0,55},{16434,17,0,32},{0,2,0,55},{16435,17,0,32},{0,2,0,55},{16436,17,0,32},{0,
2,0,55},{16437,17,0,32},{0,2,0,55},{16438,17,0,32},{0,2,0,55},{16439,17,0,32},
{0,2,0,55},{16440,17,0,32},{0,2,0,55},{16441,17,0,32},{0,2,0,55},{16447,17,0,
32},{0,2,0,55},{16447,17,0,32},{0,2,0,56},{16448,17,0,32},{0,2,0,55},{16448,17,
0,32},{0,2,0,56},{16449,17,0,32},{0,2,0,55},{16449,17,0,32},{0,2,0,56},{16450,
17,0,32},{0,2,0,55},{16450,17,0,32},{0,2,0,56},{16451,17,0,32},{0,2,0,55},
{16451,17,0,32},{0,2,0,56},{16423,17,0,32},{0,2,0,55},{16465,17,0,32},{0,2,0,
55},{16466,17,0,32},{0,2,0,55},{16467,17,0,32},{0,2,0,55},{16468,17,0,32},{0,2,
0,55},{7506,2,0,32},{0,2,0,55},{16431,22,0,32},{16441,22,0,32},{64320,20,0,32},
{52736,0,0,0},{64320,20,0,32},{52876,0,0,0},{64320,20,0,32},{52745,0,0,0},
{64320,20,0,32},{55003,0,0,0},{64320,20,0,32},{52746,0,0,0},{64320,20,0,32},
{52781,0,0,0},{64320,20,0,32},{52747,0,0,0},{64320,20,0,32},{62770,0,0,0},
{64320,20,0,32},{52825,0,0,0},{64320,20,0,32},{52761,0,0,0},{64320,20,0,32},
{52737,0,0,0},{64320,20,0,32},{55593,0,0,0},{64320,20,0,32},{55088,0,0,0},
{64320,20,0,32},{52922,0,0,0},{16756,4,0,32},{0,4,0,275},{16780,4,0,32},{0,4,0,
275},{16772,4,0,32},{0,4,0,275},{16767,4,0,32},{0,4,0,275},{16791,4,0,32},{0,4,
0,275},{16787,4,0,32},{0,4,0,275},{16805,4,0,32},{0,4,0,276},{16786,4,0,32},{0,
4,0,275},{16804,4,0,32},{0,4,0,275},{16805,4,0,32},{0,4,0,275},{16792,4,0,32},
{0,4,0,275},{16794,4,0,32},{0,4,0,275},{16804,22,0,32},{0,22,0,275},{803,4,1,
32},{16064,4,0,32},{804,4,1,32},{803,4,1,32},{16066,4,0,32},{804,4,1,32},{803,4,
1,32},{16067,4,0,32},{804,4,1,32},{803,4,1,32},{16069,4,0,32},{804,4,1,32},{803,
4,1,32},{16070,4,0,32},{804,4,1,32},{803,4,1,32},{16071,4,0,32},{804,4,1,32},
{803,4,1,32},{16073,4,0,32},{804,4,1,32},{803,4,1,32},{16075,4,0,32},{804,4,1,
32},{803,4,1,32},{16076,4,0,32},{804,4,1,32},{803,4,1,32},{16078,4,0,32},{804,4,
1,32},{803,4,1,32},{16079,4,0,32},{804,4,1,32},{803,4,1,32},{16080,4,0,32},{804,
4,1,32},{803,4,1,32},{16081,4,0,32},{804,4,1,32},{803,4,1,32},{16082,4,0,32},
{804,4,1,32},{803,4,1,32},{16064,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,
32},{16066,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16067,4,0,32},
{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16069,4,0,32},{16190,4,0,32},{804,4,1,
32},{803,4,1,32},{16070,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16071,
4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16073,4,0,32},{16190,4,0,32},
{804,4,1,32},{803,4,1,32},{16075,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,
32},{16076,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16078,4,0,32},
{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16079,4,0,32},{16190,4,0,32},{804,4,1,
32},{803,4,1,32},{16080,4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16081,
4,0,32},{16190,4,0,32},{804,4,1,32},{803,4,1,32},{16082,4,0,32},{16190,4,0,32},
{804,4,1,32},{803,4,1,32},{16076,4,0,32},{16203,4,0,32},{804,4,1,32},{803,4,1,
32},{16075,4,0,32},{16198,4,0,32},{16076,4,0,32},{16194,4,0,32},{16287,4,0,32},
{804,4,1,32},{803,4,1,32},{16075,4,0,32},{16198,4,0,32},{16082,4,0,32},{16203,4,
0,32},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{52736,0,0,0},{804,4,1,32},{803,
4,1,32},{64320,4,0,32},{52876,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},
{52745,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{55003,0,0,0},{804,4,1,
32},{803,4,1,32},{64320,4,0,32},{52884,0,0,0},{804,4,1,32},{803,4,1,32},{64320,
4,0,32},{53613,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{52739,0,0,0},
{804,4,1,32},{803,4,1,32},{64320,4,0,32},{53611,0,0,0},{804,4,1,32},{803,4,1,
32},{64320,4,0,32},{52829,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},
{54081,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{59144,0,0,0},{804,4,1,
32},{803,4,1,32},{64320,4,0,32},{61547,0,0,0},{804,4,1,32},{803,4,1,32},{64320,
4,0,32},{60468,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{59176,0,0,0},
{804,4,1,32},{803,4,1,32},{64321,4,0,32},{37329,0,0,0},{804,4,1,32},{803,4,1,
32},{64320,4,0,32},{55071,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},
{58853,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{59434,0,0,0},{804,4,1,
32},{803,4,1,32},{64320,4,0,32},{59145,0,0,0},{804,4,1,32},{803,4,1,32},{64320,
4,0,32},{63806,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{54285,0,0,0},
{804,4,1,32},{803,4,1,32},{64320,4,0,32},{62073,0,0,0},{804,4,1,32},{803,4,1,
32},{64321,4,0,32},{36001,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},
{63837,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{53940,0,0,0},{804,4,1,
32},{803,4,1,32},{64320,4,0,32},{52963,0,0,0},{804,4,1,32},{803,4,1,32},{64320,
4,0,32},{54396,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{56166,0,0,0},
{804,4,1,32},{803,4,1,32},{64320,4,0,32},{63203,0,0,0},{804,4,1,32},{803,4,1,
32},{64320,4,0,32},{52993,0,0,0},{804,4,1,32},{803,4,1,32},{64321,4,0,32},
{36039,0,0,0},{804,4,1,32},{803,4,1,32},{64320,4,0,32},{54100,0,0,0},{804,4,1,
32},{803,4,1,32},{64320,4,0,32},{63853,0,0,0},{804,4,1,32},{803,4,1,32},{64320,
4,0,32},{53009,0,0,0},{804,4,1,32},{803,4,1,32},{64321,4,0,32},{33258,0,0,0},
{804,4,1,32},{803,4,1,32},{64321,4,0,32},{33267,0,0,0},{804,4,1,32},{64320,6,0,
32},{54607,0,0,0},{64320,6,0,32},{56956,0,0,0},{64320,6,0,32},{58759,0,0,0},
{64320,6,0,32},{64399,0,0,0},{7557,6,0,32},{7556,6,0,32},{7558,6,0,32},{7556,6,
0,32},{7559,6,0,32},{7556,6,0,32},{7560,6,0,32},{7556,6,0,32},{7561,6,0,32},
{7556,6,0,32},{7562,6,0,32},{7556,6,0,32},{7563,6,0,32},{7556,6,0,32},{7564,6,0,
32},{7556,6,0,32},{8019,29,0,32},{8157,29,0,32},{7665,29,0,32},{7558,6,0,32},
{7557,6,0,32},{7558,6,0,32},{7558,6,0,32},{7558,6,0,32},{7559,6,0,32},{7558,6,0,
32},{7560,6,0,32},{7558,6,0,32},{7561,6,0,32},{7558,6,0,32},{7562,6,0,32},{7558,
6,0,32},{7563,6,0,32},{7558,6,0,32},{7564,6,0,32},{7558,6,0,32},{7565,6,0,32},
{7559,6,0,32},{7556,6,0,32},{7559,6,0,32},{7557,6,0,32},{7559,6,0,32},{7558,6,0,
32},{7559,6,0,32},{7559,6,0,32},{7559,6,0,32},{7560,6,0,32},{7559,6,0,32},{7561,
6,0,32},{16064,6,0,32},{16190,6,0,32},{16066,6,0,32},{16190,6,0,32},{16067,6,0,
32},{16190,6,0,32},{16069,6,0,32},{16190,6,0,32},{16070,6,0,32},{16190,6,0,32},
{16071,6,0,32},{16190,6,0,32},{16073,6,0,32},{16190,6,0,32},{16075,6,0,32},
{16190,6,0,32},{16076,6,0,32},{16190,6,0,32},{16078,6,0,32},{16190,6,0,32},
{16079,6,0,32},{16190,6,0,32},{16080,6,0,32},{16190,6,0,32},{16081,6,0,32},
{16190,6,0,32},{16082,6,0,32},{16190,6,0,32},{16078,6,0,32},{16190,6,0,32},
{16299,6,0,32},{16064,6,0,32},{16198,6,0,32},{16076,6,0,32},{16203,6,0,32},
{16075,6,0,32},{16209,6,0,32},{16075,6,0,32},{16203,6,0,32},{64320,6,0,32},
{52736,0,0,0},{64320,6,0,32},{52876,0,0,0},{64320,6,0,32},{52745,0,0,0},{64320,
6,0,32},{55003,0,0,0},{64320,6,0,32},{52884,0,0,0},{64320,6,0,32},{53613,0,0,0},
{64320,6,0,32},{52739,0,0,0},{64320,6,0,32},{53611,0,0,0},{64320,6,0,32},{52829,
0,0,0},{64320,6,0,32},{54081,0,0,0},{64320,6,0,32},{59144,0,0,0},{64320,6,0,32},
{61547,0,0,0},{64320,6,0,32},{60468,0,0,0},{64320,6,0,32},{59176,0,0,0},{64321,
6,0,32},{37329,0,0,0},{64320,6,0,32},{55071,0,0,0},{64320,6,0,32},{58853,0,0,0},
{64320,6,0,32},{59434,0,0,0},{64320,6,0,32},{59145,0,0,0},{64320,6,0,32},{63806,
0,0,0},{64320,6,0,32},{54285,0,0,0},{64320,6,0,32},{62073,0,0,0},{64321,6,0,32},
{36001,0,0,0},{64320,6,0,32},{63837,0,0,0},{64320,6,0,32},{53940,0,0,0},{64320,
6,0,32},{63960,0,0,0},{64320,6,0,32},{62775,0,0,0},{64320,6,0,32},{55667,0,0,0},
{64321,6,0,32},{36969,0,0,0},{64320,6,0,32},{53546,0,0,0},{64320,6,0,32},{54128,
0,0,0},{64320,6,0,32},{60648,0,0,0},{64321,6,0,32},{38917,0,0,0},{64320,6,0,32},
{53009,0,0,0},{64320,6,0,32},{53657,0,0,0},{64320,6,0,32},{60259,0,0,0},{64320,
6,0,32},{52746,0,0,0},{64320,6,0,32},{52781,0,0,0},{64320,6,0,32},{52747,0,0,0},
{64320,6,0,32},{56806,0,0,0},{64320,6,0,32},{54259,0,0,0},{64320,6,0,32},{54075,
0,0,0},{64320,6,0,32},{56215,0,0,0},{64320,6,0,32},{56166,0,0,0},{64320,6,0,32},
{63203,0,0,0},{64320,6,0,32},{52993,0,0,0},{64321,6,0,32},{36039,0,0,0},{64320,
6,0,32},{54100,0,0,0},{64320,6,0,32},{55580,0,0,0},{7559,6,0,32},{7562,6,0,32},
{7559,6,0,32},{7563,6,0,32},{7559,6,0,32},{7564,6,0,32},{7559,6,0,32},{7565,6,0,
32},{7560,6,0,32},{7556,6,0,32},{7560,6,0,32},{7557,6,0,32},{7560,6,0,32},{7558,
6,0,32},{7560,6,0,32},{7559,6,0,32},{7560,6,0,32},{7560,6,0,32},{7560,6,0,32},
{7561,6,0,32},{7560,6,0,32},{7562,6,0,32},{7560,6,0,32},{7563,6,0,32},{7560,6,0,
32},{7564,6,0,32},{7560,6,0,32},{7565,6,0,32},{7561,6,0,32},{7556,6,0,32},{7557,
4,0,32},{64320,4,0,32},{59144,0,0,0},{7558,4,0,32},{64320,4,0,32},{59144,0,0,0},
{7559,4,0,32},{64320,4,0,32},{59144,0,0,0},{7560,4,0,32},{64320,4,0,32},{59144,
0,0,0},{7561,4,0,32},{64320,4,0,32},{59144,0,0,0},{7562,4,0,32},{64320,4,0,32},
{59144,0,0,0},{7563,4,0,32},{64320,4,0,32},{59144,0,0,0},{7564,4,0,32},{64320,4,
0,32},{59144,0,0,0},{7565,4,0,32},{64320,4,0,32},{59144,0,0,0},{7557,4,0,32},
{7556,4,0,32},{64320,4,0,32},{59144,0,0,0},{7557,4,0,32},{7557,4,0,32},{64320,4,
0,32},{59144,0,0,0},{7557,4,0,32},{7558,4,0,32},{64320,4,0,32},{59144,0,0,0},
{7775,29,0,32},{7739,28,0,32},{7665,28,0,32},{8059,28,0,32},{7739,28,0,32},
{7665,28,0,32},{8236,29,0,32},{7870,29,0,32},{8157,29,0,32},{7638,29,0,32},
{16421,28,0,32},{16447,28,0,32},{0,28,0,56},{7505,28,0,32},{16441,28,0,32},
{16421,28,0,32},{16462,28,0,32},{16449,28,0,32},{16421,28,0,32},{16421,28,0,32},
{16469,28,0,32},{16450,28,0,32},{0,28,0,56},{16421,28,0,32},{16421,28,0,32},
{7505,28,0,32},{16462,28,0,32},{16422,28,0,32},{16443,28,0,32},{16469,28,0,32},
{16429,28,0,32},{0,28,0,55},{16422,28,0,32},{16469,28,0,32},{16438,28,0,32},
{16423,28,0,32},{16426,28,0,32},{16469,28,0,32},{16425,28,0,32},{16434,28,0,32},
{16429,28,0,32},{7505,28,0,32},{16441,28,0,32},{0,28,0,55},{16425,28,0,32},
{7505,28,0,32},{16427,28,0,32},{7505,28,0,32},{16426,28,0,32},{16469,28,0,32},
{16434,28,0,32},{16426,28,0,32},{7505,28,0,32},{16454,28,0,32},{16427,28,0,32},
{16422,28,0,32},{16461,28,0,32},{16427,28,0,32},{16460,28,0,32},{16439,28,0,32},
{16441,28,0,32},{16427,28,0,32},{16464,28,0,32},{16461,28,0,32},{7505,28,0,32},
{16427,28,0,32},{0,28,0,55},{16464,28,0,32},{16469,28,0,32},{16427,28,0,32},{0,
28,0,55},{16469,28,0,32},{16452,28,0,32},{16428,28,0,32},{0,28,0,55},{16427,28,
0,32},{0,28,0,55},{16428,28,0,32},{0,28,0,55},{16443,28,0,32},{7505,28,0,32},
{16428,28,0,32},{16458,28,0,32},{16461,28,0,32},{7505,28,0,32},{16428,28,0,32},
{0,28,0,55},{16462,28,0,32},{16437,28,0,32},{0,28,0,55},{7505,28,0,32},{16428,
28,0,32},{16464,28,0,32},{16428,28,0,32},{16464,28,0,32},{16429,28,0,32},{0,28,
0,55},{16460,28,0,32},{16454,28,0,32},{16428,28,0,32},{16464,28,0,32},{16455,28,
0,32},{7505,28,0,32},{16441,28,0,32},{16462,28,0,32},{16428,28,0,32},{16464,28,
0,32},{16465,28,0,32},{16439,28,0,32},{16441,28,0,32},{16429,28,0,32},{0,28,0,
55},{16460,28,0,32},{16454,28,0,32},{16429,28,0,32},{0,28,0,55},{16460,28,0,32},
{16454,28,0,32},{16441,28,0,32},{16469,28,0,32},{16429,28,0,32},{16462,28,0,32},
{16435,28,0,32},{0,28,0,55},{16422,28,0,32},{16464,28,0,32},{16429,28,0,32},
{16464,28,0,32},{7505,28,0,32},{16445,28,0,32},{16430,28,0,32},{7505,28,0,32},
{16434,28,0,32},{16431,28,0,32},{16462,28,0,32},{16442,28,0,32},{16431,28,0,32},
{7505,28,0,32},{16451,28,0,32},{0,28,0,56},{16432,28,0,32},{16422,28,0,32},
{16429,28,0,32},{16462,28,0,32},{16432,28,0,32},{16469,28,0,32},{16438,28,0,32},
{7505,28,0,32},{16454,28,0,32},{16433,28,0,32},{16461,28,0,32},{16469,28,0,32},
{16429,28,0,32},{0,28,0,55},{16435,28,0,32},{16469,28,0,32},{16438,28,0,32},
{16435,28,0,32},{16469,28,0,32},{16441,28,0,32},{16437,28,0,32},{0,28,0,55},
{7505,28,0,32},{16434,28,0,32},{16440,28,0,32},{0,28,0,55},{16433,28,0,32},
{16441,28,0,32},{0,28,0,55},{16462,28,0,32},{16441,28,0,32},{16469,28,0,32},
{16442,28,0,32},{16446,28,0,32},{16446,28,0,32},{16439,28,0,32},{16441,28,0,32},
{16447,28,0,32},{16422,28,0,32},{16439,28,0,32},{16447,28,0,32},{0,28,0,56},
{7505,28,0,32},{16435,28,0,32},{16469,28,0,32},{16441,28,0,32},{16447,28,0,32},
{0,28,0,56},{7505,28,0,32},{16439,28,0,32},{16447,28,0,32},{0,28,0,55},{7505,28,
0,32},{16463,28,0,32},{16462,28,0,32},{16448,28,0,32},{0,28,0,56},{16421,28,0,
32},{16434,28,0,32},{16441,28,0,32},{16462,28,0,32},{16448,28,0,32},{0,28,0,56},
{16429,28,0,32},{16462,28,0,32},{16448,28,0,32},{0,28,0,56},{16431,28,0,32},
{16448,28,0,32},{0,28,0,55},{16462,28,0,32},{16449,28,0,32},{16421,28,0,32},
{16460,28,0,32},{16439,28,0,32},{16441,28,0,32},{0,28,0,55},{16449,28,0,32},
{16422,28,0,32},{7505,28,0,32},{16441,28,0,32},{16449,28,0,32},{0,28,0,55},
{16439,28,0,32},{16433,28,0,32},{16425,28,0,32},{16462,28,0,32},{16449,28,0,32},
{16460,28,0,32},{16469,28,0,32},{16450,28,0,32},{16429,28,0,32},{16437,28,0,32},
{7505,28,0,32},{16462,28,0,32},{16450,28,0,32},{0,28,0,56},{16436,28,0,32},
{16450,28,0,32},{0,28,0,56},{16443,28,0,32},{16448,28,0,32},{16450,28,0,32},
{16462,28,0,32},{16439,28,0,32},{16450,28,0,32},{0,28,0,56},{16469,28,0,32},
{16434,28,0,32},{16450,28,0,32},{0,28,0,56},{7505,28,0,32},{16433,28,0,32},{0,
28,0,55},{16450,28,0,32},{0,28,0,55},{7505,28,0,32},{16437,28,0,32},{16451,28,0,
32},{0,28,0,56},{16422,28,0,32},{16469,28,0,32},{16441,28,0,32},{16451,28,0,32},
{0,28,0,55},{16462,28,0,32},{16441,28,0,32},{16451,28,0,32},{16469,28,0,32},
{16451,28,0,32},{0,28,0,56},{16469,28,0,32},{16441,28,0,32},{0,28,0,55},{16451,
28,0,32},{7505,28,0,32},{16462,28,0,32},{16451,28,0,32},{7505,28,0,32},{16469,
28,0,32},{16452,28,0,32},{16422,28,0,32},{16429,28,0,32},{16464,28,0,32},{16452,
28,0,32},{16422,28,0,32},{16462,28,0,32},{16452,28,0,32},{16439,28,0,32},{16447,
28,0,32},{16452,28,0,32},{16462,28,0,32},{16429,28,0,32},{16452,28,0,32},{16469,
28,0,32},{16433,28,0,32},{16459,28,0,32},{16469,28,0,32},{16453,28,0,32},{16429,
28,0,32},{16464,28,0,32},{16469,28,0,32},{16453,28,0,32},{16461,28,0,32},{16453,
28,0,32},{16461,28,0,32},{16447,28,0,32},{0,28,0,55},{7505,28,0,32},{16462,28,0,
32},{16455,28,0,32},{16427,28,0,32},{0,28,0,55},{16455,28,0,32},{16427,28,0,32},
{0,28,0,55},{16441,28,0,32},{16469,28,0,32},{16455,28,0,32},{7505,28,0,32},
{16441,28,0,32},{16462,28,0,32},{16457,28,0,32},{7505,28,0,32},{16441,28,0,32},
{0,28,0,55},{16457,28,0,32},{7505,28,0,32},{16462,28,0,32},{16458,28,0,32},
{16421,28,0,32},{16469,28,0,32},{16461,28,0,32},{16439,28,0,32},{16441,28,0,32},
{16462,28,0,32},{16461,28,0,32},{16460,28,0,32},{16462,28,0,32},{16448,28,0,32},
{0,28,0,56},{7505,28,0,32},{16462,28,0,32},{7505,28,0,32},{16449,28,0,32},{0,28,
0,55},{16462,28,0,32},{16463,28,0,32},{16454,28,0,32},{16463,28,0,32},{16469,28,
0,32},{16441,28,0,32},{16430,28,0,32},{0,28,0,55},{16469,28,0,32},{16465,28,0,
32},{16439,28,0,32},{16441,28,0,32},{7556,4,0,32},{64320,4,0,32},{61625,0,0,0},
{7557,4,0,32},{64320,4,0,32},{61625,0,0,0},{7558,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7559,4,0,32},{64320,4,0,32},{61625,0,0,0},{7560,4,0,32},{64320,4,0,32},
{61625,0,0,0},{7561,4,0,32},{64320,4,0,32},{61625,0,0,0},{7562,4,0,32},{64320,4,
0,32},{61625,0,0,0},{7563,4,0,32},{64320,4,0,32},{61625,0,0,0},{7564,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7565,4,0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,
0,32},{7556,4,0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},{7557,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},{7558,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7557,4,0,32},{7559,4,0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},
{7560,4,0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},{7561,4,0,32},{64320,4,
0,32},{61625,0,0,0},{7557,4,0,32},{7562,4,0,32},{64320,4,0,32},{61625,0,0,0},
{7557,4,0,32},{7563,4,0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},{7564,4,
0,32},{64320,4,0,32},{61625,0,0,0},{7557,4,0,32},{7565,4,0,32},{64320,4,0,32},
{61625,0,0,0},{7558,4,0,32},{7556,4,0,32},{64320,4,0,32},{61625,0,0,0},{7558,4,
0,32},{7557,4,0,32},{64320,4,0,32},{61625,0,0,0},{7558,4,0,32},{7558,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7558,4,0,32},{7559,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7558,4,0,32},{7560,4,0,32},{64320,4,0,32},{61625,0,0,0},{7775,28,0,32},
{8019,29,0,32},{7566,28,0,32},{7638,28,0,32},{7566,28,0,32},{7566,29,0,32},
{8189,29,0,32},{7591,28,0,32},{7566,28,0,32},{8059,28,0,32},{7972,28,0,32},
{8236,29,0,32},{8019,28,0,32},{7617,28,0,32},{7638,28,0,32},{7921,28,0,32},
{7638,28,0,32},{7921,28,0,32},{7558,28,0,32},{7638,28,0,32},{7921,28,0,32},
{7559,28,0,32},{7801,29,0,32},{8189,29,0,32},{64320,28,0,32},{56947,0,0,0},
{64320,28,0,32},{57872,0,0,0},{64320,28,0,32},{58925,0,0,0},{64320,28,0,32},
{54412,0,0,0},{64320,28,0,32},{55591,0,0,0},{64320,28,0,32},{60259,0,0,0},
{64320,28,0,32},{58894,0,0,0},{64320,28,0,32},{60603,0,0,0},{64320,28,0,32},
{59434,0,0,0},{64320,28,0,32},{57103,0,0,0},{64320,28,0,32},{53018,0,0,0},
{64320,28,0,32},{63806,0,0,0},{8019,28,0,32},{7566,29,0,32},{7936,28,0,32},
{7566,29,0,32},{8468,28,0,32},{7566,29,0,32},{7921,28,0,32},{7566,29,0,32},
{7852,28,0,32},{7566,29,0,32},{7852,29,0,32},{7591,29,0,32},{7921,29,0,32},
{7591,29,0,32},{7739,29,0,32},{7591,29,0,32},{7617,28,0,32},{7566,28,0,32},
{7870,28,0,32},{7852,28,0,32},{7617,28,0,32},{7566,28,0,32},{7870,28,0,32},
{8019,28,0,32},{7724,29,0,32},{7936,28,0,32},{7724,29,0,32},{8468,28,0,32},
{7724,29,0,32},{8468,28,0,32},{7739,28,0,32},{7921,28,0,32},{7739,28,0,32},
{7852,28,0,32},{7739,28,0,32},{7775,29,0,32},{8298,28,0,32},{7852,28,0,32},
{7775,29,0,32},{8298,28,0,32},{7921,29,0,32},{7775,29,0,32},{8298,28,0,32},
{7739,29,0,32},{7775,29,0,32},{8298,28,0,32},{8157,29,0,32},{7775,29,0,32},
{8298,28,0,32},{8468,28,0,32},{7870,28,0,32},{7921,28,0,32},{7870,28,0,32},
{7638,28,0,32},{7870,28,0,32},{7852,28,0,32},{7870,28,0,32},{7724,28,0,32},
{7921,28,0,32},{7936,28,0,32},{7921,28,0,32},{8468,28,0,32},{7921,28,0,32},
{7921,28,0,32},{7921,28,0,32},{7617,28,0,32},{7921,28,0,32},{7852,28,0,32},
{7921,28,0,32},{7921,28,0,32},{7921,28,0,32},{7558,28,0,32},{7617,28,0,32},
{7921,28,0,32},{7558,28,0,32},{7921,28,0,32},{7558,28,0,32},{7852,28,0,32},
{7921,28,0,32},{7558,28,0,32},{7921,28,0,32},{7921,28,0,32},{7559,28,0,32},
{7617,28,0,32},{7921,28,0,32},{7559,28,0,32},{7921,28,0,32},{7559,28,0,32},
{7852,28,0,32},{7921,28,0,32},{7559,28,0,32},{7921,28,0,32},{1614,28,1,32},
{8121,28,0,32},{7921,28,0,32},{1614,28,1,32},{8121,28,0,32},{7558,28,0,32},
{8019,29,0,32},{7566,28,0,32},{7852,28,0,32},{8019,29,0,32},{7566,28,0,32},
{7921,29,0,32},{8019,29,0,32},{7566,28,0,32},{7739,29,0,32},{8019,29,0,32},
{7566,28,0,32},{8059,28,0,32},{7566,28,0,32},{7638,28,0,32},{8059,28,0,32},
{7566,28,0,32},{7638,28,0,32},{1614,28,1,32},{8121,28,0,32},{8059,28,0,32},
{7566,28,0,32},{7638,28,0,32},{1614,28,1,32},{8121,28,0,32},{7558,28,0,32},
{8019,28,0,32},{8121,28,0,32},{7936,28,0,32},{8121,28,0,32},{8468,28,0,32},
{8121,28,0,32},{7921,28,0,32},{8121,28,0,32},{8019,28,0,32},{8236,29,0,32},
{7936,28,0,32},{8236,29,0,32},{8468,28,0,32},{8236,29,0,32},{7921,28,0,32},
{8236,29,0,32},{7852,28,0,32},{8236,29,0,32},{7921,29,0,32},{8236,29,0,32},
{8019,28,0,32},{8254,29,0,32},{7936,28,0,32},{8254,29,0,32},{8468,28,0,32},
{8254,29,0,32},{7921,28,0,32},{8254,29,0,32},{7852,28,0,32},{8254,29,0,32},
{7921,29,0,32},{8254,29,0,32},{7852,28,0,32},{8490,29,0,32},{7921,29,0,32},
{8490,29,0,32},{7566,28,0,32},{635,28,1,32},{7921,28,0,32},{635,28,1,32},{7591,
29,0,32},{8040,28,0,32},{7617,28,0,32},{7617,28,0,32},{7617,28,0,32},{7638,28,0,
32},{7617,29,0,32},{1614,28,1,32},{7852,28,0,32},{7739,28,0,32},{7617,29,0,32},
{7972,28,0,32},{635,28,1,32},{7638,28,0,32},{7591,29,0,32},{7739,29,0,32},{8276,
28,0,32},{7775,28,0,32},{7566,28,0,32},{7775,29,0,32},{8019,29,0,32},{7801,28,0,
32},{7936,28,0,32},{7852,29,0,32},{7852,29,0,32},{7852,29,0,32},{7921,29,0,32},
{7852,28,0,32},{8157,28,0,32},{7870,28,0,32},{7921,28,0,32},{7870,28,0,32},
{7936,28,0,32},{7870,28,0,32},{7972,28,0,32},{7739,28,0,32},{7870,28,0,32},
{8264,28,0,32},{7921,28,0,32},{7591,28,0,32},{7921,28,0,32},{7801,28,0,32},
{7870,28,0,32},{7921,28,0,32},{7972,28,0,32},{7870,28,0,32},{8019,29,0,32},
{7775,29,0,32},{8019,28,0,32},{635,28,1,32},{7921,28,0,32},{635,28,1,32},{8019,
29,0,32},{8019,29,0,32},{7921,29,0,32},{8019,29,0,32},{8059,29,0,32},{8121,28,0,
32},{8059,28,0,32},{8121,29,0,32},{8236,28,0,32},{8254,29,0,32},{7591,28,0,32},
{8236,29,0,32},{1614,28,1,32},{7921,28,0,32},{7566,29,0,32},{1614,28,1,32},
{7921,28,0,32},{7557,4,0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},{64320,
4,0,32},{58853,0,0,0},{7559,4,0,32},{64320,4,0,32},{58853,0,0,0},{7560,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7561,4,0,32},{64320,4,0,32},{58853,0,0,0},{7562,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7563,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7564,4,0,32},{64320,4,0,32},{58853,0,0,0},{7565,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7557,4,0,32},{7556,4,0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,0,32},
{7557,4,0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,0,32},{7558,4,0,32},{64320,4,
0,32},{58853,0,0,0},{7557,4,0,32},{7559,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7557,4,0,32},{7560,4,0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,0,32},{7561,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,0,32},{7562,4,0,32},{64320,4,0,32},
{58853,0,0,0},{7557,4,0,32},{7563,4,0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,
0,32},{7564,4,0,32},{64320,4,0,32},{58853,0,0,0},{7557,4,0,32},{7565,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},{7556,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7558,4,0,32},{7557,4,0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},
{7558,4,0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},{7559,4,0,32},{64320,4,
0,32},{58853,0,0,0},{7558,4,0,32},{7560,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7558,4,0,32},{7561,4,0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},{7562,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,0,32},{7563,4,0,32},{64320,4,0,32},
{58853,0,0,0},{7558,4,0,32},{7564,4,0,32},{64320,4,0,32},{58853,0,0,0},{7558,4,
0,32},{7565,4,0,32},{64320,4,0,32},{58853,0,0,0},{7559,4,0,32},{7556,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7559,4,0,32},{7557,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7739,28,0,32},{7566,28,0,32},{7870,28,0,32},{64384,2,0,32},{46238,0,0,
0},{64384,2,0,32},{46265,0,0,0},{64384,2,0,32},{46267,0,0,0},{64384,2,0,32},
{46303,0,0,0},{64384,2,0,32},{46357,0,0,0},{64384,2,0,32},{46830,0,0,0},{64384,
2,0,32},{46844,0,0,0},{64384,2,0,32},{46977,0,0,0},{64384,2,0,32},{47151,0,0,0},
{64384,2,0,32},{47202,0,0,0},{64384,2,0,32},{47228,0,0,0},{64384,2,0,32},{47303,
0,0,0},{64384,2,0,32},{47331,0,0,0},{64384,2,0,32},{47388,0,0,0},{64384,2,0,32},
{47418,0,0,0},{64384,2,0,32},{47662,0,0,0},{64384,2,0,32},{47724,0,0,0},{64384,
2,0,32},{47844,0,0,0},{64384,2,0,32},{47880,0,0,0},{64384,2,0,32},{47897,0,0,0},
{64384,2,0,32},{47945,0,0,0},{64384,2,0,32},{48029,0,0,0},{64384,2,0,32},{48152,
0,0,0},{64384,2,0,32},{48206,0,0,0},{64384,2,0,32},{48435,0,0,0},{64384,2,0,32},
{48534,0,0,0},{64384,2,0,32},{48812,0,0,0},{64384,2,0,32},{48824,0,0,0},{64384,
2,0,32},{48923,0,0,0},{64384,2,0,32},{49148,0,0,0},{64384,2,0,32},{49160,0,0,0},
{64384,2,0,32},{49176,0,0,0},{64384,2,0,32},{49209,0,0,0},{64384,2,0,32},{49222,
0,0,0},{64384,2,0,32},{49302,0,0,0},{64384,2,0,32},{49379,0,0,0},{64384,2,0,32},
{49455,0,0,0},{64384,2,0,32},{49666,0,0,0},{64384,2,0,32},{49703,0,0,0},{64384,
2,0,32},{49824,0,0,0},{64384,2,0,32},{49921,0,0,0},{64384,2,0,32},{49972,0,0,0},
{64384,2,0,32},{50009,0,0,0},{64384,2,0,32},{50133,0,0,0},{64384,2,0,32},{50137,
0,0,0},{64384,2,0,32},{50187,0,0,0},{64384,2,0,32},{50283,0,0,0},{64384,2,0,32},
{50475,0,0,0},{64384,2,0,32},{50525,0,0,0},{64384,2,0,32},{50529,0,0,0},{64384,
2,0,32},{50539,0,0,0},{64384,2,0,32},{50647,0,0,0},{64384,2,0,32},{50681,0,0,0},
{64384,2,0,32},{50741,0,0,0},{64384,2,0,32},{50878,0,0,0},{64384,2,0,32},{50887,
0,0,0},{64384,2,0,32},{51605,0,0,0},{64384,2,0,32},{51686,0,0,0},{64384,2,0,32},
{51822,0,0,0},{64384,2,0,32},{51830,0,0,0},{64384,2,0,32},{51890,0,0,0},{64384,
2,0,32},{52019,0,0,0},{64384,2,0,32},{52174,0,0,0},{64384,2,0,32},{52430,0,0,0},
{64384,2,0,32},{52461,0,0,0},{64384,2,0,32},{52472,0,0,0},{64384,2,0,32},{52566,
0,0,0},{64320,2,0,32},{52749,0,0,0},{64320,2,0,32},{52774,0,0,0},{64320,2,0,32},
{52786,0,0,0},{64320,2,0,32},{52792,0,0,0},{64320,2,0,32},{52793,0,0,0},{64320,
2,0,32},{52797,0,0,0},{64320,2,0,32},{52801,0,0,0},{64320,2,0,32},{52866,0,0,0},
{64320,2,0,32},{52870,0,0,0},{64320,2,0,32},{52910,0,0,0},{64320,2,0,32},{52928,
0,0,0},{64320,2,0,32},{52940,0,0,0},{64320,2,0,32},{52964,0,0,0},{64320,2,0,32},
{53088,0,0,0},{64320,2,0,32},{53120,0,0,0},{64320,2,0,32},{53126,0,0,0},{64320,
2,0,32},{53131,0,0,0},{64320,2,0,32},{53166,0,0,0},{64320,2,0,32},{53179,0,0,0},
{64320,2,0,32},{53183,0,0,0},{64320,2,0,32},{53250,0,0,0},{64320,2,0,32},{53291,
0,0,0},{64320,2,0,32},{53370,0,0,0},{64320,2,0,32},{53401,0,0,0},{64320,2,0,32},
{53455,0,0,0},{64320,2,0,32},{53466,0,0,0},{64320,2,0,32},{53479,0,0,0},{64320,
2,0,32},{53568,0,0,0},{64320,2,0,32},{53573,0,0,0},{64320,2,0,32},{53581,0,0,0},
{64320,2,0,32},{53588,0,0,0},{64320,2,0,32},{53604,0,0,0},{64320,2,0,32},{53607,
0,0,0},{64320,2,0,32},{53608,0,0,0},{64320,2,0,32},{53609,0,0,0},{64320,2,0,32},
{53613,0,0,0},{64320,2,0,32},{53623,0,0,0},{64320,2,0,32},{53632,0,0,0},{64320,
2,0,32},{53645,0,0,0},{64320,2,0,32},{53650,0,0,0},{64320,2,0,32},{53653,0,0,0},
{64320,2,0,32},{53655,0,0,0},{64320,2,0,32},{53668,0,0,0},{64320,2,0,32},{53676,
0,0,0},{64320,2,0,32},{53685,0,0,0},{64320,2,0,32},{53687,0,0,0},{64320,2,0,32},
{53705,0,0,0},{64320,2,0,32},{53708,0,0,0},{64320,2,0,32},{53724,0,0,0},{64320,
2,0,32},{53726,0,0,0},{64320,2,0,32},{53749,0,0,0},{64320,2,0,32},{53763,0,0,0},
{64320,2,0,32},{53767,0,0,0},{64320,2,0,32},{53783,0,0,0},{64320,2,0,32},{53801,
0,0,0},{64320,2,0,32},{53818,0,0,0},{64320,2,0,32},{53819,0,0,0},{64320,2,0,32},
{53830,0,0,0},{64320,2,0,32},{53874,0,0,0},{64320,2,0,32},{53879,0,0,0},{64320,
2,0,32},{53897,0,0,0},{64320,2,0,32},{53915,0,0,0},{64320,2,0,32},{53923,0,0,0},
{64320,2,0,32},{53939,0,0,0},{64320,2,0,32},{53959,0,0,0},{64320,2,0,32},{53961,
0,0,0},{64320,2,0,32},{53970,0,0,0},{64320,2,0,32},{53982,0,0,0},{64320,2,0,32},
{53988,0,0,0},{64320,2,0,32},{54005,0,0,0},{64320,2,0,32},{54010,0,0,0},{64320,
2,0,32},{54021,0,0,0},{64320,2,0,32},{54022,0,0,0},{64320,2,0,32},{54039,0,0,0},
{64320,2,0,32},{54079,0,0,0},{64320,2,0,32},{54089,0,0,0},{64320,2,0,32},{54097,
0,0,0},{64320,2,0,32},{54106,0,0,0},{64320,2,0,32},{54131,0,0,0},{64320,2,0,32},
{54133,0,0,0},{64320,2,0,32},{54141,0,0,0},{64320,2,0,32},{54143,0,0,0},{64320,
2,0,32},{54211,0,0,0},{64320,2,0,32},{54218,0,0,0},{64320,2,0,32},{54239,0,0,0},
{64320,2,0,32},{54245,0,0,0},{64320,2,0,32},{54251,0,0,0},{64320,2,0,32},{54257,
0,0,0},{64320,2,0,32},{54278,0,0,0},{64320,2,0,32},{54287,0,0,0},{64320,2,0,32},
{54301,0,0,0},{64320,2,0,32},{54328,0,0,0},{64320,2,0,32},{54338,0,0,0},{64320,
2,0,32},{54344,0,0,0},{64320,2,0,32},{54376,0,0,0},{64320,2,0,32},{54430,0,0,0},
{64320,2,0,32},{54434,0,0,0},{64320,2,0,32},{54461,0,0,0},{64320,2,0,32},{54518,
0,0,0},{64320,2,0,32},{54544,0,0,0},{64320,2,0,32},{54611,0,0,0},{64320,2,0,32},
{54613,0,0,0},{64320,2,0,32},{54627,0,0,0},{64320,2,0,32},{54660,0,0,0},{64320,
2,0,32},{54663,0,0,0},{64320,2,0,32},{54681,0,0,0},{64320,2,0,32},{54685,0,0,0},
{64320,2,0,32},{54699,0,0,0},{64320,2,0,32},{54707,0,0,0},{64320,2,0,32},{54720,
0,0,0},{64320,2,0,32},{54722,0,0,0},{64320,2,0,32},{54754,0,0,0},{64320,2,0,32},
{54790,0,0,0},{64320,2,0,32},{54865,0,0,0},{64320,2,0,32},{54888,0,0,0},{64320,
2,0,32},{54900,0,0,0},{64320,2,0,32},{55033,0,0,0},{64320,2,0,32},{55062,0,0,0},
{64320,2,0,32},{55063,0,0,0},{64320,2,0,32},{55179,0,0,0},{64320,2,0,32},{55246,
0,0,0},{64320,2,0,32},{55284,0,0,0},{64320,2,0,32},{55309,0,0,0},{64320,2,0,32},
{55345,0,0,0},{64320,2,0,32},{55346,0,0,0},{64320,2,0,32},{55360,0,0,0},{64320,
2,0,32},{55386,0,0,0},{64320,2,0,32},{55390,0,0,0},{64320,2,0,32},{55464,0,0,0},
{64320,2,0,32},{55468,0,0,0},{64320,2,0,32},{55475,0,0,0},{64320,2,0,32},{55512,
0,0,0},{64320,2,0,32},{55519,0,0,0},{64320,2,0,32},{55534,0,0,0},{64320,2,0,32},
{55538,0,0,0},{64320,2,0,32},{55543,0,0,0},{64320,2,0,32},{55558,0,0,0},{64320,
2,0,32},{55578,0,0,0},{64320,2,0,32},{55586,0,0,0},{64320,2,0,32},{55620,0,0,0},
{64320,2,0,32},{55624,0,0,0},{64320,2,0,32},{55633,0,0,0},{64320,2,0,32},{55636,
0,0,0},{64320,2,0,32},{55650,0,0,0},{64320,2,0,32},{55667,0,0,0},{64320,2,0,32},
{55768,0,0,0},{64320,2,0,32},{55788,0,0,0},{64320,2,0,32},{55835,0,0,0},{64320,
2,0,32},{55847,0,0,0},{64320,2,0,32},{55906,0,0,0},{64320,2,0,32},{55910,0,0,0},
{64320,2,0,32},{55989,0,0,0},{64320,2,0,32},{56072,0,0,0},{64320,2,0,32},{56104,
0,0,0},{64320,2,0,32},{56126,0,0,0},{64320,2,0,32},{56197,0,0,0},{64320,2,0,32},
{56259,0,0,0},{64320,2,0,32},{56280,0,0,0},{64320,2,0,32},{56295,0,0,0},{64320,
2,0,32},{56302,0,0,0},{64320,2,0,32},{56307,0,0,0},{64320,2,0,32},{56319,0,0,0},
{64320,2,0,32},{56326,0,0,0},{64320,2,0,32},{56354,0,0,0},{64320,2,0,32},{56383,
0,0,0},{64320,2,0,32},{56416,0,0,0},{64320,2,0,32},{56418,0,0,0},{64320,2,0,32},
{56420,0,0,0},{64320,2,0,32},{56421,0,0,0},{64320,2,0,32},{56430,0,0,0},{64320,
2,0,32},{56461,0,0,0},{64320,2,0,32},{56512,0,0,0},{64320,2,0,32},{56601,0,0,0},
{64320,2,0,32},{56643,0,0,0},{64320,2,0,32},{56656,0,0,0},{64320,2,0,32},{56683,
0,0,0},{64320,2,0,32},{56686,0,0,0},{64320,2,0,32},{56700,0,0,0},{64320,2,0,32},
{56754,0,0,0},{64320,2,0,32},{56762,0,0,0},{64320,2,0,32},{56801,0,0,0},{64320,
2,0,32},{56802,0,0,0},{64320,2,0,32},{56829,0,0,0},{64320,2,0,32},{56872,0,0,0},
{64320,2,0,32},{56893,0,0,0},{64320,2,0,32},{56937,0,0,0},{64320,2,0,32},{56948,
0,0,0},{64320,2,0,32},{56998,0,0,0},{64320,2,0,32},{57008,0,0,0},{64320,2,0,32},
{57011,0,0,0},{64320,2,0,32},{57014,0,0,0},{64320,2,0,32},{57033,0,0,0},{64320,
2,0,32},{57034,0,0,0},{64320,2,0,32},{57042,0,0,0},{64320,2,0,32},{57043,0,0,0},
{64320,2,0,32},{57049,0,0,0},{64320,2,0,32},{57068,0,0,0},{64320,2,0,32},{57086,
0,0,0},{64320,2,0,32},{57092,0,0,0},{64320,2,0,32},{57122,0,0,0},{64320,2,0,32},
{57171,0,0,0},{64320,2,0,32},{57186,0,0,0},{64320,2,0,32},{57193,0,0,0},{64320,
2,0,32},{57195,0,0,0},{64320,2,0,32},{57227,0,0,0},{64320,2,0,32},{57242,0,0,0},
{64320,2,0,32},{57257,0,0,0},{64320,2,0,32},{57261,0,0,0},{64320,2,0,32},{57293,
0,0,0},{64320,2,0,32},{57303,0,0,0},{64320,2,0,32},{57333,0,0,0},{64320,2,0,32},
{57337,0,0,0},{64320,2,0,32},{57362,0,0,0},{64320,2,0,32},{57372,0,0,0},{64320,
2,0,32},{57461,0,0,0},{64320,2,0,32},{57473,0,0,0},{64320,2,0,32},{57492,0,0,0},
{64320,2,0,32},{57543,0,0,0},{64320,2,0,32},{57560,0,0,0},{64320,2,0,32},{57569,
0,0,0},{64320,2,0,32},{57608,0,0,0},{64320,2,0,32},{57668,0,0,0},{64320,2,0,32},
{57672,0,0,0},{64320,2,0,32},{57676,0,0,0},{64320,2,0,32},{57678,0,0,0},{64320,
2,0,32},{57696,0,0,0},{64320,2,0,32},{57704,0,0,0},{64320,2,0,32},{57722,0,0,0},
{64320,2,0,32},{57742,0,0,0},{64320,2,0,32},{57744,0,0,0},{64320,2,0,32},{57764,
0,0,0},{64320,2,0,32},{57775,0,0,0},{64320,2,0,32},{57778,0,0,0},{64320,2,0,32},
{57822,0,0,0},{64320,2,0,32},{57842,0,0,0},{64320,2,0,32},{57846,0,0,0},{64320,
2,0,32},{57856,0,0,0},{64320,2,0,32},{57872,0,0,0},{64320,2,0,32},{57883,0,0,0},
{64320,2,0,32},{57902,0,0,0},{64320,2,0,32},{57908,0,0,0},{64320,2,0,32},{57949,
0,0,0},{64320,2,0,32},{58033,0,0,0},{64320,2,0,32},{58057,0,0,0},{64320,2,0,32},
{58063,0,0,0},{64320,2,0,32},{58067,0,0,0},{64320,2,0,32},{58068,0,0,0},{64320,
2,0,32},{58108,0,0,0},{64320,2,0,32},{58110,0,0,0},{64320,2,0,32},{58173,0,0,0},
{64320,2,0,32},{58192,0,0,0},{64320,2,0,32},{58216,0,0,0},{64320,2,0,32},{58235,
0,0,0},{64320,2,0,32},{58243,0,0,0},{64320,2,0,32},{58272,0,0,0},{64320,2,0,32},
{58281,0,0,0},{64320,2,0,32},{58308,0,0,0},{64320,2,0,32},{58309,0,0,0},{64320,
2,0,32},{58340,0,0,0},{64320,2,0,32},{58396,0,0,0},{64320,2,0,32},{58402,0,0,0},
{64320,2,0,32},{58450,0,0,0},{64320,2,0,32},{58473,0,0,0},{64320,2,0,32},{58487,
0,0,0},{64320,2,0,32},{58494,0,0,0},{64320,2,0,32},{58522,0,0,0},{64320,2,0,32},
{58525,0,0,0},{64320,2,0,32},{58564,0,0,0},{64320,2,0,32},{58703,0,0,0},{64320,
2,0,32},{58710,0,0,0},{64320,2,0,32},{58732,0,0,0},{64320,2,0,32},{58744,0,0,0},
{64320,2,0,32},{58777,0,0,0},{64320,2,0,32},{58821,0,0,0},{64320,2,0,32},{58850,
0,0,0},{64320,2,0,32},{58851,0,0,0},{64320,2,0,32},{58899,0,0,0},{64320,2,0,32},
{58953,0,0,0},{64320,2,0,32},{58996,0,0,0},{64320,2,0,32},{59016,0,0,0},{64320,
2,0,32},{59025,0,0,0},{64320,2,0,32},{59036,0,0,0},{64320,2,0,32},{59060,0,0,0},
{64320,2,0,32},{59078,0,0,0},{64320,2,0,32},{59124,0,0,0},{64320,2,0,32},{59128,
0,0,0},{64320,2,0,32},{59136,0,0,0},{64320,2,0,32},{59159,0,0,0},{64320,2,0,32},
{59163,0,0,0},{64320,2,0,32},{59169,0,0,0},{64320,2,0,32},{59214,0,0,0},{64320,
2,0,32},{59219,0,0,0},{64320,2,0,32},{59222,0,0,0},{64320,2,0,32},{59230,0,0,0},
{64320,2,0,32},{59259,0,0,0},{64320,2,0,32},{59269,0,0,0},{64320,2,0,32},{59287,
0,0,0},{64320,2,0,32},{59379,0,0,0},{64320,2,0,32},{59386,0,0,0},{64320,2,0,32},
{59415,0,0,0},{64320,2,0,32},{59423,0,0,0},{64320,2,0,32},{59474,0,0,0},{64320,
2,0,32},{59521,0,0,0},{64320,2,0,32},{59525,0,0,0},{64320,2,0,32},{59534,0,0,0},
{64320,2,0,32},{59560,0,0,0},{64320,2,0,32},{59668,0,0,0},{64320,2,0,32},{59714,
0,0,0},{64320,2,0,32},{59811,0,0,0},{64320,2,0,32},{59882,0,0,0},{64320,2,0,32},
{59906,0,0,0},{64320,2,0,32},{59923,0,0,0},{64320,2,0,32},{60072,0,0,0},{64320,
2,0,32},{60115,0,0,0},{64320,2,0,32},{60123,0,0,0},{64320,2,0,32},{60164,0,0,0},
{64320,2,0,32},{60193,0,0,0},{64320,2,0,32},{60244,0,0,0},{64320,2,0,32},{60274,
0,0,0},{64320,2,0,32},{60279,0,0,0},{64320,2,0,32},{60281,0,0,0},{64320,2,0,32},
{60319,0,0,0},{64320,2,0,32},{60334,0,0,0},{64320,2,0,32},{60346,0,0,0},{64320,
2,0,32},{60347,0,0,0},{64320,2,0,32},{60494,0,0,0},{64320,2,0,32},{60519,0,0,0},
{64320,2,0,32},{60552,0,0,0},{64320,2,0,32},{60607,0,0,0},{64320,2,0,32},{60620,
0,0,0},{64320,2,0,32},{60621,0,0,0},{64320,2,0,32},{60645,0,0,0},{64320,2,0,32},
{60694,0,0,0},{64320,2,0,32},{60699,0,0,0},{64320,2,0,32},{60702,0,0,0},{64320,
2,0,32},{60724,0,0,0},{64320,2,0,32},{60734,0,0,0},{64320,2,0,32},{60737,0,0,0},
{64320,2,0,32},{60777,0,0,0},{64320,2,0,32},{60778,0,0,0},{64320,2,0,32},{60791,
0,0,0},{64320,2,0,32},{60792,0,0,0},{64320,2,0,32},{60805,0,0,0},{64320,2,0,32},
{60875,0,0,0},{64320,2,0,32},{60890,0,0,0},{64320,2,0,32},{60906,0,0,0},{64320,
2,0,32},{60921,0,0,0},{64320,2,0,32},{60954,0,0,0},{64320,2,0,32},{60975,0,0,0},
{64320,2,0,32},{61038,0,0,0},{64320,2,0,32},{61084,0,0,0},{64320,2,0,32},{61114,
0,0,0},{64320,2,0,32},{61127,0,0,0},{64320,2,0,32},{61131,0,0,0},{64320,2,0,32},
{61137,0,0,0},{64320,2,0,32},{61147,0,0,0},{64320,2,0,32},{61199,0,0,0},{64320,
2,0,32},{61218,0,0,0},{64320,2,0,32},{61219,0,0,0},{64320,2,0,32},{61294,0,0,0},
{64320,2,0,32},{61382,0,0,0},{64320,2,0,32},{61419,0,0,0},{64320,2,0,32},{61438,
0,0,0},{64320,2,0,32},{61467,0,0,0},{64320,2,0,32},{61470,0,0,0},{64320,2,0,32},
{61497,0,0,0},{64320,2,0,32},{61514,0,0,0},{64320,2,0,32},{61552,0,0,0},{64320,
2,0,32},{61559,0,0,0},{64320,2,0,32},{61565,0,0,0},{64320,2,0,32},{61593,0,0,0},
{64320,2,0,32},{61613,0,0,0},{64320,2,0,32},{61640,0,0,0},{64320,2,0,32},{61657,
0,0,0},{64320,2,0,32},{61765,0,0,0},{64320,2,0,32},{61769,0,0,0},{64320,2,0,32},
{61806,0,0,0},{64320,2,0,32},{61852,0,0,0},{64320,2,0,32},{61902,0,0,0},{64320,
2,0,32},{61904,0,0,0},{64320,2,0,32},{61968,0,0,0},{64320,2,0,32},{61979,0,0,0},
{64320,2,0,32},{61992,0,0,0},{64320,2,0,32},{61995,0,0,0},{64320,2,0,32},{62005,
0,0,0},{64320,2,0,32},{62032,0,0,0},{64320,2,0,32},{62050,0,0,0},{64320,2,0,32},
{62080,0,0,0},{64320,2,0,32},{62101,0,0,0},{64320,2,0,32},{62127,0,0,0},{64320,
2,0,32},{62144,0,0,0},{64320,2,0,32},{62204,0,0,0},{64320,2,0,32},{62250,0,0,0},
{64320,2,0,32},{62325,0,0,0},{64320,2,0,32},{62330,0,0,0},{64320,2,0,32},{62343,
0,0,0},{64320,2,0,32},{62347,0,0,0},{64320,2,0,32},{62373,0,0,0},{64320,2,0,32},
{62386,0,0,0},{64320,2,0,32},{62430,0,0,0},{64320,2,0,32},{62470,0,0,0},{64320,
2,0,32},{62473,0,0,0},{64320,2,0,32},{62498,0,0,0},{64320,2,0,32},{62535,0,0,0},
{64320,2,0,32},{62556,0,0,0},{64320,2,0,32},{62569,0,0,0},{64320,2,0,32},{62577,
0,0,0},{64320,2,0,32},{62597,0,0,0},{64320,2,0,32},{62601,0,0,0},{64320,2,0,32},
{62616,0,0,0},{64320,2,0,32},{62666,0,0,0},{64320,2,0,32},{62726,0,0,0},{64320,
2,0,32},{62756,0,0,0},{64320,2,0,32},{62779,0,0,0},{64320,2,0,32},{62782,0,0,0},
{64320,2,0,32},{62809,0,0,0},{64320,2,0,32},{62821,0,0,0},{64320,2,0,32},{62832,
0,0,0},{64320,2,0,32},{62946,0,0,0},{64320,2,0,32},{62992,0,0,0},{64320,2,0,32},
{63005,0,0,0},{64320,2,0,32},{63007,0,0,0},{64320,2,0,32},{63042,0,0,0},{64320,
2,0,32},{63081,0,0,0},{64320,2,0,32},{63178,0,0,0},{64320,2,0,32},{63195,0,0,0},
{64320,2,0,32},{63207,0,0,0},{64320,2,0,32},{63220,0,0,0},{64320,2,0,32},{63233,
0,0,0},{64320,2,0,32},{63262,0,0,0},{64320,2,0,32},{63263,0,0,0},{64320,2,0,32},
{63296,0,0,0},{64320,2,0,32},{63306,0,0,0},{64320,2,0,32},{63371,0,0,0},{64320,
2,0,32},{63399,0,0,0},{64320,2,0,32},{63566,0,0,0},{64320,2,0,32},{63595,0,0,0},
{64320,2,0,32},{63628,0,0,0},{64320,2,0,32},{63633,0,0,0},{64320,2,0,32},{63690,
0,0,0},{64320,2,0,32},{63692,0,0,0},{64320,2,0,32},{63739,0,0,0},{64320,2,0,32},
{63786,0,0,0},{64320,2,0,32},{63804,0,0,0},{64320,2,0,32},{63806,0,0,0},{64320,
2,0,32},{63816,0,0,0},{64320,2,0,32},{63817,0,0,0},{64320,2,0,32},{63824,0,0,0},
{64320,2,0,32},{63830,0,0,0},{64320,2,0,32},{63837,0,0,0},{64320,2,0,32},{63838,
0,0,0},{64320,2,0,32},{63845,0,0,0},{64320,2,0,32},{63871,0,0,0},{64320,2,0,32},
{63885,0,0,0},{64320,2,0,32},{63886,0,0,0},{64320,2,0,32},{63887,0,0,0},{64320,
2,0,32},{63918,0,0,0},{64320,2,0,32},{63946,0,0,0},{64320,2,0,32},{63979,0,0,0},
{64320,2,0,32},{64028,0,0,0},{64320,2,0,32},{64064,0,0,0},{64320,2,0,32},{64074,
0,0,0},{64320,2,0,32},{64079,0,0,0},{64320,2,0,32},{64129,0,0,0},{64320,2,0,32},
{64177,0,0,0},{64320,2,0,32},{64203,0,0,0},{64320,2,0,32},{64238,0,0,0},{64320,
2,0,32},{64288,0,0,0},{64320,2,0,32},{64448,0,0,0},{64320,2,0,32},{64454,0,0,0},
{64320,2,0,32},{64457,0,0,0},{64320,2,0,32},{64574,0,0,0},{64320,2,0,32},{64608,
0,0,0},{64320,2,0,32},{64635,0,0,0},{64320,2,0,32},{64658,0,0,0},{64320,2,0,32},
{64702,0,0,0},{64320,2,0,32},{64722,0,0,0},{64320,2,0,32},{64726,0,0,0},{64320,
2,0,32},{64739,0,0,0},{64320,2,0,32},{64743,0,0,0},{64320,2,0,32},{64744,0,0,0},
{64320,2,0,32},{64768,0,0,0},{64320,2,0,32},{64784,0,0,0},{64320,2,0,32},{64802,
0,0,0},{64320,2,0,32},{64815,0,0,0},{64320,2,0,32},{64859,0,0,0},{64320,2,0,32},
{64867,0,0,0},{64320,2,0,32},{64928,0,0,0},{64320,2,0,32},{64958,0,0,0},{64320,
2,0,32},{64967,0,0,0},{64320,2,0,32},{65012,0,0,0},{64320,2,0,32},{65026,0,0,0},
{64320,2,0,32},{65033,0,0,0},{64320,2,0,32},{65079,0,0,0},{64320,2,0,32},{65089,
0,0,0},{64320,2,0,32},{65093,0,0,0},{64320,2,0,32},{65342,0,0,0},{64320,2,0,32},
{65394,0,0,0},{64320,2,0,32},{65401,0,0,0},{64320,2,0,32},{65402,0,0,0},{64320,
2,0,32},{65413,0,0,0},{64320,2,0,32},{65429,0,0,0},{64320,2,0,32},{65434,0,0,0},
{64320,2,0,32},{65469,0,0,0},{64320,2,0,32},{65530,0,0,0},{64321,2,0,32},{32769,
0,0,0},{64321,2,0,32},{32773,0,0,0},{64321,2,0,32},{32838,0,0,0},{64321,2,0,32},
{32864,0,0,0},{64321,2,0,32},{32879,0,0,0},{64321,2,0,32},{32880,0,0,0},{64321,
2,0,32},{32894,0,0,0},{64321,2,0,32},{32907,0,0,0},{64321,2,0,32},{32941,0,0,0},
{64321,2,0,32},{32946,0,0,0},{64321,2,0,32},{33027,0,0,0},{64321,2,0,32},{33086,
0,0,0},{64321,2,0,32},{33240,0,0,0},{64321,2,0,32},{33256,0,0,0},{64321,2,0,32},
{33261,0,0,0},{64321,2,0,32},{33281,0,0,0},{64321,2,0,32},{33284,0,0,0},{64321,
2,0,32},{33304,0,0,0},{64321,2,0,32},{33391,0,0,0},{64321,2,0,32},{33401,0,0,0},
{64321,2,0,32},{33419,0,0,0},{64321,2,0,32},{33425,0,0,0},{64321,2,0,32},{33437,
0,0,0},{64321,2,0,32},{33457,0,0,0},{64321,2,0,32},{33459,0,0,0},{64321,2,0,32},
{33469,0,0,0},{64321,2,0,32},{33509,0,0,0},{64321,2,0,32},{33510,0,0,0},{64321,
2,0,32},{33565,0,0,0},{64321,2,0,32},{33571,0,0,0},{64321,2,0,32},{33590,0,0,0},
{64321,2,0,32},{33618,0,0,0},{64321,2,0,32},{33619,0,0,0},{64321,2,0,32},{33635,
0,0,0},{64321,2,0,32},{33709,0,0,0},{64321,2,0,32},{33725,0,0,0},{64321,2,0,32},
{33737,0,0,0},{64321,2,0,32},{33738,0,0,0},{64321,2,0,32},{33740,0,0,0},{64321,
2,0,32},{33756,0,0,0},{64321,2,0,32},{33767,0,0,0},{64321,2,0,32},{33775,0,0,0},
{64321,2,0,32},{33777,0,0,0},{64321,2,0,32},{33853,0,0,0},{64321,2,0,32},{33865,
0,0,0},{64321,2,0,32},{33879,0,0,0},{64321,2,0,32},{34030,0,0,0},{64321,2,0,32},
{34033,0,0,0},{64321,2,0,32},{34035,0,0,0},{64321,2,0,32},{34044,0,0,0},{64321,
2,0,32},{34070,0,0,0},{64321,2,0,32},{34148,0,0,0},{64321,2,0,32},{34253,0,0,0},
{64321,2,0,32},{34298,0,0,0},{64321,2,0,32},{34310,0,0,0},{64321,2,0,32},{34322,
0,0,0},{64321,2,0,32},{34349,0,0,0},{64321,2,0,32},{34367,0,0,0},{64321,2,0,32},
{34384,0,0,0},{64321,2,0,32},{34396,0,0,0},{64321,2,0,32},{34407,0,0,0},{64321,
2,0,32},{34409,0,0,0},{64321,2,0,32},{34440,0,0,0},{64321,2,0,32},{34473,0,0,0},
{64321,2,0,32},{34530,0,0,0},{64321,2,0,32},{34574,0,0,0},{64321,2,0,32},{34600,
0,0,0},{64321,2,0,32},{34667,0,0,0},{64321,2,0,32},{34681,0,0,0},{64321,2,0,32},
{34694,0,0,0},{64321,2,0,32},{34746,0,0,0},{64321,2,0,32},{34785,0,0,0},{64321,
2,0,32},{34817,0,0,0},{64321,2,0,32},{34847,0,0,0},{64321,2,0,32},{34892,0,0,0},
{64321,2,0,32},{34912,0,0,0},{64321,2,0,32},{34915,0,0,0},{64321,2,0,32},{35010,
0,0,0},{64321,2,0,32},{35023,0,0,0},{64321,2,0,32},{35031,0,0,0},{64321,2,0,32},
{35038,0,0,0},{64321,2,0,32},{35041,0,0,0},{64321,2,0,32},{35064,0,0,0},{64321,
2,0,32},{35066,0,0,0},{64321,2,0,32},{35088,0,0,0},{64321,2,0,32},{35137,0,0,0},
{64321,2,0,32},{35172,0,0,0},{64321,2,0,32},{35206,0,0,0},{64321,2,0,32},{35211,
0,0,0},{64321,2,0,32},{35222,0,0,0},{64321,2,0,32},{35488,0,0,0},{64321,2,0,32},
{35498,0,0,0},{64321,2,0,32},{35519,0,0,0},{64321,2,0,32},{35531,0,0,0},{64321,
2,0,32},{35538,0,0,0},{64321,2,0,32},{35542,0,0,0},{64321,2,0,32},{35565,0,0,0},
{64321,2,0,32},{35576,0,0,0},{64321,2,0,32},{35582,0,0,0},{64321,2,0,32},{35585,
0,0,0},{64321,2,0,32},{35641,0,0,0},{64321,2,0,32},{35672,0,0,0},{64321,2,0,32},
{35712,0,0,0},{64321,2,0,32},{35722,0,0,0},{64321,2,0,32},{35912,0,0,0},{64321,
2,0,32},{35925,0,0,0},{64321,2,0,32},{36011,0,0,0},{64321,2,0,32},{36033,0,0,0},
{64321,2,0,32},{36034,0,0,0},{64321,2,0,32},{36040,0,0,0},{64321,2,0,32},{36051,
0,0,0},{64321,2,0,32},{36104,0,0,0},{64321,2,0,32},{36123,0,0,0},{64321,2,0,32},
{36215,0,0,0},{64321,2,0,32},{36284,0,0,0},{64321,2,0,32},{36299,0,0,0},{64321,
2,0,32},{36335,0,0,0},{64321,2,0,32},{36336,0,0,0},{64321,2,0,32},{36554,0,0,0},
{64321,2,0,32},{36564,0,0,0},{64321,2,0,32},{36646,0,0,0},{64321,2,0,32},{36650,
0,0,0},{64321,2,0,32},{36664,0,0,0},{64321,2,0,32},{36667,0,0,0},{64321,2,0,32},
{36706,0,0,0},{64321,2,0,32},{36766,0,0,0},{64321,2,0,32},{36784,0,0,0},{64321,
2,0,32},{36790,0,0,0},{64321,2,0,32},{36899,0,0,0},{64321,2,0,32},{36920,0,0,0},
{64321,2,0,32},{36978,0,0,0},{64321,2,0,32},{36988,0,0,0},{64321,2,0,32},{37007,
0,0,0},{64321,2,0,32},{37012,0,0,0},{64321,2,0,32},{37070,0,0,0},{64321,2,0,32},
{37086,0,0,0},{64321,2,0,32},{37105,0,0,0},{64321,2,0,32},{37117,0,0,0},{64321,
2,0,32},{37137,0,0,0},{64321,2,0,32},{37147,0,0,0},{64321,2,0,32},{37226,0,0,0},
{64321,2,0,32},{37273,0,0,0},{64321,2,0,32},{37300,0,0,0},{64321,2,0,32},{37324,
0,0,0},{64321,2,0,32},{37327,0,0,0},{64321,2,0,32},{37329,0,0,0},{64321,2,0,32},
{37428,0,0,0},{64321,2,0,32},{37432,0,0,0},{64321,2,0,32},{37494,0,0,0},{64321,
2,0,32},{37500,0,0,0},{64321,2,0,32},{37591,0,0,0},{64321,2,0,32},{37592,0,0,0},
{64321,2,0,32},{37636,0,0,0},{64321,2,0,32},{37706,0,0,0},{64321,2,0,32},{37881,
0,0,0},{64321,2,0,32},{37909,0,0,0},{64321,2,0,32},{38283,0,0,0},{64321,2,0,32},
{38317,0,0,0},{64321,2,0,32},{38327,0,0,0},{64321,2,0,32},{38446,0,0,0},{64321,
2,0,32},{38475,0,0,0},{64321,2,0,32},{38477,0,0,0},{64321,2,0,32},{38517,0,0,0},
{64321,2,0,32},{38520,0,0,0},{64321,2,0,32},{38524,0,0,0},{64321,2,0,32},{38534,
0,0,0},{64321,2,0,32},{38563,0,0,0},{64321,2,0,32},{38583,0,0,0},{64321,2,0,32},
{38584,0,0,0},{64321,2,0,32},{38595,0,0,0},{64321,2,0,32},{38626,0,0,0},{64321,
2,0,32},{38627,0,0,0},{64321,2,0,32},{38646,0,0,0},{64321,2,0,32},{38647,0,0,0},
{64321,2,0,32},{38691,0,0,0},{64321,2,0,32},{38706,0,0,0},{64321,2,0,32},{38728,
0,0,0},{64321,2,0,32},{38742,0,0,0},{64321,2,0,32},{38875,0,0,0},{64321,2,0,32},
{38880,0,0,0},{64321,2,0,32},{38911,0,0,0},{64321,2,0,32},{38923,0,0,0},{64321,
2,0,32},{38936,0,0,0},{64321,2,0,32},{38953,0,0,0},{64321,2,0,32},{38971,0,0,0},
{64321,2,0,32},{39006,0,0,0},{64321,2,0,32},{39138,0,0,0},{64321,2,0,32},{39151,
0,0,0},{64321,2,0,32},{39164,0,0,0},{64321,2,0,32},{39208,0,0,0},{64321,2,0,32},
{39209,0,0,0},{64321,2,0,32},{39335,0,0,0},{64321,2,0,32},{39362,0,0,0},{64321,
2,0,32},{39409,0,0,0},{64321,2,0,32},{39422,0,0,0},{64321,2,0,32},{39530,0,0,0},
{64321,2,0,32},{39698,0,0,0},{64321,2,0,32},{39791,0,0,0},{64321,2,0,32},{40000,
0,0,0},{64321,2,0,32},{40023,0,0,0},{64321,2,0,32},{40189,0,0,0},{64321,2,0,32},
{40295,0,0,0},{64321,2,0,32},{40372,0,0,0},{64321,2,0,32},{40442,0,0,0},{64321,
2,0,32},{40478,0,0,0},{64321,2,0,32},{40575,0,0,0},{64321,2,0,32},{40599,0,0,0},
{64321,2,0,32},{40607,0,0,0},{64321,2,0,32},{40635,0,0,0},{64321,2,0,32},{40654,
0,0,0},{64321,2,0,32},{40697,0,0,0},{64321,2,0,32},{40702,0,0,0},{64321,2,0,32},
{40709,0,0,0},{64321,2,0,32},{40719,0,0,0},{64321,2,0,32},{40726,0,0,0},{64321,
2,0,32},{40763,0,0,0},{64321,2,0,32},{40771,0,0,0},{64321,2,0,32},{40845,0,0,0},
{64321,2,0,32},{40846,0,0,0},{64321,2,0,32},{40860,0,0,0},{14865,4,0,32},{15120,
4,0,32},{14883,4,0,32},{15120,4,0,32},{14904,4,0,32},{15120,4,0,32},{14924,4,0,
32},{15121,4,0,32},{14935,4,0,32},{15120,4,0,32},{14941,4,0,32},{15121,4,0,32},
{14943,4,0,32},{15121,4,0,32},{14949,4,0,32},{15120,4,0,32},{14986,4,0,32},
{15120,4,0,32},{15033,4,0,32},{15120,4,0,32},{15056,4,0,32},{15120,4,0,32},
{15062,4,0,32},{15121,4,0,32},{15069,4,0,32},{15120,4,0,32},{8657,4,0,32},{0,4,
0,43},{8157,10,0,32},{8298,4,0,32},{8157,4,0,32},{8298,4,0,32},{7566,10,0,32},
{7566,10,0,32},{7566,4,0,32},{7566,4,0,32},{7566,10,0,32},{7972,10,0,32},{7566,
4,0,32},{7972,4,0,32},{7566,10,0,32},{8189,10,0,32},{7566,4,0,32},{8189,4,0,32},
{7566,10,0,32},{8236,10,0,32},{7566,4,0,32},{8236,4,0,32},{7566,10,0,32},{0,4,0,
274},{8236,10,0,32},{7566,4,0,32},{0,4,0,274},{8236,4,0,32},{7566,10,0,32},
{8276,10,0,32},{7566,4,0,32},{8276,4,0,32},{7972,10,0,32},{7972,10,0,32},{7972,
4,0,32},{7972,4,0,32},{8236,10,0,32},{8276,10,0,32},{8236,4,0,32},{8276,4,0,32},
{7638,10,0,32},{0,4,0,275},{7638,4,0,32},{0,4,0,275},{7724,10,0,32},{0,4,0,275},
{7724,4,0,32},{0,4,0,275},{7739,10,0,32},{0,4,0,275},{8059,10,0,32},{0,4,0,275},
{8059,4,0,32},{0,4,0,275},{8121,10,0,32},{0,4,0,275},{8121,4,0,32},{0,4,0,275},
{8157,10,0,32},{0,4,0,275},{8157,4,0,32},{0,4,0,275},{7566,10,0,32},{0,4,0,43},
{7566,4,0,32},{0,4,0,43},{7972,10,0,32},{0,4,0,43},{7972,4,0,32},{0,4,0,43},
{8189,10,0,32},{0,4,0,43},{8189,4,0,32},{0,4,0,43},{7739,10,0,32},{0,4,0,53},
{7739,4,0,32},{0,4,0,53},{7852,10,0,32},{0,4,0,53},{7852,4,0,32},{0,4,0,53},
{7936,10,0,32},{0,4,0,53},{7936,4,0,32},{0,4,0,53},{8059,10,0,32},{0,4,0,53},
{8059,4,0,32},{0,4,0,53},{8121,10,0,32},{0,4,0,53},{8121,4,0,32},{0,4,0,53},
{7775,20,0,32},{0,20,0,57},{7972,20,0,32},{0,20,0,274},{7665,20,0,32},{12260,2,
0,32},{12313,2,0,32},{12261,2,0,32},{12313,2,0,32},{12262,2,0,32},{12313,2,0,
32},{12263,2,0,32},{12313,2,0,32},{12264,2,0,32},{12313,2,0,32},{12265,2,0,32},
{12313,2,0,32},{12266,2,0,32},{12313,2,0,32},{12267,2,0,32},{12313,2,0,32},
{12268,2,0,32},{12313,2,0,32},{12269,2,0,32},{12313,2,0,32},{12270,2,0,32},
{12313,2,0,32},{12271,2,0,32},{12313,2,0,32},{12272,2,0,32},{12313,2,0,32},
{12273,2,0,32},{12313,2,0,32},{12274,2,0,32},{12313,2,0,32},{12275,2,0,32},
{12313,2,0,32},{12276,2,0,32},{12313,2,0,32},{12277,2,0,32},{12313,2,0,32},
{12278,2,0,32},{12313,2,0,32},{12279,2,0,32},{12313,2,0,32},{12280,2,0,32},
{12313,2,0,32},{12281,2,0,32},{12313,2,0,32},{12282,2,0,32},{12313,2,0,32},
{12283,2,0,32},{12313,2,0,32},{12284,2,0,32},{12313,2,0,32},{12285,2,0,32},
{12313,2,0,32},{12286,2,0,32},{12313,2,0,32},{12287,2,0,32},{12313,2,0,32},
{12288,2,0,32},{12313,2,0,32},{12289,2,0,32},{12313,2,0,32},{12290,2,0,32},
{12313,2,0,32},{12291,2,0,32},{12313,2,0,32},{12292,2,0,32},{12313,2,0,32},
{12293,2,0,32},{12313,2,0,32},{12294,2,0,32},{12313,2,0,32},{12295,2,0,32},
{12313,2,0,32},{12296,2,0,32},{12313,2,0,32},{12297,2,0,32},{12313,2,0,32},
{12298,2,0,32},{12313,2,0,32},{12299,2,0,32},{12313,2,0,32},{12300,2,0,32},
{12313,2,0,32},{12301,2,0,32},{12313,2,0,32},{12302,2,0,32},{12313,2,0,32},
{12303,2,0,32},{12313,2,0,32},{12304,2,0,32},{12313,2,0,32},{12305,2,0,32},
{12313,2,0,32},{12306,2,0,32},{12313,2,0,32},{12307,2,0,32},{12313,2,0,32},
{12260,2,0,32},{12314,2,0,32},{12261,2,0,32},{12314,2,0,32},{12262,2,0,32},
{12314,2,0,32},{12263,2,0,32},{12314,2,0,32},{12264,2,0,32},{12314,2,0,32},
{12265,2,0,32},{12314,2,0,32},{12266,2,0,32},{12314,2,0,32},{12267,2,0,32},
{12314,2,0,32},{12268,2,0,32},{12314,2,0,32},{12269,2,0,32},{12314,2,0,32},
{12270,2,0,32},{12314,2,0,32},{12271,2,0,32},{12314,2,0,32},{12272,2,0,32},
{12314,2,0,32},{12273,2,0,32},{12314,2,0,32},{12274,2,0,32},{12314,2,0,32},
{12275,2,0,32},{12314,2,0,32},{12276,2,0,32},{12314,2,0,32},{12277,2,0,32},
{12314,2,0,32},{12278,2,0,32},{12314,2,0,32},{12279,2,0,32},{12314,2,0,32},
{12280,2,0,32},{12314,2,0,32},{12281,2,0,32},{12314,2,0,32},{12282,2,0,32},
{12314,2,0,32},{12283,2,0,32},{12314,2,0,32},{12284,2,0,32},{12314,2,0,32},
{12285,2,0,32},{12314,2,0,32},{12286,2,0,32},{12314,2,0,32},{12287,2,0,32},
{12314,2,0,32},{12288,2,0,32},{12314,2,0,32},{12289,2,0,32},{12314,2,0,32},
{12290,2,0,32},{12314,2,0,32},{12291,2,0,32},{12314,2,0,32},{12292,2,0,32},
{12314,2,0,32},{12293,2,0,32},{12314,2,0,32},{12294,2,0,32},{12314,2,0,32},
{12295,2,0,32},{12314,2,0,32},{12296,2,0,32},{12314,2,0,32},{12297,2,0,32},
{12314,2,0,32},{12298,2,0,32},{12314,2,0,32},{12299,2,0,32},{12314,2,0,32},
{12300,2,0,32},{12314,2,0,32},{12301,2,0,32},{12314,2,0,32},{12302,2,0,32},
{12314,2,0,32},{12303,2,0,32},{12314,2,0,32},{12304,2,0,32},{12314,2,0,32},
{12305,2,0,32},{12314,2,0,32},{12306,2,0,32},{12314,2,0,32},{12307,2,0,32},
{12314,2,0,32},{12260,2,0,32},{12317,2,0,32},{12261,2,0,32},{12317,2,0,32},
{12262,2,0,32},{12317,2,0,32},{12263,2,0,32},{12317,2,0,32},{12264,2,0,32},
{12317,2,0,32},{12265,2,0,32},{12317,2,0,32},{12266,2,0,32},{12317,2,0,32},
{12267,2,0,32},{12317,2,0,32},{12268,2,0,32},{12317,2,0,32},{12269,2,0,32},
{12317,2,0,32},{12270,2,0,32},{12317,2,0,32},{12271,2,0,32},{12317,2,0,32},
{12272,2,0,32},{12317,2,0,32},{12273,2,0,32},{12317,2,0,32},{12274,2,0,32},
{12317,2,0,32},{12275,2,0,32},{12317,2,0,32},{12276,2,0,32},{12317,2,0,32},
{12277,2,0,32},{12317,2,0,32},{12278,2,0,32},{12317,2,0,32},{12279,2,0,32},
{12317,2,0,32},{12280,2,0,32},{12317,2,0,32},{12281,2,0,32},{12317,2,0,32},
{12282,2,0,32},{12317,2,0,32},{12283,2,0,32},{12317,2,0,32},{12284,2,0,32},
{12317,2,0,32},{12285,2,0,32},{12317,2,0,32},{12286,2,0,32},{12317,2,0,32},
{12287,2,0,32},{12317,2,0,32},{12288,2,0,32},{12317,2,0,32},{12289,2,0,32},
{12317,2,0,32},{12290,2,0,32},{12317,2,0,32},{12291,2,0,32},{12317,2,0,32},
{12292,2,0,32},{12317,2,0,32},{12293,2,0,32},{12317,2,0,32},{12294,2,0,32},
{12317,2,0,32},{12295,2,0,32},{12317,2,0,32},{12296,2,0,32},{12317,2,0,32},
{12297,2,0,32},{12317,2,0,32},{12298,2,0,32},{12317,2,0,32},{12299,2,0,32},
{12317,2,0,32},{12300,2,0,32},{12317,2,0,32},{12301,2,0,32},{12317,2,0,32},
{12302,2,0,32},{12317,2,0,32},{12303,2,0,32},{12317,2,0,32},{12304,2,0,32},
{12317,2,0,32},{12305,2,0,32},{12317,2,0,32},{12306,2,0,32},{12317,2,0,32},
{12307,2,0,32},{12317,2,0,32},{12260,2,0,32},{12319,2,0,32},{12261,2,0,32},
{12319,2,0,32},{12262,2,0,32},{12319,2,0,32},{12263,2,0,32},{12319,2,0,32},
{12264,2,0,32},{12319,2,0,32},{12265,2,0,32},{12319,2,0,32},{12266,2,0,32},
{12319,2,0,32},{12267,2,0,32},{12319,2,0,32},{12268,2,0,32},{12319,2,0,32},
{12269,2,0,32},{12319,2,0,32},{12270,2,0,32},{12319,2,0,32},{12271,2,0,32},
{12319,2,0,32},{12272,2,0,32},{12319,2,0,32},{12273,2,0,32},{12319,2,0,32},
{12274,2,0,32},{12319,2,0,32},{12275,2,0,32},{12319,2,0,32},{12276,2,0,32},
{12319,2,0,32},{12277,2,0,32},{12319,2,0,32},{12278,2,0,32},{12319,2,0,32},
{12279,2,0,32},{12319,2,0,32},{12280,2,0,32},{12319,2,0,32},{12281,2,0,32},
{12319,2,0,32},{12282,2,0,32},{12319,2,0,32},{12283,2,0,32},{12319,2,0,32},
{12284,2,0,32},{12319,2,0,32},{12285,2,0,32},{12319,2,0,32},{12286,2,0,32},
{12319,2,0,32},{12287,2,0,32},{12319,2,0,32},{12288,2,0,32},{12319,2,0,32},
{12289,2,0,32},{12319,2,0,32},{12290,2,0,32},{12319,2,0,32},{12291,2,0,32},
{12319,2,0,32},{12292,2,0,32},{12319,2,0,32},{12293,2,0,32},{12319,2,0,32},
{12294,2,0,32},{12319,2,0,32},{12295,2,0,32},{12319,2,0,32},{12296,2,0,32},
{12319,2,0,32},{12297,2,0,32},{12319,2,0,32},{12298,2,0,32},{12319,2,0,32},
{12299,2,0,32},{12319,2,0,32},{12300,2,0,32},{12319,2,0,32},{12301,2,0,32},
{12319,2,0,32},{12302,2,0,32},{12319,2,0,32},{12303,2,0,32},{12319,2,0,32},
{12304,2,0,32},{12319,2,0,32},{12305,2,0,32},{12319,2,0,32},{12306,2,0,32},
{12319,2,0,32},{12307,2,0,32},{12319,2,0,32},{12260,2,0,32},{12320,2,0,32},
{12261,2,0,32},{12320,2,0,32},{12262,2,0,32},{12320,2,0,32},{12263,2,0,32},
{12320,2,0,32},{12264,2,0,32},{12320,2,0,32},{12265,2,0,32},{12320,2,0,32},
{12266,2,0,32},{12320,2,0,32},{12267,2,0,32},{12320,2,0,32},{12268,2,0,32},
{12320,2,0,32},{12269,2,0,32},{12320,2,0,32},{12270,2,0,32},{12320,2,0,32},
{12271,2,0,32},{12320,2,0,32},{12272,2,0,32},{12320,2,0,32},{12273,2,0,32},
{12320,2,0,32},{12274,2,0,32},{12320,2,0,32},{12275,2,0,32},{12320,2,0,32},
{12276,2,0,32},{12320,2,0,32},{12277,2,0,32},{12320,2,0,32},{12278,2,0,32},
{12320,2,0,32},{12279,2,0,32},{12320,2,0,32},{12280,2,0,32},{12320,2,0,32},
{12281,2,0,32},{12320,2,0,32},{12282,2,0,32},{12320,2,0,32},{12283,2,0,32},
{12320,2,0,32},{12284,2,0,32},{12320,2,0,32},{12285,2,0,32},{12320,2,0,32},
{12286,2,0,32},{12320,2,0,32},{12287,2,0,32},{12320,2,0,32},{12288,2,0,32},
{12320,2,0,32},{12289,2,0,32},{12320,2,0,32},{12290,2,0,32},{12320,2,0,32},
{12291,2,0,32},{12320,2,0,32},{12292,2,0,32},{12320,2,0,32},{12293,2,0,32},
{12320,2,0,32},{12294,2,0,32},{12320,2,0,32},{12295,2,0,32},{12320,2,0,32},
{12296,2,0,32},{12320,2,0,32},{12297,2,0,32},{12320,2,0,32},{12298,2,0,32},
{12320,2,0,32},{12299,2,0,32},{12320,2,0,32},{12300,2,0,32},{12320,2,0,32},
{12301,2,0,32},{12320,2,0,32},{12302,2,0,32},{12320,2,0,32},{12303,2,0,32},
{12320,2,0,32},{12304,2,0,32},{12320,2,0,32},{12305,2,0,32},{12320,2,0,32},
{12306,2,0,32},{12320,2,0,32},{12307,2,0,32},{12320,2,0,32},{64321,2,0,32},
{64014,0,0,0},{64321,2,0,32},{64015,0,0,0},{64321,2,0,32},{64017,0,0,0},{64321,
2,0,32},{64019,0,0,0},{64321,2,0,32},{64020,0,0,0},{64321,2,0,32},{64031,0,0,0},
{64321,2,0,32},{64033,0,0,0},{64321,2,0,32},{64035,0,0,0},{64321,2,0,32},{64036,
0,0,0},{64321,2,0,32},{64039,0,0,0},{64321,2,0,32},{64040,0,0,0},{64321,2,0,32},
{64041,0,0,0},{7724,4,0,32},{7724,4,0,32},{7724,4,0,32},{7801,4,0,32},{7724,4,0,
32},{7870,4,0,32},{7724,4,0,32},{7724,4,0,32},{7801,4,0,32},{7724,4,0,32},{7724,
4,0,32},{7870,4,0,32},{8121,4,0,32},{0,4,0,275},{8157,4,0,32},{8121,4,0,32},
{8157,4,0,32},{9197,4,0,32},{9200,4,0,32},{9197,4,0,32},{9182,4,0,32},{9197,4,0,
32},{9188,4,0,32},{9208,4,0,32},{9200,4,0,32},{9197,4,0,32},{9190,4,0,32},{9218,
4,0,32},{9229,4,0,32},{9473,26,0,32},{0,26,0,131},{9473,25,0,32},{0,25,0,131},
{9503,26,0,32},{0,26,0,131},{9503,25,0,32},{0,25,0,131},{9478,26,0,32},{9288,26,
0,32},{9298,26,0,32},{9302,26,0,32},{9298,25,0,32},{9302,25,0,32},{9298,26,0,
32},{9473,26,0,32},{9298,25,0,32},{9473,25,0,32},{9298,26,0,32},{9474,26,0,32},
{9298,25,0,32},{9474,25,0,32},{9298,26,0,32},{9478,26,0,32},{9298,25,0,32},
{9478,25,0,32},{9298,26,0,32},{9477,26,0,32},{9298,25,0,32},{9477,25,0,32},
{9298,26,0,32},{9479,26,0,32},{9298,25,0,32},{9479,25,0,32},{9298,26,0,32},
{9493,26,0,32},{9298,25,0,32},{9493,25,0,32},{9298,23,0,32},{9493,23,0,32},
{9298,26,0,32},{9488,26,0,32},{9298,25,0,32},{9488,25,0,32},{9298,23,0,32},
{9488,23,0,32},{9298,26,0,32},{9328,26,0,32},{9298,26,0,32},{9335,26,0,32},
{9298,26,0,32},{9454,26,0,32},{9298,26,0,32},{9488,26,0,32},{9298,26,0,32},
{9489,26,0,32},{9304,26,0,32},{9328,26,0,32},{9304,26,0,32},{9335,26,0,32},
{9304,26,0,32},{9336,26,0,32},{9304,26,0,32},{9454,26,0,32},{9304,26,0,32},
{9488,26,0,32},{9304,26,0,32},{9489,26,0,32},{9320,26,0,32},{9328,26,0,32},
{9320,26,0,32},{9335,26,0,32},{9320,26,0,32},{9336,26,0,32},{9320,26,0,32},
{9454,26,0,32},{9320,26,0,32},{9488,26,0,32},{9320,26,0,32},{9489,26,0,32},
{9321,26,0,32},{9328,26,0,32},{9321,26,0,32},{9454,26,0,32},{9321,26,0,32},
{9488,26,0,32},{9321,26,0,32},{9489,26,0,32},{9328,26,0,32},{9335,26,0,32},
{9328,26,0,32},{9454,26,0,32},{9335,26,0,32},{9328,26,0,32},{9335,26,0,32},
{9454,26,0,32},{9336,26,0,32},{9328,26,0,32},{9336,26,0,32},{9335,26,0,32},
{9336,26,0,32},{9454,26,0,32},{9380,26,0,32},{9328,26,0,32},{9380,26,0,32},
{9335,26,0,32},{9380,26,0,32},{9336,26,0,32},{9380,26,0,32},{9454,26,0,32},
{9391,26,0,32},{9335,26,0,32},{9391,26,0,32},{9454,26,0,32},{9392,26,0,32},
{9328,26,0,32},{9392,26,0,32},{9335,26,0,32},{9392,26,0,32},{9336,26,0,32},
{9392,26,0,32},{9454,26,0,32},{9397,26,0,32},{9335,26,0,32},{9397,26,0,32},
{9454,26,0,32},{9398,26,0,32},{9454,26,0,32},{9401,26,0,32},{9328,26,0,32},
{9401,26,0,32},{9454,26,0,32},{9402,26,0,32},{9328,26,0,32},{9402,26,0,32},
{9454,26,0,32},{9409,26,0,32},{9328,26,0,32},{9409,26,0,32},{9335,26,0,32},
{9409,26,0,32},{9336,26,0,32},{9409,26,0,32},{9454,26,0,32},{9409,26,0,32},
{9488,26,0,32},{9409,26,0,32},{9489,26,0,32},{9421,26,0,32},{9335,26,0,32},
{9421,26,0,32},{9454,26,0,32},{9421,26,0,32},{9488,26,0,32},{9421,26,0,32},
{9489,26,0,32},{9426,26,0,32},{9302,26,0,32},{9426,26,0,32},{9328,26,0,32},
{9426,26,0,32},{9335,26,0,32},{9426,26,0,32},{9336,26,0,32},{9426,26,0,32},
{9447,26,0,32},{9426,26,0,32},{9454,26,0,32},{9426,26,0,32},{9488,26,0,32},
{9426,26,0,32},{9489,26,0,32},{9447,26,0,32},{9328,26,0,32},{9447,26,0,32},
{9335,26,0,32},{9447,26,0,32},{9336,26,0,32},{9447,26,0,32},{9454,26,0,32},
{9447,26,0,32},{9488,26,0,32},{9447,26,0,32},{9489,26,0,32},{9454,26,0,32},
{9328,26,0,32},{9454,26,0,32},{9335,26,0,32},{9454,26,0,32},{9336,26,0,32},
{9454,26,0,32},{9454,26,0,32},{9454,26,0,32},{9488,26,0,32},{9454,26,0,32},
{9489,26,0,32},{9458,26,0,32},{9328,26,0,32},{9458,26,0,32},{9335,26,0,32},
{9458,26,0,32},{9336,26,0,32},{9458,26,0,32},{9454,26,0,32},{9458,26,0,32},
{9488,26,0,32},{9458,26,0,32},{9489,26,0,32},{9468,26,0,32},{9328,26,0,32},
{9468,26,0,32},{9454,26,0,32},{9468,26,0,32},{9488,26,0,32},{9468,26,0,32},
{9489,26,0,32},{9489,26,0,32},{9328,26,0,32},{9489,26,0,32},{9335,26,0,32},
{9489,26,0,32},{9336,26,0,32},{9489,26,0,32},{9454,26,0,32},{9489,26,0,32},
{9488,26,0,32},{9489,26,0,32},{9489,26,0,32},{9347,26,0,32},{0,26,0,152},{9361,
26,0,32},{0,26,0,152},{9488,26,0,32},{0,26,0,152},{0,26,0,112},{0,26,0,128},{0,
26,0,115},{0,26,0,128},{0,26,0,118},{0,26,0,128},{0,26,0,122},{0,26,0,128},{0,
26,0,125},{0,26,0,128},{0,26,0,128},{0,26,0,152},{9298,25,0,32},{9361,25,0,32},
{9298,25,0,32},{9362,25,0,32},{9298,25,0,32},{9454,25,0,32},{9298,25,0,32},
{9458,25,0,32},{9298,25,0,32},{9488,25,0,32},{9298,25,0,32},{9489,25,0,32},
{9304,25,0,32},{9361,25,0,32},{9304,25,0,32},{9362,25,0,32},{9304,25,0,32},
{9454,25,0,32},{9304,25,0,32},{9458,25,0,32},{9304,25,0,32},{9488,25,0,32},
{9304,25,0,32},{9489,25,0,32},{9320,25,0,32},{9361,25,0,32},{9320,25,0,32},
{9362,25,0,32},{9320,25,0,32},{9454,25,0,32},{9320,25,0,32},{9458,25,0,32},
{9320,25,0,32},{9488,25,0,32},{9320,25,0,32},{9489,25,0,32},{9321,25,0,32},
{9361,25,0,32},{9321,25,0,32},{9362,25,0,32},{9321,25,0,32},{9454,25,0,32},
{9321,25,0,32},{9458,25,0,32},{9321,25,0,32},{9488,25,0,32},{9321,25,0,32},
{9489,25,0,32},{9409,25,0,32},{9488,25,0,32},{9409,25,0,32},{9489,25,0,32},
{9421,25,0,32},{9488,25,0,32},{9421,25,0,32},{9489,25,0,32},{9426,25,0,32},
{9302,25,0,32},{9426,25,0,32},{9447,25,0,32},{9426,25,0,32},{9454,25,0,32},
{9426,25,0,32},{9488,25,0,32},{9426,25,0,32},{9489,25,0,32},{9447,25,0,32},
{9454,25,0,32},{9447,25,0,32},{9488,25,0,32},{9447,25,0,32},{9489,25,0,32},
{9454,25,0,32},{9302,25,0,32},{9454,25,0,32},{9454,25,0,32},{9458,25,0,32},
{9361,25,0,32},{9458,25,0,32},{9362,25,0,32},{9458,25,0,32},{9454,25,0,32},
{9458,25,0,32},{9458,25,0,32},{9458,25,0,32},{9488,25,0,32},{9458,25,0,32},
{9489,25,0,32},{9488,25,0,32},{0,25,0,152},{9489,25,0,32},{9361,25,0,32},{9489,
25,0,32},{9362,25,0,32},{9489,25,0,32},{9454,25,0,32},{9489,25,0,32},{9458,25,0,
32},{9489,25,0,32},{9488,25,0,32},{9489,25,0,32},{9489,25,0,32},{9298,23,0,32},
{9328,23,0,32},{9298,23,0,32},{9335,23,0,32},{9298,23,0,32},{9336,23,0,32},
{9298,23,0,32},{9454,23,0,32},{9298,23,0,32},{9468,23,0,32},{9304,23,0,32},
{9328,23,0,32},{9304,23,0,32},{9335,23,0,32},{9304,23,0,32},{9336,23,0,32},
{9304,23,0,32},{9454,23,0,32},{9304,23,0,32},{9468,23,0,32},{9320,23,0,32},
{9328,23,0,32},{9320,23,0,32},{9335,23,0,32},{9320,23,0,32},{9336,23,0,32},
{9320,23,0,32},{9454,23,0,32},{9320,23,0,32},{9468,23,0,32},{9321,23,0,32},
{9454,23,0,32},{9328,23,0,32},{9335,23,0,32},{9328,23,0,32},{9454,23,0,32},
{9335,23,0,32},{9328,23,0,32},{9335,23,0,32},{9454,23,0,32},{9336,23,0,32},
{9328,23,0,32},{9336,23,0,32},{9454,23,0,32},{9380,23,0,32},{9328,23,0,32},
{9380,23,0,32},{9335,23,0,32},{9380,23,0,32},{9336,23,0,32},{9380,23,0,32},
{9454,23,0,32},{9391,23,0,32},{9335,23,0,32},{9391,23,0,32},{9336,23,0,32},
{9391,23,0,32},{9454,23,0,32},{9392,23,0,32},{9328,23,0,32},{9392,23,0,32},
{9335,23,0,32},{9392,23,0,32},{9336,23,0,32},{9392,23,0,32},{9454,23,0,32},
{9397,23,0,32},{9335,23,0,32},{9398,23,0,32},{9454,23,0,32},{9401,23,0,32},
{9328,23,0,32},{9401,23,0,32},{9454,23,0,32},{9402,23,0,32},{9328,23,0,32},
{9402,23,0,32},{9454,23,0,32},{9409,23,0,32},{9328,23,0,32},{9409,23,0,32},
{9335,23,0,32},{9409,23,0,32},{9336,23,0,32},{9409,23,0,32},{9454,23,0,32},
{9421,23,0,32},{9335,23,0,32},{9421,23,0,32},{9454,23,0,32},{9426,23,0,32},
{9328,23,0,32},{9426,23,0,32},{9335,23,0,32},{9426,23,0,32},{9336,23,0,32},
{9426,23,0,32},{9447,23,0,32},{9426,23,0,32},{9454,23,0,32},{9447,23,0,32},
{9328,23,0,32},{9447,23,0,32},{9335,23,0,32},{9447,23,0,32},{9336,23,0,32},
{9447,23,0,32},{9454,23,0,32},{9447,23,0,32},{9468,23,0,32},{9454,23,0,32},
{9328,23,0,32},{9454,23,0,32},{9335,23,0,32},{9454,23,0,32},{9336,23,0,32},
{9454,23,0,32},{9454,23,0,32},{9458,23,0,32},{9328,23,0,32},{9458,23,0,32},
{9335,23,0,32},{9458,23,0,32},{9336,23,0,32},{9458,23,0,32},{9454,23,0,32},
{9458,23,0,32},{9468,23,0,32},{9468,23,0,32},{9328,23,0,32},{9468,23,0,32},
{9454,23,0,32},{9468,23,0,32},{0,23,0,152},{9489,23,0,32},{9328,23,0,32},{9489,
23,0,32},{9335,23,0,32},{9489,23,0,32},{9336,23,0,32},{9489,23,0,32},{9454,23,0,
32},{9489,23,0,32},{9468,23,0,32},{9298,24,0,32},{9454,24,0,32},{9298,24,0,32},
{9468,24,0,32},{9304,24,0,32},{9454,24,0,32},{9304,24,0,32},{9468,24,0,32},
{9320,24,0,32},{9454,24,0,32},{9320,24,0,32},{9468,24,0,32},{9321,24,0,32},
{9454,24,0,32},{9321,24,0,32},{9468,24,0,32},{9380,24,0,32},{9454,24,0,32},
{9380,24,0,32},{9468,24,0,32},{9381,24,0,32},{9454,24,0,32},{9381,24,0,32},
{9468,24,0,32},{9426,24,0,32},{9447,24,0,32},{9426,24,0,32},{9454,24,0,32},
{9447,24,0,32},{9454,24,0,32},{9458,24,0,32},{9454,24,0,32},{9458,24,0,32},
{9468,24,0,32},{9489,24,0,32},{9454,24,0,32},{9489,24,0,32},{9468,24,0,32},{0,
24,0,118},{0,24,0,128},{0,24,0,122},{0,24,0,128},{0,24,0,125},{0,24,0,128},
{9397,26,0,32},{9488,26,0,32},{9397,26,0,32},{9489,26,0,32},{9401,26,0,32},
{9488,26,0,32},{9401,26,0,32},{9489,26,0,32},{9402,26,0,32},{9488,26,0,32},
{9402,26,0,32},{9489,26,0,32},{9380,26,0,32},{9488,26,0,32},{9380,26,0,32},
{9489,26,0,32},{9381,26,0,32},{9488,26,0,32},{9381,26,0,32},{9489,26,0,32},
{9335,26,0,32},{9488,26,0,32},{9335,26,0,32},{9489,26,0,32},{9328,26,0,32},
{9488,26,0,32},{9328,26,0,32},{9489,26,0,32},{9336,26,0,32},{9488,26,0,32},
{9336,26,0,32},{9489,26,0,32},{9391,26,0,32},{9488,26,0,32},{9391,26,0,32},
{9489,26,0,32},{9392,26,0,32},{9488,26,0,32},{9392,26,0,32},{9489,26,0,32},
{9381,26,0,32},{9328,26,0,32},{9381,26,0,32},{9335,26,0,32},{9381,26,0,32},
{9336,26,0,32},{9381,26,0,32},{9454,26,0,32},{9381,26,0,32},{9361,26,0,32},
{9380,26,0,32},{9361,26,0,32},{9391,26,0,32},{9361,26,0,32},{9392,26,0,32},
{9361,26,0,32},{9397,25,0,32},{9488,25,0,32},{9397,25,0,32},{9489,25,0,32},
{9401,25,0,32},{9488,25,0,32},{9401,25,0,32},{9489,25,0,32},{9402,25,0,32},
{9488,25,0,32},{9402,25,0,32},{9489,25,0,32},{9380,25,0,32},{9488,25,0,32},
{9380,25,0,32},{9489,25,0,32},{9381,25,0,32},{9488,25,0,32},{9381,25,0,32},
{9489,25,0,32},{9335,25,0,32},{9488,25,0,32},{9335,25,0,32},{9489,25,0,32},
{9328,25,0,32},{9488,25,0,32},{9328,25,0,32},{9489,25,0,32},{9336,25,0,32},
{9488,25,0,32},{9336,25,0,32},{9489,25,0,32},{9391,25,0,32},{9488,25,0,32},
{9391,25,0,32},{9489,25,0,32},{9392,25,0,32},{9488,25,0,32},{9392,25,0,32},
{9489,25,0,32},{9381,25,0,32},{9328,25,0,32},{9381,25,0,32},{9335,25,0,32},
{9381,25,0,32},{9336,25,0,32},{9381,25,0,32},{9454,25,0,32},{9381,25,0,32},
{9361,25,0,32},{9380,25,0,32},{9361,25,0,32},{9391,25,0,32},{9361,25,0,32},
{9392,25,0,32},{9361,25,0,32},{9381,23,0,32},{9328,23,0,32},{9381,23,0,32},
{9335,23,0,32},{9381,23,0,32},{9336,23,0,32},{9381,23,0,32},{9454,23,0,32},
{9380,23,0,32},{9468,23,0,32},{9381,23,0,32},{9468,23,0,32},{9397,23,0,32},
{9454,23,0,32},{9380,24,0,32},{9328,24,0,32},{9380,24,0,32},{9335,24,0,32},
{9380,24,0,32},{9336,24,0,32},{9381,24,0,32},{9328,24,0,32},{9381,24,0,32},
{9335,24,0,32},{9381,24,0,32},{9336,24,0,32},{9397,24,0,32},{9454,24,0,32},
{9398,24,0,32},{9454,24,0,32},{9302,25,0,32},{0,25,0,109},{9302,26,0,32},{0,26,
0,109},{9320,23,0,32},{9328,23,0,32},{9454,23,0,32},{9320,25,0,32},{9335,25,0,
32},{9328,25,0,32},{9320,23,0,32},{9335,23,0,32},{9328,23,0,32},{9320,23,0,32},
{9335,23,0,32},{9454,23,0,32},{9320,23,0,32},{9336,23,0,32},{9454,23,0,32},
{9320,23,0,32},{9454,23,0,32},{9328,23,0,32},{9320,23,0,32},{9454,23,0,32},
{9335,23,0,32},{9320,23,0,32},{9454,23,0,32},{9336,23,0,32},{9328,25,0,32},
{9454,25,0,32},{9335,25,0,32},{9328,23,0,32},{9454,23,0,32},{9335,23,0,32},
{9335,25,0,32},{9454,25,0,32},{9489,25,0,32},{9335,25,0,32},{9454,25,0,32},
{9488,25,0,32},{9380,23,0,32},{9335,23,0,32},{9328,23,0,32},{9380,23,0,32},
{9328,23,0,32},{9335,23,0,32},{9380,25,0,32},{9328,25,0,32},{9488,25,0,32},
{9380,25,0,32},{9454,25,0,32},{9335,25,0,32},{9380,23,0,32},{9454,23,0,32},
{9335,23,0,32},{9380,23,0,32},{9454,23,0,32},{9328,23,0,32},{9380,25,0,32},
{9454,25,0,32},{9454,25,0,32},{9380,23,0,32},{9454,23,0,32},{9454,23,0,32},
{9391,25,0,32},{9335,25,0,32},{9335,25,0,32},{9391,23,0,32},{9335,23,0,32},
{9335,23,0,32},{9391,25,0,32},{9454,25,0,32},{9454,25,0,32},{9381,25,0,32},
{9335,25,0,32},{9454,25,0,32},{9381,23,0,32},{9335,23,0,32},{9454,23,0,32},
{9381,25,0,32},{9328,25,0,32},{9489,25,0,32},{9381,25,0,32},{9454,25,0,32},
{9336,25,0,32},{9381,23,0,32},{9454,23,0,32},{9336,23,0,32},{9381,25,0,32},
{9454,25,0,32},{9454,25,0,32},{9381,23,0,32},{9454,23,0,32},{9454,23,0,32},
{9392,25,0,32},{9335,25,0,32},{9488,25,0,32},{9392,25,0,32},{9336,25,0,32},
{9454,25,0,32},{9392,23,0,32},{9336,23,0,32},{9454,23,0,32},{9397,25,0,32},
{9454,25,0,32},{9335,25,0,32},{9397,23,0,32},{9454,23,0,32},{9335,23,0,32},
{9397,23,0,32},{9454,23,0,32},{9454,23,0,32},{9397,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9401,25,0,32},{9328,25,0,32},{9454,25,0,32},{9401,25,0,32},
{9454,25,0,32},{9454,25,0,32},{9401,23,0,32},{9454,23,0,32},{9454,23,0,32},
{9401,25,0,32},{9454,25,0,32},{9488,25,0,32},{9402,25,0,32},{9454,25,0,32},
{9454,25,0,32},{9402,25,0,32},{9454,25,0,32},{9489,25,0,32},{9402,25,0,32},
{9454,25,0,32},{9488,25,0,32},{9409,25,0,32},{9336,25,0,32},{9454,25,0,32},
{9409,23,0,32},{9336,23,0,32},{9454,23,0,32},{9421,25,0,32},{9454,25,0,32},
{9335,25,0,32},{9421,25,0,32},{9454,25,0,32},{9454,25,0,32},{9447,25,0,32},
{9335,25,0,32},{9454,25,0,32},{9447,25,0,32},{9335,25,0,32},{9489,25,0,32},
{9447,25,0,32},{9335,25,0,32},{9488,25,0,32},{9447,23,0,32},{9328,23,0,32},
{9328,23,0,32},{9447,25,0,32},{9328,25,0,32},{9328,25,0,32},{9447,25,0,32},
{9336,25,0,32},{9454,25,0,32},{9447,23,0,32},{9336,23,0,32},{9454,23,0,32},
{9447,25,0,32},{9454,25,0,32},{9335,25,0,32},{9447,23,0,32},{9454,23,0,32},
{9335,23,0,32},{9454,23,0,32},{9335,23,0,32},{9328,23,0,32},{9454,23,0,32},
{9335,23,0,32},{9454,23,0,32},{9454,25,0,32},{9335,25,0,32},{9489,25,0,32},
{9454,23,0,32},{9328,23,0,32},{9335,23,0,32},{9454,23,0,32},{9328,23,0,32},
{9454,23,0,32},{9454,23,0,32},{9336,23,0,32},{9328,23,0,32},{9454,23,0,32},
{9336,23,0,32},{9454,23,0,32},{9454,23,0,32},{9328,23,0,32},{9336,23,0,32},
{9468,23,0,32},{9454,23,0,32},{9328,23,0,32},{9468,23,0,32},{9454,23,0,32},
{9454,23,0,32},{9458,23,0,32},{9335,23,0,32},{9454,23,0,32},{9458,25,0,32},
{9335,25,0,32},{9488,25,0,32},{9458,25,0,32},{9328,25,0,32},{9454,25,0,32},
{9458,23,0,32},{9328,23,0,32},{9454,23,0,32},{9458,25,0,32},{9328,25,0,32},
{9488,25,0,32},{9458,25,0,32},{9454,25,0,32},{9489,25,0,32},{9458,25,0,32},
{9454,25,0,32},{9488,25,0,32},{9489,25,0,32},{9454,25,0,32},{9454,25,0,32},
{9489,23,0,32},{9454,23,0,32},{9454,23,0,32},{9304,25,0,32},{9336,25,0,32},
{9489,25,0,32},{9320,25,0,32},{9328,25,0,32},{9489,25,0,32},{9320,25,0,32},
{9328,25,0,32},{9488,25,0,32},{9320,25,0,32},{9336,25,0,32},{9489,25,0,32},
{9320,25,0,32},{9336,25,0,32},{9488,25,0,32},{9320,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9320,25,0,32},{9454,25,0,32},{9488,25,0,32},{9328,25,0,32},
{9454,25,0,32},{9489,25,0,32},{9328,25,0,32},{9335,25,0,32},{9488,25,0,32},
{9328,25,0,32},{9454,25,0,32},{9488,25,0,32},{9380,25,0,32},{9336,25,0,32},
{9488,25,0,32},{9391,25,0,32},{9335,25,0,32},{9489,25,0,32},{9381,25,0,32},
{9335,25,0,32},{9489,25,0,32},{9392,25,0,32},{9335,25,0,32},{9489,25,0,32},
{9447,25,0,32},{9328,25,0,32},{9489,25,0,32},{9447,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9489,25,0,32},{9335,25,0,32},{9489,25,0,32},{9489,25,0,32},
{9328,25,0,32},{9489,25,0,32},{9489,25,0,32},{9454,25,0,32},{9489,25,0,32},
{9454,25,0,32},{9454,25,0,32},{9489,25,0,32},{9421,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9458,25,0,32},{9335,25,0,32},{9489,25,0,32},{9421,23,0,32},
{9454,23,0,32},{9335,23,0,32},{9447,23,0,32},{9335,23,0,32},{9454,23,0,32},
{9401,25,0,32},{9454,25,0,32},{9489,25,0,32},{9426,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9458,23,0,32},{9328,23,0,32},{9335,23,0,32},{9454,25,0,32},
{9336,25,0,32},{9489,25,0,32},{9447,23,0,32},{9328,23,0,32},{9454,23,0,32},
{9426,25,0,32},{9454,25,0,32},{9454,25,0,32},{9447,25,0,32},{9328,25,0,32},
{9454,25,0,32},{9458,25,0,32},{9328,25,0,32},{9335,25,0,32},{9328,25,0,32},
{9335,25,0,32},{9489,25,0,32},{9335,25,0,32},{9328,25,0,32},{9489,25,0,32},
{9454,25,0,32},{9328,25,0,32},{9489,25,0,32},{9409,25,0,32},{9454,25,0,32},
{9489,25,0,32},{9304,25,0,32},{9335,25,0,32},{9489,25,0,32},{9426,23,0,32},
{9454,23,0,32},{9454,23,0,32},{9401,23,0,32},{9328,23,0,32},{9454,23,0,32},
{9391,23,0,32},{9454,23,0,32},{9454,23,0,32},{9380,25,0,32},{9336,25,0,32},
{9489,25,0,32},{9458,25,0,32},{9328,25,0,32},{9489,25,0,32},{9391,26,0,32},
{9447,26,0,32},{9503,26,0,32},{9421,26,0,32},{9447,26,0,32},{9503,26,0,32},
{9302,26,0,32},{9447,26,0,32},{9447,26,0,32},{9468,26,0,32},{9302,26,0,32},
{9426,26,0,32},{9304,26,0,32},{9361,26,0,32},{9454,26,0,32},{9335,26,0,32},
{9454,26,0,32},{9346,26,0,32},{9391,26,0,32},{9447,26,0,32},{9401,26,0,32},
{9454,26,0,32},{9361,26,0,32},{9380,26,0,32},{9474,26,0,32},{9447,26,0,32},
{9401,26,0,32},{9447,26,0,32},{9489,26,0,32},{9468,26,0,32},{9474,26,0,32},
{9380,26,0,32},{9447,26,0,32},{9454,26,0,32},{9391,26,0,32},{9447,26,0,32},
{9488,26,0,32},{9391,26,0,32},{9447,26,0,32},{9488,26,0,32},{521,26,1,32},{9302,
26,0,32},{9447,26,0,32},{9447,26,0,32},{9468,26,0,32},{521,26,1,32},{9401,26,0,
32},{9447,26,0,32},{9489,26,0,32},{9468,26,0,32},{521,26,1,32},{9474,26,0,32},
{9380,26,0,32},{9447,26,0,32},{9454,26,0,32},{9328,26,0,32},{9447,26,0,32},{521,
26,1,32},{9328,26,0,32},{9447,26,0,32},{9302,26,0,32},{9447,26,0,32},{9468,26,0,
32},{9361,26,0,32},{9490,26,0,32},{9302,26,0,32},{9447,26,0,32},{635,22,1,32},
{635,22,1,32},{635,22,1,32},{635,22,1,32},{635,22,1,32},{9447,26,0,32},{9289,26,
0,32},{9447,25,0,32},{9289,25,0,32},{9447,26,0,32},{9290,26,0,32},{9447,25,0,
32},{9290,25,0,32},{9447,26,0,32},{9294,26,0,32},{9447,25,0,32},{9294,25,0,32},
{9447,26,0,32},{9302,26,0,32},{9447,25,0,32},{9302,25,0,32},{22102,4,0,32},{0,4,
0,274},{22103,4,0,32},{0,4,0,274},{22104,4,0,32},{0,4,0,274},{22105,4,0,32},{0,
4,0,274},{22106,4,0,32},{0,4,0,274},{22107,4,0,32},{0,4,0,274},{22108,4,0,32},
{0,4,0,274},{22108,4,0,32},{0,4,0,275},{22109,4,0,32},{0,4,0,274},{22110,4,0,
32},{0,4,0,274},{22111,4,0,32},{0,4,0,274},{22111,4,0,32},{0,4,0,275},{22112,4,
0,32},{0,4,0,274},{22112,4,0,32},{0,4,0,275},{22113,4,0,32},{0,4,0,274},{22113,
4,0,32},{0,4,0,275},{22114,4,0,32},{0,4,0,274},{22115,4,0,32},{0,4,0,274},
{22116,4,0,32},{0,4,0,274},{22117,4,0,32},{0,4,0,275},{22117,4,0,32},{0,4,0,
276},{22118,4,0,32},{0,4,0,274},{22119,4,0,32},{0,4,0,274},{22120,4,0,32},{0,4,
0,274},{22121,4,0,32},{0,4,0,274},{22121,4,0,32},{0,4,0,275},{22122,4,0,32},{0,
4,0,274},{22122,4,0,32},{0,4,0,275},{22123,4,0,32},{0,4,0,274},{22124,4,0,32},
{0,4,0,274},{22117,4,0,32},{0,4,0,274},{19770,4,0,32},{0,4,0,275},{19609,4,0,
32},{0,4,0,274},{14808,4,0,32},{0,4,0,274},{14810,4,0,32},{0,4,0,274},{14813,4,
0,32},{0,4,0,274},{14814,4,0,32},{0,4,0,274},{14815,4,0,32},{0,4,0,274},{14816,
4,0,32},{0,4,0,274},{14817,4,0,32},{0,4,0,274},{14818,4,0,32},{0,4,0,274},
{14820,4,0,32},{0,4,0,274},{14821,4,0,32},{0,4,0,274},{14822,4,0,32},{0,4,0,
274},{14823,4,0,32},{0,4,0,274},{14824,4,0,32},{0,4,0,274},{14825,4,0,32},{0,4,
0,274},{14830,4,0,32},{0,4,0,274},{14831,4,0,32},{0,4,0,274},{14832,4,0,32},{0,
4,0,274},{14833,4,0,32},{0,4,0,274},{14835,4,0,32},{0,4,0,274},{14839,4,0,32},
{0,4,0,274},{14840,4,0,32},{0,4,0,274},{14841,4,0,32},{0,4,0,274},{14842,4,0,
32},{0,4,0,274},{14843,4,0,32},{0,4,0,274},{14847,4,0,32},{0,4,0,274},{14848,4,
0,32},{0,4,0,274},{14849,4,0,32},{0,4,0,274},{14850,4,0,32},{0,4,0,274},{14767,
10,0,32},{0,4,0,274},{14775,10,0,32},{0,4,0,274},{14775,10,0,32},{0,4,0,275},
{14780,10,0,32},{0,4,0,274},{14790,10,0,32},{0,4,0,274},{14791,10,0,32},{0,4,0,
274},{14791,10,0,32},{0,4,0,275},{14794,10,0,32},{0,4,0,274},{14801,10,0,32},{0,
4,0,274},{14802,10,0,32},{0,4,0,274},{14767,4,0,32},{0,4,0,274},{14775,4,0,32},
{0,4,0,274},{14775,4,0,32},{0,4,0,275},{14780,4,0,32},{0,4,0,274},{14790,4,0,
32},{0,4,0,274},{14791,4,0,32},{0,4,0,274},{14791,4,0,32},{0,4,0,275},{14794,4,
0,32},{0,4,0,274},{14801,4,0,32},{0,4,0,274},{14802,4,0,32},{0,4,0,274},{19810,
4,0,32},{0,4,0,275},{19812,4,0,32},{0,4,0,275},{19814,4,0,32},{0,4,0,275},
{19817,4,0,32},{0,4,0,275},{19812,4,0,32},{19815,4,0,32},{19835,4,0,32},{0,4,0,
275},{11061,2,0,32},{0,2,0,194},{11062,2,0,32},{0,2,0,194},{11071,2,0,32},{0,2,
0,194},{11549,4,0,32},{0,4,0,274},{11549,4,0,32},{0,4,0,275},{11550,4,0,32},{0,
4,0,274},{11551,4,0,32},{0,4,0,274},{11597,4,0,32},{0,4,0,274},{11598,4,0,32},
{0,4,0,274},{11782,4,0,32},{0,4,0,274},{11798,4,0,32},{0,4,0,274},{11785,4,0,
32},{0,4,0,274},{7557,4,0,32},{0,4,0,274},{7558,4,0,32},{0,4,0,274},{7559,2,0,
32},{0,2,0,274},{4474,2,1,32},{0,0,0,0},{4475,2,1,32},{0,0,0,0},{4475,2,1,32},
{0,0,0,0},{0,0,0,0},{4475,2,1,32},{0,0,0,0},{0,0,0,0},{4475,2,1,32},{0,0,0,0},
{0,0,0,0},{4475,2,1,32},{0,0,0,0},{0,0,0,0},{4475,2,1,32},{0,0,0,0},{0,0,0,0},
{4527,2,1,32},{0,0,0,0},{4527,2,1,32},{0,0,0,0},{0,0,0,0},{4527,2,1,32},{0,0,0,
0},{0,0,0,0},{4528,2,1,32},{0,0,0,0},{4528,2,1,32},{0,0,0,0},{0,0,0,0},{4528,2,
1,32},{0,0,0,0},{0,0,0,0},{7557,4,0,32},{0,4,0,274},{7558,4,0,32},{0,4,0,274},
{7556,4,0,32},{635,4,1,32},{7556,4,0,32},{546,4,1,32},{7557,4,0,32},{546,4,1,
32},{7558,4,0,32},{546,4,1,32},{7559,4,0,32},{546,4,1,32},{7560,4,0,32},{546,4,
1,32},{7561,4,0,32},{546,4,1,32},{7562,4,0,32},{546,4,1,32},{7563,4,0,32},{546,
4,1,32},{7564,4,0,32},{546,4,1,32},{7565,4,0,32},{546,4,1,32},{803,4,1,32},
{7566,10,0,32},{804,4,1,32},{803,4,1,32},{7591,10,0,32},{804,4,1,32},{803,4,1,
32},{7617,10,0,32},{804,4,1,32},{803,4,1,32},{7638,10,0,32},{804,4,1,32},{803,4,
1,32},{7665,10,0,32},{804,4,1,32},{803,4,1,32},{7724,10,0,32},{804,4,1,32},{803,
4,1,32},{7739,10,0,32},{804,4,1,32},{803,4,1,32},{7775,10,0,32},{804,4,1,32},
{803,4,1,32},{7801,10,0,32},{804,4,1,32},{803,4,1,32},{7827,10,0,32},{804,4,1,
32},{803,4,1,32},{7852,10,0,32},{804,4,1,32},{803,4,1,32},{7870,10,0,32},{804,4,
1,32},{803,4,1,32},{7921,10,0,32},{804,4,1,32},{803,4,1,32},{7936,10,0,32},{804,
4,1,32},{803,4,1,32},{7972,10,0,32},{804,4,1,32},{803,4,1,32},{8019,10,0,32},
{804,4,1,32},{803,4,1,32},{8040,10,0,32},{804,4,1,32},{803,4,1,32},{8059,10,0,
32},{804,4,1,32},{803,4,1,32},{8121,10,0,32},{804,4,1,32},{803,4,1,32},{8157,10,
0,32},{804,4,1,32},{803,4,1,32},{8189,10,0,32},{804,4,1,32},{803,4,1,32},{8236,
10,0,32},{804,4,1,32},{803,4,1,32},{8254,10,0,32},{804,4,1,32},{803,4,1,32},
{8264,10,0,32},{804,4,1,32},{803,4,1,32},{8276,10,0,32},{804,4,1,32},{803,4,1,
32},{8298,10,0,32},{804,4,1,32},{901,4,1,32},{8121,10,0,32},{902,4,1,32},{7617,
12,0,32},{7638,12,0,32},{8254,12,0,32},{8298,12,0,32},{7775,29,0,32},{8236,29,0,
32},{7921,29,0,32},{8236,29,0,32},{8121,29,0,32},{7638,29,0,32},{8121,29,0,32},
{8121,29,0,32},{8019,29,0,32},{8019,29,0,32},{8236,29,0,32},{8254,29,0,32},
{7617,29,0,32},{7921,20,0,32},{7617,20,0,32},{7921,20,0,32},{7638,20,0,32},
{7801,29,0,32},{7617,29,0,32},{8019,29,0,32},{7566,29,0,32},{8121,29,0,32},
{7566,29,0,32},{7566,29,0,32},{7591,29,0,32},{8254,29,0,32},{7617,29,0,32},
{7638,29,0,32},{7827,29,0,32},{7617,29,0,32},{7870,29,0,32},{7617,29,0,32},
{7972,29,0,32},{7972,29,0,32},{7870,29,0,32},{7724,29,0,32},{8059,29,0,32},
{7665,29,0,32},{7665,29,0,32},{7801,29,0,32},{7638,29,0,32},{7936,29,0,32},
{7665,29,0,32},{8254,29,0,32},{7936,29,0,32},{7739,29,0,32},{7972,29,0,32},
{7852,29,0,32},{8121,29,0,32},{7972,29,0,32},{8121,29,0,32},{8189,29,0,32},
{8019,29,0,32},{612,28,1,32},{8236,29,0,32},{8121,29,0,32},{7559,28,0,32},{7638,
29,0,32},{7558,28,0,32},{7936,28,0,32},{7638,28,0,32},{521,28,1,32},{8121,29,0,
32},{7617,28,0,32},{8059,28,0,32},{7558,28,0,32},{7852,29,0,32},{7560,28,0,32},
{7852,29,0,32},{7564,28,0,32},{7852,29,0,32},{7561,28,0,32},{635,28,1,32},{7557,
28,0,32},{7563,28,0,32},{635,28,1,32},{7557,28,0,32},{7558,28,0,32},{7558,28,0,
32},{635,28,1,32},{7558,28,0,32},{7562,28,0,32},{7556,28,0,32},{8019,29,0,32},
{7557,28,0,32},{7558,28,0,32},{7556,28,0,32},{8019,29,0,32},{7775,29,0,32},
{7617,28,0,32},{7775,29,0,32},{7638,28,0,32},{8059,29,0,32},{7775,29,0,32},
{7801,28,0,32},{521,28,1,32},{8059,29,0,32},{7665,28,0,32},{8121,28,0,32},{7870,
29,0,32},{7972,28,0,32},{8121,28,0,32},{8121,28,0,32},{7870,28,0,32},{7665,28,0,
32},{8121,28,0,32},{8121,28,0,32},{8121,29,0,32},{7775,29,0,32},{8236,29,0,32},
{8189,29,0,32},{7775,29,0,32},{7638,29,0,32},{8236,29,0,32},{7972,29,0,32},
{7638,29,0,32},{16451,28,0,32},{16427,28,0,32},{16431,28,0,32},{16431,28,0,32},
{64320,28,0,32},{57931,0,0,0},{64320,28,0,32},{56151,0,0,0},{64320,28,0,32},
{54220,0,0,0},{16440,28,0,32},{0,28,0,55},{64320,28,0,32},{52876,0,0,0},{64320,
28,0,32},{55578,0,0,0},{64321,28,0,32},{35299,0,0,0},{64320,28,0,32},{55593,0,0,
0},{64320,28,0,32},{52900,0,0,0},{64320,28,0,32},{58912,0,0,0},{64320,28,0,32},
{61729,0,0,0},{64320,28,0,32},{58777,0,0,0},{64320,28,0,32},{53837,0,0,0},
{64320,28,0,32},{57228,0,0,0},{64320,28,0,32},{53645,0,0,0},{64320,28,0,32},
{58800,0,0,0},{64320,28,0,32},{53789,0,0,0},{64320,28,0,32},{64834,0,0,0},
{64320,28,0,32},{62751,0,0,0},{64321,28,0,32},{36009,0,0,0},{64320,28,0,32},
{55536,0,0,0},{64320,28,0,32},{54329,0,0,0},{64320,28,0,32},{61204,0,0,0},
{64320,28,0,32},{58005,0,0,0},{64320,28,0,32},{58197,0,0,0},{64320,28,0,32},
{52736,0,0,0},{64320,28,0,32},{52745,0,0,0},{64321,28,0,32},{36938,0,0,0},
{64320,28,0,32},{56806,0,0,0},{64320,28,0,32},{52781,0,0,0},{64320,28,0,32},
{54259,0,0,0},{64320,28,0,32},{58119,0,0,0},{64321,28,0,32},{36208,0,0,0},
{64320,28,0,32},{57939,0,0,0},{64320,28,0,32},{63873,0,0,0},{64320,28,0,32},
{64122,0,0,0},{64320,28,0,32},{54280,0,0,0},{64320,28,0,32},{61056,0,0,0},
{64320,28,0,32},{59145,0,0,0},{64320,28,0,32},{59144,0,0,0},{64320,28,0,32},
{62771,0,0,0},{64320,28,0,32},{53874,0,0,0},{64320,28,0,32},{54710,0,0,0},
{64321,28,0,32},{37197,0,0,0},{901,4,1,32},{64320,4,0,32},{59180,0,0,0},{902,4,
1,32},{901,4,1,32},{64320,4,0,32},{52745,0,0,0},{902,4,1,32},{901,4,1,32},
{64320,4,0,32},{52876,0,0,0},{902,4,1,32},{901,4,1,32},{64320,4,0,32},{56201,0,
0,0},{902,4,1,32},{901,4,1,32},{64320,4,0,32},{61625,0,0,0},{902,4,1,32},{901,4,
1,32},{64320,4,0,32},{57939,0,0,0},{902,4,1,32},{901,4,1,32},{64320,4,0,32},
{63191,0,0,0},{902,4,1,32},{901,4,1,32},{64320,4,0,32},{53981,0,0,0},{902,4,1,
32},{901,4,1,32},{64320,4,0,32},{58711,0,0,0},{902,4,1,32},{64320,6,0,32},
{57239,0,0,0},{64320,6,0,32},{54255,0,0,0},{64388,2,0,32},{33058,0,0,0},{64388,
2,0,32},{34076,0,0,0},{64388,2,0,32},{34085,0,0,0},{64388,2,0,32},{34123,0,0,0},
{64388,2,0,32},{34362,0,0,0},{64388,2,0,32},{34820,0,0,0},{64388,2,0,32},{35038,
0,0,0},{64388,2,0,32},{35372,0,0,0},{64388,2,0,32},{35683,0,0,0},{64388,2,0,32},
{38116,0,0,0},{64388,2,0,32},{38568,0,0,0},{64388,2,0,32},{38634,0,0,0},{64388,
2,0,32},{39368,0,0,0},{64388,2,0,32},{39704,0,0,0},{64388,2,0,32},{40203,0,0,0},
{64388,2,0,32},{40420,0,0,0},{64388,2,0,32},{40422,0,0,0},{64388,2,0,32},{41347,
0,0,0},{64388,2,0,32},{41375,0,0,0},{64388,2,0,32},{41777,0,0,0},{64388,2,0,32},
{42708,0,0,0},{64388,2,0,32},{43076,0,0,0},{64388,2,0,32},{43082,0,0,0},{64388,
2,0,32},{43788,0,0,0},{64388,2,0,32},{44017,0,0,0},{64388,2,0,32},{45066,0,0,0},
{64388,2,0,32},{45752,0,0,0},{64388,2,0,32},{45919,0,0,0},{64388,2,0,32},{45971,
0,0,0},{64388,2,0,32},{45980,0,0,0},{64388,2,0,32},{46019,0,0,0},{64388,2,0,32},
{46037,0,0,0},{64388,2,0,32},{46189,0,0,0},{64388,2,0,32},{46755,0,0,0},{64388,
2,0,32},{47271,0,0,0},{64388,2,0,32},{47757,0,0,0},{64388,2,0,32},{47866,0,0,0},
{64388,2,0,32},{48316,0,0,0},{64388,2,0,32},{48414,0,0,0},{64388,2,0,32},{48849,
0,0,0},{64388,2,0,32},{48990,0,0,0},{64388,2,0,32},{49038,0,0,0},{64388,2,0,32},
{49763,0,0,0},{64388,2,0,32},{49902,0,0,0},{64388,2,0,32},{50091,0,0,0},{64388,
2,0,32},{50696,0,0,0},{64388,2,0,32},{50997,0,0,0},{64388,2,0,32},{51220,0,0,0},
{64388,2,0,32},{52278,0,0,0},{64388,2,0,32},{52370,0,0,0},{64388,2,0,32},{53153,
0,0,0},{64388,2,0,32},{53176,0,0,0},{64388,2,0,32},{53316,0,0,0},{64388,2,0,32},
{53490,0,0,0},{64388,2,0,32},{53491,0,0,0},{64388,2,0,32},{53529,0,0,0},{64388,
2,0,32},{53555,0,0,0},{64388,2,0,32},{53833,0,0,0},{64388,2,0,32},{54301,0,0,0},
{64388,2,0,32},{54822,0,0,0},{64388,2,0,32},{54938,0,0,0},{64388,2,0,32},{54981,
0,0,0},{64388,2,0,32},{55676,0,0,0},{64388,2,0,32},{55975,0,0,0},{64388,2,0,32},
{56235,0,0,0},{64388,2,0,32},{56448,0,0,0},{64388,2,0,32},{56528,0,0,0},{64388,
2,0,32},{57222,0,0,0},{64388,2,0,32},{57818,0,0,0},{64388,2,0,32},{57896,0,0,0},
{64388,2,0,32},{57927,0,0,0},{64388,2,0,32},{58073,0,0,0},{64388,2,0,32},{58174,
0,0,0},{64388,2,0,32},{58586,0,0,0},{64388,2,0,32},{58659,0,0,0},{64388,2,0,32},
{58792,0,0,0},{64388,2,0,32},{59303,0,0,0},{64388,2,0,32},{59317,0,0,0},{64388,
2,0,32},{60220,0,0,0},{64388,2,0,32},{60470,0,0,0},{64388,2,0,32},{60629,0,0,0},
{64388,2,0,32},{60779,0,0,0},{64388,2,0,32},{61228,0,0,0},{64388,2,0,32},{61361,
0,0,0},{64388,2,0,32},{61650,0,0,0},{64388,2,0,32},{62410,0,0,0},{64388,2,0,32},
{63079,0,0,0},{64388,2,0,32},{63662,0,0,0},{64388,2,0,32},{63846,0,0,0},{64388,
2,0,32},{64680,0,0,0},{64388,2,0,32},{65235,0,0,0},{64388,2,0,32},{65327,0,0,0},
{64389,2,0,32},{34258,0,0,0},{64389,2,0,32},{34285,0,0,0},{64389,2,0,32},{34606,
0,0,0},{64389,2,0,32},{35834,0,0,0},{64389,2,0,32},{36215,0,0,0},{64389,2,0,32},
{37189,0,0,0},{64389,2,0,32},{37343,0,0,0},{64389,2,0,32},{37402,0,0,0},{64389,
2,0,32},{37898,0,0,0},{64389,2,0,32},{38038,0,0,0},{64389,2,0,32},{38326,0,0,0},
{64389,2,0,32},{39728,0,0,0},{64389,2,0,32},{41166,0,0,0},{64389,2,0,32},{41221,
0,0,0},{64389,2,0,32},{41486,0,0,0},{64389,2,0,32},{41617,0,0,0},{64389,2,0,32},
{41874,0,0,0},{64389,2,0,32},{42496,0,0,0}};
