#ifndef WAVEFORMMARKSET_H
#define WAVEFORMMARKSET_H

#include <QList>

#include "waveformmark.h"
#include "skin/skincontext.h"
#include "util/memory.h"

class WaveformWidgetRenderer;

class WaveformMarkSet {
  public:
    WaveformMarkSet();
    virtual ~WaveformMarkSet();

    void setup(const QString& group, const QDomNode& node,
               const SkinContext& context,
               const WaveformSignalColors& signalColors);

    inline QList<WaveformMarkPointer>::const_iterator begin() const { return m_marks.begin(); }
    inline QList<WaveformMarkPointer>::const_iterator end() const { return m_marks.end(); }

    // hotCue must be valid (>= 0 and < NUM_HOT_CUES)
    WaveformMarkPointer getHotCueMark(int hotCue) const;

  private:
    void clear(){ m_marks.clear(); }
    std::unique_ptr<WaveformMark> m_pDefaultMark;
    QList<WaveformMarkPointer> m_marks;
    QMap<int, WaveformMarkPointer> m_hotCueMarks;

    DISALLOW_COPY_AND_ASSIGN(WaveformMarkSet);
};

#endif // WAVEFORMMARKSET_H
