/***************************** LICENSE START ***********************************

 Copyright 2018 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQECLAYERHELP_H
#define MVQECLAYERHELP_H

#include "MvQRequestPanelHelp.h"
#include "Parameter.h"

#include <QPen>
#include <QWidget>
#include <QAbstractItemModel>
#include <QStyledItemDelegate>

class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QSlider;
class QSpinBox;
class QTabWidget;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;

class MvQEcLayerDbItem;
class RequestPanel;

class MvQEcLayerTreeWidget;

#if 0
class MvQEcLayerDelegate : public QStyledItemDelegate
{
public:
    MvQEcLayerDelegate(QWidget *parent=0);
    void paint(QPainter *painter,const QStyleOptionViewItem &option,
                   const QModelIndex& index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

protected:
    QColor borderCol_;
};
#endif


//Model to dislay/select the suites
class MvQEcLayerModel : public QAbstractItemModel
{
public:
    enum CustomItemRole {SortRole=Qt::UserRole+1};

    explicit MvQEcLayerModel(QObject *parent=0);
    ~MvQEcLayerModel();

    int columnCount (const QModelIndex& parent = QModelIndex() ) const;
    int rowCount (const QModelIndex& parent = QModelIndex() ) const;

    QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
    QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;

    QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
    QModelIndex parent (const QModelIndex & ) const;

    void setFilter(QString s);
    void clearFilter();

protected:
    bool isFiltered(MvQEcLayerDbItem *item) const;

    QString filter_;
};

class MvQEcLayerSelectionWidget : public QWidget
{
    Q_OBJECT
public:
    MvQEcLayerSelectionWidget(QWidget* parent=0);
    void setCurrent(const std::string&);

protected slots:
    void slotNameFilter(QString s);
    void slotItemSelected(const QModelIndex&);
    void slotClearFilter();

signals:
    void itemSelected(int);

protected:
    bool ignoreFilterChanged_;    
    QLineEdit *nameLe_;

    MvQEcLayerTreeWidget *browser_;
    MvQEcLayerModel* model_;
    QSortFilterProxyModel *sortModel_;
};

class MvQEcLayerHelp : public MvQRequestPanelHelp
{
Q_OBJECT

public:
    MvQEcLayerHelp(RequestPanel& owner,const Parameter& param);
    ~MvQEcLayerHelp() {}

    void start() {}
    bool dialog() {return false;}
    QWidget* widget() {return selector_;}

public slots:
    void slotSelected(int);

protected:
    virtual void refresh(const vector<string>&);

private:
    MvQEcLayerSelectionWidget* selector_;
    QString oriName_;
};

#endif

