/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "jit-cache.h"

void
jit_cache_add(struct jit_cache *cache, unsigned long state, unsigned long pc, void *func)
{
	struct jit_entry *e;
	unsigned int hash;

	e = malloc(sizeof(*e));
	assert(e);

	e->state = state;
	e->pc = pc;
	e->func = func;

	hash = (e->state ^ e->pc) % 1024;

	e->prev = cache->last[hash];
	e->next = NULL;
	if (e->prev) {
		e->prev->next = e;
	} else {
		cache->first[hash] = e;
	}
	cache->last[hash] = e;
}

void *
jit_cache_lookup(struct jit_cache *cache, unsigned long state, unsigned long pc) 
{
	unsigned int hash;
	struct jit_entry *e;

	hash = (state ^ pc) % 1024;

	for (e = cache->first[hash]; ; e = e->next) {
		if (! e) {
			return NULL;
		}   
		if (e->state == state
		 && e->pc == pc) {
			return e->func;
		}   
	}   
}

void
jit_cache_reset(struct jit_cache *jit)
{
}

void
jit_cache_create(struct jit_cache *jit)
{
        unsigned int hash;

        for (hash = 0; hash < sizeof(jit->first) / sizeof(jit->first[0]); hash++) {
                jit->first[hash] = NULL;
                jit->last[hash] = NULL;
        }
}

void
jit_cache_destroy(struct jit_cache *jit)
{
}
