/*
 *  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "trans_pnp.h"

#define COMP_(x)	trans_pnp_ ## x

struct cpssp {
	unsigned int state_emitter;
	struct sig_std_logic *port_collector;
	unsigned int state_basis;
};

static void
COMP_(update)(struct cpssp *cpssp)
{
	if (cpssp->state_basis < cpssp->state_emitter) {
		sig_std_logic_set(cpssp->port_collector, cpssp,
				SIG_COMB(cpssp->state_emitter, -1));
	} else {
		sig_std_logic_set(cpssp->port_collector, cpssp,
				SIG_STD_LOGIC_0); /* FIXME */
	}
}

static void
COMP_(emitter_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_emitter = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(basis_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_basis = SIG_mV(val);
	COMP_(update)(cpssp);
}

void *
COMP_(create)(
	const char *name,
        struct sig_manage *port_manage,
	struct sig_std_logic *port_emitter,
	struct sig_std_logic *port_collector,
	struct sig_std_logic *port_basis
)
{
	static const struct sig_std_logic_funcs emitter_funcs = {
		.std_logic_set = COMP_(emitter_set),
	};
	static const struct sig_std_logic_funcs basis_funcs = {
		.std_logic_set = COMP_(basis_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_collector = port_collector;
	sig_std_logic_connect_out(port_collector, cpssp, SIG_STD_LOGIC_Z);

	/* In */
	cpssp->state_emitter = 0;
	sig_std_logic_connect_in(port_emitter, cpssp, &emitter_funcs);
	cpssp->state_basis = 0;
	sig_std_logic_connect_in(port_basis, cpssp, &basis_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
