package main

import (
	"bytes"
	"flag"
	"fmt"
	"io/ioutil"
	"net/http"
)

var (
	_bucket   = flag.String("b", "", "the bucket name")
	_operator = flag.String("o", "", "the operator")
	_passwd   = flag.String("p", "", "the operator password")
	_uri      = flag.String("u", "", "the request uri")
	_method   = flag.String("m", "", "the request method")
	_data     = flag.String("d", "", "the request data")

	_host = "v0.api.upyun.com"
)

func main() {
	flag.Parse()
	if err := checkOptions(); err != nil {
		fmt.Println(err)
		return
	}

	var err error
	switch *_method {
	case "GET":
		err = doGet()
	case "PUT":
		err = doPut()
	case "DELETE":
		err = doDelete()
	case "POST":
		err = doPost()
	default:
		fmt.Println("Unsupported method:", *_method)
		return
	}
	if err != nil {
		fmt.Printf("Failed to [%s]: %v\n", *_method, err)
		return
	}
}

func doGet() error {
	req, err := http.NewRequest("GET", "http://"+_host+*_uri, nil)
	if err != nil {
		return err
	}

	var date = makeRFC1123Date()
	doSetHeader(req, date, "", 0)

	var cli = new(http.Client)
	resp, err := cli.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	dumpResponse(resp)
	return nil
}

func doPut() error {
	var data = "{\"name\":\"deepin\"}"
	var body = bytes.NewBufferString(data)
	req, err := http.NewRequest("PUT", "http://"+_host+*_uri, body)
	if err != nil {
		return err
	}
	var date = makeRFC1123Date()
	doSetHeader(req, date, md5Str(data), len(data))

	var cli = new(http.Client)
	resp, err := cli.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	dumpResponse(resp)
	return nil
}

func doDelete() error {
	req, err := http.NewRequest("DELETE", "http://"+_host+*_uri, nil)
	if err != nil {
		return err
	}

	var date = makeRFC1123Date()
	doSetHeader(req, date, "", 0)

	var cli = new(http.Client)
	resp, err := cli.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	dumpResponse(resp)
	return nil
}

// mkdir
func doPost() error {
	var data = "{\"folder\":true}"
	var body = bytes.NewBufferString(data)
	req, err := http.NewRequest("POST", "http://"+_host+*_uri, body)
	if err != nil {
		return err
	}

	var date = makeRFC1123Date()
	doSetHeader(req, date, md5Str(data), len(data))

	var cli = new(http.Client)
	resp, err := cli.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	dumpResponse(resp)
	return nil
}

func doSetHeader(req *http.Request, date, md5 string, dataLen int) {
	sign := doSignature(*_method, *_uri, date, *_passwd, md5)
	req.Header.Set("Authorization", "UPYUN "+*_operator+":"+sign)
	req.Header.Set("Content-MD5", md5)
	req.Header.Set("Date", date)
	// req.Header.Set("Content-Type","application/json")
	req.Header.Set("Host", _host)
	req.Header.Set("Content-Length", fmt.Sprint(dataLen))
}

func dumpResponse(resp *http.Response) {
	content, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		fmt.Println("Failed to read response:", err)
		return
	}
	fmt.Println("Response:")
	fmt.Println(string(content))
	fmt.Println("-----------------")
}

func checkOptions() error {
	if len(*_bucket) == 0 || len(*_operator) == 0 || len(*_passwd) == 0 ||
		len(*_uri) == 0 || len(*_method) == 0 {
		return fmt.Errorf("Invalid options")
	}
	return nil
}
