package pusher

import (
	"encoding/json"

	"pkg.deepin.io/daemon/sync/infrastructure/log"

	nsq "github.com/nsqio/go-nsq"
)

type msgHandler struct {
	notify    *notify
	topicName string
}

type message struct {
	MsgType  string `json:"type"`
	Playload map[string]interface{}
}

func (h *msgHandler) HandleMessage(m *nsq.Message) error {
	var msg message
	err := json.Unmarshal(m.Body, &msg)
	if err != nil {
		log.Errorf("ERROR: failed to write to os.Stdout - %s", err)
		return err
	}

	h.notify.sendMessage(msg)

	return nil
}
