package appearance

import (
	"reflect"
	"testing"
)

var (
	_core1 = Data{
		FontSize:      11,
		GTK:           "deepin",
		Icon:          "deepin",
		Cursor:        "deepin",
		FontStandard:  "Noto CJK Sans",
		FontMonospace: "Noto Mono",
	}
	_core2 = Data{
		FontSize:      12,
		GTK:           "Breeze",
		Icon:          "Breeze",
		Cursor:        "Breeze",
		FontStandard:  "Noto Sans",
		FontMonospace: "mononoki",
	}
)

func TestName(t *testing.T) {
	var core = &Data{}
	if core.Name() != "appearance" {
		panic("[TestName] name should be equal")
	}
}

func TestModel(t *testing.T) {
	var core = &Data{}
	if !reflect.DeepEqual(core, core.Model()) {
		panic("[TestModel] model should be equal")
	}
}

func TestToIFC(t *testing.T) {
	var tmp = &Data{}
	if !reflect.DeepEqual(tmp.ToIFC(&_core1), &_core1) {
		panic("[TestToIFC] ToIFC should be equal")
	}
}

func TestEqual(t *testing.T) {
	var core = _core1
	if !(&core).Equal(&_core1) {
		panic("[TestEqual] core and core1 should be equal")
	}
	core.GTK = "Breeze"
	if (&core).Equal(&_core1) {
		panic("[TestEqual] core and core1 should be not equal after modified")
	}
}

func TestGenCache(t *testing.T) {
	if !reflect.DeepEqual((&_core1).GenCache(&Data{}), &_core1) {
		panic("[TestGenCahce] core1 should be equal with the cache")
	}
}

func TestMerge(t *testing.T) {
	var core = _core1
	(&core).Merge(&_core2, &_core1)
	if !reflect.DeepEqual(&core, &_core2) {
		panic("[TestMerge] core should be equal with core1")
	}
}
