#pragma once
#include <gtest/gtest.h>
#include <QTest>

#include "../../src/widgets/filter.h"

using namespace testing;
class HoverShadowFilterTest:public testing::Test{

public:
    HoverShadowFilter *m_hoverShadowFilter;
    virtual void SetUp() override{
        m_hoverShadowFilter = new HoverShadowFilter();
    }

    virtual void TearDown() override{
        if(nullptr != m_hoverShadowFilter)
            delete m_hoverShadowFilter;
    }
};

TEST_F(HoverShadowFilterTest, eventFilter)
{
    QWidget *widget = new QWidget();
    QEvent *enterEvent = new QEvent(QEvent::Enter);
    m_hoverShadowFilter->eventFilter(widget,enterEvent);
    QEvent *enterLeave = new QEvent(QEvent::Leave);
    m_hoverShadowFilter->eventFilter(widget,enterLeave);
    QEvent *enterMove = new QEvent(QEvent::Move);
    m_hoverShadowFilter->eventFilter(widget,enterMove);
    if(nullptr != widget)
        widget->deleteLater();
}





