#!/usr/bin/python3

from setuptools import setup

import subprocess, glob, os.path
import os

extra_data = []
# Build hybrid-detect on x86
if '86' in os.uname()[4]:
    subprocess.check_call(["make", "-C", "share/hybrid", "all"])
    extra_data.append(("/usr/bin/", ["share/hybrid/gpu-manager"]))
    extra_data.append(("/lib/systemd/system/", ["share/hybrid/gpu-manager.service"]))
    extra_data.append(("/sbin/", ["share/hybrid/u-d-c-print-pci-ids"]))
    extra_data.append(("/lib/udev/rules.d/", ["share/hybrid/71-u-d-c-gpu-detection.rules"]))

# Make the nvidia-installer hooks executable
#for x in glob.glob("nvidia-installer-hooks/*"):
#    os.chmod(x, 0o755)

setup(
    name="deepin-prime",
    author="Alberto Milone",
    author_email="albertomilone@alice.it",
    maintainer="Alberto Milone",
    maintainer_email="albertomilone@alice.it",
    url="http://www.albertomilone.com",
    license="gpl",
    description="Detect and install additional Ubuntu driver packages",
    data_files=[] + extra_data,
)
