/*
 * Copyright (C) 2016 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *
 * Maintainer: sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DCC_BLUETOOTH_ADAPTER_H
#define DCC_BLUETOOTH_ADAPTER_H

#include <QObject>

#include "device.h"

namespace dcc {
namespace bluetooth {

class Adapter : public QObject
{
    Q_OBJECT
public:
    explicit Adapter(QObject *parent = 0);

    inline QString name() const { return m_name; }
    void setName(const QString &name);

    inline QString id() const { return m_id; }
    void setId(const QString &id);

    QMap<QString, const Device *> devices() const;
    QList<QString> devicesId() const;
    const Device *deviceById(const QString &id) const;

    inline bool powered() const { return m_powered; }
    void setPowered(bool powered, bool discovering);

    inline bool discoverabled() const { return m_discoverable; }
    void setDiscoverabled(const bool discoverable);

    inline bool discovering() const { return m_discovering; }

public Q_SLOTS:
    void addDevice(const Device *device);
    void removeDevice(const QString &deviceId);

Q_SIGNALS:
    void nameChanged(const QString &name) const;
    void deviceAdded(const Device *device) const;
    void deviceRemoved(const QString &deviceId) const;
    void poweredChanged(const bool &powered, const bool &discovering) const;
    void loadStatus() const;
    void discoverableChanged(const bool &discoverable) const;
    void closeDetailPage() const;

private:
    QString m_id;
    QString m_name;
    bool m_powered;
    bool m_discovering;
    bool m_discoverable;
    QMap<QString, const Device *> m_devices;
    //按序存放设备id,确定设备显示顺序
    QList<QString> m_devicesId;
};

} // namespace bluetooth
} // namespace dcc

#endif // DCC_BLUETOOTH_ADAPTER_H
