/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef CDO_MATH_H
#define CDO_MATH_H

// clang-format off
namespace cdo
{
  template<class T> 
  const T& max(const T& a, const T& b) { return (a < b) ? b : a; }

  template<class T> 
  const T& min(const T& a, const T& b) { return (b < a) ? b : a; }

  constexpr double sqr(const double a) { return a * a; }
}
// clang-format on

#endif
