/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.aspectj.internal.tools.build.Sample;
import org.aspectj.internal.tools.build.Samples;

class SampleUtil {
    public static final String SAMPLE_BASE_DIR_NAME = "sandbox";

    public static void simpleRender(Samples result, StringBuffer sink) {
        List<Sample> sortedSamples = result.getSortedSamples();
        int i = 0;
        ListIterator<Sample> iter = sortedSamples.listIterator();
        while (iter.hasNext()) {
            Sample sample = iter.next();
            sink.append(i++ + ": " + sample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaFile getJavaFile(File path) {
        if (null == path) {
            throw new IllegalArgumentException("null path");
        }
        String result = path.getPath().replace('\\', '/');
        String packag = "";
        String javaPath = null;
        String prefix = null;
        IOException thrown = null;
        if (result.endsWith(".java") || result.endsWith(".aj")) {
            FileReader reader = null;
            try {
                String line;
                reader = new FileReader(path);
                BufferedReader br = new BufferedReader(reader);
                while (null != (line = br.readLine())) {
                    int loc = line.indexOf("package");
                    if (-1 != loc) {
                        int end = line.indexOf(";");
                        if (-1 == loc) {
                            String m = "unterminated package statement \"";
                            throw new Error(m + line + "\" in " + path);
                        }
                        packag = (line.substring(loc + 7, end) + ".").trim().replace('.', '/');
                    } else {
                        loc = line.indexOf("import");
                        if (-1 == loc) continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                thrown = e;
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (null == thrown) {
                javaPath = packag + path.getName();
                int loc = result.indexOf(javaPath);
                if (-1 == loc) {
                    String m = "expected suffix " + javaPath + " in ";
                    throw new Error(m + result);
                }
                prefix = result.substring(0, loc);
            }
        }
        return new JavaFile(path, javaPath, prefix, thrown);
    }

    public static String renderCodePath(File path) {
        int loc;
        JavaFile javaFile = SampleUtil.getJavaFile(path);
        if (javaFile.thrown != null) {
            throw new Error(javaFile.thrown.getClass() + ": " + javaFile.thrown.getMessage());
        }
        String file = javaFile.javaPath;
        String prefix = javaFile.prefix;
        if (prefix == null) {
            prefix = path.getPath().replace('\\', '/');
        }
        if (-1 == (loc = prefix.lastIndexOf(SAMPLE_BASE_DIR_NAME))) {
            String m = "not after sandbox";
            throw new IllegalArgumentException(m + "?: " + path);
        }
        prefix = prefix.substring(loc + 1 + SAMPLE_BASE_DIR_NAME.length());
        if (file == null) {
            int slash = prefix.lastIndexOf(47);
            if (-1 == slash) {
                file = prefix;
                prefix = "";
            } else {
                file = prefix.substring(slash + 1);
                prefix = prefix.substring(0, slash);
            }
        }
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return (prefix + " " + file).trim();
    }

    public static int commonPrefix(String[] lhs, String[] rhs) {
        int firstDiff;
        int max = SampleUtil.smallerSize(lhs, rhs);
        for (firstDiff = 0; firstDiff < max && lhs[firstDiff].equals(rhs[firstDiff]); ++firstDiff) {
        }
        return firstDiff;
    }

    private static int smallerSize(Object[] one, Object[] two) {
        if (null == one || null == two) {
            return 0;
        }
        return one.length > two.length ? two.length : one.length;
    }

    public static String[] splitAnchorName(Sample sample) {
        return SampleUtil.splitAnchorName(sample.anchorName);
    }

    public static String[] splitAnchorName(String anchorName) {
        String next;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int loc = anchorName.indexOf("-", start);
        while (loc != -1) {
            next = anchorName.substring(start, loc);
            result.add(next);
            start = loc + 1;
            loc = anchorName.indexOf("-", start);
        }
        next = anchorName.substring(start);
        result.add(next);
        return result.toArray(new String[result.size()]);
    }

    public static String replace(String source, String[] from, String[] to) {
        if (null == source || 0 == source.length()) {
            return source;
        }
        if (from.length != to.length) {
            throw new IllegalArgumentException("unmatched from/to");
        }
        StringBuffer result = new StringBuffer();
        int LEN = source.length();
        int start = 0;
        block0: for (int i = 0; i < LEN; ++i) {
            String suffix = source.substring(i);
            for (int j = 0; j < from.length; ++j) {
                if (!suffix.startsWith(from[j])) continue;
                result.append(source.substring(start, i));
                result.append(to[j]);
                start = i + from[j].length();
                i = start - 1;
                continue block0;
            }
        }
        if (start < source.length()) {
            result.append(source.substring(start));
        }
        return result.toString();
    }

    public static void render(Sample sample, String fieldDelim, String valueDelim, StringBuffer sink) {
        if (null == sink || null == sample) {
            return;
        }
        if (null == fieldDelim) {
            fieldDelim = "";
        }
        if (null == valueDelim) {
            valueDelim = "";
        }
        sink.append("anchorName");
        sink.append(valueDelim);
        sink.append(sample.anchorName);
        sink.append(fieldDelim);
        sink.append("author");
        sink.append(valueDelim);
        sink.append(sample.author);
        sink.append(fieldDelim);
        sink.append("sourcePath");
        sink.append(valueDelim);
        sink.append(sample.sourcePath.toString());
        sink.append(fieldDelim);
        sink.append("startLine");
        sink.append(valueDelim);
        sink.append(sample.startLine);
        sink.append(fieldDelim);
        sink.append("endLine");
        sink.append(valueDelim);
        sink.append(sample.endLine);
        sink.append(fieldDelim);
        sink.append("sampleCode");
        sink.append(valueDelim);
        sink.append(sample.sampleCode.toString());
        sink.append(fieldDelim);
    }

    private SampleUtil() {
    }

    static class JavaFile {
        final File path;
        final String javaPath;
        final String prefix;
        final Throwable thrown;

        JavaFile(File path, String javaPath, String prefix, Throwable thrown) {
            this.path = path;
            this.javaPath = javaPath;
            this.prefix = prefix;
            this.thrown = thrown;
        }
    }
}

