/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.check;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.cobertura.check.CheckCoverageMain;
import net.sourceforge.cobertura.check.CoverageRate;
import net.sourceforge.cobertura.check.CoverageResultEntry;
import net.sourceforge.cobertura.check.CoverageThreshold;
import net.sourceforge.cobertura.check.PackageCoverage;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.reporting.CoverageThresholdsReport;
import net.sourceforge.cobertura.reporting.Report;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCoverageTask {
    private static final Logger logger = LoggerFactory.getLogger(CheckCoverageMain.class);
    private final Perl5Matcher pm = new Perl5Matcher();
    private final Perl5Compiler pc = new Perl5Compiler();
    private CoverageRate minimumCoverageRate;
    private Map<Pattern, CoverageRate> minimumCoverageRates = new HashMap<Pattern, CoverageRate>();
    private Map<String, PackageCoverage> packageCoverageMap = new HashMap<String, PackageCoverage>();

    private CoverageRate findMinimumCoverageRate(String classname) {
        for (Map.Entry<Pattern, CoverageRate> patternCoverageRateEntry : this.minimumCoverageRates.entrySet()) {
            Map.Entry<Pattern, CoverageRate> entry = patternCoverageRateEntry;
            if (!this.pm.matches(classname, entry.getKey())) continue;
            return entry.getValue();
        }
        return this.minimumCoverageRate;
    }

    public Report checkCoverage(Arguments arguments, ProjectData projectData) {
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        double branchCoverageRate = arguments.getClassBranchThreshold();
        dataFile = arguments.getDataFile();
        double lineCoverageRate = arguments.getClassLineThreshold();
        for (CoverageThreshold threshold : arguments.getMinimumCoverageThresholds()) {
            try {
                this.minimumCoverageRates.put(this.pc.compile(threshold.getRegex()), new CoverageRate(threshold.getMinBranchPercentage(), threshold.getMinLinePercentage()));
            }
            catch (MalformedPatternException e) {
                logger.error(String.format("Got malformed regex expression %s", threshold.getRegex()), (Throwable)e);
            }
        }
        double packageBranchCoverageRate = arguments.getPackageBranchThreshold();
        double packageLineCoverageRate = arguments.getPackageLineThreshold();
        double totalBranchCoverageRate = arguments.getTotalBranchThreshold();
        double totalLineCoverageRate = arguments.getTotalLineThreshold();
        if (branchCoverageRate == -1.0 && lineCoverageRate == -1.0 && packageLineCoverageRate == -1.0 && packageBranchCoverageRate == -1.0 && totalLineCoverageRate == -1.0 && totalBranchCoverageRate == -1.0 && this.minimumCoverageRates.size() == 0) {
            branchCoverageRate = 0.5;
            lineCoverageRate = 0.5;
            packageBranchCoverageRate = 0.5;
            packageLineCoverageRate = 0.5;
            totalBranchCoverageRate = 0.5;
            totalLineCoverageRate = 0.5;
        } else {
            if (branchCoverageRate == -1.0) {
                branchCoverageRate = 0.0;
            }
            if (lineCoverageRate == -1.0) {
                lineCoverageRate = 0.0;
            }
            if (packageLineCoverageRate == -1.0) {
                packageLineCoverageRate = 0.0;
            }
            if (packageBranchCoverageRate == -1.0) {
                packageBranchCoverageRate = 0.0;
            }
            if (totalLineCoverageRate == -1.0) {
                totalLineCoverageRate = 0.0;
            }
            if (totalBranchCoverageRate == -1.0) {
                totalBranchCoverageRate = 0.0;
            }
        }
        this.minimumCoverageRate = new CoverageRate(lineCoverageRate, branchCoverageRate);
        double totalLines = 0.0;
        double totalLinesCovered = 0.0;
        double totalBranches = 0.0;
        double totalBranchesCovered = 0.0;
        Iterator iter = projectData.getClasses().iterator();
        ArrayList<CoverageResultEntry> coverageResultEntries = new ArrayList<CoverageResultEntry>();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            CoverageRate coverageRate = this.findMinimumCoverageRate(classData.getName());
            if (totalBranchCoverageRate > 0.0) {
                totalBranches += (double)classData.getNumberOfValidBranches();
                totalBranchesCovered += (double)classData.getNumberOfCoveredBranches();
            }
            if (totalLineCoverageRate > 0.0) {
                totalLines += (double)classData.getNumberOfValidLines();
                totalLinesCovered += (double)classData.getNumberOfCoveredLines();
            }
            PackageCoverage packageCoverage = this.getPackageCoverage(classData.getPackageName());
            if (packageBranchCoverageRate > 0.0) {
                packageCoverage.addBranchCount(classData.getNumberOfValidBranches());
                packageCoverage.addBranchCoverage(classData.getNumberOfCoveredBranches());
            }
            if (packageLineCoverageRate > 0.0) {
                packageCoverage.addLineCount(classData.getNumberOfValidLines());
                packageCoverage.addLineCoverage(classData.getNumberOfCoveredLines());
            }
            logger.debug("Class " + classData.getName() + ", line coverage rate: " + this.percentage(classData.getLineCoverageRate()) + "%, branch coverage rate: " + this.percentage(classData.getBranchCoverageRate()) + "%");
            coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.CLASS, CoverageResultEntry.CoverageType.BRANCH, classData.getName(), classData.getBranchCoverageRate(), coverageRate.getBranchCoverageRate()));
            coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.CLASS, CoverageResultEntry.CoverageType.LINE, classData.getName(), classData.getLineCoverageRate(), coverageRate.getLineCoverageRate()));
        }
        coverageResultEntries.addAll(this.checkPackageCoverageLevels(packageBranchCoverageRate, packageLineCoverageRate));
        coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.PROJECT, CoverageResultEntry.CoverageType.BRANCH, "project", totalBranchesCovered / totalBranches, totalBranchCoverageRate));
        coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.PROJECT, CoverageResultEntry.CoverageType.LINE, "project", totalLinesCovered / totalLines, totalLineCoverageRate));
        return new CoverageThresholdsReport(Collections.unmodifiableList(coverageResultEntries));
    }

    private PackageCoverage getPackageCoverage(String packageName) {
        PackageCoverage packageCoverage = this.packageCoverageMap.get(packageName);
        if (packageCoverage == null) {
            packageCoverage = new PackageCoverage();
            this.packageCoverageMap.put(packageName, packageCoverage);
        }
        return packageCoverage;
    }

    private List<CoverageResultEntry> checkPackageCoverageLevels(double packageBranchCoverageRate, double packageLineCoverageRate) {
        Iterator<Map.Entry<String, PackageCoverage>> i$ = this.packageCoverageMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, PackageCoverage> entry = i$.next();
            String packageName = entry.getKey();
            PackageCoverage packageCoverage = entry.getValue();
            return this.checkPackageCoverage(packageBranchCoverageRate, packageLineCoverageRate, packageName, packageCoverage);
        }
        return new ArrayList<CoverageResultEntry>();
    }

    private List<CoverageResultEntry> checkPackageCoverage(double packageBranchCoverageRate, double packageLineCoverageRate, String packageName, PackageCoverage packageCoverage) {
        ArrayList<CoverageResultEntry> coverageResultEntries = new ArrayList<CoverageResultEntry>();
        coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.PACKAGE, CoverageResultEntry.CoverageType.BRANCH, packageName, packageCoverage.getBranchCoverage() / packageCoverage.getBranchCount(), packageBranchCoverageRate));
        coverageResultEntries.add(new CoverageResultEntry(CoverageResultEntry.CoverageLevel.PACKAGE, CoverageResultEntry.CoverageType.LINE, packageName, packageCoverage.getLineCoverage() / packageCoverage.getLineCount(), packageLineCoverageRate));
        return coverageResultEntries;
    }

    private String percentage(double coverateRate) {
        BigDecimal decimal = new BigDecimal(coverateRate * 100.0);
        return decimal.setScale(1, 1).toString();
    }
}

