//
// Created by uos on 2022/6/9.
//

#include "LogDialog.h"
#include "common/BaseItemDelegate.h"
#include <DTitlebar>
#include <DLabel>
#include <QVBoxLayout>
#include <DFontSizeManager>
#include <DBackgroundGroup>
#include <QHeaderView>
#include <QScreen>
#include <QDateTime>
#include <QAbstractItemView>


const int TABLE_COL_NO = 0;             //table表：序号
const int TABLE_COL_TYPE = 1;           //table表：类型
const int TABLE_COL_USER = 2;           //table表：用户名
const int TABLE_COL_TIME = 3;           //table表：时间
const int TABLE_COL_REMARK = 4;         //table表：备注

LogDialog::LogDialog(QWidget *parent) : DMainWindow(parent)
{
    this->setAccessibleName("LogDialog");
    initUI();
}

void LogDialog::initUI()
{
    auto titleBar = titlebar();
    setWindowFlags(windowFlags());// & ~Qt::WindowMinimizeButtonHint);
    titleBar->setMenuVisible(false);
    titleBar->setIcon(QIcon::fromTheme("uos-recovery"));
    auto contentLayout = new QVBoxLayout;
    contentLayout->setSpacing(10);
    contentLayout->setContentsMargins(10, 16, 10, 50);

    DLabel *label = new DLabel;
    label->setText(tr("Logs"));
    DFontSizeManager::instance()->bind(label, DFontSizeManager::T5);
    QFont font = label->font();
    font.setWeight(QFont::Medium);
    label->setFont(font);
    label->setAlignment(Qt::AlignLeft);
    contentLayout->addWidget(label);

    QWidget *contentWidget = new QWidget;
    contentWidget->setObjectName("contentWidget");
    contentWidget->setLayout(contentLayout);

    auto mainLayout = new QHBoxLayout;
    auto mainWidget = new DBackgroundGroup();
    mainWidget->setObjectName("mainWidget");
    mainLayout->addWidget(contentWidget);
    setCentralWidget(mainWidget);
    centralWidget()->setLayout(mainLayout);

    m_tableView = new BaseTableView;
    m_model = new QStandardItemModel;
    m_tableView->setModel(m_model);
    m_tableView->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    auto itemDelegate = new BaseItemDelegate(this);
    m_tableView->setItemDelegate(itemDelegate);
    initTableView();
    contentLayout->addWidget(m_tableView);
}

void LogDialog::initTableView()
{
    m_tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    m_tableView->setSortingEnabled(false);
    m_tableView->setFocusPolicy(Qt::NoFocus);
    m_tableView->setRowBackgroundDelta(10);

    //序号
    auto noItem = new QStandardItem(tr("No."));
    noItem->setTextAlignment(Qt::AlignVCenter);

    // 类型
    auto typeItem = new QStandardItem(tr("Type"));
    typeItem->setTextAlignment(Qt::AlignVCenter);

    //用户名
    auto nameItem = new QStandardItem(tr("User"));
    nameItem->setTextAlignment(Qt::AlignVCenter);

    // 时间
    auto timeItem = new QStandardItem(tr("Time"));
    timeItem->setTextAlignment(Qt::AlignVCenter);

    //备注
    auto remarkItem = new QStandardItem(tr("Note"));
    remarkItem->setTextAlignment(Qt::AlignVCenter);


    m_model->setHorizontalHeaderItem(TABLE_COL_NO, noItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_TYPE, typeItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_USER, nameItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_TIME, timeItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_REMARK, remarkItem);

//    m_tableView->header()->setSectionResizeMode(QHeaderView::Stretch);
    m_tableView->setColumnWidth(TABLE_COL_NO, 20);
    m_tableView->setColumnWidth(TABLE_COL_TYPE, 120);
    m_tableView->setColumnWidth(TABLE_COL_USER, 150);
    m_tableView->setColumnWidth(TABLE_COL_TIME, 150);
    m_tableView->setColumnWidth(TABLE_COL_REMARK, 140);

    // 禁止拖动列宽
    QHeaderView * headerView = m_tableView->header();
    headerView->setSectionResizeMode(TABLE_COL_NO, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_TYPE, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_USER, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_TIME, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_REMARK, QHeaderView::ResizeMode::Fixed);
}

void LogDialog::setData(const OperateLogList operateLogList)
{
    m_model->removeRows(0, m_model->rowCount());
    auto iter = operateLogList.begin();
    int seqNo = 1;
    for (; iter != operateLogList.end(); ++iter) {
        int currentRow = m_model->rowCount();
        auto seqItem = new QStandardItem(QString("%1").arg(seqNo++));
        m_model->setItem(currentRow, TABLE_COL_NO, seqItem);

        QString type;
        switch (iter->operateType) {
            case SystemBackup:
                type = tr("System backup");
                break;
            case SystemRestore:
                type = tr("System restore");
                break;
            case UserDataBackup:
                type = tr("Data backup");
                break;
            case UserDataRestore:
                type = tr("Data restore");
                break;
            case removeBackup:
                type = tr("Delete backup");
                break;
            case FactoryRestore: {
                type = tr("Reset to factory settings");
                break;
            }
            default:
                break;
        }
        auto typeItem = new QStandardItem(type);
        m_model->setItem(currentRow, TABLE_COL_TYPE, typeItem);

        auto nameItem = new QStandardItem(iter->username);
        m_model->setItem(currentRow, TABLE_COL_USER, nameItem);

        auto time = QDateTime::fromMSecsSinceEpoch(iter->time);
        auto timeItem = new QStandardItem(time.toString("yyyy-MM-dd HH:mm:ss"));
        m_model->setItem(currentRow, TABLE_COL_TIME, timeItem);

        auto remarkItem = new QStandardItem(iter->remark);
        m_model->setItem(currentRow, TABLE_COL_REMARK, remarkItem);
    }
}

void LogDialog::showToCenter()
{
    auto screen = QGuiApplication::primaryScreen();
    auto rect = screen->geometry();
    if (rect.width() < MAIN_WINDOW_WIDTH || rect.height() < MAIN_WINDOW_HEIGHT) {
        QWidget::showMaximized();
    } else {
        setFixedSize(QSize(MAIN_WINDOW_WIDTH - 80, MAIN_WINDOW_HEIGHT - 80));
        move((rect.width() - width()) / 2, (rect.height() - height()) / 2);
        QWidget::show();
    }
}

// void LogDialog::closeEvent(QCloseEvent *event)
// {
//     DMainWindow::closeEvent(event);
// //    this->close();
//     Q_EMIT closeMainWindow();
// }
