#pragma once

#include "interface/ModuleInterface.h"
#include "BackupWidget.h"
#include "SystemBackupWidget.h"
#include "UserDataBackupSelectWidget.h"
#include "UserDataBackupWidget.h"
#include "common/ProgressWidget.h"
#include "common/ResultWidget.h"
#include <QObject>
#include <QTimer>
#include <QJsonObject>

class FrameProxyInterface;
class QString;

class BackupModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit BackupModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                          QObject *parent = nullptr);
    ~BackupModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;

    void updateDestPartition(const QJsonObject &jsonObject);
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);
    void setSystemBackupSpaceTips(const QString &tips);

public Q_SLOTS:
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onSystemBackup();
    void onStartSystemBackup(const QString &remark);
    void onDataBackup();
    void onStartDataBackup(const QString &remark);
    void onBack();
    void onBackHome();
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onCheckSpace();
    void onReportCheckSpace(const QString &space);

#ifdef UI_TEST
    void onTimeout();
#endif

private:
    QStringList getUsrDataSpecialExcludes();
    void showUserDataBackupWidget(const QString &comboBoxText);
    void systemBackup(int operateType, int errorCode);

private:
    BackupWidget *m_backupWidget = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    SystemBackupWidget *m_systemBackupWidget = nullptr;
    UserDataBackupSelectWidget *m_userDataBackupSelectWidget = nullptr;
    UserDataBackupWidget *m_userDataBackupWidget = nullptr;
    ResultWidget *m_resultWidget = nullptr;
    QList<FileItem> m_fileItems;
    QList<FileItem> m_excludeFileItems;
    QStringList m_excludes;
    QString m_destUUID;
    QString m_curSysBackupReq = "";
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;

#ifdef UI_TEST
    QTimer *m_timer = nullptr;
    int m_progress = 0;
#endif
};