//
// Created by uos on 2022/2/16.
//

#ifndef UOS_RECOVERY_PROCESSTEST_H
#define UOS_RECOVERY_PROCESSTEST_H

#include "utils/Process.h"
#include <gtest/gtest.h>
#include <QStringList>
#include <QDebug>

class ProcessTest : public testing::Test
{
public:
    void SetUp() override
    {

    }

    void TearDown() override
    {

    }

};

TEST_F(ProcessTest, spawnCmd)
{
    EXPECT_TRUE(Process::spawnCmd("ls", QStringList() << "-l"));
    EXPECT_FALSE(Process::spawnCmd("NoDefineCommand", QStringList()));
    QString out, err;
    EXPECT_TRUE(Process::spawnCmd("ls", QStringList() << "-l", out, err));
    EXPECT_FALSE(out.isEmpty());
    EXPECT_TRUE(err.isEmpty());
    EXPECT_TRUE(Process::spawnCmd("ls", QStringList() << "-l", out, err, 2));
    EXPECT_FALSE(Process::spawnCmd("NoDefineCommand", QStringList(), out, err, 2));
}

#endif //UOS_RECOVERY_PROCESSTEST_H
