//
// Created by dtx on 2022/3/24.
//

#include "stdio.h"
#include "ExtractSquashfsTaskTest.h"
#include "utils/Process.h"
#include <QDebug>
#include <QDir>
#include "stdio.h"


ExtractSquashfsTaskTestHandle::ExtractSquashfsTaskTestHandle(QEventLoop *eventLoop)
{
    m_squashfsTask = new SquashfsTask();
    m_eventLoop = eventLoop;
}

ExtractSquashfsTaskTestHandle::~ExtractSquashfsTaskTestHandle()
{
    if (m_squashfsTask != nullptr) {
        delete m_squashfsTask;
        m_squashfsTask = nullptr;
    }
}

bool ExtractSquashfsTaskTestHandle::doExtractSquashfs(const QString &srcfile, const QString &destdir)
{
    connect(m_squashfsTask, &SquashfsTask::progressChanged, [=](const QJsonObject &processvalue) {
        qInfo() << "doExtractSquashfs : " << "process value is : " << processvalue;
    });
    connect(m_squashfsTask, &SquashfsTask::success, [=] {
        qInfo() << "doExtractSquashfs : " << "process value is : " << 100;
        m_eventLoop->quit();
    });
    connect(m_squashfsTask, &SquashfsTask::error, [=] {
        qInfo() << "doExtractSquashfs : " << "process value is : " << 100;
        Q_EMIT error();
        m_eventLoop->quit();
    });

    qInfo() << "doExtractSquashfs : " << "process value is : " << 5;

    return m_squashfsTask->extractSquashfs(srcfile, destdir);
}

bool ExtractSquashfsTaskTestHandle::isDone() {
    return m_squashfsTask->isFinished();
}

TEST_F(ExtractSquashfsTaskTest, all) {
    ExtractSquashfsTaskTestHandle doExtractSquashfsTaskTestHandle(m_loop);
    QDir testpath;

    EXPECT_TRUE(Process::spawnCmd("/bin/bash", {"-c", QString("rm -rf %1").arg(TEST_DATA_DIR"testsq")}));

    if (doExtractSquashfsTaskTestHandle.doExtractSquashfs(TEST_DATA_DIR"squashfsfiletest.squashfs", TEST_DATA_DIR"testsq")) {
        //m_loop->exec();
        while (!doExtractSquashfsTaskTestHandle.isDone()) {
            QThread::msleep(100);
        }
    } else {
        m_loop->quit();
    }
}

