#include "osinfo.h"
#include "functionhandler.h"

#include <QDebug>

#include <DSysInfo>

DCORE_USE_NAMESPACE

OsInfo::OsInfo(QObject *parent)
    : QObject{parent}
{
    m_pureEnvironment = QProcessEnvironment::systemEnvironment();
}

QProcessEnvironment OsInfo::pureEnvironment()
{
    return m_pureEnvironment;
}

void OsInfo::printInfo()
{
    qInfo() << "{"
            << DSysInfo::uosEditionName() << ","
            << DSysInfo::productTypeString() << ","
            << DSysInfo::productVersion()
            << " [ major=" << DSysInfo::majorVersion()
            << ", minor=" << DSysInfo::minorVersion()
            << " ]"
            << "}";
    qInfo() << "cache system environment" << m_pureEnvironment.toStringList();
}
