/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate, __metadata } from '../../../../tslib/tslib.js';
import { html, LitElement } from '../../../../lit/index.js';
import { property } from '../../../../lit/decorators.js';
import { classMap } from '../../../../lit/directives/class-map.js';
/** @soyCompatible */
export class Badge extends LitElement {
    constructor() {
        super(...arguments);
        this.value = '';
    }
    /** @soyTemplate */
    render() {
        return html `<div class="md3-badge ${classMap(this.getRenderClasses())}"><p class="md3-badge__value">${this.value}</p></div>`;
    }
    /** @soyTemplate */
    getRenderClasses() {
        return {
            'md3-badge--large': this.value,
        };
    }
}
__decorate([
    property({ type: String }),
    __metadata("design:type", Object)
], Badge.prototype, "value", void 0);
//# sourceMappingURL=badge.js.map