// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SURFACE_HANDLE_H_
#define GPU_IPC_COMMON_SURFACE_HANDLE_H_

#include <stdint.h>

#include "build/build_config.h"

#if (BUILDFLAG(IS_APPLE) || BUILDFLAG(IS_WIN) || BUILDFLAG(IS_OZONE)) && \
    !BUILDFLAG(IS_NACL)
#include "ui/gfx/native_widget_types.h"
#define GPU_SURFACE_HANDLE_IS_ACCELERATED_WINDOW
#endif

namespace gpu {

// SurfaceHandle is the native type used to reference a native surface in the
// GPU process so that we can create "view" contexts on it.

// On Windows, Mac, Linux and Chrome OS, we can use a AcceleratedWidget across
// processes, so SurfaceHandle is exactly that.
// On Android, there is no type we can directly access across processes, so we
// go through the GpuSurfaceTracker, and SurfaceHandle is a (scalar) handle
// generated by that.
// On NaCl, we don't have native surfaces per se, but we need SurfaceHandle to
// be defined, because some APIs that use it are referenced there.
//
// TODO(fuchsia): Figure out the right approach for Fuchsia.
#if defined(GPU_SURFACE_HANDLE_IS_ACCELERATED_WINDOW)
using SurfaceHandle = gfx::AcceleratedWidget;
constexpr SurfaceHandle kNullSurfaceHandle = gfx::kNullAcceleratedWidget;
#elif BUILDFLAG(IS_ANDROID) || BUILDFLAG(IS_NACL) || BUILDFLAG(IS_FUCHSIA)
using SurfaceHandle = int32_t;
constexpr SurfaceHandle kNullSurfaceHandle = 0;
#else
#error Platform not supported.
#endif

}  // namespace gpu

#endif  // GPU_IPC_COMMON_SURFACE_HANDLE_H_
