# Visual Studio Code Dev

**Get started [here](#setup)**.

[Visual Studio Code (VS Code)](https://code.visualstudio.com) is a free,
open source, lightweight and powerful code editor for Windows, Mac and Linux,
based on [Electron](https://www.electronjs.org/)/Chromium.
It has built-in support for JavaScript, TypeScript and Node.js and a rich
extension ecosystem that adds intellisense, debugging, syntax highlighting etc.
For many languages like C++, Python, Go, Java, it works without too much setup.

It is NOT a full-fledged IDE like Visual Studio. The two are completely
separate products. The only commonality with Visual Studio is that both are
from Microsoft.

Here's what works well:

*   **Editing code** works well especially when you get used to the [keyboard
    shortcuts](#Keyboard-Shortcuts). VS Code is very responsive and can handle
    even big code bases like Chromium.
*   **Git integration** is a blast. Built-in side-by-side view, local commit and
    even extensions for
    [history](https://marketplace.visualstudio.com/items?itemName=donjayamanne.githistory)
    and
    [blame view](https://marketplace.visualstudio.com/items?itemName=ryu1kn.annotator).
*   [**Debugging**](https://code.visualstudio.com/Docs/editor/debugging) works
    well, even though startup times can be fairly high (~40 seconds with
    gdb on Linux, much lower on Windows). You can step through code, inspect
    variables, view call stacks for multiple threads etc.
    *   For more information on debugging Python code, see [here](vscode_python.md).
*   **Command Palette** makes opening files and searching solution really easy.
*   **Building** works well. Build tools are easy to integrate. Warnings and errors
    are displayed on a separate page and you can click to jump to the
    corresponding line of code.
*   **VS Code Remote**, which allows you to edit remotely-hosted code, and even
    run computationally expensive plugins like vscode-clangd on the remote
    server. Great for working from home. See the [Remote section](#Remote) for
    more details.

[TOC]


## Updating This Page

Please keep this doc up-to-date. VS Code is still in active development and
subject to changes. This doc is checked into the Chromium git repo, so if you
make changes, read the [documentation
guidelines](documentation_guidelines.md) and
[submit a change list](contributing.md).

All file paths and commands have been tested on Linux. Windows and Mac might
require a slightly different setup (e.g. `Ctrl` -> `Cmd`). Please update this
page accordingly.


## Setup

### Installation

*** promo
Googlers: See [go/vscode/install](http://go/vscode/install).
***

Follow the steps on [Setting up Visual Studio Code](https://code.visualstudio.com/docs/setup/setup-overview).

### Usage

To run it on Linux, just navigate to Chromium's `src` folder and type `code .`
in a terminal. The argument to `code` is the base directory of the workspace. VS
Code does not require project or solution files. However, it does store
workspace settings in a `.vscode` folder in your base directory.

If you installed Code Insiders, the binary name is `code-insiders` instead.

### Fixes for Known Issues

#### Git on Windows

If you only have the `depot_tools` Git installed on your machine, even though it
is in your PATH, VS Code will ignore it as it seems to be looking for `git.exe`.
You will have to add the following to your settings in order for the Git
integration to work:

```json
{
  "git.path": "C:\\src\\depot_tools\\git.bat"

  // more settings here...
}
```

Tip: you can jump to the settings JSON file by using `Ctrl+Shift+P` and using
the "Preferences: Open User Settings (JSON)" verb (for whatever reason, setting
`git.path` as a folder setting does not appear to work).

### Useful Extensions

Up to now, you have a basic version of VS Code without much language support.
Next, we will install some useful extensions. Jump to the extensions window
(`Ctrl+Shift+X`) and install the extensions, or run the following commands.

You will most likely use the following extensions every day:

```bash
$ echo "ms-vscode.cpptools llvm-vs-code-extensions.vscode-clangd ms-python.python bbenoist.togglehs peterj.proto Google.vscode-mojom msedge-dev.gnls stkb.rewrap ms-vscode-remote.remote-ssh eamodio.gitlens" | xargs -n 1 code --force --install-extension
```

*   [**C/C++**](https://marketplace.visualstudio.com/items?itemName=ms-vscode.cpptools) -
    Code formatting, debugging, Intellisense. Enables the use of clang-format
    (via the `C_Cpp.clang_format_path` setting) and format-on-save (via the
    `editor.formatOnSave` setting).
*   [**vscode-clangd**](https://marketplace.visualstudio.com/items?itemName=llvm-vs-code-extensions.vscode-clangd) -
    Enables VS Code to compile Chromium, provide Chromium XRefs to support
    functions like jumping to definition, and provide smarter autocompletion
    than **C/C++** extension's IntelliSense, but they also conflicts with each
    other. To resolve the conflict, add the following to `settings.json`:
    `"C_Cpp.intelliSenseEngine": "Disabled"`.  See [clangd.md](clangd.md) for
    setup instructions.
*   [**Python**](https://marketplace.visualstudio.com/items?itemName=ms-python.python) -
    Linting, intellisense, code formatting, refactoring, debugging, snippets.
    * If you want type checking, add: `"python.analysis.typeCheckingMode": "basic",`
      to your `settings.json` file (you can also find it in the settings UI).
*   [**Toggle Header/Source**](https://marketplace.visualstudio.com/items?itemName=bbenoist.togglehs) -
    Toggles between .cc and .h with `F4`. The C/C++ extension supports this as
    well through `Alt+O` but sometimes chooses the wrong file when there are
    multiple files in the workspace that have the same name.
*   [**Protobuf support**](https://marketplace.visualstudio.com/items?itemName=peterj.proto) -
    Syntax highlighting for .proto files.
*   [**Mojom IDL support**](https://marketplace.visualstudio.com/items?itemName=Google.vscode-mojom) -
    Syntax highlighting and a
    [language server](https://microsoft.github.io/language-server-protocol/)
    for .mojom files.
*   [**GN**](https://marketplace.visualstudio.com/items?itemName=msedge-dev.gnls) -
    Code IntelliSense for the GN build system.
*   [**Rewrap**](https://marketplace.visualstudio.com/items?itemName=stkb.rewrap) -
    Wrap lines at 80 characters with `Alt+Q`.
*   [**Remote**](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-ssh) -
    Remotely connect to your workstation through SSH using your laptop. See the
    [Remote](#Remote) section for more information about how to set this up.
*   [**GitLens**](https://marketplace.visualstudio.com/items?itemName=eamodio.gitlens) -
    Git supercharged. A Powerful, feature rich, and highly customizable git
    extension.

The following extensions might be useful for you as well:

```bash
$ echo "wmaurer.change-case shd101wyy.markdown-preview-enhanced Gruntfuggly.todo-tree alefragnani.Bookmarks spmeesseman.vscode-taskexplorer streetsidesoftware.code-spell-checker tht13.html-preview-vscode anseki.vscode-color" | xargs -n 1 code --force --install-extension
```

*   **chromium-codesearch** -
    Mac and Linux only: adds ability to open the current line in [Chromium Code
    Search](https://cs.chromium.org/). All other functionality is deprecated, so
    currently only of limited usefulness.
*   [**change-case**](https://marketplace.visualstudio.com/items?itemName=wmaurer.change-case) -
    Quickly change the case of the current selection or current word.
*   [**Markdown Preview Enhanced**](https://marketplace.visualstudio.com/items?itemName=shd101wyy.markdown-preview-enhanced) -
    Preview markdown side-by-side with automatic scroll sync and many other
    features with `ctrl+k v`. This document was written with this extension!
*   [**Todo Tree**](https://marketplace.visualstudio.com/items?itemName=Gruntfuggly.todo-tree) -
    Displays comment tags like TODO/FIXME in a tree view in a dedicated sidebar.
*   [**Bookmarks**](https://marketplace.visualstudio.com/items?itemName=alefragnani.Bookmarks) -
    Supports easy mark/unmark positions in the codebase and displays them in a
    dedicated sidebar. Very useful for a large codebase like Chromium.
*   [**Task Explorer**](https://marketplace.visualstudio.com/items?itemName=spmeesseman.vscode-taskexplorer) -
    Displays supported tasks, e.g. vscode tasks, shell scripts and others,
    organized into a treeview in sidebar.
*   [**Code Spell Checker**](https://marketplace.visualstudio.com/items?itemName=streetsidesoftware.code-spell-checker) -
    A basic spell checker that works well with camelCase code. It helps catch
    common spelling errors.
*   [**HTML Preview**](https://marketplace.visualstudio.com/items?itemName=tht13.html-preview-vscode) -
    Previews HTML files while editing with `ctrl+k v`.
*   [**Color Picker**](https://marketplace.visualstudio.com/items?itemName=anseki.vscode-color) -
    Visualizes color codes inline and provides color picker GUI to generates new
    color codes.


Also be sure to take a look at the
[VS Code marketplace](https://marketplace.visualstudio.com/VSCode) to check out
other useful extensions.

### Color Scheme

Press `Ctrl+Shift+P, color, Enter` to pick a color scheme for the editor. There
are also tons of [color schemes available for download on the
marketplace](https://marketplace.visualstudio.com/search?target=VSCode&category=Themes&sortBy=Downloads).

### Keyboard Shortcuts

#### CheatSheet

*   [Windows](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-windows.pdf)
*   [Mac](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-macos.pdf)

#### Useful Shortcuts

*   `Ctrl+P` opens a search box to find and open a file.
*   `F1` or `Ctrl+Shift+P` opens a search box to find a command (e.g. Tasks: Run
    Task). Note: if you want to run one of the [Predefined tasks in
    tasks.json](#Tasks), it is faster to just use `Ctrl+P` &gt; "task <n>".
*   `Ctrl+K, Ctrl+S` opens the key bindings editor.
*   ``Ctrl+` `` toggles the built-in terminal.
*   `Ctrl+Shift+M` toggles the problems view (linter warnings, compile errors
    and warnings). You'll switch a lot between terminal and problem view during
    compilation.
*   `Alt+O` switches between the source/header file.
*   `Ctrl+G` jumps to a line.
*   `F12` jumps to the definition of the symbol at the cursor (also available on
    right-click context menu).
*   `Shift+F12` or `F1, CodeSearchReferences, Return` shows all references of
    the symbol at the cursor.
*   `F1, CodeSearchOpen, Return` opens the current file in Code Search.
*   `Ctrl+D` selects the word at the cursor. Pressing it multiple times
    multi-selects the next occurrences, so typing in one types in all of them,
    and `Ctrl+U` deselects the last occurrence.
*   `Ctrl+K, Z` enters Zen Mode, a fullscreen editing mode with nothing but the
    current editor visible.
*   `Ctrl+X` without anything selected cuts the current line. `Ctrl+V` pastes
    the line.

*** aside
Note: See also [Key Bindings for Visual Studio Code
](https://code.visualstudio.com/docs/getstarted/keybindings).
***

### Java/Android Support

*Before anything*, add these to your settings.json.
```
// LightWeight is the language support, the feature we care about. The other
// modes include build functionality with Maven and Gradle. They try to build
// on their own and end up showing thousands of errors.
"java.server.launchMode": "LightWeight",
// Avoids overwriting the custom .classpath file (c.f. next section).
"java.configuration.updateBuildConfiguration": "disabled",
```
Then install the "Language Support for Java" extension. If you installed it
before setting the configs above, uninstall, delete the <project> folder (c.f.
next section) and reinstall. You also don't need any of the remaining extensions
in "Extension Pack for Java".

#### Setting up code completion/reference finding/etc.

You'll need to generate a placeholder .classpath file and locate it. In order
to generate it, right click on any Java source folder in the left panel and
choose "Add folder to java source path". Its location will depend on whether
you're doing local or remote development. Local path on linux will look
something like:

`~/.vscode/data/User/workspaceStorage/<hash>/redhat.java/jdt_ws/<project>/.classpath`

You might find multiple folders when looking for `<project>`. Choose anything except
`jdt.ls-java-project`. If you only see `jdt.ls-java-project`, try using the
"Add folder to java source path" option again.

If doing remote development, the file will be under `~/.vscode-server/` on your
remote machine.

You'll need to replace all of the contents of that file with the contents of
`tools/android/eclipse/.classpath` (external) or
`clank/development/ide/eclipse/.classpath` (generated by gclient runhooks for
Chrome developers), and then replace some paths as vscode interprets some paths
differently from eclipse.
*   Replace: `kind="src" path="` with `kind="src" path="_/`
    * eg. `<classpathentry kind="src" path="_/android_webview/glue/java/src"/>`
*   Replace: `kind="lib" path="../src` with `kind="lib" path="_`
    * eg.
`<classpathentry kind="lib" path="_/out/Debug/lib.java/base/base_java.jar"/>`
*   Remove all nested paths (or exclude them from their parents). At time of
writing:
    * `third_party/android_protobuf/src/java/src/main/java`
    * `third_party/junit/src/src/main/java`

Also, make sure
`export ANDROID_HOME=/usr/local/google/home/{your_ldap}/Android/Sdk` is in the
remote machine's `~/.bashrc`.

Then restart vscode, open a Java file, and wait for a bit.

Debugging tips:
*   Right clicking on a folder in vscode and clicking "Add folder to java source
path" will error if there are syntax problems with your classpath. (Don't use
this actually add new paths to your classpath as it won't work correctly)
    * If there are no syntax errors, ensure the correct .classpath file is being
    used by seeing if the folder was actually added to the .classpath file you
    edited.

## Setup For Chromium

VS Code is configured via JSON files. This paragraph contains JSON configuration
files that are useful for Chromium development, in particular. See [VS Code
documentation](https://code.visualstudio.com/docs/customization/overview) for an
introduction to VS Code customization.

### Workspace Settings

Open the file [//tools/vscode/settings.json](/tools/vscode/settings.json),
and check out the default settings there. Feel free to commit added or removed
settings to enable better team development, or change settings locally to suit
personal preference.

To use these settings wholesale, enter the following commands into your terminal
while at the src directory:

```bash
$ mkdir .vscode/
$ cp tools/vscode/settings.json .vscode
```

Note: these settings assume that the workspace folder (the root folder displayed
in the Explorer tab) is Chromium's `src/` directory. If this is not the case,
replace any references to ${workspaceFolder} with the path to your `src/`.

### Tasks

Next, we'll tell VS Code how to compile our code, run tests, and to read
warnings and errors from the build output. Open the file
[//tools/vscode/tasks.json](/tools/vscode/tasks.json). This will provide tasks
to do basic things. You might have to adjust the commands to your situation and
needs. To use these settings wholesale, enter the following command into your
terminal:
```bash
$ cp tools/vscode/tasks.json .vscode
```

Before running most of the tasks, you'll need to set the `chromeOutputDir` value
in your `.vscode/tasks.json` file.

Now you can run tasks by using `Ctrl+P` and typing "task " and then a number
of your choice. If you select one of the build tasks, the build output will
display in the terminal pane. Jump through build problems quickly using F8 /
Shift-F8. See [task names](#task-names) for more info on running tasks.

If you have intellisense enabled but do not have include paths set up correctly,
jumping through problems will also try to navigate through all the include files
it cannot locate and add a lot of noise. You can fix your include path or simply
set intellisense to "tag parser" mode by doing the following:

1. Open Preferences (`Ctrl+Shift+P` &gt; "Preferences: Open User Settings").
2. Type "intellisense engine" in the settings search box.
3. Select "Tag Parser" as the provider.

Note: on a Chromebook, use 🔍+<8th button in the top row that's not ESC>. In
most cases, this is the top row button that is the closest to be directly above
the 8 key.

### Launch Commands

Launch commands are the equivalent of `F5` in Visual Studio: They launch some
program or a debugger. Optionally, they can run some task defined in
`tasks.json`. Launch commands can be run from the debug view (`Ctrl+Shift+D`).
Open the file at [//tools/vscode/launch.json](/tools/vscode/launch.json) and
adjust the example launch commands to your situation and needs (e.g., the value
of "type" needs adjustment for Windows). To use these settings wholesale, enter
the following command into your terminal:

```bash
$ cp tools/vscode/launch.json .vscode
```

### Key Bindings

To edit key bindings, press `Ctrl+K, Ctrl+S`. You'll see the defaults on the
left and your overrides on the right stored in the file `keybindings.json`. To
change a key binding, copy the corresponding key binding to the right. It's
fairly self-explanatory.

You can bind any command to a key, even commands specified by extensions like
`CodeSearchOpen`. For instance, to bind `CodeSearchOpen` to `F2` to , simply add
`{ "key": "F2", "command": "cs.open" },`.
Note that the command title `CodeSearchOpen` won't work. You have to get the
actual command name from the [package.json
file](https://github.com/chaopeng/vscode-chromium-codesearch/blob/master/package.json)
of the extension.

If you are used to other editors, you can also install your favorite keymap.
For instance, to install eclipse keymaps, install the
`vscode-eclipse-keybindings` extension. More keymaps can be found
[in the marketplace](https://marketplace.visualstudio.com/search?target=vscode&category=Keymaps).

Some key bindings that are likely to be useful for you are available at
[//tools/vscode/keybindings.json](/tools/vscode/keybindings.json). Please
take a look and adjust them to your situation and needs. To use these settings
wholesale, enter the following command into your terminal:

```bash
$ cp tools/vscode/keybindings.json .vscode
```

### Remote

*** promo
Googlers: See [go/vscode-remote](http://go/vscode-remote).
***

VS Code now has a
[Remote](https://code.visualstudio.com/docs/remote/remote-overview) framework
that allows you to use VS Code on your laptop while your code is hosted
elsewhere. This really shines when used in conjunction with the vscode-clangd plugin,
which allows clangd to run remotely as well.

To get this to run, install the Remote pack extension, and then make sure your
ssh config file has your remote connection:

`~/.ssh/config`:
```
Host my-connection
  HostName my-remote-host.corp.company.com
```

VS Code will then list this connection in the 'Remote Explorer' section on the
left. To launch VS Code with this connection, click on the '+window' icon next
to the listed hostname. It has you choose a folder - use the 'src' folder root.
This will open a new VS Code window in 'Remote' mode. ***Now you can install
extensions specifically for your remote connection, like vscode-clangd, etc.***

#### Chromebooks

For Googlers, [here](http://go/vscode/remote_development_via_web) are
Google-specific instructions for setting up remote development on chromebooks
without using Crostini.

#### Windows & SSH

VS Code remote tools requires 'sshd' which isn't installed on Windows by
default.

For Googlers, sshd should already be installed on your workstation, and VS Code
should work remotely if you followed the setup instructions at
[go/building-chrome-win](http://go/building-chrome-win). If you are still having
problems, please refer to
[go/vscode-remote#windows](http://go/vscode-remote#windows).

Non-Googlers may follow may follow Microsoft's instructions for
[installing the OpenSSH server](https://docs.microsoft.com/en-us/windows-server/administration/openssh/openssh_install_firstuse).
VS Code should work remotely after following this step.

### Snippets

There are some useful snippets provided in
[//tools/vscode/cpp.json](/tools/vscode/cpp.json).

You can either install them in your user profile (path may vary depending on the
platform):
```bash
$ mkdir -p ~/.config/Code/User/snippets
$ cp tools/vscode/cpp.json ~/.config/Code/User/snippets
```

Or install them as project snippets:
```bash
$ cp tools/vscode/cpp.json .vscode/cpp.code-snippets
```

### Tips

#### The `out` folder

Automatically generated code is put into a subfolder of out/, which means that
these files are ignored by VS Code (see files.exclude above) and cannot be
opened e.g. from quick-open (`Ctrl+P`).
As of version 1.21, VS Code does not support negated glob commands, but you can
define a set of exclude pattern to include only out/Debug/gen:
```
"files.exclude": {
  // Ignore build output folders. Except out/Debug/gen/
  "out/[^D]*/": true,
  "out/Debug/[^g]*": true,
  "out/Debug/g[^e]*": true,
  "out_*/**": true,
},
```

Once it does, you can use
```
"!out/Debug/gen/**": true
```
in files.exclude instead of the symlink.

#### Using VS Code as git editor

Add `[core] editor = "code --wait"` to your `~/.gitconfig` file in order to use
VS Code as editor for git commit messages etc. Note that the editor starts up
significantly slower than nano or vim. To use VS Code as merge tool, add
`[merge] tool = code`.

#### Task Names

Note that we named the tasks `1-build_chrome_debug`, `2-build_chrome_release`
etc. This allows you to quickly execute tasks by pressing their number:
Press `Ctrl+P` and enter `task <n>`, where `<n>` is the number of the task. You
can also create a keyboard shortcut for running a task. `File > Preferences >
Keyboard Shortcuts` and add `{ "key": "ctrl+r", "command":
"workbench.action.tasks.runTask", "when": "!inDebugMode" }`. Then it's
sufficient to press `Ctrl+R` and enter `<n>`.

#### Working on Laptop

You might want to disable git status autorefresh to save battery.

```
"git.autorefresh": false,
```

#### Editing in multiple Git repositories

If you frequently work in multiple Git repositories that are part of the Chromium repository, you might find that the built-in tooling does not work as expected for files that exist below folders that are part of a `.gitignore` file checked in to Chromium.

To work around this, you can add the directories you edit as separate `folders` entries in your workspace configuration, and ensure that the directories that are ignored in Chromium are listed **before** the Chromium `src` path.

To edit this, go to `Settings` -> Select the `Workspace` tab, and choose to open as JSON (button in the top right), and configure `folders` like this (change paths to match your local setup and usage):

```
{
  "folders": [
    {
      "path": "chromium/src/third_party/perfetto"
    },
    {
      "path": "chromium/src"
    }
  ]
}
```

### Unable to open $File resource is not available when debugging Chromium on Linux

Chromium [recently changed](https://docs.google.com/document/d/1OX4jY_bOCeNK7PNjVRuBQE9s6BQKS8XRNWGK8FEyh-E/edit?usp=sharing)
the file path to be relative to the output dir. Check
`gn args out/$dir --list` if `strip_absolute_paths_from_debug_symbols` is true (which is the default),
set `cwd` to the output dir. otherwise, set `cwd` to `${workspaceFolder}`.

### More

More tips and tricks can be found
[here](https://code.visualstudio.com/docs/getstarted/tips-and-tricks).
