# Largest Contentful Paint Bug Fixes in M96

## Bug Fixes in Chrome 96

In Chrome 96, a bug fix was made to the Chrome implementation. Previously, a
[change](https://chromium-review.googlesource.com/c/chromium/src/+/2441732) was
made to ignore images occupying the full viewport. However, this change used the
frame's viewport instead of the page's viewport. This meant that images embedded
in an iframe and occupying the full iframe size were ignored. This fixes this
issue by always using the full page viewport instead of frame viewport when
considering which images to ignore. [Source code for this
change](https://chromium-review.googlesource.com/c/chromium/src/+/2965459).

## How does this affect a site's metrics?

We saw two main types of sites affected by this change:

* Some sites embedding images or videos in smaller iframes could see changes, as
those images or poster images would no longer be ignored and could potentially
become the LCP.

* Certain sites using ads may also see changes to their LCP scores because the
images embedded in those ads would no longer be ignored despite occupying the
full ad iframe size.

## When were users affected?

Chrome 96 is currently scheduled to be released the week of November 16, 2021.
