
# Cumulative Layout Shift Changes in Chrome 93

### Bug fix involving scroll anchoring

Shifts of offscreen elements that are countered with scroll anchoring, and
combined with a natural user scroll, are now correctly ignored.

[Source code](https://chromium-review.googlesource.com/c/chromium/src/+/2946459)

### Ignore layout shift while dragging or resizing elements with a mouse

For mouse drag and resize actions, we buffer the layout shift for Mousemove
events after Mousedown event. When the Mouseup is received, We set hadRecentInput
to be true, which triggers the exclusion window to ignore the layout shift
score during mouse dragging and resizing.

[Source code for change 1](https://chromium-review.googlesource.com/c/chromium/src/+/2893404)

[Source code for change 2](https://chromium-review.googlesource.com/c/chromium/src/+/2950013)

## How does this affect a site's metrics?

### Bug fix involving scroll anchoring

Sites should see a decrease in their Cumulative Layout Shift scores when shifts of offscreen elements happens for scroll anchoring.

### Ignore layout shift while dragging or resizing elements with a mouse

Desktop sites which make use of mouse drag and resize will now receive an input exclusion on these user interactions, resulting in lower CLS scores.

## When were users affected?

Chrome 93 is currently expected to be released the week of August 31, 2021.
