/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.Comment;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.grammar.CommentListener;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class FileContents
implements CommentListener {
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final Pattern MATCH_SINGLELINE_COMMENT = Pattern.compile("^\\s*//.*$");
    private final FileText text;
    private final Map<Integer, TextBlock> javadocComments = new HashMap<Integer, TextBlock>();
    private final Map<Integer, TextBlock> cppComments = new HashMap<Integer, TextBlock>();
    private final Map<Integer, List<TextBlock>> clangComments = new HashMap<Integer, List<TextBlock>>();

    public FileContents(FileText text) {
        this.text = new FileText(text);
    }

    public FileText getText() {
        return new FileText(this.text);
    }

    public String[] getLines() {
        return this.text.toLinesArray();
    }

    public String getLine(int index) {
        return this.text.get(index);
    }

    public String getFileName() {
        return this.text.getFile().toString();
    }

    @Override
    public void reportSingleLineComment(String type, int startLineNo, int startColNo) {
        this.reportSingleLineComment(startLineNo, startColNo);
    }

    public void reportSingleLineComment(int startLineNo, int startColNo) {
        String line = this.line(startLineNo - 1);
        String[] txt = new String[]{line.substring(startColNo)};
        Comment comment = new Comment(txt, startColNo, startLineNo, line.length() - 1);
        this.cppComments.put(startLineNo, comment);
    }

    @Override
    public void reportBlockComment(String type, int startLineNo, int startColNo, int endLineNo, int endColNo) {
        this.reportBlockComment(startLineNo, startColNo, endLineNo, endColNo);
    }

    public void reportBlockComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        String[] cComment = this.extractBlockComment(startLineNo, startColNo, endLineNo, endColNo);
        Comment comment = new Comment(cComment, startColNo, endLineNo, endColNo);
        List entries = this.clangComments.computeIfAbsent(startLineNo, empty -> new ArrayList());
        entries.add(comment);
        String firstLine = this.line(startLineNo - 1);
        if (firstLine.contains("/**") && !firstLine.contains("/**/")) {
            this.javadocComments.put(endLineNo - 1, comment);
        }
    }

    private String[] extractBlockComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        String[] returnValue;
        if (startLineNo == endLineNo) {
            returnValue = new String[]{this.line(startLineNo - 1).substring(startColNo, endColNo + 1)};
        } else {
            returnValue = new String[endLineNo - startLineNo + 1];
            returnValue[0] = this.line(startLineNo - 1).substring(startColNo);
            for (int i = startLineNo; i < endLineNo; ++i) {
                returnValue[i - startLineNo + 1] = this.line(i);
            }
            returnValue[returnValue.length - 1] = this.line(endLineNo - 1).substring(0, endColNo + 1);
        }
        return returnValue;
    }

    private String line(int lineNo) {
        return this.text.get(lineNo);
    }

    public TextBlock getJavadocBefore(int lineNoBefore) {
        int lineNo;
        for (lineNo = lineNoBefore - 2; lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo)); --lineNo) {
        }
        return this.javadocComments.get(lineNo);
    }

    public boolean lineIsBlank(int lineNo) {
        return CommonUtil.isBlank(this.line(lineNo));
    }

    public boolean lineIsComment(int lineNo) {
        return MATCH_SINGLELINE_COMMENT.matcher(this.line(lineNo)).matches();
    }

    public boolean hasIntersectionWithComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        return this.hasIntersectionWithBlockComment(startLineNo, startColNo, endLineNo, endColNo) || this.hasIntersectionWithSingleLineComment(startLineNo, startColNo, endLineNo, endColNo);
    }

    private boolean hasIntersectionWithBlockComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        Collection<List<TextBlock>> values = this.clangComments.values();
        return values.stream().flatMap(Collection::stream).anyMatch(comment -> comment.intersects(startLineNo, startColNo, endLineNo, endColNo));
    }

    private boolean hasIntersectionWithSingleLineComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        boolean hasIntersection = false;
        for (int lineNumber = startLineNo; lineNumber <= endLineNo; ++lineNumber) {
            TextBlock comment = this.cppComments.get(lineNumber);
            if (comment == null || !comment.intersects(startLineNo, startColNo, endLineNo, endColNo)) continue;
            hasIntersection = true;
            break;
        }
        return hasIntersection;
    }

    public Map<Integer, TextBlock> getSingleLineComments() {
        return Collections.unmodifiableMap(this.cppComments);
    }

    public Map<Integer, List<TextBlock>> getBlockComments() {
        return Collections.unmodifiableMap(this.clangComments);
    }

    @Deprecated(since="10.2")
    public boolean inPackageInfo() {
        return "package-info.java".equals(this.text.getFile().getName());
    }
}

