import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Effects

import org.deepin.dtk as D
import org.deepin.dtk.style as DS
import org.deepin.dcc
import org.deepin.dcc.passkey

D.DialogWindow {
    id: dialog
    icon: "preferences-system"
    modality: Qt.WindowModal
    width: 360

    Item {
        implicitWidth: parent.width
        implicitHeight: 450 - DS.Style.dialogWindow.titleBarHeight - DS.Style.dialogWindow.contentHMargin

        ScrollView {
            anchors.fill: parent
            contentWidth: availableWidth
            clip: true
            ScrollBar.horizontal.policy: ScrollBar.AlwaysOff

            ColumnLayout {
                width: parent.width

                D.Label {
                    Layout.fillWidth: true
                    horizontalAlignment: Text.AlignHCenter
                    wrapMode: Text.WordWrap
                    font: D.DTK.fontManager.t5
                    text: qsTr("Reset Security Key")
                }

                StackLayout {
                    id: stackLayout
                    Layout.fillWidth: true
                    Layout.fillHeight: true

                    // 0. 提示 1. 重新插入 2. 正在识别 3. 触摸两次提示 4. 触摸第二次 5. 成功 6. 失败
                    currentIndex: {
                        switch (dccData.model.resetDialogStyle) {
                        case Common.DescriptionStyle:
                            return 0
                        case Common.InsertStyle:
                            return 1
                        case Common.IdentifyingStyle:
                            return 2
                        case Common.FirstTouchStyle:
                            return 3
                        case Common.SecondTouchStyle:
                            return 4
                        case Common.ResultSuccessStyle:
                            return 5
                        case Common.ResultFailedStyle:
                            return 6
                        default:
                            return 6
                        }
                    }

                    ColumnLayout {

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Resetting the security key includes but is not limited to the following steps. Are you sure you want to reset the key?")
                        }

                        Item {
                            Layout.preferredHeight: 40
                        }

                        D.Label {
                            Layout.fillWidth: true
                            wrapMode: Text.WordWrap
                            font.family: D.DTK.fontManager.t7.family
                            font.pixelSize: D.DTK.fontManager.t7.pixelSize
                            font.bold: true
                            text: "• " + qsTr("Revoke the certificate generated by the current system") + "\n" +
                                  "• " + qsTr("Erase all user-stored certificates") + "\n" +
                                  "• " + qsTr("Delete credential data for biometric authentication") + "\n" +
                                  "• " + qsTr("Reset some features and settings of the security key")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10

                            D.Button {
                                text: qsTr("Cancel")
                                Layout.fillWidth: true
                                onClicked: {
                                    dccData.worker.deactivate()
                                    close()
                                }
                            }

                            D.Button {
                                id: resetButton
                                enabled: false
                                Layout.fillWidth: true
                                text: qsTr("Reset") + "(5)"
                                onClicked: {
                                    dccData.worker.requestReset()
                                }

                                Timer {
                                    interval: 1000
                                    property int count: 4
                                    repeat: true
                                    running: true
                                    onTriggered: {
                                        if (count <= 0) {
                                            resetButton.enabled = true
                                            resetButton.text = qsTr("Reset")
                                            running = false
                                        } else {
                                            resetButton.text = qsTr("Reset") + "(" + count + ")"
                                            count--
                                        }
                                    }
                                }
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Image {
                            source: "qrc:/icons/deepin/builtin/texts/page_insert_180px.svg"
                            Layout.alignment: Qt.AlignHCenter
                            Layout.preferredWidth: 180
                            Layout.preferredHeight: 180
                        }

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Please plug in the security key again")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        D.Button {
                            text: qsTr("Cancel")
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            onClicked: {
                                dccData.worker.requestStopReset()
                                close()
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Image {
                            fillMode: Image.Pad
                            Layout.alignment: Qt.AlignHCenter
                            clip: true
                            width: 180
                            height: 180
                            source: "qrc:/icons/deepin/builtin/texts/page_identify_180px.svg"
                        }

                        RowLayout {
                            Layout.alignment: Qt.AlignHCenter
                            spacing: 10

                            D.BusyIndicator {
                                running: visible
                                Layout.preferredWidth: 24
                                Layout.preferredHeight: 24
                            }

                            Label {
                                text: qsTr("Identifying the security key")
                                font.family: D.DTK.fontManager.t6.family
                                font.pixelSize: D.DTK.fontManager.t6.pixelSize
                                font.bold: true
                            }
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        D.Button {
                            text: qsTr("Cancel")
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            onClicked: {
                                dccData.worker.requestStopReset()
                                close()
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Image {
                            source: "qrc:/icons/deepin/builtin/texts/page_touch_180px.svg"
                            Layout.alignment: Qt.AlignHCenter
                            Layout.preferredWidth: 180
                            Layout.preferredHeight: 180
                        }

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Please touch or swipe the device twice within 10 seconds")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            D.Button {
                                text: qsTr("Cancel")
                                Layout.fillWidth: true
                                onClicked: {
                                    dccData.worker.requestStopReset()
                                    close()
                                }
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Image {
                            source: "qrc:/icons/deepin/builtin/texts/page_touch_180px.svg"
                            Layout.alignment: Qt.AlignHCenter
                            Layout.preferredWidth: 180
                            Layout.preferredHeight: 180
                        }

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Please touch or swipe the security key again")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            D.Button {
                                text: qsTr("Cancel")
                                Layout.fillWidth: true
                                onClicked: {
                                    dccData.worker.requestStopReset()
                                    close()
                                }
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Item {
                            Layout.preferredHeight: 50
                        }

                        D.DciIcon {
                            name: "icon_success"
                            sourceSize: Qt.size(96, 96)
                            Layout.alignment: Qt.AlignHCenter
                        }

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Reset complete")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            D.Button {
                                text: qsTr("Done")
                                Layout.fillWidth: true
                                onClicked: {
                                    dccData.worker.activate()
                                    close()
                                }
                            }
                        }
                    }

                    ColumnLayout {
                        spacing: 30

                        Item {
                            Layout.preferredHeight: 50
                        }

                        D.DciIcon {
                            name: "icon_fail"
                            sourceSize: Qt.size(96, 96)
                            Layout.alignment: Qt.AlignHCenter
                        }

                        D.Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignHCenter
                            wrapMode: Text.WordWrap
                            font: D.DTK.fontManager.t6
                            text: qsTr("Unable to complete the security key reset")
                        }

                        Item {
                            Layout.fillHeight: true
                        }

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            D.Button {
                                text: qsTr("Done")
                                Layout.fillWidth: true
                                onClicked: {
                                    dccData.worker.activate()
                                    close()
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
