/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WORKER_H
#define WORKER_H

#include "model.h"

#include <QObject>
#include <QJsonDocument>
#include <QProcess>
#include <QDBusInterface>
#include <QDBusPendingCallWatcher>
#include <QTimer>

#include <DWindowManagerHelper>

DGUI_USE_NAMESPACE
//发送信息到DBUS改变电脑的桌面样式、运行模式、图标主题类
class Worker : public QObject
{
    Q_OBJECT

public:
    static Worker* Instance();
    /* 判断当前系统是否是wayland系统 */
    static bool isWaylandType();

    Model::DesktopMode desktopMode();
public slots:
    //设置桌面样式发送到dock栏
    void setDesktopMode(Model::DesktopMode mode);
    //设置运行模式发送DBUS修改电脑的窗口特效打开或关闭
    void setWMMode(Model::WMType type);
    //设置主题图标改变电脑的主题图标配置
    void setIcon(const IconStruct &icon);

private slots:
    //运行模式变化保存到model槽
    void onWMChanged(const QString &wm);
    //目前不使用，等后续研究
    void onWMChang(/*const quint32 &wm*/);
    //桌面样式变化保存到model槽
    void onDisplayModeChanged(int mode);
    //图标刷新槽
    void onIconRefreshed(const QString &name);
    //图标主题列表变化响应槽
    void onIconListChanged(const QString & value);
    //图标图片完成响应槽
    void onIconPixmapFinished(QDBusPendingCallWatcher *w);
    //v23图标图片完成响应槽
    void onIconPixmapFinished(QJsonObject w, QVariant pixmap);
    //图片点击刷新响应槽 ut002764 2021.6.1
    void onIconClickChange(QDBusPendingCallWatcher *w);

private:
    explicit Worker(QObject *parent = nullptr);

private:
    Model*      m_model;
    //图标DBUS
    QDBusInterface*   m_iconInterface;
    //窗口特效DBUS
    QDBusInterface*   m_wmInterface;
    //窗口管理帮助，什么作用???
    DWindowManagerHelper* m_windowManage;
};

#endif // WORKER_H
