// SPDX-FileCopyrightText: 2021 - 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "iconmodule.h"
#include "commonlywidget.h"
#include "quicklystartwidget.h"

#include <QPainter>
#include <QTimer>
#include <QDBusInterface>
#include <DCommandLinkButton>
#include <DFontSizeManager>

IconModule::IconModule(QWidget *parent)
    : ModuleInterface(parent)
{
    m_selectBtn->hide();
    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(0, 20, 0, 0);
    layout->setSpacing(20);
    setLayout(layout);
    setFixedSize(860, 490);

    QStringList svgList;
    QList<QPixmap> pixList;
    QStringList textList;
    QList<QString> propertyList;

    svgList << ":/resources/socializing.svg"
            << ":/resources/office.svg"
            << ":/resources/operation.svg"
            << ":/resources/more.svg"
            << ":/resources/arrow.svg";

    pixList << QPixmap(DHiDPIHelper::loadNxPixmap(":/resources/operate.png"))
            << QPixmap(DHiDPIHelper::loadNxPixmap(":/resources/applicationlibrary.png"))
            << QPixmap(DHiDPIHelper::loadNxPixmap(":/resources/guide.png"));

    textList << tr("Social Communication") << tr("Office Software") << tr("Operation tools") << tr("More Apps")
             << tr("Learn basics operations") << tr("Common App Libraries") << tr("Video Tutorials");

    propertyList << "searchApp?keyword=社交通讯" << "searchApp?keyword=社交办公" << "searchApp?keyword=网络应用" << ""
                 << "learn-basic-operations" << "common-application-libraries" << "" << "";

    DLabel *installLabel = new DLabel(tr("Install some frequently used applications"));
    DFontSizeManager::instance()->bind(installLabel, DFontSizeManager::T5, QFont::DemiBold);
    installLabel->setForegroundRole(DPalette::TextTitle);
    installLabel->setFixedHeight(25);
    QFont labelFont = installLabel->font();
    QFontMetrics lableFM(labelFont);
    installLabel->setFixedWidth(lableFM.horizontalAdvance(installLabel->text()));
#ifdef DTKWIDGET_CLASS_DSizeMode
    connect(DGuiApplicationHelper::instance(), &DGuiApplicationHelper::sizeModeChanged, installLabel, [ = ](DGuiApplicationHelper::SizeMode sizeMode) {
        QTimer::singleShot(50, installLabel, [ = ]() {
            QFont labelFont = installLabel->font();
            QFontMetrics lableFM(labelFont);
            installLabel->setMinimumWidth(lableFM.horizontalAdvance(installLabel->text()));
        });
    });
#endif
    layout->addWidget(installLabel);

    QWidget *installWidget = new QWidget;
    QHBoxLayout *installLayout = new QHBoxLayout;
    installLayout->setSpacing(14);
    installLayout->setContentsMargins(0, 0, 0, 0);
    installWidget->setLayout(installLayout);
    for (int i = 0; i < 4; i++) {
        CommonlyWidget *commonly = new CommonlyWidget(false, svgList.at(i), textList.at(i), this);
        installLayout->addWidget(commonly);
        commonly->setMethod(propertyList.at(i));
        connect(commonly, &CommonlyWidget::clicked, this, &IconModule::slotOpenAppStore);
    }
    CommonlyWidget *commonly = new CommonlyWidget(true, svgList.last(), tr("Enter the App Store"), this);
    installLayout->addWidget(commonly);
    connect(commonly, &CommonlyWidget::clicked, this, &IconModule::slotOpenAppStore);
    layout->addSpacing(10);
    layout->addWidget(installWidget);
    layout->addSpacing(35 / devicePixelRatioF());

    DLabel *uosLabel = new DLabel(tr("How to get started quickly with UOS"));
    DFontSizeManager::instance()->bind(uosLabel, DFontSizeManager::T5, QFont::DemiBold);
    uosLabel->setForegroundRole(DPalette::TextTitle);
    uosLabel->setFixedHeight(25);
//    layout->addWidget(uosLabel);

    QWidget *uosWidget = new QWidget;
    QHBoxLayout *uosLayout = new QHBoxLayout;
    uosLayout->setContentsMargins(0, 0, 0, 0);
    uosLayout->setSpacing(20);
    uosWidget->setLayout(uosLayout);
    for (int i = 0; i < pixList.size(); i++) {
        QuicklyStartWidget *quickly = new QuicklyStartWidget(pixList.at(i), textList.at(i + 4), this);
        quickly->setMethod(propertyList.at(i + 4));
        uosLayout->addWidget(quickly);
        connect(quickly, &QuicklyStartWidget::clicked, this, &IconModule::slotOpenManual);
    }
    CommonlyWidget *quickly = new CommonlyWidget(true, svgList.last(), tr("View Manuals"), this);
    uosLayout->addWidget(quickly);
    connect(quickly, &CommonlyWidget::clicked, this, &IconModule::slotOpenManual);
    uosLayout->addStretch();
//    layout->addWidget(uosWidget);
    layout->addStretch();
}

//首次启动初始化图片
void IconModule::updateBigIcon()
{
}

//日常启动初始化图片
void IconModule::updateSmallIcon()
{
}

//更新选择按钮位置
void IconModule::updateSelectBtnPos()
{
}

void IconModule::slotOpenAppStore()
{
    QDBusInterface Interface("com.home.appstore.client",
                             "/com/home/appstore/client",
                             "com.home.appstore.client",
                             QDBusConnection::sessionBus());
    QString method = dynamic_cast<CommonlyWidget *>(sender())->getMethod();
    if (method.isEmpty()) {
        Interface.call("openInstalledNecessaryPage");
    } else {
        Interface.call("openBusinessUri", method);
    }
}

void IconModule::slotOpenManual()
{
    QDBusInterface Interface("com.deepin.Manual.Open",
                             "/com/deepin/Manual/Open",
                             "com.deepin.Manual.Open",
                             QDBusConnection::sessionBus());
    QuicklyStartWidget *quick = dynamic_cast<QuicklyStartWidget *>(sender());
    QString method;
    if (quick)
        method = quick->getMethod();
    if (method.isEmpty()) {
        Interface.call("Open", "");
    } else {
        Interface.call("Open", method);
    }
}
