% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsvaNewAPI.R
\name{gsvaAnnotation}
\alias{gsvaAnnotation}
\alias{gsvaAnnotation<-}
\alias{gsvaAnnotation,GsvaExprData-method}
\alias{gsvaAnnotation<-,GsvaExprData,GeneIdentifierType-method}
\alias{gsvaAnnotation,ExpressionSet-method}
\alias{gsvaAnnotation<-,ExpressionSet,character-method}
\alias{gsvaAnnotation<-,ExpressionSet,GeneIdentifierType-method}
\alias{gsvaAnnotation,SummarizedExperiment-method}
\alias{gsvaAnnotation<-,SummarizedExperiment,GeneIdentifierType-method}
\alias{gsvaAnnotation,SingleCellExperiment-method}
\alias{gsvaAnnotation<-,SingleCellExperiment,GeneIdentifierType-method}
\alias{gsvaAnnotation,SpatialExperiment-method}
\alias{gsvaAnnotation<-,SpatialExperiment,GeneIdentifierType-method}
\alias{gsvaAnnotation,list-method}
\alias{gsvaAnnotation<-,list,GeneIdentifierType-method}
\alias{gsvaAnnotation,GeneSetCollection-method}
\title{Store and Retrieve Annotation Metadata}
\usage{
\S4method{gsvaAnnotation}{GsvaExprData}(object)

\S4method{gsvaAnnotation}{GsvaExprData,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{ExpressionSet}(object)

\S4method{gsvaAnnotation}{ExpressionSet,character}(object) <- value

\S4method{gsvaAnnotation}{ExpressionSet,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{SummarizedExperiment}(object)

\S4method{gsvaAnnotation}{SummarizedExperiment,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{SingleCellExperiment}(object)

\S4method{gsvaAnnotation}{SingleCellExperiment,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{SpatialExperiment}(object)

\S4method{gsvaAnnotation}{SpatialExperiment,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{list}(object)

\S4method{gsvaAnnotation}{list,GeneIdentifierType}(object) <- value

\S4method{gsvaAnnotation}{GeneSetCollection}(object)
}
\arguments{
\item{object}{An expression data object of one of the classes described in
\code{\linkS4class{GsvaExprData}}.  Simple \code{matrix} and \code{dgCMatrix} objects are not
capable of storing annotation metadata and will return \code{NULL}.}

\item{value}{For the replacement methods, the annotation metadata to be
stored in the object.  For \code{\linkS4class{ExpressionSet}} objects, this must be a
character of length 1 specifying the name of the annotation database to be
used.  For \code{\linkS4class{SummarizedExperiment}} and its subclasses, this must be
a \code{\link{GeneIdentifierType}} created by one of the constructors from package
\code{GSEABase} where the \code{annotation} argument is typically the name of an
organism or annotation database, e.g. \code{org.Hs.eg.db}.  Simple \code{matrix} and
\code{dgCMatrix} objects are not capable of storing annotation metadata and the
attempt to do so will result in an error.}
}
\value{
For the retrieval methods, the annotation metadata stored in the
object of \code{NULL}.  For the replacement methods, the updated object.
}
\description{
Methods for storing and retrieving annotation metadata in
expression data objects that support it.  If gene sets and expression data
are using different but known gene identifier types and an appropriate
annotation database is available, gene set identifiers can be mapped to
expression data identifiers without manual user intervention, e.g. from
an MSigDb gene set using ENTREZ IDs or gene symbols to an expression data
set using ENSEMBL IDs.
}
