% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\docType{package}
\name{DESeq2-package}
\alias{DESeq2}
\alias{DESeq2-package}
\title{DESeq2 package for differential analysis of count data}
\description{
The DESeq2 package is designed for normalization,
visualization, and differential analysis of high-dimensional
count data. It makes use of empirical Bayes techniques
to estimate priors for log fold change and dispersion, and
to calculate posterior estimates for these quantities.
}
\details{
The main functions are:

\itemize{
\item \code{\link{DESeqDataSet}} - build the dataset, see tximeta & tximport packages for preparing input
\item \code{\link{DESeq}} - perform differential analysis
\item \code{\link{results}} - build a results table
\item \code{\link{lfcShrink}} - estimate shrunken LFC (posterior estimates) using apeglm & ashr pakges
\item \code{\link{vst}} - apply variance stabilizing transformation, e.g. for PCA or sample clustering
\item Plots, e.g.: \code{\link{plotPCA}}, \code{\link{plotMA}}, \code{\link{plotCounts}}
}

For detailed information on usage, see the package vignette, by typing
\code{vignette("DESeq2")}, or the workflow linked to on the first page
of the vignette.

All software-related questions should be posted to the Bioconductor Support Site:

\url{https://support.bioconductor.org}

The code can be viewed at the GitHub repository,
which also lists the contributor code of conduct:

\url{https://github.com/mikelove/tximport}
}
\references{
Love, M.I., Huber, W., Anders, S. (2014)
Moderated estimation of fold change and dispersion
for RNA-seq data with DESeq2. Genome Biology, 15:550.
\url{https://doi.org/10.1186/s13059-014-0550-8}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/thelovelab/DESeq2}
}

}
\author{
Michael Love, Wolfgang Huber, Simon Anders
}
\keyword{package}
