//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/10/18.
//

#ifndef UOS_RECOVERY_SYS_RESTORE_WIDGET_V20_H
#define UOS_RECOVERY_SYS_RESTORE_WIDGET_V20_H

#include <QWidget>
#include <dfilechooseredit.h>
#include <DTipLabel>
#include <DLabel>
#include "utils/Utils.h"
#include "utils/global.h"

class QLabel;
class QPushButton;
class RadioItem;
class QCheckBox;
class BaseTableTreeView;
class TreeViewModel;
class SettingsGroup;
class QFileDialog;

class SysRestoreWidgetV20 : public QWidget {
    Q_OBJECT
public:
    explicit SysRestoreWidgetV20(QWidget *parent = nullptr);
    void initUI();
    void initDFileChooserEdit();

    void setTipsVisible(const bool &visible);
    void setFileDialog(QFileDialog *fileDialog);
    void addTitleLabel();
    //专用设备只保留系统还原功能，其他全部删除
    void setDevicePage();
    void doSuccess();
    void doError(int errCode);
    void cancelRestoreSuccess();
    void setEnableInHighSysLevelMode(bool enable);
    void showHistoryBackup();
    void setTipsLabelText(const QString &msg);

protected:
    void showEvent(QShowEvent *event) override;
    void resizeEvent(QResizeEvent *event) override;
    void setColumnWidth();
    void processTreeViewListItem(TreeViewModel *model);

Q_SIGNALS:
    void requestSystemRestore(bool formatData) const;
    void requestManualRestore(const QString& directory) const;
    //void requestTreeViewListItem(TreeViewModel* model);
    void cancelRestore();

public Q_SLOTS:
    void onSystemRestoreItemVisibelChanged(bool value);
    void onRestoreButtonVisibleChanged(bool value);
    void onManualRestoreErrorChanged(ErrorType errorType);

private Q_SLOTS:
    void onItemChecked();
    void restore();

private:
//    enum class ActionType {
//        RestoreSystem,
//        ManualRestore,
//        CoverRestore
//    };

    bool isExistDim(const QString &path);

private:
    Dtk::Widget::DLabel *m_subTitle = nullptr;
    QCheckBox* m_saveUserDataCheckBox;
    Dtk::Widget::DFileChooserEdit* m_directoryChooseWidget;
    Dtk::Widget::DTipLabel* m_tipsLabel;
    QPushButton* m_backupBtn;
    RadioItem* m_systemRestore;
    RadioItem* m_manualRestore;
    RadioItem* m_coverRestore;
    QWidget *m_loadingWidget;
    BaseTableTreeView* m_treeView;
    TreeViewModel* m_treeViewModel;
    SettingsGroup* m_settingsGrp;
    ActionType m_actionType;
    QWidget *m_defaultWidget = nullptr;
    QWidget* bgWidget = nullptr;
};

#endif // UOS_RECOVERY_SYS_RESTORE_WIDGET_V20_H
