/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef X11_H
#define X11_H

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xcomposite.h>

class X11WindowSystem
{
public:
    X11WindowSystem();
    ~X11WindowSystem();

    Window getRootWindow() const;

    Atom parseAtom(const char* name, bool only_if_exists);
    const char* atomName(Atom atom);

    bool isViewableWindow(Window win);

    template <typename T>
    std::vector<T> getWindowProperty(Window window, const std::string &atomName,
                                     Atom atomType) const;

    Window getTopLevelWindow(Window window);
    std::vector<Window> getAllTopLevelWindows();
    std::pair<bool, Window> findTopLevelWindowInChildren(
        Window window, const std::vector<Window> &topLevelWindows) const;

    int execCmdToGetWindow(const char *cmd);

private:
    Display* m_display = NULL;
    std::vector<Window> m_topLevelWindows;

};
#endif // X11_H
