/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSPREFS_COMMON_H__
#define __UOSPREFS_COMMON_H__

#include "libsylph/prefs_common.h"
typedef PrefsCommon UosPrefsCommon;

#include "uosenums.h"
#include "uosprefs.h"

typedef RecvDialogMode UosRecvDialogMode;
#define UosRECV_DIALOG_ALWAYS RECV_DIALOG_ALWAYS
#define UosRECV_DIALOG_MANUAL RECV_DIALOG_MANUAL
#define UosRECV_DIALOG_NEVER RECV_DIALOG_NEVER

typedef TransferEncodingMethod UosTransferEncodingMethod;
#define UosCTE_AUTO CTE_AUTO
#define UosCTE_BASE64 CTE_BASE64
#define UosCTE_QUOTED_PRINTABLE CTE_QUOTED_PRINTABLE
#define UosCTE_8BIT CTE_8BIT

typedef MIMEFilenameEncodingMethod UosMIMEFilenameEncodingMethod;
#define UosFENC_MIME FENC_MIME
#define UosFENC_RFC2231 FENC_RFC2231
#define UosFENC_NONE FENC_NONE

UosPrefsCommon *uos_prefs_common_get		(void);

UosPrefParam *uos_prefs_common_get_params	(void);

void uos_prefs_common_read_config		(void);
void uos_prefs_common_write_config		(void);

void uos_prefs_common_junk_filter_list_set		(void);

void uos_prefs_common_junk_folder_rename_path	(const gchar	*old_path,
						 const gchar	*new_path);

#endif /* __UOSPREFS_COMMON_H__ */
