/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSHTML_H__
#define __UOSHTML_H__

#include "libsylph/html.h"

#include "uoscodeconv.h"

typedef HTMLState UosHTMLState;

typedef HTMLParser UosHTMLParser;
typedef HTMLAttr UosHTMLAttr;
typedef HTMLTag UosHTMLTag;

UosHTMLParser *uos_html_parser_new	(FILE		*fp,
                 UosCodeConverter	*conv);
void uos_html_parser_destroy	(UosHTMLParser	*parser);
const gchar *uos_html_parse		(UosHTMLParser	*parser);

#endif /* __UOSHTML_H__ */
