.TH CWEB 1 "28 October 2018" "Web2C @VERSION@"
.\"=====================================================================
.SH NAME
ctangle, cweave \- translate CWEB to C and/or TeX
.\"=====================================================================
.SH SYNOPSIS
.na
.B ctangle
.RB [ \-bhp ]
.RB [ +s ]
.IR webfile [ \fB.w\fP ]
.RI [{ changefile [ \fB.ch\fP ]| \fB\-\fP }
.RI [ outfile [ \fB.c\fP ]]]
.br
.B cweave
.RB [ \-befhpx ]
.RB [ +s ]
.IR webfile [ \fB.w\fP ]
.RI [{ changefile [ \fB.ch\fP ]| \fB\-\fP }
.RI [ outfile [ \fB.tex\fP ]]]
.ad
.\"=====================================================================
.SH DESCRIPTION
The
.B ctangle
program converts a CWEB
source document into a C\ program that may be compiled in the usual way.
The output file includes #line specifications so that debugging can be
done in terms of the CWEB source file.
.PP
The
.B cweave
program converts the same CWEB file into a TeX file that may be
formatted and printed in the usual way.
It takes appropriate care of typographic details like page
layout and the use of indentation, italics, boldface, etc., and it supplies
extensive cross-index information that it gathers automatically.
.PP
CWEB allows you to prepare a single
document containing all the information that is needed both to produce
a compilable C\ program and to produce a well-formatted document
describing the program in as much detail as the writer may desire.
The user of CWEB ought to be familiar with TeX as well as\ C.
.PP
The command line should have one, two, or three names on it.
The first is taken as the CWEB file (and
.B .w
is added if there is no extension).
If that file cannot be opened, the extension
.B .web
is tried instead. (But
.B .w
is recommended, since
.B .web
usually implies Pascal.)
If there is a second name, it is a change file (and
.B .ch
is added if there is no extension).
The change file overrides parts of the WEB file,
as described in the documentation.
If there is a third name, it overrides
the default name of the output file, which is ordinarily the same as
the name of the input file (but on the current directory) with the
extension
.B .c
or
.BR .tex .
.PP
Options in the command line may be either turned off with\ \-
(if they are on by default) or turned on with\ + (if they are off by
default).
In fact, the options are processed from left to right,
so a sequence like -f\ +f corresponds to +f (which is the default).
.PP
The
.B \-b
option suppresses the banner line that normally appears on your terminal
when ctangle or cweave begins.
The
.B \-h
option suppresses the happy message that normally appears if the processing
was successful.
The
.B \-p
option suppresses progress reports (starred module numbers) as the processing
takes place.
If you say
.BR \-bhp ,
you get nothing but error messages.
.PP
The
.B +s
option prints statistics about memory usage at the end of a run.
.PP
There are three other options applicable to
.B cweave
only:
.B \-f
means do not force a newline after every statement in the formatted output.
.B \-e
inhibits the enclosure of C\ material formatted by
.I cweave
in brackets
\ePB{.\|.\|.}.
Such brackets are normally inserted so that special hooks
can be used by
.I cweb-latex
and similar programs.
.B \-x
means omit the index and table of contents.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable CWEBINPUTS is used to search for the input files,
or the system default if CWEBINPUTS is not set.  See
.BR tex (1)
for the details of the searching.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I cwebmac.tex
TeX macros used by cweave output.
.TP
.I cwebman.tex
The user manual.
.\"=====================================================================
.SH "SEE ALSO"
.TP
.I Literate Programming
by D. E. Knuth.
.TP
.I Weaving a Program
by Wayne Sewell.
.TP
.I The CWEB System of Structured Documentation
by Donald E. Knuth and Silvio Levy (hardcopy version of cwebman.tex
and the source code listings).
.PP
.BR tex (1),
.BR cc (1).
.\"=====================================================================
.SH AUTHORS
Don Knuth wrote WEB for TeX and Pascal.
Silvio Levy designed and developed CWEB
by adapting the WEB conventions to\ C and by recoding everything in CWEB.
Knuth began using CWEB and made further refinements.
Many other helpers are acknowledged in the CWEB manual.

