" Vim color file
" Name:            frugal
" Maintainer:      Ralph Amissah <ralph@amissah.com>
" Last Change:     2013-02-09
" URL:             <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=data/sisu/conf/editor-syntax-etc/vim/colors/frugal.vim;hb=HEAD>
" Note:            8 color cterm, related colorschemes 8 & sparse
:set background=dark
:hi clear
if exists("syntax_on")
  syntax reset
endif
:let colors_name = "frugal"
" 0 = black, 1 = red, 2 = green, 3 = yellow/orange, 4 = blue, 5 = magenta, 6 = cyan, 7 = white
:hi Normal                                                           ctermbg=0          ctermfg=7                      guibg=black         guifg=white
:hi Cursor         term=reverse             cterm=reverse                                               gui=bold       guibg=white         guifg=black
:hi lCursor        term=reverse             cterm=reverse                                               gui=bold       guibg=white         guifg=black
:hi StatusLine     term=bold,reverse        cterm=bold,reverse                                          gui=bold,reverse
:hi StatusLineNC   term=reverse             cterm=reverse                                               gui=reverse
:hi Search         term=reverse                                      ctermbg=2                                                             guifg=green
:hi IncSearch      term=reverse             cterm=reverse                                               gui=reverse
:hi SpecialKey     term=bold                                                             ctermfg=4                                         guifg=blue
:hi Visual         term=reverse             cterm=reverse                                               gui=reverse
:hi VisualNOS      term=bold,underline      cterm=bold,underline                                        gui=bold,underline
:hi MoreMsg        term=bold                                                             ctermfg=2                                         guifg=green
:hi ModeMsg        term=bold                cterm=bold
:hi Question       term=standout                                                         ctermfg=2                                         guifg=green
:hi Title          term=bold                                                             ctermfg=1                                         guifg=red
:hi NonText        term=bold                cterm=bold                                   ctermfg=4                                         guifg=blue
:hi LineNr         term=underline           cterm=bold               ctermbg=0           ctermfg=0*     gui=bold       guibg=black         guifg=grey
:hi Directory      term=bold                                                             ctermfg=4                                         guifg=blue
:hi WildMenu       term=standout                                     ctermbg=3           ctermfg=0                     guibg=yellow        guifg=black
:hi VertSplit      term=reverse             cterm=reverse                                               gui=reverse
:hi Folded         term=standout            cterm=none               ctermbg=0           ctermfg=7      gui=none       guibg=black         guifg=white
:hi FoldColumn     term=standout                                     ctermbg=7           ctermfg=4
:hi DiffChange                              cterm=none               ctermbg=7           ctermfg=0      gui=none       guibg=white         guifg=black
:hi DiffText                                cterm=none               ctermbg=6           ctermfg=0      gui=none       guibg=magenta       guifg=black
:hi DiffAdd                                 cterm=none               ctermbg=2           ctermfg=0      gui=none       guibg=green         guifg=black
:hi DiffDelete                              cterm=none               ctermbg=7           ctermfg=0      gui=none       guibg=white         guifg=black
:hi String                                  cterm=none                                   ctermfg=3      gui=none                           guifg=yellow
:hi Comment                                 cterm=none               ctermbg=0           ctermfg=4      gui=bold       guibg=black         guifg=grey
:hi Constant       term=underline                                                        ctermfg=1                                         guifg=red
:hi Special        term=bold                                                             ctermfg=3                                         guifg=yellow
:hi Identifier     term=underline           cterm=none                                   ctermfg=6      gui=none                           guifg=magenta
:hi Statement      term=bold                cterm=none                                   ctermfg=2      gui=none                           guifg=green
":hi Operator       term=bold                                                             ctermfg=1                                         guifg=red
:hi PreProc        term=underline                                                        ctermfg=1                                         guifg=red
:hi Type           term=underline           cterm=bold                                   ctermfg=3      gui=bold                           guifg=yellow
:hi Delimiter                               cterm=none                                   ctermfg=2      gui=none                           guifg=green
:hi Ignore                                  cterm=bold                                   ctermfg=7      gui=bold                           guifg=white
:hi Todo           term=standout                                     ctermbg=3           ctermfg=0                     guibg=yellow        guifg=black
:hi Underlined     term=underline           cterm=underline                                             gui=underline
":hi Include                                                                              ctermfg=1                                         guifg=red
":hi Define                                                                               ctermfg=3                                         guifg=yellow
":hi Function                                                                             ctermfg=6                                         guifg=magenta
":hi Structure                                                                            ctermfg=2                                         guifg=green
:hi MatchParen                              cterm=bold               ctermbg=4           ctermfg=7
:hi CursorLine                              cterm=bold,underline
:hi CursorColumn                            cterm=bold
:hi ColorColumn                                                      ctermbg=8
:hi SpellBad       term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=white         guifg=black
:hi SpellCap       term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=white         guifg=black
:hi SpellLocal     term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=white         guifg=black
:hi SpellRare      term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=white         guifg=black
:hi WarningMsg     term=standout                                                         ctermfg=1                                         guifg=red
:hi ErrorMsg       term=standout            cterm=bold               ctermbg=1           ctermfg=7      gui=bold       guibg=red           guifg=white
:hi Error          term=reverse             cterm=bold               ctermbg=1           ctermfg=7      gui=bold       guibg=red           guifg=white
