#ifndef _FACEANTISPOOFING_H_
#define _FACEANTISPOOFING_H_

#include "seeta/Common/Struct.h"

#include <string>
#include <vector>


namespace seeta
{
    namespace v6
    {

        class FaceAntiSpoofing {
        public:
            /*
             * ʶ״̬
             */
            enum Status
            {
                REAL = 0,   ///< ʵ
                SPOOF = 1,  ///< 
                FUZZY = 2,  ///< ޷жϣã
                DETECTING = 3,  ///< ڼ
            };

            enum Property {
                PROPERTY_NUMBER_THREADS = 4,
                PROPERTY_ARM_CPU_MODE = 5
            };


            /**
             * \brief ģļ
             * \param setting ģļ, 0-ֲļѡ1-ȫֻļѡ
             */
            SEETA_API explicit FaceAntiSpoofing( const seeta::ModelSetting &setting );
            SEETA_API ~FaceAntiSpoofing();


            /**
             * \brief 
             * \param [in] image ͼҪ RGB ɫͨ
             * \param [in] face Ҫʶλ
             * \param [in] points Ҫʶ
             * \return ״̬ @see Status
             * \note ˺̵ֶ֧߳ãڶ̻߳ҪӦ FaceAntiSpoofing Ķֱü⺯
             * \note ǰ汾ܷ REAL, SPOOF, FUZZY
             * \see SeetaImageData, SeetaRect, PointF, Status
             */
            SEETA_API Status Predict( const SeetaImageData &image, const SeetaRect &face, const SeetaPointF *points ) const;

            /**
            * \brief 壨Videoģʽ
            * \param [in] image ͼҪ RGB ɫͨ
            * \param [in] face Ҫʶλ
            * \param [in] points Ҫʶ
            * \return ״̬ @see Status
            * \note ˺̵ֶ֧߳ãڶ̻߳ҪӦ FaceAntiSpoofing Ķֱü⺯
            * \note Ҫ֡УҪһƵǣҪ ResetVideo ü״̬
            * \note ǰ汾ܷ REAL, SPOOF, DETECTION
            * \see SeetaImageData, SeetaRect, PointF, Status
            */
            SEETA_API Status PredictVideo( const SeetaImageData &image, const SeetaRect &face, const SeetaPointF *points ) const;

            /**
             * \brief  Videoʼһ PredictVideo ʶ
             */
            SEETA_API void ResetVideo();

            /**
             * \brief ȡڲ
             * \param [out] clarity 
             * \param [out] reality ʵ
             * \note ȡһε Predict  PredictVideo ӿںڲֵ
             */
            SEETA_API void GetPreFrameScore( float *clarity = nullptr, float *reality = nullptr );

            /**
             *  Video ģʽУʶƵ֡֡ΪֵԺŻзֵ
             * \param [in] number Ƶ֡
             */
            SEETA_API void SetVideoFrameCount( int32_t number );

            /**
             * \return ȡƵ֡
             */
            SEETA_API int32_t GetVideoFrameCount() const;

            /**
             * ֵ
             * \param [in] clarity ֵ
             * \param [in] reality ֵ
             * \note clarity ԽҪͼԽߣreality Խ߶ʶҪԽϸ
             * \note ĬֵΪ 0.3, 0.8
             */
            SEETA_API void SetThreshold( float clarity, float reality );
			
			 /**
             * ȫֵ
             * \param [in] box_thresh ȫֵּ
             * \note ĬֵΪ 0.8
             */
			 SEETA_API void SetBoxThresh(float box_thresh);
			 
			 SEETA_API float GetBoxThresh()const;

            /**
             * ȡֵ
             * \param [out] clarity ֵ
             * \param [out] reality ֵ
             */
            SEETA_API void GetThreshold( float *clarity = nullptr, float *reality = nullptr ) const;

            SEETA_API void set(Property property, double value);

            SEETA_API double get(Property property) const;
        private:
            FaceAntiSpoofing( const FaceAntiSpoofing & ) = delete;
            const FaceAntiSpoofing &operator=( const FaceAntiSpoofing & ) = delete;

        private:
            class Implement;
            Implement *m_impl;
        };
    }
    using namespace v6;
}

#endif
