# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SubProtectionPolicy(Model):
    """Sub-protection policy which includes schedule and retention.

    :param policy_type: Type of backup policy type
    :type policy_type: str
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _attribute_map = {
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(SubProtectionPolicy, self).__init__(**kwargs)
        self.policy_type = kwargs.get('policy_type', None)
        self.schedule_policy = kwargs.get('schedule_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)
