/*   PLAST : Parallel Local Alignment Search Tool                            *
 *   Version 2.3, released November 2015                                     *
 *   Copyright (c) 2009-2015 Inria-Cnrs-Ens                                  *
 *                                                                           *
 *   PLAST is free software; you can redistribute it and/or modify it under  *
 *   the Affero GPL ver 3 License, that is compatible with the GNU General   *
 *   Public License                                                          *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
 *   Affero GPL ver 3 License for more details.                              *
 *****************************************************************************/

/** \file DatabaseVisitorComment.hpp
 *  \brief Definition of a database sequence visitor
 *  \date 03/06/2014
 *  \author sbrillet

 */

#ifndef _DATABASE_VISITOR_HPP_
#define _DATABASE_VISITOR_HPP_

#include <database/impl/BufferedSequenceDatabase.hpp>

/********************************************************************************/
/** \brief Definition of concepts related to genomic databases. */
namespace database {
/** \brief Implementation of concepts related to genomic databases. */
namespace impl {
class DatabaseVisitorComment : public DatabaseVisitor
{
public:
	DatabaseVisitorComment(const ISequence& seq, std::string &str) :_result(str),_sequence(seq)
	{
	}

	void visitBufferedSequenceDatabase  (BufferedSequenceDatabase& db) {
		_result = db._refIterator->transformComment(_sequence.comment);
	}
	void visitCompositeSequenceDatabase (CompositeSequenceDatabase& db) {
		_result="CompositeSequenceDatabase";}
protected:
	std::string &_result;
	const ISequence& _sequence;

};
}
}
#endif /*  _DATABASE_VISITOR_HPP_ */
