---
title: Pitivi
...

# Pitivi development website

This is the documentation for **planning/contributing** to [Pitivi], the
Free and Open Source video editor based on GStreamer. If you're looking
for documentation on how to *use* Pitivi, check out our [User's Manual]
(also available directly inside the application)!

To edit the website edit the markdown files in our git repo in the
`docs/` and follow our [developer instructions].

  [Pitivi]: http://www.pitivi.org
  [User's Manual]: http://pitivi.org/manual/
  [developer instructions]: HACKING.md

# Contributors' documentation

See the [Developer documentation](HACKING.md) section
page for a complete listing of documentation aimed at contributing to
Pitivi. Here is a small overview/some starting points taken from that
category:

-   [Easy and fun projects](Pitivi_Love.md) for new contributors
-   [Roadmap](Roadmap.md) (long-term plans)
-   [Architecture](Architecture.md): where does Pitivi fit? What
    are all those components?
-   [Brainstorming](design.md) (UI mockups and “future” features only!)

See also the [Contributing](http://www.pitivi.org/?go=contributing) page
on the website (includes a “Why contribute to Pitivi?” section).

## Tools to help you get started

-   [Git](Git.md)
-   [Setup development environment](HACKING.md) (official and
    easiest way to get your testing/development environment running,
    with pre-built dependencies)
-   The [test suite](Testing.md) (outdated)

## Ways to communicate

-   [Reporting bugs](Bug_reporting.md)
-   IRC: [\#pitivi](irc://irc.freenode.net/pitivi) on irc.freenode.net
-   Our [Google+ page](https://plus.google.com/+pitivi) or
    [Twitter](https://twitter.com/pitivi) account. Do *not* report bugs
    there, use our bug tracker instead!
-   [The people](The_people.md) (who does what)

# Random stuff

-   [Goals](Goals.md) (mission statement, vision)
-   [Project history](Project_history.md) - rumors of our death
    have been greatly exaggerated... :)
-   [Current events](Current_events.md) - releases, meetings,
    talks ... See also the [planet](http://www.pitivi.org/planet) for
    news about the project.
-   [Why Python?](design/Why_python.md)
-   [Praise](Praise.md) - a page to list some of the praises and
    positive comments we received
-   [Google Summer of Code](Google_Summer_of_Code.md)

# Pages that need to be reworked/deleted

The pages in these categories need to be reworked. Help is welcome!
Also, feel free to tag pages with these categories should you find that
a page is woefully incomplete or outdated:

-   [Probably obsolete](attic.md)
