Description: fix denial of service attack
 OpenBSD 6.6 errata 018, January 30, 2020:
 .
 smtpd can crash on opportunistic TLS downgrade, causing a denial of service.
Origin: https://ftp.openbsd.org/pub/OpenBSD/patches/6.6/common/018_smtpd_tls.patch.sig
Bug-Debian: https://bugs.debian.org/950121
---
This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
Index: opensmtpd/smtpd/mta_session.c
===================================================================
--- opensmtpd.orig/smtpd/mta_session.c	2020-01-28 17:56:07.336180890 -0500
+++ opensmtpd/smtpd/mta_session.c	2020-01-28 17:56:07.336180890 -0500
@@ -1292,40 +1292,20 @@
 		break;
 
 	case IO_ERROR:
+	case IO_TLSERROR:
 		log_debug("debug: mta: %p: IO error: %s", s, io_error(io));
-		if (!s->ready) {
-			mta_error(s, "IO Error: %s", io_error(io));
-			mta_connect(s);
-			break;
-		}
-		else if (!(s->flags & (MTA_FORCE_TLS|MTA_FORCE_SMTPS|MTA_FORCE_ANYSSL))) {
-			/* error in non-strict SSL negotiation, downgrade to plain */
-			if (s->flags & MTA_TLS) {
-				log_info("smtp-out: Error on session %016"PRIx64
-				    ": opportunistic TLS failed, "
-				    "downgrading to plain", s->id);
-				s->flags &= ~MTA_TLS;
-				s->flags |= MTA_DOWNGRADE_PLAIN;
-				mta_connect(s);
-				break;
-			}
-		}
-		mta_error(s, "IO Error: %s", io_error(io));
-		mta_free(s);
-		break;
 
-	case IO_TLSERROR:
-		log_debug("debug: mta: %p: TLS IO error: %s", s, io_error(io));
-		if (!(s->flags & (MTA_FORCE_TLS|MTA_FORCE_SMTPS|MTA_FORCE_ANYSSL))) {
+		if (s->state == MTA_STARTTLS && s->use_smtp_tls) {
 			/* error in non-strict SSL negotiation, downgrade to plain */
-			log_info("smtp-out: TLS Error on session %016"PRIx64
-			    ": TLS failed, "
+			log_info("smtp-out: Error on session %016"PRIx64
+			    ": opportunistic TLS failed, "
 			    "downgrading to plain", s->id);
 			s->flags &= ~MTA_TLS;
 			s->flags |= MTA_DOWNGRADE_PLAIN;
 			mta_connect(s);
 			break;
 		}
+
 		mta_error(s, "IO Error: %s", io_error(io));
 		mta_free(s);
 		break;
