/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/DocXml/SchemaTypesXml/ClassCardinalityXml.h"
#include "Doc/SchemaTypesDoc/SchemaTypesDocTypes.h"

#include "Doc/SchemaTypesDoc/CClassCardinalityDoc.h"
#include "Doc/SchemaTypesDoc/CRelationshipDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/RelationshipXml.h"

using namespace Caf;

void RelationshipXml::add(
	const SmartPtrCRelationshipDoc relationshipDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RelationshipXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(relationshipDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string namespaceValVal = relationshipDoc->getNamespaceVal();
		CAF_CM_VALIDATE_STRING(namespaceValVal);
		thisXml->addAttribute("namespace", namespaceValVal);

		const std::string nameVal = relationshipDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string versionVal = relationshipDoc->getVersion();
		CAF_CM_VALIDATE_STRING(versionVal);
		thisXml->addAttribute("version", versionVal);

		const std::string arityVal =
			EnumConvertersXml::convertArityTypeToString(relationshipDoc->getArity());
		CAF_CM_VALIDATE_STRING(arityVal);
		thisXml->addAttribute("arity", arityVal);

		const SmartPtrCClassCardinalityDoc dataClassLeftVal =
			relationshipDoc->getDataClassLeft();
		CAF_CM_VALIDATE_SMARTPTR(dataClassLeftVal);

		const SmartPtrCXmlElement dataClassLeftXml =
			thisXml->createAndAddElement("dataClassLeft");
		ClassCardinalityXml::add(dataClassLeftVal, dataClassLeftXml);

		const SmartPtrCClassCardinalityDoc dataClassRightVal =
			relationshipDoc->getDataClassRight();
		CAF_CM_VALIDATE_SMARTPTR(dataClassRightVal);

		const SmartPtrCXmlElement dataClassRightXml =
			thisXml->createAndAddElement("dataClassRight");
		ClassCardinalityXml::add(dataClassRightVal, dataClassRightXml);

		const std::string descriptionVal = relationshipDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCRelationshipDoc RelationshipXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RelationshipXml", "parse");

	SmartPtrCRelationshipDoc relationshipDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string namespaceValStrVal =
			thisXml->findRequiredAttribute("namespace");
		const std::string namespaceValVal = namespaceValStrVal;

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string versionStrVal =
			thisXml->findRequiredAttribute("version");
		const std::string versionVal = versionStrVal;

		const std::string arityStrVal =
			thisXml->findRequiredAttribute("arity");
		ARITY_TYPE arityVal = ARITY_NONE;
		if (! arityStrVal.empty()) {
			arityVal = EnumConvertersXml::convertStringToArityType(arityStrVal);
		}

		const SmartPtrCXmlElement dataClassLeftXml =
			thisXml->findRequiredChild("dataClassLeft");

		SmartPtrCClassCardinalityDoc dataClassLeftVal;
		if (! dataClassLeftXml.IsNull()) {
			dataClassLeftVal = ClassCardinalityXml::parse(dataClassLeftXml);
		}

		const SmartPtrCXmlElement dataClassRightXml =
			thisXml->findRequiredChild("dataClassRight");

		SmartPtrCClassCardinalityDoc dataClassRightVal;
		if (! dataClassRightXml.IsNull()) {
			dataClassRightVal = ClassCardinalityXml::parse(dataClassRightXml);
		}

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		relationshipDoc.CreateInstance();
		relationshipDoc->initialize(
			namespaceValVal,
			nameVal,
			versionVal,
			arityVal,
			dataClassLeftVal,
			dataClassRightVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return relationshipDoc;
}

