"use strict";

var helpers = require("../../helpers/helpers");

exports["Europe/Vienna"] = {

	"guess:by:offset" : helpers.makeTestGuess("Europe/Vienna", { offset: true, expect: "Europe/Paris" }),

	"guess:by:abbr" : helpers.makeTestGuess("Europe/Vienna", { abbr: true, expect: "Europe/Paris" }),

	"1916" : helpers.makeTestYear("Europe/Vienna", [
		["1916-04-30T21:59:59+00:00", "22:59:59", "CET", -60],
		["1916-04-30T22:00:00+00:00", "00:00:00", "CEST", -120],
		["1916-09-30T22:59:59+00:00", "00:59:59", "CEST", -120],
		["1916-09-30T23:00:00+00:00", "00:00:00", "CET", -60]
	]),

	"1917" : helpers.makeTestYear("Europe/Vienna", [
		["1917-04-16T00:59:59+00:00", "01:59:59", "CET", -60],
		["1917-04-16T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1917-09-17T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1917-09-17T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1918" : helpers.makeTestYear("Europe/Vienna", [
		["1918-04-15T00:59:59+00:00", "01:59:59", "CET", -60],
		["1918-04-15T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1918-09-16T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1918-09-16T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1920" : helpers.makeTestYear("Europe/Vienna", [
		["1920-04-05T00:59:59+00:00", "01:59:59", "CET", -60],
		["1920-04-05T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1920-09-13T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1920-09-13T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1940" : helpers.makeTestYear("Europe/Vienna", [
		["1940-04-01T00:59:59+00:00", "01:59:59", "CET", -60],
		["1940-04-01T01:00:00+00:00", "03:00:00", "CEST", -120]
	]),

	"1942" : helpers.makeTestYear("Europe/Vienna", [
		["1942-11-02T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1942-11-02T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1943" : helpers.makeTestYear("Europe/Vienna", [
		["1943-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1943-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1943-10-04T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1943-10-04T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1944" : helpers.makeTestYear("Europe/Vienna", [
		["1944-04-03T00:59:59+00:00", "01:59:59", "CET", -60],
		["1944-04-03T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1944-10-02T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1944-10-02T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1945" : helpers.makeTestYear("Europe/Vienna", [
		["1945-04-02T00:59:59+00:00", "01:59:59", "CET", -60],
		["1945-04-02T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1945-04-12T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1945-04-12T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1946" : helpers.makeTestYear("Europe/Vienna", [
		["1946-04-14T00:59:59+00:00", "01:59:59", "CET", -60],
		["1946-04-14T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1946-10-06T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1946-10-06T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1947" : helpers.makeTestYear("Europe/Vienna", [
		["1947-04-06T00:59:59+00:00", "01:59:59", "CET", -60],
		["1947-04-06T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1947-10-05T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1947-10-05T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1948" : helpers.makeTestYear("Europe/Vienna", [
		["1948-04-18T00:59:59+00:00", "01:59:59", "CET", -60],
		["1948-04-18T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1948-10-03T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1948-10-03T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1980" : helpers.makeTestYear("Europe/Vienna", [
		["1980-04-05T22:59:59+00:00", "23:59:59", "CET", -60],
		["1980-04-05T23:00:00+00:00", "01:00:00", "CEST", -120],
		["1980-09-27T21:59:59+00:00", "23:59:59", "CEST", -120],
		["1980-09-27T22:00:00+00:00", "23:00:00", "CET", -60]
	]),

	"1981" : helpers.makeTestYear("Europe/Vienna", [
		["1981-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1981-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1981-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1981-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1982" : helpers.makeTestYear("Europe/Vienna", [
		["1982-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1982-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1982-09-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1982-09-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1983" : helpers.makeTestYear("Europe/Vienna", [
		["1983-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1983-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1983-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1983-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1984" : helpers.makeTestYear("Europe/Vienna", [
		["1984-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["1984-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1984-09-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1984-09-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1985" : helpers.makeTestYear("Europe/Vienna", [
		["1985-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1985-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1985-09-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1985-09-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1986" : helpers.makeTestYear("Europe/Vienna", [
		["1986-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["1986-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1986-09-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1986-09-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1987" : helpers.makeTestYear("Europe/Vienna", [
		["1987-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1987-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1987-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1987-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1988" : helpers.makeTestYear("Europe/Vienna", [
		["1988-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1988-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1988-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1988-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1989" : helpers.makeTestYear("Europe/Vienna", [
		["1989-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["1989-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1989-09-24T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1989-09-24T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1990" : helpers.makeTestYear("Europe/Vienna", [
		["1990-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["1990-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1990-09-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1990-09-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1991" : helpers.makeTestYear("Europe/Vienna", [
		["1991-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1991-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1991-09-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1991-09-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1992" : helpers.makeTestYear("Europe/Vienna", [
		["1992-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1992-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1992-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1992-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1993" : helpers.makeTestYear("Europe/Vienna", [
		["1993-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1993-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1993-09-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1993-09-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1994" : helpers.makeTestYear("Europe/Vienna", [
		["1994-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1994-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1994-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1994-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1995" : helpers.makeTestYear("Europe/Vienna", [
		["1995-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["1995-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1995-09-24T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1995-09-24T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1996" : helpers.makeTestYear("Europe/Vienna", [
		["1996-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1996-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1996-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1996-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1997" : helpers.makeTestYear("Europe/Vienna", [
		["1997-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["1997-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1997-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1997-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1998" : helpers.makeTestYear("Europe/Vienna", [
		["1998-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1998-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1998-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1998-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1999" : helpers.makeTestYear("Europe/Vienna", [
		["1999-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1999-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1999-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1999-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2000" : helpers.makeTestYear("Europe/Vienna", [
		["2000-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2000-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2000-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2000-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2001" : helpers.makeTestYear("Europe/Vienna", [
		["2001-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2001-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2001-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2001-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2002" : helpers.makeTestYear("Europe/Vienna", [
		["2002-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2002-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2002-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2002-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2003" : helpers.makeTestYear("Europe/Vienna", [
		["2003-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2003-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2003-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2003-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2004" : helpers.makeTestYear("Europe/Vienna", [
		["2004-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2004-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2004-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2004-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2005" : helpers.makeTestYear("Europe/Vienna", [
		["2005-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2005-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2005-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2005-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2006" : helpers.makeTestYear("Europe/Vienna", [
		["2006-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2006-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2006-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2006-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2007" : helpers.makeTestYear("Europe/Vienna", [
		["2007-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2007-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2007-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2007-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2008" : helpers.makeTestYear("Europe/Vienna", [
		["2008-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2008-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2008-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2008-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2009" : helpers.makeTestYear("Europe/Vienna", [
		["2009-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2009-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2009-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2009-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2010" : helpers.makeTestYear("Europe/Vienna", [
		["2010-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2010-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2010-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2010-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2011" : helpers.makeTestYear("Europe/Vienna", [
		["2011-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2011-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2011-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2011-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2012" : helpers.makeTestYear("Europe/Vienna", [
		["2012-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2012-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2012-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2012-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2013" : helpers.makeTestYear("Europe/Vienna", [
		["2013-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2013-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2013-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2013-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2014" : helpers.makeTestYear("Europe/Vienna", [
		["2014-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2014-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2014-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2014-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2015" : helpers.makeTestYear("Europe/Vienna", [
		["2015-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2015-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2015-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2015-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2016" : helpers.makeTestYear("Europe/Vienna", [
		["2016-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2016-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2016-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2016-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2017" : helpers.makeTestYear("Europe/Vienna", [
		["2017-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2017-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2017-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2017-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2018" : helpers.makeTestYear("Europe/Vienna", [
		["2018-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2018-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2018-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2018-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2019" : helpers.makeTestYear("Europe/Vienna", [
		["2019-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2019-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2019-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2019-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2020" : helpers.makeTestYear("Europe/Vienna", [
		["2020-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2020-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2020-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2020-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2021" : helpers.makeTestYear("Europe/Vienna", [
		["2021-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2021-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2021-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2021-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2022" : helpers.makeTestYear("Europe/Vienna", [
		["2022-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2022-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2022-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2022-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2023" : helpers.makeTestYear("Europe/Vienna", [
		["2023-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2023-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2023-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2023-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2024" : helpers.makeTestYear("Europe/Vienna", [
		["2024-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2024-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2024-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2024-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2025" : helpers.makeTestYear("Europe/Vienna", [
		["2025-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2025-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2025-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2025-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2026" : helpers.makeTestYear("Europe/Vienna", [
		["2026-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2026-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2026-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2026-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2027" : helpers.makeTestYear("Europe/Vienna", [
		["2027-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2027-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2027-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2027-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2028" : helpers.makeTestYear("Europe/Vienna", [
		["2028-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2028-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2028-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2028-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2029" : helpers.makeTestYear("Europe/Vienna", [
		["2029-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2029-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2029-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2029-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2030" : helpers.makeTestYear("Europe/Vienna", [
		["2030-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2030-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2030-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2030-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2031" : helpers.makeTestYear("Europe/Vienna", [
		["2031-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2031-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2031-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2031-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2032" : helpers.makeTestYear("Europe/Vienna", [
		["2032-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2032-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2032-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2032-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2033" : helpers.makeTestYear("Europe/Vienna", [
		["2033-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2033-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2033-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2033-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2034" : helpers.makeTestYear("Europe/Vienna", [
		["2034-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2034-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2034-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2034-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2035" : helpers.makeTestYear("Europe/Vienna", [
		["2035-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2035-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2035-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2035-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2036" : helpers.makeTestYear("Europe/Vienna", [
		["2036-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2036-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2036-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2036-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2037" : helpers.makeTestYear("Europe/Vienna", [
		["2037-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2037-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2037-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2037-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2038" : helpers.makeTestYear("Europe/Vienna", [
		["2038-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2038-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2038-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2038-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2039" : helpers.makeTestYear("Europe/Vienna", [
		["2039-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2039-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2039-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2039-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2040" : helpers.makeTestYear("Europe/Vienna", [
		["2040-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2040-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2040-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2040-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2041" : helpers.makeTestYear("Europe/Vienna", [
		["2041-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2041-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2041-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2041-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2042" : helpers.makeTestYear("Europe/Vienna", [
		["2042-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2042-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2042-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2042-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2043" : helpers.makeTestYear("Europe/Vienna", [
		["2043-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2043-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2043-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2043-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2044" : helpers.makeTestYear("Europe/Vienna", [
		["2044-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2044-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2044-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2044-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2045" : helpers.makeTestYear("Europe/Vienna", [
		["2045-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2045-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2045-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2045-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2046" : helpers.makeTestYear("Europe/Vienna", [
		["2046-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2046-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2046-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2046-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2047" : helpers.makeTestYear("Europe/Vienna", [
		["2047-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2047-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2047-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2047-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2048" : helpers.makeTestYear("Europe/Vienna", [
		["2048-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2048-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2048-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2048-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2049" : helpers.makeTestYear("Europe/Vienna", [
		["2049-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2049-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2049-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2049-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2050" : helpers.makeTestYear("Europe/Vienna", [
		["2050-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2050-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2050-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2050-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2051" : helpers.makeTestYear("Europe/Vienna", [
		["2051-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2051-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2051-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2051-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2052" : helpers.makeTestYear("Europe/Vienna", [
		["2052-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2052-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2052-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2052-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2053" : helpers.makeTestYear("Europe/Vienna", [
		["2053-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2053-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2053-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2053-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2054" : helpers.makeTestYear("Europe/Vienna", [
		["2054-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2054-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2054-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2054-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2055" : helpers.makeTestYear("Europe/Vienna", [
		["2055-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2055-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2055-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2055-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2056" : helpers.makeTestYear("Europe/Vienna", [
		["2056-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2056-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2056-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2056-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2057" : helpers.makeTestYear("Europe/Vienna", [
		["2057-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2057-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2057-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2057-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2058" : helpers.makeTestYear("Europe/Vienna", [
		["2058-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2058-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2058-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2058-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2059" : helpers.makeTestYear("Europe/Vienna", [
		["2059-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2059-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2059-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2059-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2060" : helpers.makeTestYear("Europe/Vienna", [
		["2060-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2060-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2060-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2060-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2061" : helpers.makeTestYear("Europe/Vienna", [
		["2061-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2061-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2061-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2061-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2062" : helpers.makeTestYear("Europe/Vienna", [
		["2062-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2062-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2062-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2062-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2063" : helpers.makeTestYear("Europe/Vienna", [
		["2063-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2063-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2063-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2063-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2064" : helpers.makeTestYear("Europe/Vienna", [
		["2064-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2064-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2064-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2064-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2065" : helpers.makeTestYear("Europe/Vienna", [
		["2065-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2065-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2065-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2065-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2066" : helpers.makeTestYear("Europe/Vienna", [
		["2066-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2066-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2066-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2066-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2067" : helpers.makeTestYear("Europe/Vienna", [
		["2067-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2067-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2067-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2067-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2068" : helpers.makeTestYear("Europe/Vienna", [
		["2068-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2068-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2068-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2068-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2069" : helpers.makeTestYear("Europe/Vienna", [
		["2069-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2069-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2069-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2069-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2070" : helpers.makeTestYear("Europe/Vienna", [
		["2070-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2070-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2070-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2070-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2071" : helpers.makeTestYear("Europe/Vienna", [
		["2071-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2071-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2071-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2071-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2072" : helpers.makeTestYear("Europe/Vienna", [
		["2072-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2072-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2072-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2072-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2073" : helpers.makeTestYear("Europe/Vienna", [
		["2073-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2073-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2073-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2073-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2074" : helpers.makeTestYear("Europe/Vienna", [
		["2074-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2074-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2074-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2074-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2075" : helpers.makeTestYear("Europe/Vienna", [
		["2075-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2075-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2075-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2075-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2076" : helpers.makeTestYear("Europe/Vienna", [
		["2076-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2076-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2076-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2076-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2077" : helpers.makeTestYear("Europe/Vienna", [
		["2077-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2077-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2077-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2077-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2078" : helpers.makeTestYear("Europe/Vienna", [
		["2078-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2078-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2078-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2078-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2079" : helpers.makeTestYear("Europe/Vienna", [
		["2079-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2079-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2079-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2079-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2080" : helpers.makeTestYear("Europe/Vienna", [
		["2080-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2080-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2080-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2080-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2081" : helpers.makeTestYear("Europe/Vienna", [
		["2081-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2081-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2081-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2081-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2082" : helpers.makeTestYear("Europe/Vienna", [
		["2082-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2082-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2082-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2082-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2083" : helpers.makeTestYear("Europe/Vienna", [
		["2083-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2083-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2083-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2083-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2084" : helpers.makeTestYear("Europe/Vienna", [
		["2084-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2084-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2084-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2084-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2085" : helpers.makeTestYear("Europe/Vienna", [
		["2085-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2085-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2085-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2085-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2086" : helpers.makeTestYear("Europe/Vienna", [
		["2086-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2086-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2086-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2086-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2087" : helpers.makeTestYear("Europe/Vienna", [
		["2087-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2087-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2087-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2087-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2088" : helpers.makeTestYear("Europe/Vienna", [
		["2088-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2088-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2088-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2088-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2089" : helpers.makeTestYear("Europe/Vienna", [
		["2089-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2089-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2089-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2089-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2090" : helpers.makeTestYear("Europe/Vienna", [
		["2090-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2090-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2090-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2090-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2091" : helpers.makeTestYear("Europe/Vienna", [
		["2091-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2091-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2091-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2091-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2092" : helpers.makeTestYear("Europe/Vienna", [
		["2092-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2092-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2092-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2092-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2093" : helpers.makeTestYear("Europe/Vienna", [
		["2093-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2093-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2093-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2093-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2094" : helpers.makeTestYear("Europe/Vienna", [
		["2094-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2094-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2094-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2094-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2095" : helpers.makeTestYear("Europe/Vienna", [
		["2095-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2095-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2095-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2095-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2096" : helpers.makeTestYear("Europe/Vienna", [
		["2096-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2096-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2096-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2096-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2097" : helpers.makeTestYear("Europe/Vienna", [
		["2097-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2097-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2097-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2097-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2098" : helpers.makeTestYear("Europe/Vienna", [
		["2098-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2098-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2098-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2098-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2099" : helpers.makeTestYear("Europe/Vienna", [
		["2099-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2099-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2099-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2099-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2100" : helpers.makeTestYear("Europe/Vienna", [
		["2100-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2100-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2100-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2100-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2101" : helpers.makeTestYear("Europe/Vienna", [
		["2101-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2101-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2101-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2101-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2102" : helpers.makeTestYear("Europe/Vienna", [
		["2102-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2102-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2102-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2102-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2103" : helpers.makeTestYear("Europe/Vienna", [
		["2103-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2103-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2103-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2103-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2104" : helpers.makeTestYear("Europe/Vienna", [
		["2104-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2104-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2104-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2104-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2105" : helpers.makeTestYear("Europe/Vienna", [
		["2105-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2105-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2105-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2105-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2106" : helpers.makeTestYear("Europe/Vienna", [
		["2106-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2106-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2106-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2106-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2107" : helpers.makeTestYear("Europe/Vienna", [
		["2107-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2107-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2107-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2107-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2108" : helpers.makeTestYear("Europe/Vienna", [
		["2108-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2108-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2108-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2108-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2109" : helpers.makeTestYear("Europe/Vienna", [
		["2109-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2109-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2109-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2109-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2110" : helpers.makeTestYear("Europe/Vienna", [
		["2110-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2110-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2110-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2110-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2111" : helpers.makeTestYear("Europe/Vienna", [
		["2111-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2111-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2111-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2111-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2112" : helpers.makeTestYear("Europe/Vienna", [
		["2112-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2112-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2112-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2112-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2113" : helpers.makeTestYear("Europe/Vienna", [
		["2113-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2113-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2113-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2113-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2114" : helpers.makeTestYear("Europe/Vienna", [
		["2114-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2114-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2114-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2114-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2115" : helpers.makeTestYear("Europe/Vienna", [
		["2115-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2115-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2115-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2115-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2116" : helpers.makeTestYear("Europe/Vienna", [
		["2116-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2116-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2116-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2116-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2117" : helpers.makeTestYear("Europe/Vienna", [
		["2117-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2117-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2117-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2117-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2118" : helpers.makeTestYear("Europe/Vienna", [
		["2118-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2118-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2118-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2118-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2119" : helpers.makeTestYear("Europe/Vienna", [
		["2119-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2119-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2119-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2119-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2120" : helpers.makeTestYear("Europe/Vienna", [
		["2120-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2120-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2120-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2120-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2121" : helpers.makeTestYear("Europe/Vienna", [
		["2121-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2121-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2121-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2121-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2122" : helpers.makeTestYear("Europe/Vienna", [
		["2122-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2122-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2122-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2122-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2123" : helpers.makeTestYear("Europe/Vienna", [
		["2123-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2123-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2123-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2123-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2124" : helpers.makeTestYear("Europe/Vienna", [
		["2124-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2124-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2124-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2124-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2125" : helpers.makeTestYear("Europe/Vienna", [
		["2125-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2125-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2125-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2125-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2126" : helpers.makeTestYear("Europe/Vienna", [
		["2126-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2126-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2126-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2126-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2127" : helpers.makeTestYear("Europe/Vienna", [
		["2127-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2127-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2127-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2127-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2128" : helpers.makeTestYear("Europe/Vienna", [
		["2128-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2128-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2128-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2128-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2129" : helpers.makeTestYear("Europe/Vienna", [
		["2129-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2129-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2129-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2129-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2130" : helpers.makeTestYear("Europe/Vienna", [
		["2130-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2130-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2130-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2130-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2131" : helpers.makeTestYear("Europe/Vienna", [
		["2131-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2131-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2131-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2131-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2132" : helpers.makeTestYear("Europe/Vienna", [
		["2132-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2132-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2132-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2132-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2133" : helpers.makeTestYear("Europe/Vienna", [
		["2133-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2133-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2133-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2133-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2134" : helpers.makeTestYear("Europe/Vienna", [
		["2134-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2134-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2134-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2134-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2135" : helpers.makeTestYear("Europe/Vienna", [
		["2135-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2135-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2135-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2135-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2136" : helpers.makeTestYear("Europe/Vienna", [
		["2136-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2136-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2136-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2136-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2137" : helpers.makeTestYear("Europe/Vienna", [
		["2137-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2137-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2137-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2137-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2138" : helpers.makeTestYear("Europe/Vienna", [
		["2138-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2138-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2138-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2138-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2139" : helpers.makeTestYear("Europe/Vienna", [
		["2139-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2139-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2139-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2139-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2140" : helpers.makeTestYear("Europe/Vienna", [
		["2140-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2140-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2140-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2140-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2141" : helpers.makeTestYear("Europe/Vienna", [
		["2141-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2141-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2141-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2141-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2142" : helpers.makeTestYear("Europe/Vienna", [
		["2142-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2142-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2142-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2142-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2143" : helpers.makeTestYear("Europe/Vienna", [
		["2143-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2143-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2143-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2143-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2144" : helpers.makeTestYear("Europe/Vienna", [
		["2144-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2144-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2144-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2144-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2145" : helpers.makeTestYear("Europe/Vienna", [
		["2145-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2145-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2145-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2145-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2146" : helpers.makeTestYear("Europe/Vienna", [
		["2146-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2146-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2146-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2146-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2147" : helpers.makeTestYear("Europe/Vienna", [
		["2147-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2147-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2147-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2147-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2148" : helpers.makeTestYear("Europe/Vienna", [
		["2148-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2148-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2148-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2148-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2149" : helpers.makeTestYear("Europe/Vienna", [
		["2149-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2149-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2149-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2149-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2150" : helpers.makeTestYear("Europe/Vienna", [
		["2150-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2150-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2150-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2150-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2151" : helpers.makeTestYear("Europe/Vienna", [
		["2151-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2151-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2151-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2151-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2152" : helpers.makeTestYear("Europe/Vienna", [
		["2152-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2152-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2152-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2152-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2153" : helpers.makeTestYear("Europe/Vienna", [
		["2153-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2153-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2153-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2153-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2154" : helpers.makeTestYear("Europe/Vienna", [
		["2154-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2154-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2154-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2154-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2155" : helpers.makeTestYear("Europe/Vienna", [
		["2155-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2155-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2155-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2155-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2156" : helpers.makeTestYear("Europe/Vienna", [
		["2156-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2156-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2156-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2156-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2157" : helpers.makeTestYear("Europe/Vienna", [
		["2157-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2157-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2157-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2157-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2158" : helpers.makeTestYear("Europe/Vienna", [
		["2158-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2158-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2158-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2158-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2159" : helpers.makeTestYear("Europe/Vienna", [
		["2159-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2159-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2159-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2159-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2160" : helpers.makeTestYear("Europe/Vienna", [
		["2160-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2160-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2160-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2160-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2161" : helpers.makeTestYear("Europe/Vienna", [
		["2161-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2161-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2161-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2161-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2162" : helpers.makeTestYear("Europe/Vienna", [
		["2162-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2162-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2162-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2162-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2163" : helpers.makeTestYear("Europe/Vienna", [
		["2163-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2163-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2163-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2163-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2164" : helpers.makeTestYear("Europe/Vienna", [
		["2164-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2164-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2164-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2164-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2165" : helpers.makeTestYear("Europe/Vienna", [
		["2165-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2165-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2165-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2165-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2166" : helpers.makeTestYear("Europe/Vienna", [
		["2166-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2166-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2166-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2166-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2167" : helpers.makeTestYear("Europe/Vienna", [
		["2167-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2167-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2167-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2167-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2168" : helpers.makeTestYear("Europe/Vienna", [
		["2168-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2168-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2168-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2168-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2169" : helpers.makeTestYear("Europe/Vienna", [
		["2169-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2169-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2169-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2169-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2170" : helpers.makeTestYear("Europe/Vienna", [
		["2170-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2170-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2170-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2170-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2171" : helpers.makeTestYear("Europe/Vienna", [
		["2171-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2171-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2171-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2171-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2172" : helpers.makeTestYear("Europe/Vienna", [
		["2172-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2172-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2172-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2172-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2173" : helpers.makeTestYear("Europe/Vienna", [
		["2173-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2173-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2173-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2173-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2174" : helpers.makeTestYear("Europe/Vienna", [
		["2174-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2174-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2174-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2174-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2175" : helpers.makeTestYear("Europe/Vienna", [
		["2175-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2175-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2175-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2175-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2176" : helpers.makeTestYear("Europe/Vienna", [
		["2176-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2176-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2176-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2176-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2177" : helpers.makeTestYear("Europe/Vienna", [
		["2177-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2177-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2177-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2177-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2178" : helpers.makeTestYear("Europe/Vienna", [
		["2178-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2178-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2178-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2178-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2179" : helpers.makeTestYear("Europe/Vienna", [
		["2179-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2179-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2179-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2179-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2180" : helpers.makeTestYear("Europe/Vienna", [
		["2180-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2180-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2180-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2180-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2181" : helpers.makeTestYear("Europe/Vienna", [
		["2181-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2181-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2181-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2181-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2182" : helpers.makeTestYear("Europe/Vienna", [
		["2182-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2182-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2182-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2182-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2183" : helpers.makeTestYear("Europe/Vienna", [
		["2183-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2183-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2183-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2183-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2184" : helpers.makeTestYear("Europe/Vienna", [
		["2184-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2184-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2184-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2184-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2185" : helpers.makeTestYear("Europe/Vienna", [
		["2185-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2185-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2185-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2185-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2186" : helpers.makeTestYear("Europe/Vienna", [
		["2186-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2186-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2186-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2186-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2187" : helpers.makeTestYear("Europe/Vienna", [
		["2187-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2187-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2187-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2187-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2188" : helpers.makeTestYear("Europe/Vienna", [
		["2188-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2188-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2188-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2188-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2189" : helpers.makeTestYear("Europe/Vienna", [
		["2189-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2189-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2189-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2189-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2190" : helpers.makeTestYear("Europe/Vienna", [
		["2190-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2190-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2190-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2190-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2191" : helpers.makeTestYear("Europe/Vienna", [
		["2191-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2191-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2191-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2191-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2192" : helpers.makeTestYear("Europe/Vienna", [
		["2192-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2192-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2192-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2192-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2193" : helpers.makeTestYear("Europe/Vienna", [
		["2193-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2193-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2193-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2193-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2194" : helpers.makeTestYear("Europe/Vienna", [
		["2194-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2194-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2194-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2194-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2195" : helpers.makeTestYear("Europe/Vienna", [
		["2195-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2195-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2195-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2195-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2196" : helpers.makeTestYear("Europe/Vienna", [
		["2196-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2196-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2196-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2196-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2197" : helpers.makeTestYear("Europe/Vienna", [
		["2197-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2197-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2197-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2197-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2198" : helpers.makeTestYear("Europe/Vienna", [
		["2198-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2198-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2198-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2198-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2199" : helpers.makeTestYear("Europe/Vienna", [
		["2199-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2199-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2199-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2199-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2200" : helpers.makeTestYear("Europe/Vienna", [
		["2200-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2200-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2200-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2200-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2201" : helpers.makeTestYear("Europe/Vienna", [
		["2201-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2201-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2201-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2201-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2202" : helpers.makeTestYear("Europe/Vienna", [
		["2202-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2202-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2202-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2202-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2203" : helpers.makeTestYear("Europe/Vienna", [
		["2203-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2203-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2203-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2203-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2204" : helpers.makeTestYear("Europe/Vienna", [
		["2204-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2204-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2204-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2204-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2205" : helpers.makeTestYear("Europe/Vienna", [
		["2205-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2205-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2205-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2205-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2206" : helpers.makeTestYear("Europe/Vienna", [
		["2206-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2206-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2206-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2206-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2207" : helpers.makeTestYear("Europe/Vienna", [
		["2207-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2207-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2207-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2207-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2208" : helpers.makeTestYear("Europe/Vienna", [
		["2208-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2208-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2208-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2208-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2209" : helpers.makeTestYear("Europe/Vienna", [
		["2209-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2209-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2209-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2209-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2210" : helpers.makeTestYear("Europe/Vienna", [
		["2210-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2210-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2210-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2210-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2211" : helpers.makeTestYear("Europe/Vienna", [
		["2211-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2211-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2211-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2211-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2212" : helpers.makeTestYear("Europe/Vienna", [
		["2212-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2212-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2212-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2212-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2213" : helpers.makeTestYear("Europe/Vienna", [
		["2213-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2213-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2213-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2213-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2214" : helpers.makeTestYear("Europe/Vienna", [
		["2214-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2214-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2214-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2214-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2215" : helpers.makeTestYear("Europe/Vienna", [
		["2215-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2215-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2215-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2215-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2216" : helpers.makeTestYear("Europe/Vienna", [
		["2216-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2216-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2216-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2216-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2217" : helpers.makeTestYear("Europe/Vienna", [
		["2217-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2217-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2217-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2217-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2218" : helpers.makeTestYear("Europe/Vienna", [
		["2218-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2218-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2218-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2218-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2219" : helpers.makeTestYear("Europe/Vienna", [
		["2219-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2219-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2219-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2219-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2220" : helpers.makeTestYear("Europe/Vienna", [
		["2220-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2220-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2220-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2220-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2221" : helpers.makeTestYear("Europe/Vienna", [
		["2221-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2221-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2221-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2221-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2222" : helpers.makeTestYear("Europe/Vienna", [
		["2222-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2222-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2222-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2222-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2223" : helpers.makeTestYear("Europe/Vienna", [
		["2223-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2223-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2223-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2223-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2224" : helpers.makeTestYear("Europe/Vienna", [
		["2224-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2224-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2224-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2224-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2225" : helpers.makeTestYear("Europe/Vienna", [
		["2225-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2225-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2225-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2225-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2226" : helpers.makeTestYear("Europe/Vienna", [
		["2226-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2226-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2226-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2226-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2227" : helpers.makeTestYear("Europe/Vienna", [
		["2227-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2227-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2227-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2227-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2228" : helpers.makeTestYear("Europe/Vienna", [
		["2228-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2228-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2228-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2228-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2229" : helpers.makeTestYear("Europe/Vienna", [
		["2229-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2229-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2229-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2229-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2230" : helpers.makeTestYear("Europe/Vienna", [
		["2230-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2230-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2230-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2230-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2231" : helpers.makeTestYear("Europe/Vienna", [
		["2231-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2231-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2231-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2231-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2232" : helpers.makeTestYear("Europe/Vienna", [
		["2232-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2232-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2232-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2232-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2233" : helpers.makeTestYear("Europe/Vienna", [
		["2233-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2233-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2233-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2233-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2234" : helpers.makeTestYear("Europe/Vienna", [
		["2234-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2234-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2234-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2234-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2235" : helpers.makeTestYear("Europe/Vienna", [
		["2235-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2235-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2235-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2235-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2236" : helpers.makeTestYear("Europe/Vienna", [
		["2236-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2236-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2236-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2236-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2237" : helpers.makeTestYear("Europe/Vienna", [
		["2237-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2237-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2237-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2237-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2238" : helpers.makeTestYear("Europe/Vienna", [
		["2238-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2238-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2238-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2238-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2239" : helpers.makeTestYear("Europe/Vienna", [
		["2239-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2239-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2239-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2239-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2240" : helpers.makeTestYear("Europe/Vienna", [
		["2240-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2240-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2240-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2240-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2241" : helpers.makeTestYear("Europe/Vienna", [
		["2241-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2241-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2241-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2241-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2242" : helpers.makeTestYear("Europe/Vienna", [
		["2242-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2242-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2242-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2242-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2243" : helpers.makeTestYear("Europe/Vienna", [
		["2243-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2243-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2243-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2243-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2244" : helpers.makeTestYear("Europe/Vienna", [
		["2244-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2244-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2244-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2244-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2245" : helpers.makeTestYear("Europe/Vienna", [
		["2245-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2245-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2245-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2245-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2246" : helpers.makeTestYear("Europe/Vienna", [
		["2246-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2246-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2246-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2246-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2247" : helpers.makeTestYear("Europe/Vienna", [
		["2247-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2247-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2247-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2247-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2248" : helpers.makeTestYear("Europe/Vienna", [
		["2248-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2248-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2248-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2248-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2249" : helpers.makeTestYear("Europe/Vienna", [
		["2249-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2249-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2249-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2249-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2250" : helpers.makeTestYear("Europe/Vienna", [
		["2250-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2250-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2250-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2250-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2251" : helpers.makeTestYear("Europe/Vienna", [
		["2251-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2251-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2251-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2251-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2252" : helpers.makeTestYear("Europe/Vienna", [
		["2252-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2252-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2252-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2252-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2253" : helpers.makeTestYear("Europe/Vienna", [
		["2253-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2253-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2253-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2253-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2254" : helpers.makeTestYear("Europe/Vienna", [
		["2254-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2254-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2254-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2254-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2255" : helpers.makeTestYear("Europe/Vienna", [
		["2255-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2255-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2255-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2255-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2256" : helpers.makeTestYear("Europe/Vienna", [
		["2256-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2256-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2256-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2256-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2257" : helpers.makeTestYear("Europe/Vienna", [
		["2257-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2257-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2257-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2257-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2258" : helpers.makeTestYear("Europe/Vienna", [
		["2258-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2258-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2258-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2258-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2259" : helpers.makeTestYear("Europe/Vienna", [
		["2259-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2259-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2259-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2259-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2260" : helpers.makeTestYear("Europe/Vienna", [
		["2260-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2260-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2260-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2260-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2261" : helpers.makeTestYear("Europe/Vienna", [
		["2261-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2261-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2261-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2261-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2262" : helpers.makeTestYear("Europe/Vienna", [
		["2262-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2262-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2262-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2262-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2263" : helpers.makeTestYear("Europe/Vienna", [
		["2263-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2263-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2263-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2263-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2264" : helpers.makeTestYear("Europe/Vienna", [
		["2264-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2264-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2264-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2264-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2265" : helpers.makeTestYear("Europe/Vienna", [
		["2265-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2265-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2265-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2265-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2266" : helpers.makeTestYear("Europe/Vienna", [
		["2266-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2266-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2266-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2266-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2267" : helpers.makeTestYear("Europe/Vienna", [
		["2267-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2267-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2267-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2267-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2268" : helpers.makeTestYear("Europe/Vienna", [
		["2268-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2268-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2268-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2268-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2269" : helpers.makeTestYear("Europe/Vienna", [
		["2269-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2269-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2269-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2269-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2270" : helpers.makeTestYear("Europe/Vienna", [
		["2270-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2270-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2270-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2270-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2271" : helpers.makeTestYear("Europe/Vienna", [
		["2271-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2271-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2271-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2271-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2272" : helpers.makeTestYear("Europe/Vienna", [
		["2272-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2272-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2272-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2272-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2273" : helpers.makeTestYear("Europe/Vienna", [
		["2273-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2273-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2273-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2273-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2274" : helpers.makeTestYear("Europe/Vienna", [
		["2274-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2274-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2274-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2274-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2275" : helpers.makeTestYear("Europe/Vienna", [
		["2275-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2275-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2275-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2275-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2276" : helpers.makeTestYear("Europe/Vienna", [
		["2276-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2276-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2276-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2276-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2277" : helpers.makeTestYear("Europe/Vienna", [
		["2277-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2277-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2277-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2277-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2278" : helpers.makeTestYear("Europe/Vienna", [
		["2278-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2278-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2278-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2278-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2279" : helpers.makeTestYear("Europe/Vienna", [
		["2279-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2279-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2279-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2279-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2280" : helpers.makeTestYear("Europe/Vienna", [
		["2280-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2280-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2280-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2280-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2281" : helpers.makeTestYear("Europe/Vienna", [
		["2281-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2281-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2281-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2281-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2282" : helpers.makeTestYear("Europe/Vienna", [
		["2282-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2282-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2282-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2282-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2283" : helpers.makeTestYear("Europe/Vienna", [
		["2283-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2283-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2283-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2283-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2284" : helpers.makeTestYear("Europe/Vienna", [
		["2284-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2284-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2284-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2284-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2285" : helpers.makeTestYear("Europe/Vienna", [
		["2285-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2285-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2285-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2285-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2286" : helpers.makeTestYear("Europe/Vienna", [
		["2286-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2286-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2286-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2286-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2287" : helpers.makeTestYear("Europe/Vienna", [
		["2287-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2287-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2287-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2287-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2288" : helpers.makeTestYear("Europe/Vienna", [
		["2288-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2288-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2288-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2288-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2289" : helpers.makeTestYear("Europe/Vienna", [
		["2289-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2289-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2289-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2289-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2290" : helpers.makeTestYear("Europe/Vienna", [
		["2290-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2290-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2290-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2290-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2291" : helpers.makeTestYear("Europe/Vienna", [
		["2291-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2291-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2291-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2291-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2292" : helpers.makeTestYear("Europe/Vienna", [
		["2292-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2292-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2292-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2292-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2293" : helpers.makeTestYear("Europe/Vienna", [
		["2293-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2293-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2293-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2293-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2294" : helpers.makeTestYear("Europe/Vienna", [
		["2294-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2294-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2294-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2294-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2295" : helpers.makeTestYear("Europe/Vienna", [
		["2295-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2295-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2295-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2295-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2296" : helpers.makeTestYear("Europe/Vienna", [
		["2296-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2296-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2296-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2296-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2297" : helpers.makeTestYear("Europe/Vienna", [
		["2297-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2297-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2297-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2297-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2298" : helpers.makeTestYear("Europe/Vienna", [
		["2298-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2298-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2298-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2298-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2299" : helpers.makeTestYear("Europe/Vienna", [
		["2299-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2299-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2299-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2299-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2300" : helpers.makeTestYear("Europe/Vienna", [
		["2300-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2300-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2300-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2300-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2301" : helpers.makeTestYear("Europe/Vienna", [
		["2301-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2301-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2301-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2301-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2302" : helpers.makeTestYear("Europe/Vienna", [
		["2302-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2302-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2302-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2302-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2303" : helpers.makeTestYear("Europe/Vienna", [
		["2303-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2303-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2303-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2303-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2304" : helpers.makeTestYear("Europe/Vienna", [
		["2304-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2304-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2304-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2304-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2305" : helpers.makeTestYear("Europe/Vienna", [
		["2305-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2305-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2305-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2305-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2306" : helpers.makeTestYear("Europe/Vienna", [
		["2306-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2306-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2306-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2306-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2307" : helpers.makeTestYear("Europe/Vienna", [
		["2307-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2307-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2307-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2307-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2308" : helpers.makeTestYear("Europe/Vienna", [
		["2308-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2308-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2308-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2308-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2309" : helpers.makeTestYear("Europe/Vienna", [
		["2309-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2309-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2309-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2309-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2310" : helpers.makeTestYear("Europe/Vienna", [
		["2310-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2310-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2310-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2310-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2311" : helpers.makeTestYear("Europe/Vienna", [
		["2311-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2311-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2311-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2311-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2312" : helpers.makeTestYear("Europe/Vienna", [
		["2312-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2312-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2312-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2312-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2313" : helpers.makeTestYear("Europe/Vienna", [
		["2313-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2313-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2313-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2313-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2314" : helpers.makeTestYear("Europe/Vienna", [
		["2314-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2314-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2314-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2314-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2315" : helpers.makeTestYear("Europe/Vienna", [
		["2315-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2315-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2315-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2315-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2316" : helpers.makeTestYear("Europe/Vienna", [
		["2316-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2316-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2316-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2316-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2317" : helpers.makeTestYear("Europe/Vienna", [
		["2317-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2317-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2317-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2317-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2318" : helpers.makeTestYear("Europe/Vienna", [
		["2318-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2318-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2318-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2318-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2319" : helpers.makeTestYear("Europe/Vienna", [
		["2319-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2319-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2319-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2319-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2320" : helpers.makeTestYear("Europe/Vienna", [
		["2320-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2320-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2320-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2320-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2321" : helpers.makeTestYear("Europe/Vienna", [
		["2321-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2321-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2321-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2321-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2322" : helpers.makeTestYear("Europe/Vienna", [
		["2322-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2322-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2322-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2322-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2323" : helpers.makeTestYear("Europe/Vienna", [
		["2323-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2323-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2323-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2323-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2324" : helpers.makeTestYear("Europe/Vienna", [
		["2324-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2324-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2324-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2324-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2325" : helpers.makeTestYear("Europe/Vienna", [
		["2325-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2325-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2325-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2325-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2326" : helpers.makeTestYear("Europe/Vienna", [
		["2326-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2326-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2326-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2326-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2327" : helpers.makeTestYear("Europe/Vienna", [
		["2327-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2327-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2327-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2327-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2328" : helpers.makeTestYear("Europe/Vienna", [
		["2328-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2328-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2328-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2328-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2329" : helpers.makeTestYear("Europe/Vienna", [
		["2329-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2329-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2329-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2329-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2330" : helpers.makeTestYear("Europe/Vienna", [
		["2330-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2330-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2330-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2330-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2331" : helpers.makeTestYear("Europe/Vienna", [
		["2331-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2331-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2331-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2331-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2332" : helpers.makeTestYear("Europe/Vienna", [
		["2332-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2332-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2332-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2332-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2333" : helpers.makeTestYear("Europe/Vienna", [
		["2333-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2333-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2333-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2333-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2334" : helpers.makeTestYear("Europe/Vienna", [
		["2334-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2334-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2334-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2334-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2335" : helpers.makeTestYear("Europe/Vienna", [
		["2335-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2335-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2335-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2335-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2336" : helpers.makeTestYear("Europe/Vienna", [
		["2336-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2336-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2336-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2336-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2337" : helpers.makeTestYear("Europe/Vienna", [
		["2337-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2337-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2337-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2337-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2338" : helpers.makeTestYear("Europe/Vienna", [
		["2338-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2338-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2338-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2338-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2339" : helpers.makeTestYear("Europe/Vienna", [
		["2339-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2339-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2339-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2339-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2340" : helpers.makeTestYear("Europe/Vienna", [
		["2340-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2340-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2340-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2340-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2341" : helpers.makeTestYear("Europe/Vienna", [
		["2341-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2341-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2341-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2341-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2342" : helpers.makeTestYear("Europe/Vienna", [
		["2342-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2342-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2342-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2342-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2343" : helpers.makeTestYear("Europe/Vienna", [
		["2343-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2343-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2343-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2343-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2344" : helpers.makeTestYear("Europe/Vienna", [
		["2344-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2344-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2344-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2344-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2345" : helpers.makeTestYear("Europe/Vienna", [
		["2345-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2345-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2345-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2345-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2346" : helpers.makeTestYear("Europe/Vienna", [
		["2346-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2346-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2346-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2346-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2347" : helpers.makeTestYear("Europe/Vienna", [
		["2347-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2347-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2347-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2347-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2348" : helpers.makeTestYear("Europe/Vienna", [
		["2348-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2348-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2348-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2348-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2349" : helpers.makeTestYear("Europe/Vienna", [
		["2349-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2349-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2349-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2349-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2350" : helpers.makeTestYear("Europe/Vienna", [
		["2350-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2350-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2350-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2350-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2351" : helpers.makeTestYear("Europe/Vienna", [
		["2351-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2351-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2351-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2351-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2352" : helpers.makeTestYear("Europe/Vienna", [
		["2352-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2352-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2352-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2352-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2353" : helpers.makeTestYear("Europe/Vienna", [
		["2353-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2353-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2353-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2353-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2354" : helpers.makeTestYear("Europe/Vienna", [
		["2354-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2354-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2354-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2354-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2355" : helpers.makeTestYear("Europe/Vienna", [
		["2355-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2355-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2355-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2355-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2356" : helpers.makeTestYear("Europe/Vienna", [
		["2356-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2356-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2356-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2356-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2357" : helpers.makeTestYear("Europe/Vienna", [
		["2357-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2357-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2357-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2357-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2358" : helpers.makeTestYear("Europe/Vienna", [
		["2358-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2358-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2358-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2358-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2359" : helpers.makeTestYear("Europe/Vienna", [
		["2359-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2359-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2359-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2359-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2360" : helpers.makeTestYear("Europe/Vienna", [
		["2360-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2360-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2360-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2360-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2361" : helpers.makeTestYear("Europe/Vienna", [
		["2361-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2361-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2361-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2361-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2362" : helpers.makeTestYear("Europe/Vienna", [
		["2362-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2362-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2362-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2362-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2363" : helpers.makeTestYear("Europe/Vienna", [
		["2363-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2363-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2363-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2363-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2364" : helpers.makeTestYear("Europe/Vienna", [
		["2364-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2364-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2364-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2364-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2365" : helpers.makeTestYear("Europe/Vienna", [
		["2365-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2365-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2365-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2365-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2366" : helpers.makeTestYear("Europe/Vienna", [
		["2366-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2366-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2366-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2366-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2367" : helpers.makeTestYear("Europe/Vienna", [
		["2367-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2367-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2367-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2367-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2368" : helpers.makeTestYear("Europe/Vienna", [
		["2368-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2368-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2368-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2368-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2369" : helpers.makeTestYear("Europe/Vienna", [
		["2369-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2369-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2369-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2369-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2370" : helpers.makeTestYear("Europe/Vienna", [
		["2370-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2370-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2370-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2370-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2371" : helpers.makeTestYear("Europe/Vienna", [
		["2371-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2371-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2371-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2371-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2372" : helpers.makeTestYear("Europe/Vienna", [
		["2372-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2372-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2372-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2372-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2373" : helpers.makeTestYear("Europe/Vienna", [
		["2373-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2373-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2373-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2373-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2374" : helpers.makeTestYear("Europe/Vienna", [
		["2374-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2374-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2374-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2374-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2375" : helpers.makeTestYear("Europe/Vienna", [
		["2375-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2375-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2375-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2375-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2376" : helpers.makeTestYear("Europe/Vienna", [
		["2376-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2376-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2376-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2376-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2377" : helpers.makeTestYear("Europe/Vienna", [
		["2377-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2377-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2377-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2377-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2378" : helpers.makeTestYear("Europe/Vienna", [
		["2378-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2378-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2378-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2378-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2379" : helpers.makeTestYear("Europe/Vienna", [
		["2379-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2379-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2379-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2379-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2380" : helpers.makeTestYear("Europe/Vienna", [
		["2380-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2380-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2380-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2380-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2381" : helpers.makeTestYear("Europe/Vienna", [
		["2381-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2381-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2381-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2381-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2382" : helpers.makeTestYear("Europe/Vienna", [
		["2382-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2382-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2382-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2382-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2383" : helpers.makeTestYear("Europe/Vienna", [
		["2383-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2383-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2383-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2383-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2384" : helpers.makeTestYear("Europe/Vienna", [
		["2384-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2384-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2384-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2384-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2385" : helpers.makeTestYear("Europe/Vienna", [
		["2385-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2385-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2385-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2385-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2386" : helpers.makeTestYear("Europe/Vienna", [
		["2386-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2386-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2386-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2386-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2387" : helpers.makeTestYear("Europe/Vienna", [
		["2387-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2387-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2387-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2387-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2388" : helpers.makeTestYear("Europe/Vienna", [
		["2388-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2388-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2388-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2388-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2389" : helpers.makeTestYear("Europe/Vienna", [
		["2389-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2389-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2389-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2389-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2390" : helpers.makeTestYear("Europe/Vienna", [
		["2390-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2390-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2390-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2390-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2391" : helpers.makeTestYear("Europe/Vienna", [
		["2391-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2391-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2391-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2391-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2392" : helpers.makeTestYear("Europe/Vienna", [
		["2392-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2392-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2392-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2392-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2393" : helpers.makeTestYear("Europe/Vienna", [
		["2393-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2393-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2393-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2393-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2394" : helpers.makeTestYear("Europe/Vienna", [
		["2394-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2394-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2394-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2394-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2395" : helpers.makeTestYear("Europe/Vienna", [
		["2395-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2395-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2395-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2395-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2396" : helpers.makeTestYear("Europe/Vienna", [
		["2396-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2396-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2396-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2396-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2397" : helpers.makeTestYear("Europe/Vienna", [
		["2397-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2397-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2397-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2397-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2398" : helpers.makeTestYear("Europe/Vienna", [
		["2398-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2398-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2398-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2398-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2399" : helpers.makeTestYear("Europe/Vienna", [
		["2399-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2399-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2399-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2399-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2400" : helpers.makeTestYear("Europe/Vienna", [
		["2400-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2400-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2400-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2400-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2401" : helpers.makeTestYear("Europe/Vienna", [
		["2401-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2401-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2401-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2401-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2402" : helpers.makeTestYear("Europe/Vienna", [
		["2402-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2402-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2402-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2402-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2403" : helpers.makeTestYear("Europe/Vienna", [
		["2403-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2403-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2403-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2403-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2404" : helpers.makeTestYear("Europe/Vienna", [
		["2404-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2404-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2404-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2404-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2405" : helpers.makeTestYear("Europe/Vienna", [
		["2405-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2405-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2405-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2405-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2406" : helpers.makeTestYear("Europe/Vienna", [
		["2406-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2406-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2406-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2406-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2407" : helpers.makeTestYear("Europe/Vienna", [
		["2407-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2407-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2407-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2407-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2408" : helpers.makeTestYear("Europe/Vienna", [
		["2408-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2408-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2408-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2408-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2409" : helpers.makeTestYear("Europe/Vienna", [
		["2409-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2409-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2409-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2409-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2410" : helpers.makeTestYear("Europe/Vienna", [
		["2410-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2410-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2410-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2410-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2411" : helpers.makeTestYear("Europe/Vienna", [
		["2411-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2411-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2411-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2411-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2412" : helpers.makeTestYear("Europe/Vienna", [
		["2412-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2412-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2412-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2412-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2413" : helpers.makeTestYear("Europe/Vienna", [
		["2413-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2413-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2413-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2413-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2414" : helpers.makeTestYear("Europe/Vienna", [
		["2414-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2414-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2414-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2414-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2415" : helpers.makeTestYear("Europe/Vienna", [
		["2415-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2415-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2415-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2415-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2416" : helpers.makeTestYear("Europe/Vienna", [
		["2416-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2416-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2416-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2416-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2417" : helpers.makeTestYear("Europe/Vienna", [
		["2417-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2417-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2417-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2417-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2418" : helpers.makeTestYear("Europe/Vienna", [
		["2418-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2418-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2418-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2418-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2419" : helpers.makeTestYear("Europe/Vienna", [
		["2419-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2419-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2419-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2419-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2420" : helpers.makeTestYear("Europe/Vienna", [
		["2420-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2420-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2420-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2420-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2421" : helpers.makeTestYear("Europe/Vienna", [
		["2421-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2421-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2421-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2421-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2422" : helpers.makeTestYear("Europe/Vienna", [
		["2422-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2422-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2422-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2422-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2423" : helpers.makeTestYear("Europe/Vienna", [
		["2423-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2423-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2423-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2423-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2424" : helpers.makeTestYear("Europe/Vienna", [
		["2424-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2424-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2424-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2424-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2425" : helpers.makeTestYear("Europe/Vienna", [
		["2425-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2425-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2425-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2425-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2426" : helpers.makeTestYear("Europe/Vienna", [
		["2426-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2426-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2426-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2426-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2427" : helpers.makeTestYear("Europe/Vienna", [
		["2427-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2427-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2427-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2427-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2428" : helpers.makeTestYear("Europe/Vienna", [
		["2428-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2428-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2428-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2428-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2429" : helpers.makeTestYear("Europe/Vienna", [
		["2429-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2429-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2429-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2429-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2430" : helpers.makeTestYear("Europe/Vienna", [
		["2430-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2430-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2430-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2430-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2431" : helpers.makeTestYear("Europe/Vienna", [
		["2431-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2431-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2431-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2431-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2432" : helpers.makeTestYear("Europe/Vienna", [
		["2432-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2432-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2432-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2432-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2433" : helpers.makeTestYear("Europe/Vienna", [
		["2433-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2433-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2433-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2433-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2434" : helpers.makeTestYear("Europe/Vienna", [
		["2434-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2434-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2434-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2434-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2435" : helpers.makeTestYear("Europe/Vienna", [
		["2435-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2435-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2435-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2435-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2436" : helpers.makeTestYear("Europe/Vienna", [
		["2436-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2436-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2436-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2436-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2437" : helpers.makeTestYear("Europe/Vienna", [
		["2437-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2437-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2437-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2437-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2438" : helpers.makeTestYear("Europe/Vienna", [
		["2438-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2438-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2438-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2438-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2439" : helpers.makeTestYear("Europe/Vienna", [
		["2439-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2439-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2439-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2439-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2440" : helpers.makeTestYear("Europe/Vienna", [
		["2440-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2440-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2440-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2440-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2441" : helpers.makeTestYear("Europe/Vienna", [
		["2441-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2441-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2441-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2441-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2442" : helpers.makeTestYear("Europe/Vienna", [
		["2442-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2442-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2442-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2442-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2443" : helpers.makeTestYear("Europe/Vienna", [
		["2443-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2443-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2443-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2443-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2444" : helpers.makeTestYear("Europe/Vienna", [
		["2444-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2444-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2444-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2444-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2445" : helpers.makeTestYear("Europe/Vienna", [
		["2445-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2445-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2445-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2445-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2446" : helpers.makeTestYear("Europe/Vienna", [
		["2446-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2446-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2446-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2446-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2447" : helpers.makeTestYear("Europe/Vienna", [
		["2447-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2447-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2447-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2447-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2448" : helpers.makeTestYear("Europe/Vienna", [
		["2448-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2448-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2448-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2448-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2449" : helpers.makeTestYear("Europe/Vienna", [
		["2449-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2449-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2449-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2449-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2450" : helpers.makeTestYear("Europe/Vienna", [
		["2450-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2450-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2450-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2450-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2451" : helpers.makeTestYear("Europe/Vienna", [
		["2451-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2451-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2451-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2451-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2452" : helpers.makeTestYear("Europe/Vienna", [
		["2452-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2452-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2452-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2452-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2453" : helpers.makeTestYear("Europe/Vienna", [
		["2453-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2453-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2453-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2453-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2454" : helpers.makeTestYear("Europe/Vienna", [
		["2454-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2454-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2454-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2454-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2455" : helpers.makeTestYear("Europe/Vienna", [
		["2455-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2455-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2455-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2455-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2456" : helpers.makeTestYear("Europe/Vienna", [
		["2456-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2456-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2456-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2456-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2457" : helpers.makeTestYear("Europe/Vienna", [
		["2457-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2457-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2457-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2457-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2458" : helpers.makeTestYear("Europe/Vienna", [
		["2458-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2458-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2458-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2458-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2459" : helpers.makeTestYear("Europe/Vienna", [
		["2459-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2459-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2459-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2459-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2460" : helpers.makeTestYear("Europe/Vienna", [
		["2460-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2460-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2460-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2460-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2461" : helpers.makeTestYear("Europe/Vienna", [
		["2461-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2461-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2461-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2461-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2462" : helpers.makeTestYear("Europe/Vienna", [
		["2462-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2462-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2462-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2462-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2463" : helpers.makeTestYear("Europe/Vienna", [
		["2463-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2463-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2463-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2463-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2464" : helpers.makeTestYear("Europe/Vienna", [
		["2464-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2464-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2464-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2464-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2465" : helpers.makeTestYear("Europe/Vienna", [
		["2465-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2465-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2465-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2465-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2466" : helpers.makeTestYear("Europe/Vienna", [
		["2466-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2466-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2466-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2466-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2467" : helpers.makeTestYear("Europe/Vienna", [
		["2467-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2467-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2467-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2467-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2468" : helpers.makeTestYear("Europe/Vienna", [
		["2468-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2468-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2468-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2468-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2469" : helpers.makeTestYear("Europe/Vienna", [
		["2469-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2469-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2469-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2469-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2470" : helpers.makeTestYear("Europe/Vienna", [
		["2470-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2470-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2470-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2470-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2471" : helpers.makeTestYear("Europe/Vienna", [
		["2471-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2471-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2471-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2471-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2472" : helpers.makeTestYear("Europe/Vienna", [
		["2472-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2472-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2472-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2472-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2473" : helpers.makeTestYear("Europe/Vienna", [
		["2473-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2473-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2473-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2473-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2474" : helpers.makeTestYear("Europe/Vienna", [
		["2474-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2474-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2474-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2474-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2475" : helpers.makeTestYear("Europe/Vienna", [
		["2475-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2475-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2475-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2475-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2476" : helpers.makeTestYear("Europe/Vienna", [
		["2476-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2476-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2476-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2476-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2477" : helpers.makeTestYear("Europe/Vienna", [
		["2477-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2477-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2477-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2477-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2478" : helpers.makeTestYear("Europe/Vienna", [
		["2478-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2478-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2478-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2478-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2479" : helpers.makeTestYear("Europe/Vienna", [
		["2479-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2479-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2479-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2479-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2480" : helpers.makeTestYear("Europe/Vienna", [
		["2480-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2480-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2480-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2480-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2481" : helpers.makeTestYear("Europe/Vienna", [
		["2481-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2481-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2481-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2481-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2482" : helpers.makeTestYear("Europe/Vienna", [
		["2482-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2482-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2482-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2482-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2483" : helpers.makeTestYear("Europe/Vienna", [
		["2483-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2483-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2483-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2483-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2484" : helpers.makeTestYear("Europe/Vienna", [
		["2484-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2484-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2484-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2484-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2485" : helpers.makeTestYear("Europe/Vienna", [
		["2485-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2485-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2485-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2485-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2486" : helpers.makeTestYear("Europe/Vienna", [
		["2486-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2486-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2486-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2486-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2487" : helpers.makeTestYear("Europe/Vienna", [
		["2487-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2487-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2487-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2487-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2488" : helpers.makeTestYear("Europe/Vienna", [
		["2488-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2488-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2488-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2488-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2489" : helpers.makeTestYear("Europe/Vienna", [
		["2489-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2489-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2489-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2489-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2490" : helpers.makeTestYear("Europe/Vienna", [
		["2490-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2490-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2490-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2490-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2491" : helpers.makeTestYear("Europe/Vienna", [
		["2491-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2491-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2491-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2491-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2492" : helpers.makeTestYear("Europe/Vienna", [
		["2492-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2492-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2492-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2492-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2493" : helpers.makeTestYear("Europe/Vienna", [
		["2493-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2493-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2493-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2493-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2494" : helpers.makeTestYear("Europe/Vienna", [
		["2494-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2494-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2494-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2494-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2495" : helpers.makeTestYear("Europe/Vienna", [
		["2495-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2495-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2495-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2495-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2496" : helpers.makeTestYear("Europe/Vienna", [
		["2496-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2496-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2496-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2496-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2497" : helpers.makeTestYear("Europe/Vienna", [
		["2497-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2497-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2497-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2497-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2498" : helpers.makeTestYear("Europe/Vienna", [
		["2498-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2498-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2498-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2498-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2499" : helpers.makeTestYear("Europe/Vienna", [
		["2499-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2499-03-29T01:00:00+00:00", "03:00:00", "CEST", -120]
	])
};